// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateBindFrontendCreatedCode is the HTTP code returned for type CreateBindFrontendCreated
const CreateBindFrontendCreatedCode int = 201

/*
CreateBindFrontendCreated Bind created

swagger:response createBindFrontendCreated
*/
type CreateBindFrontendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewCreateBindFrontendCreated creates CreateBindFrontendCreated with default headers values
func NewCreateBindFrontendCreated() *CreateBindFrontendCreated {

	return &CreateBindFrontendCreated{}
}

// WithPayload adds the payload to the create bind frontend created response
func (o *CreateBindFrontendCreated) WithPayload(payload *models.Bind) *CreateBindFrontendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind frontend created response
func (o *CreateBindFrontendCreated) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindFrontendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateBindFrontendAcceptedCode is the HTTP code returned for type CreateBindFrontendAccepted
const CreateBindFrontendAcceptedCode int = 202

/*
CreateBindFrontendAccepted Configuration change accepted and reload requested

swagger:response createBindFrontendAccepted
*/
type CreateBindFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewCreateBindFrontendAccepted creates CreateBindFrontendAccepted with default headers values
func NewCreateBindFrontendAccepted() *CreateBindFrontendAccepted {

	return &CreateBindFrontendAccepted{}
}

// WithReloadID adds the reloadId to the create bind frontend accepted response
func (o *CreateBindFrontendAccepted) WithReloadID(reloadID string) *CreateBindFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create bind frontend accepted response
func (o *CreateBindFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create bind frontend accepted response
func (o *CreateBindFrontendAccepted) WithPayload(payload *models.Bind) *CreateBindFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind frontend accepted response
func (o *CreateBindFrontendAccepted) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateBindFrontendBadRequestCode is the HTTP code returned for type CreateBindFrontendBadRequest
const CreateBindFrontendBadRequestCode int = 400

/*
CreateBindFrontendBadRequest Bad request

swagger:response createBindFrontendBadRequest
*/
type CreateBindFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateBindFrontendBadRequest creates CreateBindFrontendBadRequest with default headers values
func NewCreateBindFrontendBadRequest() *CreateBindFrontendBadRequest {

	return &CreateBindFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create bind frontend bad request response
func (o *CreateBindFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateBindFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create bind frontend bad request response
func (o *CreateBindFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create bind frontend bad request response
func (o *CreateBindFrontendBadRequest) WithPayload(payload *models.Error) *CreateBindFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind frontend bad request response
func (o *CreateBindFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateBindFrontendConflictCode is the HTTP code returned for type CreateBindFrontendConflict
const CreateBindFrontendConflictCode int = 409

/*
CreateBindFrontendConflict The specified resource already exists

swagger:response createBindFrontendConflict
*/
type CreateBindFrontendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateBindFrontendConflict creates CreateBindFrontendConflict with default headers values
func NewCreateBindFrontendConflict() *CreateBindFrontendConflict {

	return &CreateBindFrontendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create bind frontend conflict response
func (o *CreateBindFrontendConflict) WithConfigurationVersion(configurationVersion string) *CreateBindFrontendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create bind frontend conflict response
func (o *CreateBindFrontendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create bind frontend conflict response
func (o *CreateBindFrontendConflict) WithPayload(payload *models.Error) *CreateBindFrontendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind frontend conflict response
func (o *CreateBindFrontendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindFrontendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateBindFrontendDefault General Error

swagger:response createBindFrontendDefault
*/
type CreateBindFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateBindFrontendDefault creates CreateBindFrontendDefault with default headers values
func NewCreateBindFrontendDefault(code int) *CreateBindFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateBindFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create bind frontend default response
func (o *CreateBindFrontendDefault) WithStatusCode(code int) *CreateBindFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create bind frontend default response
func (o *CreateBindFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create bind frontend default response
func (o *CreateBindFrontendDefault) WithConfigurationVersion(configurationVersion string) *CreateBindFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create bind frontend default response
func (o *CreateBindFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create bind frontend default response
func (o *CreateBindFrontendDefault) WithPayload(payload *models.Error) *CreateBindFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind frontend default response
func (o *CreateBindFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
