// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteACLBackendAcceptedCode is the HTTP code returned for type DeleteACLBackendAccepted
const DeleteACLBackendAcceptedCode int = 202

/*
DeleteACLBackendAccepted Configuration change accepted and reload requested

swagger:response deleteAclBackendAccepted
*/
type DeleteACLBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteACLBackendAccepted creates DeleteACLBackendAccepted with default headers values
func NewDeleteACLBackendAccepted() *DeleteACLBackendAccepted {

	return &DeleteACLBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete Acl backend accepted response
func (o *DeleteACLBackendAccepted) WithReloadID(reloadID string) *DeleteACLBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Acl backend accepted response
func (o *DeleteACLBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteACLBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteACLBackendNoContentCode is the HTTP code returned for type DeleteACLBackendNoContent
const DeleteACLBackendNoContentCode int = 204

/*
DeleteACLBackendNoContent ACL line deleted

swagger:response deleteAclBackendNoContent
*/
type DeleteACLBackendNoContent struct {
}

// NewDeleteACLBackendNoContent creates DeleteACLBackendNoContent with default headers values
func NewDeleteACLBackendNoContent() *DeleteACLBackendNoContent {

	return &DeleteACLBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteACLBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteACLBackendNotFoundCode is the HTTP code returned for type DeleteACLBackendNotFound
const DeleteACLBackendNotFoundCode int = 404

/*
DeleteACLBackendNotFound The specified resource was not found

swagger:response deleteAclBackendNotFound
*/
type DeleteACLBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteACLBackendNotFound creates DeleteACLBackendNotFound with default headers values
func NewDeleteACLBackendNotFound() *DeleteACLBackendNotFound {

	return &DeleteACLBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Acl backend not found response
func (o *DeleteACLBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteACLBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Acl backend not found response
func (o *DeleteACLBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Acl backend not found response
func (o *DeleteACLBackendNotFound) WithPayload(payload *models.Error) *DeleteACLBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Acl backend not found response
func (o *DeleteACLBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteACLBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteACLBackendDefault General Error

swagger:response deleteAclBackendDefault
*/
type DeleteACLBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteACLBackendDefault creates DeleteACLBackendDefault with default headers values
func NewDeleteACLBackendDefault(code int) *DeleteACLBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteACLBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete Acl backend default response
func (o *DeleteACLBackendDefault) WithStatusCode(code int) *DeleteACLBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete Acl backend default response
func (o *DeleteACLBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete Acl backend default response
func (o *DeleteACLBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteACLBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Acl backend default response
func (o *DeleteACLBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Acl backend default response
func (o *DeleteACLBackendDefault) WithPayload(payload *models.Error) *DeleteACLBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Acl backend default response
func (o *DeleteACLBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteACLBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
