// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/v1/workflows.proto

#include "google/cloud/workflows/v1/internal/workflows_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace workflows_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

WorkflowsTracingConnection::WorkflowsTracingConnection(
    std::shared_ptr<workflows_v1::WorkflowsConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::workflows::v1::Workflow>
WorkflowsTracingConnection::ListWorkflows(
    google::cloud::workflows::v1::ListWorkflowsRequest request) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::ListWorkflows");
  internal::OTelScope scope(span);
  auto sr = child_->ListWorkflows(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::workflows::v1::Workflow>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::workflows::v1::Workflow>
WorkflowsTracingConnection::GetWorkflow(
    google::cloud::workflows::v1::GetWorkflowRequest const& request) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::GetWorkflow");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetWorkflow(request));
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsTracingConnection::CreateWorkflow(
    google::cloud::workflows::v1::CreateWorkflowRequest const& request) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::CreateWorkflow");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateWorkflow(request));
}

StatusOr<google::longrunning::Operation>
WorkflowsTracingConnection::CreateWorkflow(
    NoAwaitTag,
    google::cloud::workflows::v1::CreateWorkflowRequest const& request) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::CreateWorkflow");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateWorkflow(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsTracingConnection::CreateWorkflow(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::CreateWorkflow");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateWorkflow(operation));
}

future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
WorkflowsTracingConnection::DeleteWorkflow(
    google::cloud::workflows::v1::DeleteWorkflowRequest const& request) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::DeleteWorkflow");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteWorkflow(request));
}

StatusOr<google::longrunning::Operation>
WorkflowsTracingConnection::DeleteWorkflow(
    NoAwaitTag,
    google::cloud::workflows::v1::DeleteWorkflowRequest const& request) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::DeleteWorkflow");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteWorkflow(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
WorkflowsTracingConnection::DeleteWorkflow(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::DeleteWorkflow");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteWorkflow(operation));
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsTracingConnection::UpdateWorkflow(
    google::cloud::workflows::v1::UpdateWorkflowRequest const& request) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::UpdateWorkflow");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateWorkflow(request));
}

StatusOr<google::longrunning::Operation>
WorkflowsTracingConnection::UpdateWorkflow(
    NoAwaitTag,
    google::cloud::workflows::v1::UpdateWorkflowRequest const& request) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::UpdateWorkflow");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateWorkflow(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsTracingConnection::UpdateWorkflow(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("workflows_v1::WorkflowsConnection::UpdateWorkflow");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateWorkflow(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<workflows_v1::WorkflowsConnection>
MakeWorkflowsTracingConnection(
    std::shared_ptr<workflows_v1::WorkflowsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<WorkflowsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_v1_internal
}  // namespace cloud
}  // namespace google
