// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/job_service.proto

#include "google/cloud/talent/v4/internal/job_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace talent_v4_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

JobServiceTracingStub::JobServiceTracingStub(
    std::shared_ptr<JobServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::talent::v4::Job> JobServiceTracingStub::CreateJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::CreateJobRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.talent.v4.JobService", "CreateJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateJob(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
JobServiceTracingStub::AsyncBatchCreateJobs(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::talent::v4::BatchCreateJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.JobService",
                                     "BatchCreateJobs");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncBatchCreateJobs(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> JobServiceTracingStub::BatchCreateJobs(
    grpc::ClientContext& context, Options options,
    google::cloud::talent::v4::BatchCreateJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.JobService",
                                     "BatchCreateJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->BatchCreateJobs(context, options, request));
}

StatusOr<google::cloud::talent::v4::Job> JobServiceTracingStub::GetJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::GetJobRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.talent.v4.JobService", "GetJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetJob(context, options, request));
}

StatusOr<google::cloud::talent::v4::Job> JobServiceTracingStub::UpdateJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::UpdateJobRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.talent.v4.JobService", "UpdateJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateJob(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
JobServiceTracingStub::AsyncBatchUpdateJobs(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::talent::v4::BatchUpdateJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.JobService",
                                     "BatchUpdateJobs");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncBatchUpdateJobs(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> JobServiceTracingStub::BatchUpdateJobs(
    grpc::ClientContext& context, Options options,
    google::cloud::talent::v4::BatchUpdateJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.JobService",
                                     "BatchUpdateJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->BatchUpdateJobs(context, options, request));
}

Status JobServiceTracingStub::DeleteJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::DeleteJobRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.talent.v4.JobService", "DeleteJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteJob(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
JobServiceTracingStub::AsyncBatchDeleteJobs(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::talent::v4::BatchDeleteJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.JobService",
                                     "BatchDeleteJobs");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncBatchDeleteJobs(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> JobServiceTracingStub::BatchDeleteJobs(
    grpc::ClientContext& context, Options options,
    google::cloud::talent::v4::BatchDeleteJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.JobService",
                                     "BatchDeleteJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->BatchDeleteJobs(context, options, request));
}

StatusOr<google::cloud::talent::v4::ListJobsResponse>
JobServiceTracingStub::ListJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::ListJobsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.talent.v4.JobService", "ListJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListJobs(context, options, request));
}

StatusOr<google::cloud::talent::v4::SearchJobsResponse>
JobServiceTracingStub::SearchJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::SearchJobsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.talent.v4.JobService", "SearchJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SearchJobs(context, options, request));
}

StatusOr<google::cloud::talent::v4::SearchJobsResponse>
JobServiceTracingStub::SearchJobsForAlert(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::SearchJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.JobService",
                                     "SearchJobsForAlert");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->SearchJobsForAlert(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
JobServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> JobServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<JobServiceStub> MakeJobServiceTracingStub(
    std::shared_ptr<JobServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<JobServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4_internal
}  // namespace cloud
}  // namespace google
