// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/support/v2/attachment_service.proto

#include "google/cloud/support/v2/internal/case_attachment_option_defaults.h"
#include "google/cloud/support/v2/case_attachment_connection.h"
#include "google/cloud/support/v2/case_attachment_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace support_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options CaseAttachmentServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_CASE_ATTACHMENT_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_CASE_ATTACHMENT_SERVICE_AUTHORITY",
      "cloudsupport.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<support_v2::CaseAttachmentServiceRetryPolicyOption>()) {
    options.set<support_v2::CaseAttachmentServiceRetryPolicyOption>(
        support_v2::CaseAttachmentServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<support_v2::CaseAttachmentServiceBackoffPolicyOption>()) {
    options.set<support_v2::CaseAttachmentServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options
           .has<support_v2::
                    CaseAttachmentServiceConnectionIdempotencyPolicyOption>()) {
    options.set<
        support_v2::CaseAttachmentServiceConnectionIdempotencyPolicyOption>(
        support_v2::
            MakeDefaultCaseAttachmentServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace support_v2_internal
}  // namespace cloud
}  // namespace google
