// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/spanner/v1/spanner.proto

#include "google/cloud/spanner/internal/spanner_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/spanner/v1/spanner.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace spanner_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SpannerMetadata::SpannerMetadata(
    std::shared_ptr<SpannerStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::spanner::v1::Session> SpannerMetadata::CreateSession(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::CreateSessionRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("database=", internal::UrlEncode(request.database())));
  return child_->CreateSession(context, options, request);
}

StatusOr<google::spanner::v1::BatchCreateSessionsResponse>
SpannerMetadata::BatchCreateSessions(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::BatchCreateSessionsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("database=", internal::UrlEncode(request.database())));
  return child_->BatchCreateSessions(context, options, request);
}

Status SpannerMetadata::DeleteSession(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::DeleteSessionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteSession(context, options, request);
}

StatusOr<google::spanner::v1::ResultSet> SpannerMetadata::ExecuteSql(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::ExecuteSqlRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->ExecuteSql(context, options, request);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<
    google::spanner::v1::PartialResultSet>>
SpannerMetadata::ExecuteStreamingSql(
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::spanner::v1::ExecuteSqlRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->ExecuteStreamingSql(std::move(context), options, request);
}

StatusOr<google::spanner::v1::ExecuteBatchDmlResponse>
SpannerMetadata::ExecuteBatchDml(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::ExecuteBatchDmlRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->ExecuteBatchDml(context, options, request);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<
    google::spanner::v1::PartialResultSet>>
SpannerMetadata::StreamingRead(
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::spanner::v1::ReadRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->StreamingRead(std::move(context), options, request);
}

StatusOr<google::spanner::v1::Transaction> SpannerMetadata::BeginTransaction(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::BeginTransactionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->BeginTransaction(context, options, request);
}

StatusOr<google::spanner::v1::CommitResponse> SpannerMetadata::Commit(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::CommitRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->Commit(context, options, request);
}

Status SpannerMetadata::Rollback(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::RollbackRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->Rollback(context, options, request);
}

StatusOr<google::spanner::v1::PartitionResponse>
SpannerMetadata::PartitionQuery(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::PartitionQueryRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->PartitionQuery(context, options, request);
}

StatusOr<google::spanner::v1::PartitionResponse> SpannerMetadata::PartitionRead(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::PartitionReadRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->PartitionRead(context, options, request);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<
    google::spanner::v1::BatchWriteResponse>>
SpannerMetadata::BatchWrite(
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::spanner::v1::BatchWriteRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->BatchWrite(std::move(context), options, request);
}

future<StatusOr<google::spanner::v1::BatchCreateSessionsResponse>>
SpannerMetadata::AsyncBatchCreateSessions(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::spanner::v1::BatchCreateSessionsRequest const& request) {
  SetMetadata(
      *context, *options,
      absl::StrCat("database=", internal::UrlEncode(request.database())));
  return child_->AsyncBatchCreateSessions(cq, std::move(context),
                                          std::move(options), request);
}

future<Status> SpannerMetadata::AsyncDeleteSession(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::spanner::v1::DeleteSessionRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteSession(cq, std::move(context), std::move(options),
                                    request);
}

future<StatusOr<google::spanner::v1::ResultSet>>
SpannerMetadata::AsyncExecuteSql(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::spanner::v1::ExecuteSqlRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("session=", internal::UrlEncode(request.session())));
  return child_->AsyncExecuteSql(cq, std::move(context), std::move(options),
                                 request);
}

void SpannerMetadata::SetMetadata(grpc::ClientContext& context,
                                  Options const& options,
                                  std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void SpannerMetadata::SetMetadata(grpc::ClientContext& context,
                                  Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace spanner_internal
}  // namespace cloud
}  // namespace google
