// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_holds.proto

#include "google/cloud/resourcemanager/v3/internal/tag_holds_option_defaults.h"
#include "google/cloud/resourcemanager/v3/tag_holds_connection.h"
#include "google/cloud/resourcemanager/v3/tag_holds_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace resourcemanager_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options TagHoldsDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_TAG_HOLDS_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_TAG_HOLDS_AUTHORITY",
      "cloudresourcemanager.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<resourcemanager_v3::TagHoldsRetryPolicyOption>()) {
    options.set<resourcemanager_v3::TagHoldsRetryPolicyOption>(
        resourcemanager_v3::TagHoldsLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<resourcemanager_v3::TagHoldsBackoffPolicyOption>()) {
    options.set<resourcemanager_v3::TagHoldsBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<resourcemanager_v3::TagHoldsPollingPolicyOption>()) {
    options.set<resourcemanager_v3::TagHoldsPollingPolicyOption>(
        GenericPollingPolicy<
            resourcemanager_v3::TagHoldsRetryPolicyOption::Type,
            resourcemanager_v3::TagHoldsBackoffPolicyOption::Type>(
            options.get<resourcemanager_v3::TagHoldsRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          resourcemanager_v3::TagHoldsConnectionIdempotencyPolicyOption>()) {
    options.set<resourcemanager_v3::TagHoldsConnectionIdempotencyPolicyOption>(
        resourcemanager_v3::MakeDefaultTagHoldsConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3_internal
}  // namespace cloud
}  // namespace google
