// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/uptime_service.proto

#include "google/cloud/monitoring/v3/uptime_check_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

UptimeCheckServiceConnectionIdempotencyPolicy::
    ~UptimeCheckServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<UptimeCheckServiceConnectionIdempotencyPolicy>
UptimeCheckServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<UptimeCheckServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency
UptimeCheckServiceConnectionIdempotencyPolicy::ListUptimeCheckConfigs(
    google::monitoring::v3::ListUptimeCheckConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency UptimeCheckServiceConnectionIdempotencyPolicy::GetUptimeCheckConfig(
    google::monitoring::v3::GetUptimeCheckConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
UptimeCheckServiceConnectionIdempotencyPolicy::CreateUptimeCheckConfig(
    google::monitoring::v3::CreateUptimeCheckConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
UptimeCheckServiceConnectionIdempotencyPolicy::UpdateUptimeCheckConfig(
    google::monitoring::v3::UpdateUptimeCheckConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
UptimeCheckServiceConnectionIdempotencyPolicy::DeleteUptimeCheckConfig(
    google::monitoring::v3::DeleteUptimeCheckConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency UptimeCheckServiceConnectionIdempotencyPolicy::ListUptimeCheckIps(
    google::monitoring::v3::ListUptimeCheckIpsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<UptimeCheckServiceConnectionIdempotencyPolicy>
MakeDefaultUptimeCheckServiceConnectionIdempotencyPolicy() {
  return std::make_unique<UptimeCheckServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google
