// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/autokey.proto

#include "google/cloud/kms/v1/autokey_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace kms_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AutokeyConnectionIdempotencyPolicy::~AutokeyConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<AutokeyConnectionIdempotencyPolicy>
AutokeyConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AutokeyConnectionIdempotencyPolicy>(*this);
}

Idempotency AutokeyConnectionIdempotencyPolicy::CreateKeyHandle(
    google::cloud::kms::v1::CreateKeyHandleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutokeyConnectionIdempotencyPolicy::GetKeyHandle(
    google::cloud::kms::v1::GetKeyHandleRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutokeyConnectionIdempotencyPolicy::ListKeyHandles(
    google::cloud::kms::v1::ListKeyHandlesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<AutokeyConnectionIdempotencyPolicy>
MakeDefaultAutokeyConnectionIdempotencyPolicy() {
  return std::make_unique<AutokeyConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1
}  // namespace cloud
}  // namespace google
