// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#include "google/cloud/eventarc/v1/internal/eventarc_connection_impl.h"
#include "google/cloud/eventarc/v1/internal/eventarc_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace eventarc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<eventarc_v1::EventarcRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<eventarc_v1::EventarcRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<eventarc_v1::EventarcBackoffPolicyOption>()->clone();
}

std::unique_ptr<eventarc_v1::EventarcConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<eventarc_v1::EventarcConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<eventarc_v1::EventarcPollingPolicyOption>()->clone();
}

}  // namespace

EventarcConnectionImpl::EventarcConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<eventarc_v1_internal::EventarcStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      EventarcConnection::options())) {}

StatusOr<google::cloud::eventarc::v1::Trigger>
EventarcConnectionImpl::GetTrigger(
    google::cloud::eventarc::v1::GetTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTrigger(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetTriggerRequest const& request) {
        return stub_->GetTrigger(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::Trigger>
EventarcConnectionImpl::ListTriggers(
    google::cloud::eventarc::v1::ListTriggersRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTriggers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Trigger>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListTriggersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::ListTriggersRequest const&
                       request) {
              return stub->ListTriggers(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListTriggersResponse r) {
        std::vector<google::cloud::eventarc::v1::Trigger> result(
            r.triggers().size());
        auto& messages = *r.mutable_triggers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::CreateTrigger(
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateTrigger(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
        return stub->AsyncCreateTrigger(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::CreateTrigger(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTrigger(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
        return stub_->CreateTrigger(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::CreateTrigger(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Trigger>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateTrigger",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::UpdateTrigger(
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateTrigger(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
        return stub->AsyncUpdateTrigger(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::UpdateTrigger(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateTrigger(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
        return stub_->UpdateTrigger(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::UpdateTrigger(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Trigger>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateTrigger",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::DeleteTrigger(
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteTrigger(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
        return stub->AsyncDeleteTrigger(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::DeleteTrigger(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTrigger(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
        return stub_->DeleteTrigger(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::DeleteTrigger(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Trigger>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteTrigger",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::eventarc::v1::Channel>
EventarcConnectionImpl::GetChannel(
    google::cloud::eventarc::v1::GetChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetChannel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetChannelRequest const& request) {
        return stub_->GetChannel(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::Channel>
EventarcConnectionImpl::ListChannels(
    google::cloud::eventarc::v1::ListChannelsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListChannels(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Channel>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListChannelsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::ListChannelsRequest const&
                       request) {
              return stub->ListChannels(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListChannelsResponse r) {
        std::vector<google::cloud::eventarc::v1::Channel> result(
            r.channels().size());
        auto& messages = *r.mutable_channels();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::CreateChannel(
    google::cloud::eventarc::v1::CreateChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateChannel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateChannelRequest const& request) {
        return stub->AsyncCreateChannel(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::CreateChannel(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateChannel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateChannelRequest const& request) {
        return stub_->CreateChannel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::CreateChannel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Channel>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateChannel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::UpdateChannel(
    google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateChannel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
        return stub->AsyncUpdateChannel(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::UpdateChannel(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateChannel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
        return stub_->UpdateChannel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::UpdateChannel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Channel>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateChannel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::DeleteChannel(
    google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteChannel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
        return stub->AsyncDeleteChannel(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> EventarcConnectionImpl::DeleteChannel(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteChannel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
        return stub_->DeleteChannel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcConnectionImpl::DeleteChannel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::eventarc::v1::Channel>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteChannel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::Channel>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Channel>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::eventarc::v1::Provider>
EventarcConnectionImpl::GetProvider(
    google::cloud::eventarc::v1::GetProviderRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetProvider(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetProviderRequest const& request) {
        return stub_->GetProvider(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::Provider>
EventarcConnectionImpl::ListProviders(
    google::cloud::eventarc::v1::ListProvidersRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListProviders(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Provider>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListProvidersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::ListProvidersRequest const&
                       request) {
              return stub->ListProviders(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListProvidersResponse r) {
        std::vector<google::cloud::eventarc::v1::Provider> result(
            r.providers().size());
        auto& messages = *r.mutable_providers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::eventarc::v1::ChannelConnection>
EventarcConnectionImpl::GetChannelConnection(
    google::cloud::eventarc::v1::GetChannelConnectionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetChannelConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetChannelConnectionRequest const&
                 request) {
        return stub_->GetChannelConnection(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::eventarc::v1::ChannelConnection>
EventarcConnectionImpl::ListChannelConnections(
    google::cloud::eventarc::v1::ListChannelConnectionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListChannelConnections(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::ChannelConnection>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<eventarc_v1::EventarcRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::eventarc::v1::ListChannelConnectionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::eventarc::v1::
                       ListChannelConnectionsRequest const& request) {
              return stub->ListChannelConnections(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::eventarc::v1::ListChannelConnectionsResponse r) {
        std::vector<google::cloud::eventarc::v1::ChannelConnection> result(
            r.channel_connections().size());
        auto& messages = *r.mutable_channel_connections();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcConnectionImpl::CreateChannelConnection(
    google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateChannelConnection(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::ChannelConnection>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
              request) {
        return stub->AsyncCreateChannelConnection(cq, std::move(context),
                                                  std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::ChannelConnection>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::CreateChannelConnection(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateChannelConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
                 request) {
        return stub_->CreateChannelConnection(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcConnectionImpl::CreateChannelConnection(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::eventarc::v1::ChannelConnection>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateChannelConnection",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::ChannelConnection>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::ChannelConnection>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcConnectionImpl::DeleteChannelConnection(
    google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteChannelConnection(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::ChannelConnection>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
              request) {
        return stub->AsyncDeleteChannelConnection(cq, std::move(context),
                                                  std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::ChannelConnection>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
EventarcConnectionImpl::DeleteChannelConnection(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteChannelConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
                 request) {
        return stub_->DeleteChannelConnection(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcConnectionImpl::DeleteChannelConnection(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::eventarc::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::eventarc::v1::ChannelConnection>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteChannelConnection",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::eventarc::v1::ChannelConnection>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::ChannelConnection>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcConnectionImpl::GetGoogleChannelConfig(
    google::cloud::eventarc::v1::GetGoogleChannelConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGoogleChannelConfig(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::eventarc::v1::GetGoogleChannelConfigRequest const&
                 request) {
        return stub_->GetGoogleChannelConfig(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcConnectionImpl::UpdateGoogleChannelConfig(
    google::cloud::eventarc::v1::UpdateGoogleChannelConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateGoogleChannelConfig(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::eventarc::v1::UpdateGoogleChannelConfigRequest const&
              request) {
        return stub_->UpdateGoogleChannelConfig(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_v1_internal
}  // namespace cloud
}  // namespace google
