// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/engine_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_ENGINE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_ENGINE_CLIENT_H

#include "google/cloud/discoveryengine/v1/engine_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for managing [Engine][google.cloud.discoveryengine.v1.Engine]
/// configuration.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.discoveryengine.v1.Engine]:
/// @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
///
class EngineServiceClient {
 public:
  explicit EngineServiceClient(
      std::shared_ptr<EngineServiceConnection> connection, Options opts = {});
  ~EngineServiceClient();

  ///@{
  /// @name Copy and move support
  EngineServiceClient(EngineServiceClient const&) = default;
  EngineServiceClient& operator=(EngineServiceClient const&) = default;
  EngineServiceClient(EngineServiceClient&&) = default;
  EngineServiceClient& operator=(EngineServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(EngineServiceClient const& a,
                         EngineServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(EngineServiceClient const& a,
                         EngineServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a [Engine][google.cloud.discoveryengine.v1.Engine].
  ///
  /// @param parent  Required. The parent resource name, such as
  ///  `projects/{project}/locations/{location}/collections/{collection}`.
  /// @param engine  Required. The [Engine][google.cloud.discoveryengine.v1.Engine] to create.
  /// @param engine_id  Required. The ID to use for the
  ///  [Engine][google.cloud.discoveryengine.v1.Engine], which will become the
  ///  final component of the [Engine][google.cloud.discoveryengine.v1.Engine]'s
  ///  resource name.
  ///  @n
  ///  This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
  ///  standard with a length limit of 63 characters. Otherwise, an
  ///  INVALID_ARGUMENT error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.Engine] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.CreateEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L100}
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::Engine>> CreateEngine(
      std::string const& parent,
      google::cloud::discoveryengine::v1::Engine const& engine,
      std::string const& engine_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEngine
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEngine(
      NoAwaitTag, std::string const& parent,
      google::cloud::discoveryengine::v1::Engine const& engine,
      std::string const& engine_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a [Engine][google.cloud.discoveryengine.v1.Engine].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.CreateEngineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.Engine] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.CreateEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L100}
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::Engine>> CreateEngine(
      google::cloud::discoveryengine::v1::CreateEngineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEngine
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEngine(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::CreateEngineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEngine
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::Engine>> CreateEngine(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a [Engine][google.cloud.discoveryengine.v1.Engine].
  ///
  /// @param name  Required. Full resource name of
  ///  [Engine][google.cloud.discoveryengine.v1.Engine], such as
  ///  `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
  ///  @n
  ///  If the caller does not have permission to delete the
  ///  [Engine][google.cloud.discoveryengine.v1.Engine], regardless of whether or
  ///  not it exists, a PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the [Engine][google.cloud.discoveryengine.v1.Engine] to delete does not
  ///  exist, a NOT_FOUND error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.DeleteEngineMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DeleteEngineMetadata]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L163}
  /// [google.cloud.discoveryengine.v1.DeleteEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L140}
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>
  DeleteEngine(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEngine
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEngine(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Deletes a [Engine][google.cloud.discoveryengine.v1.Engine].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.DeleteEngineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.DeleteEngineMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DeleteEngineMetadata]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L163}
  /// [google.cloud.discoveryengine.v1.DeleteEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L140}
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>
  DeleteEngine(
      google::cloud::discoveryengine::v1::DeleteEngineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEngine
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEngine(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::DeleteEngineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEngine
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>
  DeleteEngine(google::longrunning::Operation const& operation,
               Options opts = {});

  // clang-format off
  ///
  /// Updates an [Engine][google.cloud.discoveryengine.v1.Engine]
  ///
  /// @param engine  Required. The [Engine][google.cloud.discoveryengine.v1.Engine] to update.
  ///  @n
  ///  If the caller does not have permission to update the
  ///  [Engine][google.cloud.discoveryengine.v1.Engine], regardless of whether or
  ///  not it exists, a PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the [Engine][google.cloud.discoveryengine.v1.Engine] to update does not
  ///  exist, a NOT_FOUND error is returned.
  /// @param update_mask  Indicates which fields in the provided
  ///  [Engine][google.cloud.discoveryengine.v1.Engine] to update.
  ///  @n
  ///  If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
  ///  is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Engine])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  /// [google.cloud.discoveryengine.v1.UpdateEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L225}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Engine> UpdateEngine(
      google::cloud::discoveryengine::v1::Engine const& engine,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an [Engine][google.cloud.discoveryengine.v1.Engine]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.UpdateEngineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Engine])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  /// [google.cloud.discoveryengine.v1.UpdateEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L225}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Engine> UpdateEngine(
      google::cloud::discoveryengine::v1::UpdateEngineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a [Engine][google.cloud.discoveryengine.v1.Engine].
  ///
  /// @param name  Required. Full resource name of
  ///  [Engine][google.cloud.discoveryengine.v1.Engine], such as
  ///  `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Engine])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  /// [google.cloud.discoveryengine.v1.GetEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L175}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Engine> GetEngine(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a [Engine][google.cloud.discoveryengine.v1.Engine].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.GetEngineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Engine])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  /// [google.cloud.discoveryengine.v1.GetEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L175}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Engine> GetEngine(
      google::cloud::discoveryengine::v1::GetEngineRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all the [Engine][google.cloud.discoveryengine.v1.Engine]s associated
  /// with the project.
  ///
  /// @param parent  Required. The parent resource name, such as
  ///  `projects/{project}/locations/{location}/collections/{collection_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.discoveryengine.v1.Engine], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  /// [google.cloud.discoveryengine.v1.ListEnginesRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L190}
  ///
  // clang-format on
  StreamRange<google::cloud::discoveryengine::v1::Engine> ListEngines(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all the [Engine][google.cloud.discoveryengine.v1.Engine]s associated
  /// with the project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.ListEnginesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.discoveryengine.v1.Engine], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Engine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine.proto#L35}
  /// [google.cloud.discoveryengine.v1.ListEnginesRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/engine_service.proto#L190}
  ///
  // clang-format on
  StreamRange<google::cloud::discoveryengine::v1::Engine> ListEngines(
      google::cloud::discoveryengine::v1::ListEnginesRequest request,
      Options opts = {});

 private:
  std::shared_ptr<EngineServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_ENGINE_CLIENT_H
