// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/intent.proto

#include "google/cloud/dialogflow_es/intents_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

IntentsConnectionIdempotencyPolicy::~IntentsConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<IntentsConnectionIdempotencyPolicy>
IntentsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<IntentsConnectionIdempotencyPolicy>(*this);
}

Idempotency IntentsConnectionIdempotencyPolicy::ListIntents(
    google::cloud::dialogflow::v2::ListIntentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency IntentsConnectionIdempotencyPolicy::GetIntent(
    google::cloud::dialogflow::v2::GetIntentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency IntentsConnectionIdempotencyPolicy::CreateIntent(
    google::cloud::dialogflow::v2::CreateIntentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IntentsConnectionIdempotencyPolicy::UpdateIntent(
    google::cloud::dialogflow::v2::UpdateIntentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IntentsConnectionIdempotencyPolicy::DeleteIntent(
    google::cloud::dialogflow::v2::DeleteIntentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IntentsConnectionIdempotencyPolicy::BatchUpdateIntents(
    google::cloud::dialogflow::v2::BatchUpdateIntentsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IntentsConnectionIdempotencyPolicy::BatchDeleteIntents(
    google::cloud::dialogflow::v2::BatchDeleteIntentsRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<IntentsConnectionIdempotencyPolicy>
MakeDefaultIntentsConnectionIdempotencyPolicy() {
  return std::make_unique<IntentsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
