// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/admin/v1/datastore_admin.proto

#include "google/cloud/datastore/admin/v1/internal/datastore_admin_connection_impl.h"
#include "google/cloud/datastore/admin/v1/internal/datastore_admin_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datastore_admin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<datastore_admin_v1::DatastoreAdminRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<datastore_admin_v1::DatastoreAdminRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<datastore_admin_v1::DatastoreAdminBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<datastore_admin_v1::DatastoreAdminConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<
          datastore_admin_v1::DatastoreAdminConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<datastore_admin_v1::DatastoreAdminPollingPolicyOption>()
      ->clone();
}

}  // namespace

DatastoreAdminConnectionImpl::DatastoreAdminConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<datastore_admin_v1_internal::DatastoreAdminStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      DatastoreAdminConnection::options())) {}

future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
DatastoreAdminConnectionImpl::ExportEntities(
    google::datastore::admin::v1::ExportEntitiesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->ExportEntities(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::datastore::admin::v1::ExportEntitiesResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::datastore::admin::v1::ExportEntitiesRequest const& request) {
        return stub->AsyncExportEntities(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::datastore::admin::v1::ExportEntitiesResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DatastoreAdminConnectionImpl::ExportEntities(
    NoAwaitTag,
    google::datastore::admin::v1::ExportEntitiesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ExportEntities(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::datastore::admin::v1::ExportEntitiesRequest const& request) {
        return stub_->ExportEntities(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
DatastoreAdminConnectionImpl::ExportEntities(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::datastore::admin::v1::
                   ExportEntitiesMetadata>()) {
    return make_ready_future<
        StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to ExportEntities",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::datastore::admin::v1::ExportEntitiesResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::datastore::admin::v1::ExportEntitiesResponse>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
DatastoreAdminConnectionImpl::ImportEntities(
    google::datastore::admin::v1::ImportEntitiesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->ImportEntities(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::datastore::admin::v1::ImportEntitiesMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::datastore::admin::v1::ImportEntitiesRequest const& request) {
        return stub->AsyncImportEntities(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::datastore::admin::v1::ImportEntitiesMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DatastoreAdminConnectionImpl::ImportEntities(
    NoAwaitTag,
    google::datastore::admin::v1::ImportEntitiesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ImportEntities(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::datastore::admin::v1::ImportEntitiesRequest const& request) {
        return stub_->ImportEntities(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
DatastoreAdminConnectionImpl::ImportEntities(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::datastore::admin::v1::
                   ImportEntitiesMetadata>()) {
    return make_ready_future<
        StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to ImportEntities",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::datastore::admin::v1::ImportEntitiesMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::datastore::admin::v1::ImportEntitiesMetadata>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::datastore::admin::v1::Index>>
DatastoreAdminConnectionImpl::CreateIndex(
    google::datastore::admin::v1::CreateIndexRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateIndex(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::datastore::admin::v1::Index>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::datastore::admin::v1::CreateIndexRequest const& request) {
        return stub->AsyncCreateIndex(cq, std::move(context),
                                      std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::datastore::admin::v1::Index>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DatastoreAdminConnectionImpl::CreateIndex(
    NoAwaitTag,
    google::datastore::admin::v1::CreateIndexRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateIndex(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::admin::v1::CreateIndexRequest const& request) {
        return stub_->CreateIndex(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::datastore::admin::v1::Index>>
DatastoreAdminConnectionImpl::CreateIndex(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::datastore::admin::v1::
                   IndexOperationMetadata>()) {
    return make_ready_future<StatusOr<google::datastore::admin::v1::Index>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateIndex",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::datastore::admin::v1::Index>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::datastore::admin::v1::Index>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::datastore::admin::v1::Index>>
DatastoreAdminConnectionImpl::DeleteIndex(
    google::datastore::admin::v1::DeleteIndexRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteIndex(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::datastore::admin::v1::Index>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::datastore::admin::v1::DeleteIndexRequest const& request) {
        return stub->AsyncDeleteIndex(cq, std::move(context),
                                      std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::datastore::admin::v1::Index>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DatastoreAdminConnectionImpl::DeleteIndex(
    NoAwaitTag,
    google::datastore::admin::v1::DeleteIndexRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteIndex(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::admin::v1::DeleteIndexRequest const& request) {
        return stub_->DeleteIndex(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::datastore::admin::v1::Index>>
DatastoreAdminConnectionImpl::DeleteIndex(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::datastore::admin::v1::
                   IndexOperationMetadata>()) {
    return make_ready_future<StatusOr<google::datastore::admin::v1::Index>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteIndex",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::datastore::admin::v1::Index>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::datastore::admin::v1::Index>,
      polling_policy(*current), __func__);
}

StatusOr<google::datastore::admin::v1::Index>
DatastoreAdminConnectionImpl::GetIndex(
    google::datastore::admin::v1::GetIndexRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIndex(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::datastore::admin::v1::GetIndexRequest const& request) {
        return stub_->GetIndex(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::datastore::admin::v1::Index>
DatastoreAdminConnectionImpl::ListIndexes(
    google::datastore::admin::v1::ListIndexesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListIndexes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::datastore::admin::v1::Index>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<datastore_admin_v1::DatastoreAdminRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::datastore::admin::v1::ListIndexesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::datastore::admin::v1::ListIndexesRequest const&
                       request) {
              return stub->ListIndexes(context, options, request);
            },
            options, r, function_name);
      },
      [](google::datastore::admin::v1::ListIndexesResponse r) {
        std::vector<google::datastore::admin::v1::Index> result(
            r.indexes().size());
        auto& messages = *r.mutable_indexes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_admin_v1_internal
}  // namespace cloud
}  // namespace google
