// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/http_health_checks/v1/http_health_checks.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_HTTP_HEALTH_CHECKS_V1_INTERNAL_HTTP_HEALTH_CHECKS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_HTTP_HEALTH_CHECKS_V1_INTERNAL_HTTP_HEALTH_CHECKS_TRACING_CONNECTION_H

#include "google/cloud/compute/http_health_checks/v1/http_health_checks_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_http_health_checks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class HttpHealthChecksTracingConnection
    : public compute_http_health_checks_v1::HttpHealthChecksConnection {
 public:
  ~HttpHealthChecksTracingConnection() override = default;

  explicit HttpHealthChecksTracingConnection(
      std::shared_ptr<compute_http_health_checks_v1::HttpHealthChecksConnection>
          child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteHttpHealthCheck(
      google::cloud::cpp::compute::http_health_checks::v1::
          DeleteHttpHealthCheckRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteHttpHealthCheck(
      NoAwaitTag, google::cloud::cpp::compute::http_health_checks::v1::
                      DeleteHttpHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteHttpHealthCheck(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::HttpHealthCheck> GetHttpHealthCheck(
      google::cloud::cpp::compute::http_health_checks::v1::
          GetHttpHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertHttpHealthCheck(
      google::cloud::cpp::compute::http_health_checks::v1::
          InsertHttpHealthCheckRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> InsertHttpHealthCheck(
      NoAwaitTag, google::cloud::cpp::compute::http_health_checks::v1::
                      InsertHttpHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertHttpHealthCheck(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StreamRange<google::cloud::cpp::compute::v1::HttpHealthCheck>
  ListHttpHealthChecks(google::cloud::cpp::compute::http_health_checks::v1::
                           ListHttpHealthChecksRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchHttpHealthCheck(google::cloud::cpp::compute::http_health_checks::v1::
                           PatchHttpHealthCheckRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> PatchHttpHealthCheck(
      NoAwaitTag, google::cloud::cpp::compute::http_health_checks::v1::
                      PatchHttpHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchHttpHealthCheck(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  UpdateHttpHealthCheck(
      google::cloud::cpp::compute::http_health_checks::v1::
          UpdateHttpHealthCheckRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> UpdateHttpHealthCheck(
      NoAwaitTag, google::cloud::cpp::compute::http_health_checks::v1::
                      UpdateHttpHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  UpdateHttpHealthCheck(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

 private:
  std::shared_ptr<compute_http_health_checks_v1::HttpHealthChecksConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_http_health_checks_v1::HttpHealthChecksConnection>
MakeHttpHealthChecksTracingConnection(
    std::shared_ptr<compute_http_health_checks_v1::HttpHealthChecksConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_http_health_checks_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_HTTP_HEALTH_CHECKS_V1_INTERNAL_HTTP_HEALTH_CHECKS_TRACING_CONNECTION_H
