// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_MOCKS_MOCK_CLOUD_CONTROLS_PARTNER_CORE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_MOCKS_MOCK_CLOUD_CONTROLS_PARTNER_CORE_CONNECTION_H

#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_core_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `CloudControlsPartnerCoreConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `CloudControlsPartnerCoreClient`. To
 * do so, construct an object of type `CloudControlsPartnerCoreClient` with an
 * instance of this class. Then use the Google Test framework functions to
 * program the behavior of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockCloudControlsPartnerCoreConnection
    : public cloudcontrolspartner_v1::CloudControlsPartnerCoreConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::cloudcontrolspartner::v1::Workload>, GetWorkload,
      (google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::cloudcontrolspartner::v1::Workload>),
      ListWorkloads,
      (google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::cloudcontrolspartner::v1::Customer>, GetCustomer,
      (google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::cloudcontrolspartner::v1::Customer>),
      ListCustomers,
      (google::cloud::cloudcontrolspartner::v1::ListCustomersRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>,
      GetEkmConnections,
      (google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>,
      GetPartnerPermissions,
      (google::cloud::cloudcontrolspartner::v1::
           GetPartnerPermissionsRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<
          google::cloud::cloudcontrolspartner::v1::AccessApprovalRequest>),
      ListAccessApprovalRequests,
      (google::cloud::cloudcontrolspartner::v1::
           ListAccessApprovalRequestsRequest request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::cloudcontrolspartner::v1::Partner>,
              GetPartner,
              (google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const&
                   request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_MOCKS_MOCK_CLOUD_CONTROLS_PARTNER_CORE_CONNECTION_H
