// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BINARYAUTHORIZATION_V1_BINAUTHZ_MANAGEMENT_SERVICE_V1_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BINARYAUTHORIZATION_V1_BINAUTHZ_MANAGEMENT_SERVICE_V1_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/binaryauthorization/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class BinauthzManagementServiceV1ConnectionIdempotencyPolicy {
 public:
  virtual ~BinauthzManagementServiceV1ConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<
      BinauthzManagementServiceV1ConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency GetPolicy(
      google::cloud::binaryauthorization::v1::GetPolicyRequest const& request);

  virtual google::cloud::Idempotency UpdatePolicy(
      google::cloud::binaryauthorization::v1::UpdatePolicyRequest const&
          request);

  virtual google::cloud::Idempotency CreateAttestor(
      google::cloud::binaryauthorization::v1::CreateAttestorRequest const&
          request);

  virtual google::cloud::Idempotency GetAttestor(
      google::cloud::binaryauthorization::v1::GetAttestorRequest const&
          request);

  virtual google::cloud::Idempotency UpdateAttestor(
      google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&
          request);

  virtual google::cloud::Idempotency ListAttestors(
      google::cloud::binaryauthorization::v1::ListAttestorsRequest request);

  virtual google::cloud::Idempotency DeleteAttestor(
      google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&
          request);
};

std::unique_ptr<BinauthzManagementServiceV1ConnectionIdempotencyPolicy>
MakeDefaultBinauthzManagementServiceV1ConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BINARYAUTHORIZATION_V1_BINAUTHZ_MANAGEMENT_SERVICE_V1_CONNECTION_IDEMPOTENCY_POLICY_H
