// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/routine.proto

#include "google/cloud/bigquerycontrol/v2/internal/routine_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RoutineServiceTracingConnection::RoutineServiceTracingConnection(
    std::shared_ptr<bigquerycontrol_v2::RoutineServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::bigquery::v2::Routine>
RoutineServiceTracingConnection::GetRoutine(
    google::cloud::bigquery::v2::GetRoutineRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::RoutineServiceConnection::GetRoutine");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetRoutine(request));
}

StatusOr<google::cloud::bigquery::v2::Routine>
RoutineServiceTracingConnection::InsertRoutine(
    google::cloud::bigquery::v2::InsertRoutineRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::RoutineServiceConnection::InsertRoutine");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->InsertRoutine(request));
}

StatusOr<google::cloud::bigquery::v2::Routine>
RoutineServiceTracingConnection::UpdateRoutine(
    google::cloud::bigquery::v2::UpdateRoutineRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::RoutineServiceConnection::UpdateRoutine");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateRoutine(request));
}

StatusOr<google::cloud::bigquery::v2::Routine>
RoutineServiceTracingConnection::PatchRoutine(
    google::cloud::bigquery::v2::PatchRoutineRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::RoutineServiceConnection::PatchRoutine");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->PatchRoutine(request));
}

Status RoutineServiceTracingConnection::DeleteRoutine(
    google::cloud::bigquery::v2::DeleteRoutineRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::RoutineServiceConnection::DeleteRoutine");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteRoutine(request));
}

StatusOr<google::cloud::bigquery::v2::ListRoutinesResponse>
RoutineServiceTracingConnection::ListRoutines(
    google::cloud::bigquery::v2::ListRoutinesRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::RoutineServiceConnection::ListRoutines");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ListRoutines(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<bigquerycontrol_v2::RoutineServiceConnection>
MakeRoutineServiceTracingConnection(
    std::shared_ptr<bigquerycontrol_v2::RoutineServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RoutineServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google
