// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/dataset.proto

#include "google/cloud/bigquerycontrol/v2/internal/dataset_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DatasetServiceTracingConnection::DatasetServiceTracingConnection(
    std::shared_ptr<bigquerycontrol_v2::DatasetServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceTracingConnection::GetDataset(
    google::cloud::bigquery::v2::GetDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::DatasetServiceConnection::GetDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDataset(request));
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceTracingConnection::InsertDataset(
    google::cloud::bigquery::v2::InsertDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::DatasetServiceConnection::InsertDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->InsertDataset(request));
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceTracingConnection::PatchDataset(
    google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::DatasetServiceConnection::PatchDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->PatchDataset(request));
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceTracingConnection::UpdateDataset(
    google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::DatasetServiceConnection::UpdateDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateDataset(request));
}

Status DatasetServiceTracingConnection::DeleteDataset(
    google::cloud::bigquery::v2::DeleteDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::DatasetServiceConnection::DeleteDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDataset(request));
}

StreamRange<google::cloud::bigquery::v2::ListFormatDataset>
DatasetServiceTracingConnection::ListDatasets(
    google::cloud::bigquery::v2::ListDatasetsRequest request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::DatasetServiceConnection::ListDatasets");
  internal::OTelScope scope(span);
  auto sr = child_->ListDatasets(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::bigquery::v2::ListFormatDataset>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceTracingConnection::UndeleteDataset(
    google::cloud::bigquery::v2::UndeleteDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquerycontrol_v2::DatasetServiceConnection::UndeleteDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UndeleteDataset(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<bigquerycontrol_v2::DatasetServiceConnection>
MakeDatasetServiceTracingConnection(
    std::shared_ptr<bigquerycontrol_v2::DatasetServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DatasetServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google
