// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/notebook_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_NOTEBOOK_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_NOTEBOOK_CONNECTION_IMPL_H

#include "google/cloud/aiplatform/v1/internal/notebook_retry_traits.h"
#include "google/cloud/aiplatform/v1/internal/notebook_stub.h"
#include "google/cloud/aiplatform/v1/notebook_connection.h"
#include "google/cloud/aiplatform/v1/notebook_connection_idempotency_policy.h"
#include "google/cloud/aiplatform/v1/notebook_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class NotebookServiceConnectionImpl
    : public aiplatform_v1::NotebookServiceConnection {
 public:
  ~NotebookServiceConnectionImpl() override = default;

  NotebookServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<aiplatform_v1_internal::NotebookServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>>
  CreateNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateNotebookRuntimeTemplate(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>>
  CreateNotebookRuntimeTemplate(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  GetNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::GetNotebookRuntimeTemplateRequest const&
          request) override;

  StreamRange<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  ListNotebookRuntimeTemplates(
      google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesRequest
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteNotebookRuntimeTemplate(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookRuntimeTemplate(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  UpdateNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::UpdateNotebookRuntimeTemplateRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>>
  AssignNotebookRuntime(
      google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> AssignNotebookRuntime(
      NoAwaitTag,
      google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>>
  AssignNotebookRuntime(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookRuntime> GetNotebookRuntime(
      google::cloud::aiplatform::v1::GetNotebookRuntimeRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::NotebookRuntime>
  ListNotebookRuntimes(
      google::cloud::aiplatform::v1::ListNotebookRuntimesRequest request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookRuntime(
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteNotebookRuntime(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookRuntime(
      google::longrunning::Operation const& operation) override;

  future<
      StatusOr<google::cloud::aiplatform::v1::UpgradeNotebookRuntimeResponse>>
  UpgradeNotebookRuntime(
      google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpgradeNotebookRuntime(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
          request) override;

  future<
      StatusOr<google::cloud::aiplatform::v1::UpgradeNotebookRuntimeResponse>>
  UpgradeNotebookRuntime(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::StartNotebookRuntimeResponse>>
  StartNotebookRuntime(
      google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> StartNotebookRuntime(
      NoAwaitTag,
      google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::StartNotebookRuntimeResponse>>
  StartNotebookRuntime(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>>
  CreateNotebookExecutionJob(
      google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateNotebookExecutionJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>>
  CreateNotebookExecutionJob(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>
  GetNotebookExecutionJob(
      google::cloud::aiplatform::v1::GetNotebookExecutionJobRequest const&
          request) override;

  StreamRange<google::cloud::aiplatform::v1::NotebookExecutionJob>
  ListNotebookExecutionJobs(
      google::cloud::aiplatform::v1::ListNotebookExecutionJobsRequest request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookExecutionJob(
      google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteNotebookExecutionJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookExecutionJob(
      google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<aiplatform_v1_internal::NotebookServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_NOTEBOOK_CONNECTION_IMPL_H
