// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/genai_tuning_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_GEN_AI_TUNING_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_GEN_AI_TUNING_TRACING_CONNECTION_H

#include "google/cloud/aiplatform/v1/gen_ai_tuning_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class GenAiTuningServiceTracingConnection
    : public aiplatform_v1::GenAiTuningServiceConnection {
 public:
  ~GenAiTuningServiceTracingConnection() override = default;

  explicit GenAiTuningServiceTracingConnection(
      std::shared_ptr<aiplatform_v1::GenAiTuningServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::aiplatform::v1::TuningJob> CreateTuningJob(
      google::cloud::aiplatform::v1::CreateTuningJobRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::TuningJob> GetTuningJob(
      google::cloud::aiplatform::v1::GetTuningJobRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::TuningJob> ListTuningJobs(
      google::cloud::aiplatform::v1::ListTuningJobsRequest request) override;

  Status CancelTuningJob(
      google::cloud::aiplatform::v1::CancelTuningJobRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::TuningJob>> RebaseTunedModel(
      google::cloud::aiplatform::v1::RebaseTunedModelRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> RebaseTunedModel(
      NoAwaitTag,
      google::cloud::aiplatform::v1::RebaseTunedModelRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::TuningJob>> RebaseTunedModel(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<aiplatform_v1::GenAiTuningServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<aiplatform_v1::GenAiTuningServiceConnection>
MakeGenAiTuningServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::GenAiTuningServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_GEN_AI_TUNING_TRACING_CONNECTION_H
