// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#include "generator/integration_tests/golden/v1/internal/request_id_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RequestIdServiceTracingConnection::RequestIdServiceTracingConnection(
    std::shared_ptr<golden_v1::RequestIdServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::test::requestid::v1::Foo>
RequestIdServiceTracingConnection::CreateFoo(google::test::requestid::v1::CreateFooRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::RequestIdServiceConnection::CreateFoo");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateFoo(request));
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceTracingConnection::RenameFoo(google::test::requestid::v1::RenameFooRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::RequestIdServiceConnection::RenameFoo");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RenameFoo(request));
}

StatusOr<google::longrunning::Operation>
RequestIdServiceTracingConnection::RenameFoo(
    NoAwaitTag, google::test::requestid::v1::RenameFooRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::RequestIdServiceConnection::RenameFoo");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->RenameFoo(
      NoAwaitTag{}, request));
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceTracingConnection::RenameFoo(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "golden_v1::RequestIdServiceConnection::RenameFoo");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
      child_->RenameFoo(operation));
}

StreamRange<google::test::requestid::v1::Foo>
RequestIdServiceTracingConnection::ListFoos(google::test::requestid::v1::ListFoosRequest request) {
  auto span = internal::MakeSpan("golden_v1::RequestIdServiceConnection::ListFoos");
  internal::OTelScope scope(span);
  auto sr = child_->ListFoos(std::move(request));
  return internal::MakeTracedStreamRange<google::test::requestid::v1::Foo>(
        std::move(span), std::move(sr));
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceTracingConnection::AsyncCreateFoo(google::test::requestid::v1::CreateFooRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::RequestIdServiceConnection::AsyncCreateFoo");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AsyncCreateFoo(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<golden_v1::RequestIdServiceConnection>
MakeRequestIdServiceTracingConnection(
    std::shared_ptr<golden_v1::RequestIdServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RequestIdServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
