/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2025 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * TransfDIFSPrismIteration  fragmentarium code, mdifs by knighty (jan 2012)
 * and http://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_prism.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSPrismIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 zc = z;
	REAL t, tp = 0.0f;

	// swap axis
	if (fractal->transformCommon.functionEnabledSwFalse)
	{
		REAL temp = zc.x;
		zc.x = zc.z;
		zc.z = temp;
	}

	REAL priX = max(fabs(zc.y) * SQRT_3_4_F + zc.z * 0.5f, -zc.z) - fractal->transformCommon.offset05;
	tp = fabs(priX);
	if (fractal->transformCommon.functionEnabledFalse)
	{
		t = tp - fractal->transformCommon.offsetp01;
		priX = max(priX, t);
	}

	REAL priD = max(fabs(zc.x) - fractal->transformCommon.offset1, priX);

	REAL colDist = aux->dist;
	aux->dist = min(aux->dist, priD / (aux->DE + fractal->analyticDE.offset0));

	if (fractal->foldColor.auxColorEnabledFalse && colDist != aux->dist
			&& aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		REAL addCol = fractal->foldColor.difs0000.y;
		if (fractal->foldColor.auxColorEnabledAFalse)
		{
			//	if (priX == tp)
			//		aux->color += fractal->foldColor.difs0000.y;
			if (tp > fractal->transformCommon.offsetp01) addCol = fractal->foldColor.difs0000.z;
			if (fractal->transformCommon.offset1 - fractal->foldColor.difs0 < fabs(zc.x))
				addCol = fractal->foldColor.difs0000.w;
		}
		if (!fractal->foldColor.auxColorEnabledBFalse)
		{
			aux->color = addCol;
		}
		else
		{
			aux->color += addCol + fractal->foldColor.difs0000.x; // aux->color default 1
		}
	}
	return z;
}