/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Testing
 *
 * https://www.shadertoy.com/view/3ddSDs
 * Based upon: https://www.shadertoy.com/view/XdlSD4

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_testing.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TestingIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledM)
	{

		z.x = fabs(z.x + fractal->transformCommon.additionConstant111.x)
					- fabs(z.x - fractal->transformCommon.additionConstant111.x) - z.x;
		z.y = fabs(z.y + fractal->transformCommon.additionConstant111.y)
					- fabs(z.y - fractal->transformCommon.additionConstant111.y) - z.y;
		if (fractal->transformCommon.functionEnabled)
		{
			z.z = fabs(z.z + fractal->transformCommon.additionConstant111.z)
						- fabs(z.z - fractal->transformCommon.additionConstant111.z) - z.z;
		}

		REAL rr = dot(z, z);
		if (rr < fractal->transformCommon.minR2p25)
		{
			z *= fractal->transformCommon.maxMinR2factor;
			aux->DE *= fractal->transformCommon.maxMinR2factor;
		}
		else if (rr < fractal->transformCommon.maxR2d1)
		{
			z *= fractal->transformCommon.maxR2d1 / rr;
			aux->DE *= fractal->transformCommon.maxR2d1 / rr;
		}

		// scale
		REAL useScale = 1.0f;
		useScale = aux->actualScaleA + fractal->transformCommon.scale2;
		z *= useScale;
		aux->DE = aux->DE * fabs(useScale) + 1.0f;

		if (fractal->transformCommon.functionEnabledKFalse
				&& aux->i >= fractal->transformCommon.startIterationsK
				&& aux->i < fractal->transformCommon.stopIterationsK)
		{
			// update actualScaleA for next iteration
			REAL vary = fractal->transformCommon.scaleVary0
									* (fabs(aux->actualScaleA) - fractal->transformCommon.scaleC1);
			aux->actualScaleA -= vary;
		}

		// z *= fractal->transformCommon.scale2;
		// aux->DE = aux->DE * fabs(fractal->transformCommon.scale2) + 1.0f;
	}

	// menger
	if (fractal->transformCommon.functionEnabledNFalse)
	{
		z = fabs(z + fractal->transformCommon.offsetA000);

		if (z.x - z.y < 0.0f)
		{
			REAL temp = z.x;
			z.x = z.y;
			z.y = temp;
		}
		if (z.x - z.z < 0.0f)
		{
			REAL temp = z.x;
			z.x = z.z;
			z.z = temp;
		}
		if (z.y - z.z < 0.0f)
		{
			REAL temp = z.y;
			z.y = z.z;
			z.z = temp;
		}

		z *= fractal->transformCommon.scale3; // 3

		z.x -= 2.0f;
		z.y -= 2.0f;
		if (z.z > 1.0f) z.z -= 2.0f;

		aux->DE *= fractal->transformCommon.scale3; // 3
	}

	// bulb
	if (fractal->transformCommon.functionEnabledOFalse)
	{
		// if (aux->r < 1e-21f) aux->r = 1e-21f;
		REAL th0 = asin(z.z / aux->r) + fractal->bulb.betaAngleOffset;
		REAL ph0 = atan2(z.y, z.x) + fractal->bulb.alphaAngleOffset;
		REAL rp = pow(aux->r, fractal->bulb.power - 1.0f);
		REAL th = th0 * fractal->bulb.power;
		REAL ph = ph0 * fractal->bulb.power;
		REAL cth = native_cos(th);
		aux->DE = (rp * aux->DE) * fractal->bulb.power + 1.0f;
		rp *= aux->r;
		z.x = cth * native_cos(ph) * rp;
		z.y = cth * native_sin(ph) * rp;
		z.z = native_sin(th) * rp;
	}
	// rotation
	if (fractal->transformCommon.functionEnabledRFalse)
	{
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	}
	z += fractal->transformCommon.offset000;

	z += aux->c * fractal->transformCommon.constantMultiplier111;

	// THE FOLLOWING CAN BE A TRANSFORM

	REAL4 zc = z;
	// cylinder
	REAL cylinder;
	REAL cylR = native_sqrt(zc.x * zc.x + zc.y * zc.y) - fractal->transformCommon.radius1;
	REAL cylH = fabs(zc.z) - fractal->transformCommon.offsetA1;
	cylR = max(cylR, 0.0f);
	cylH = max(cylH, 0.0f);
	REAL cylD = native_sqrt(cylR * cylR + cylH * cylH);
	cylinder = min(max(cylR, cylH), 0.0f) + cylD;

	// box
	REAL4 boxSize = fractal->transformCommon.offset111;
	zc = fabs(zc) - boxSize;
	zc.x = max(zc.x, 0.0f);
	zc.y = max(zc.y, 0.0f);
	zc.z = max(zc.z, 0.0f);
	REAL box = length(zc);
	zc = z;

	// ellipsoid
	REAL4 rads4 = fractal->transformCommon.offsetA111;
	REAL3 rads3 = (REAL3){rads4.x, rads4.y, rads4.z};
	REAL3 rV = (REAL3){zc.x, zc.y, zc.z};
	rV /= rads3;
	REAL3 rrV = rV;
	rrV /= rads3;
	REAL rd = length(rV);
	REAL rrd = length(rrV);
	REAL ellipsoid = rd * (rd - 1.0f) / rrd;

	// sphere
	REAL sphere = length(zc) - fractal->transformCommon.offset3;

	// torus
	REAL torus = native_sqrt(z.x * z.x + z.z * z.z) - fractal->transformCommon.offset4;
	torus = native_sqrt(torus * torus + z.y * z.y) - fractal->transformCommon.offset1;

	if (fractal->transformCommon.functionEnabledxFalse) torus = cylinder;
	if (fractal->transformCommon.functionEnabledyFalse) sphere = box;
	if (fractal->transformCommon.functionEnabledzFalse) sphere = ellipsoid;

	// THE FOLLOWING CAN BE A TRANSFORM
	int count = fractal->transformCommon.int3;
	int tempC = fractal->transformCommon.int3X;
	REAL r;

	if (!fractal->transformCommon.functionEnabledSwFalse)
	{
		r = (aux->i < count) ? torus : sphere;
	}
	else
	{
		r = (aux->i < count) ? sphere : torus;
	}

	aux->DE = aux->DE + fractal->analyticDE.offset0;

	REAL dd = r;
	if (fractal->transformCommon.functionEnabledAx)
	{
		dd = dd / aux->DE; // same as an uncondtional aux->dist
	}
	if (fractal->transformCommon.functionEnabledBFalse)
	{
		REAL rxy = native_sqrt(z.x * z.x + z.y * z.y);
		REAL m = max(rxy - fractal->transformCommon.offsetT1, fabs(rxy * z.z) / dd);
		dd = m / aux->DE;
	}
	if (fractal->transformCommon.functionEnabledCFalse)
	{
		dd = 0.5f * dd * log(dd) / aux->DE; // = using linear and increasining detail level
	}

	if (aux->i < tempC || dd < aux->colorHybrid)
	{
		aux->colorHybrid = dd;
	}

	aux->dist = aux->colorHybrid;
	return z;
}