"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useCache = void 0;
const React = __importStar(require("react"));
const react_1 = require("react");
const cache_1 = require("./cache");
const is_server_environment_1 = require("./is-server-environment");
/**
 * Cache to hold already used styles.
 * React Context on the server - singleton object on the client.
 */
const Cache = (0, is_server_environment_1.isServerEnvironment)() ? (0, react_1.createContext)(null) : {};
if (!(0, is_server_environment_1.isServerEnvironment)() && typeof document !== 'undefined') {
    /**
     * Iterates through all found style elements generated when server side rendering.
     *
     * @param cb
     */
    const ssrStyles = document.querySelectorAll('style[data-cmpld]');
    for (let i = 0; i < ssrStyles.length; i++) {
        // Move all found server-side rendered style elements to the head before React hydration happens.
        document.head.appendChild(ssrStyles[i]);
    }
}
/**
 * Hook using the cache created on the server or client.
 */
const useCache = () => {
    if (false) {
        return {};
    }
    if ((0, is_server_environment_1.isServerEnvironment)()) {
        // On the server we use React Context to we don't leak the cache between SSR calls.
        // During runtime this hook isn't conditionally called - it is at build time that the flow gets decided.
        // eslint-disable-next-line react-hooks/rules-of-hooks
        return (0, react_1.useContext)(Cache) || {};
    }
    // On the client we use the object singleton.
    return Cache;
};
exports.useCache = useCache;
/**
 * On the server this ensures the minimal amount of styles will be rendered
 * safely using React Context.
 *
 * On the browser this turns into a fragment with no React Context.
 */
const StyleCacheProvider = (props) => {
    if ((0, is_server_environment_1.isServerEnvironment)()) {
        // This code path isn't conditionally called at build time - safe to ignore.
        // eslint-disable-next-line react-hooks/rules-of-hooks
        const inserted = (0, exports.useCache)();
        return React.createElement(Cache.Provider, { value: inserted }, props.children);
    }
    return props.children;
};
exports.default = StyleCacheProvider;
//# sourceMappingURL=style-cache.js.map