import { media } from './media-helper';
type NestedQueryString = `above.${keyof typeof media.above}` | `below.${keyof typeof media.below}`;
/**
 * A hook which returnes a `window.matchMedia` result to help you build responsively around breakpoints in JavaScript.
 *
 * The returning value **WILL NOT** update or react to change.  You can use `mq.matches` to get the latest version and you can use the optional listener argument to react to changes as desired.
 *
 * @important
 *  - This will always be `null` in SSR and the event listener should not fire on SSR => clientside hydration.
 *  - `above.xxs` will always be truthy, your listener should never fire.
 *
 * @experimental This hook only works on the client-side and is not safe in an SSR environment as `window` is unavailable (and the user's viewport would be unknown)
 *
 * @example
 * const mq = useMediaQuery('below.md', useCallback((event) => console.log('changed', event.matches)), []))
 * const isMobile = mq?.matches;
 *
 * @returns
 *  - `MediaQueryList`, primarily used to get if that media query is currently
 *  - `null` when `matchMedia` is unavailable, eg. in SSR.
 */
export declare const UNSAFE_useMediaQuery: (queryString: NestedQueryString, listener?: ((event: MediaQueryListEvent) => void) | undefined) => MediaQueryList | null;
export {};
