/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ComponentPropsWithoutRef, type ComponentPropsWithRef, type ReactElement, type ReactNode } from 'react';
import type { BasePrimitiveProps, StyleProp } from '../components/types';
type AllowedElements = Exclude<keyof JSX.IntrinsicElements, 'button' | 'a'>;
type CustomElement<P = any> = {
    [K in AllowedElements]: P extends JSX.IntrinsicElements[K] ? K : never;
}[AllowedElements];
export type FocusableProps<T extends CustomElement> = Omit<ComponentPropsWithoutRef<T>, keyof BaseFocusableProps<T> | 'className' | 'style'> & BasePrimitiveProps & StyleProp & BaseFocusableProps<T>;
type BaseFocusableProps<T extends CustomElement> = {
    /**
     * The DOM element to render as the Focusable element.
     * @default 'button'
     */
    as?: T;
    children?: ReactNode;
    /**
     * Controls whether the focus ring should be applied around or within the composed element.
     */
    isInset?: boolean;
    /**
     * Forwarded ref.
     */
    ref?: ComponentPropsWithRef<T>['ref'];
};
type FocusableComponent = <T extends CustomElement>(props: FocusableProps<T>) => ReactElement;
/**
 * __Focus ring__
 *
 * A focus ring visually indicates the currently focused item.
 *
 */
declare const Focusable: FocusableComponent;
export default Focusable;
