/**
 * @jsxRuntime classic
 * @jsx jsx
 */

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
import { jsx } from '@emotion/react';
import { parseXcss } from '../xcss/xcss';
import { UNSAFE_buildAboveMediaQueryCSS, UNSAFE_buildBelowMediaQueryCSS } from './build-media-query-css';
const hideAboveQueries = UNSAFE_buildAboveMediaQueryCSS({
  display: 'none'
});
const hideBelowQueries = UNSAFE_buildBelowMediaQueryCSS({
  display: 'none'
});
/**
 * Hides the content at a given breakpoint.  By default, content is shown.  The primary use case is for visual presentation.
 * Mix `<Hide above="md">` with `<Show above="md">` to achieve content that shifts at a breakpoint.
 *
 * Please note:
 * - This only uses `display: none` hide, it does not skip rendering of children trees.
 * - As this is rendered at all times, there is little performance savings here (just that this is not painted).
 */
export const Hide = ({
  above,
  below,
  children,
  as: AsElement = 'div',
  xcss
}) => {
  const resolvedStyles = parseXcss(xcss);
  return jsx(AsElement
  // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
  , {
    className: resolvedStyles.static,
    css: [above && hideAboveQueries[above], below && hideBelowQueries[below], resolvedStyles.emotion]
  }, children);
};