import type { DomainKey } from '../types';
import { COMMERCIAL, DEV, FEDRAMP_FEDEX, FEDRAMP_MODERATE, PRODUCTION, STAGING } from './index';
export type DomainConfig = {
    [COMMERCIAL]: RequiredDomainEnvironment;
    [FEDRAMP_FEDEX]?: DomainEnvironment;
    [FEDRAMP_MODERATE]?: DomainEnvironment;
};
export type DomainEnvironment = {
    [STAGING]?: string;
    [PRODUCTION]?: string;
    [DEV]?: string;
};
export type RequiredDomainEnvironment = {
    [PRODUCTION]: string;
} & DomainEnvironment;
/**
 * Creates a mapping from perimeter to environment to domain, allowing simply substitutions
 * to minimize the amount of data we have to ship to the browser.
 */
export declare const domainMap: DomainConfig;
export declare const subdomainOverride: Partial<Record<DomainKey, string>>;
/**
 * Contains overrides for domains where the pattern of subdomain only doesn't work.
 * Useful in situations where this is a global domain that won't vary per environment.
 * Priority is exact match > fallback to commercial production
 *
 * IF YOU ADD SOMETHING HERE YOU MUST EXPLICITLY ADD EVERY PERIMETER AND EVERY ENVIRONMENT
 * ANYTHING NOT SET EXPLICITLY WILL DEFEAULT TO COMMERCIAL/PRODUCTION
 */
export declare const fullDomainOverride: Partial<Record<DomainKey, DomainConfig>>;
