/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef jit_CacheIROpsGenerated_h
#define jit_CacheIROpsGenerated_h

/* This file is generated by jit/GenerateCacheIRFiles.py. Do not edit! */

#define CACHE_IR_OPS(_)\
_(ReturnFromIC, 0, true, 1)\
_(GuardToObject, 1, true, 1)\
_(GuardIsNullOrUndefined, 1, true, 1)\
_(GuardIsNull, 1, true, 1)\
_(GuardIsUndefined, 1, true, 1)\
_(GuardToBoolean, 1, true, 1)\
_(GuardToString, 1, true, 1)\
_(GuardToSymbol, 1, true, 1)\
_(GuardToBigInt, 1, true, 1)\
_(GuardIsNumber, 1, true, 1)\
_(GuardToInt32, 1, true, 1)\
_(GuardBooleanToInt32, 1 + 1, true, 1)\
_(GuardToInt32Index, 1 + 1, true, 1)\
_(Int32ToIntPtr, 1 + 1, true, 1)\
_(GuardNumberToIntPtrIndex, 1 + 1 + 1, true, 2)\
_(GuardToInt32ModUint32, 1 + 1, true, 2)\
_(GuardToUint8Clamped, 1 + 1, true, 2)\
_(GuardNonDoubleType, 1 + 1, true, 1)\
_(GuardShape, 1 + 1, true, 1)\
_(GuardProto, 1 + 1, true, 1)\
_(GuardNullProto, 1, true, 1)\
_(GuardClass, 1 + 1, true, 1)\
_(GuardAnyClass, 1 + 1, true, 1)\
_(HasClassResult, 1 + 1, true, 1)\
_(CallRegExpMatcherResult, 1 + 1 + 1, true, 5)\
_(CallRegExpSearcherResult, 1 + 1 + 1, true, 5)\
_(CallRegExpTesterResult, 1 + 1 + 1, true, 5)\
_(RegExpFlagResult, 1 + 4, true, 2)\
_(CallSubstringKernelResult, 1 + 1 + 1, true, 5)\
_(StringReplaceStringResult, 1 + 1 + 1, true, 5)\
_(StringSplitStringResult, 1 + 1, true, 5)\
_(RegExpPrototypeOptimizableResult, 1, true, 4)\
_(RegExpInstanceOptimizableResult, 1 + 1, true, 4)\
_(GetFirstDollarIndexResult, 1, true, 5)\
_(GuardCompartment, 1 + 1 + 1, false, 2)\
_(GuardIsExtensible, 1, true, 1)\
_(GuardIsNativeObject, 1, true, 1)\
_(GuardIsProxy, 1, true, 1)\
_(GuardIsNotProxy, 1, true, 1)\
_(GuardIsNotArrayBufferMaybeShared, 1, true, 1)\
_(GuardIsTypedArray, 1, true, 1)\
_(GuardHasProxyHandler, 1 + 1, false, 1)\
_(GuardIsNotDOMProxy, 1, true, 1)\
_(GuardSpecificObject, 1 + 1, true, 1)\
_(GuardSpecificFunction, 1 + 1 + 1, true, 1)\
_(GuardFunctionScript, 1 + 1 + 1, true, 1)\
_(GuardSpecificAtom, 1 + 1, true, 4)\
_(GuardSpecificSymbol, 1 + 1, true, 1)\
_(GuardNoDenseElements, 1, true, 1)\
_(GuardStringToIndex, 1 + 1, true, 4)\
_(GuardStringToInt32, 1 + 1, true, 4)\
_(GuardStringToNumber, 1 + 1, true, 4)\
_(BooleanToNumber, 1 + 1, true, 1)\
_(GuardAndGetIterator, 1 + 1 + 1 + 1, false, 4)\
_(GuardHasGetterSetter, 1 + 1 + 1, true, 4)\
_(GuardInt32IsNonNegative, 1, true, 1)\
_(GuardIndexIsValidUpdateOrAdd, 1 + 1, true, 1)\
_(GuardIndexGreaterThanDenseInitLength, 1 + 1, true, 1)\
_(GuardTagNotEqual, 1 + 1, true, 1)\
_(GuardXrayExpandoShapeAndDefaultProto, 1 + 1, false, 2)\
_(GuardXrayNoExpando, 1, false, 2)\
_(GuardDynamicSlotIsSpecificObject, 1 + 1 + 1, true, 1)\
_(GuardFixedSlotValue, 1 + 1 + 1, true, 1)\
_(GuardDynamicSlotValue, 1 + 1 + 1, true, 1)\
_(GuardNoAllocationMetadataBuilder, 1, true, 1)\
_(GuardFunctionHasJitEntry, 1 + 1, true, 1)\
_(GuardFunctionHasNoJitEntry, 1, true, 1)\
_(GuardFunctionIsNonBuiltinCtor, 1, true, 1)\
_(GuardFunctionIsConstructor, 1, true, 1)\
_(GuardNotClassConstructor, 1, true, 1)\
_(GuardArrayIsPacked, 1, true, 1)\
_(GuardArgumentsObjectFlags, 1 + 1, true, 1)\
_(LoadObject, 1 + 1, true, 1)\
_(LoadProto, 1 + 1, true, 1)\
_(LoadEnclosingEnvironment, 1 + 1, true, 1)\
_(LoadWrapperTarget, 1 + 1, true, 1)\
_(LoadValueTag, 1 + 1, true, 1)\
_(LoadArgumentFixedSlot, 1 + 1, true, 1)\
_(LoadArgumentDynamicSlot, 1 + 1 + 1, true, 1)\
_(TruncateDoubleToUInt32, 1 + 1, true, 4)\
_(MegamorphicLoadSlotResult, 1 + 1, true, 4)\
_(MegamorphicLoadSlotByValueResult, 1 + 1, true, 4)\
_(MegamorphicStoreSlot, 1 + 1 + 1, true, 4)\
_(MegamorphicSetElement, 1 + 1 + 1 + 1, true, 5)\
_(MegamorphicHasPropResult, 1 + 1 + 1, true, 4)\
_(LoadDOMExpandoValue, 1 + 1, true, 1)\
_(LoadDOMExpandoValueGuardGeneration, 1 + 1 + 1 + 1, true, 2)\
_(LoadDOMExpandoValueIgnoreGeneration, 1 + 1, true, 1)\
_(GuardDOMExpandoMissingOrGuardShape, 1 + 1, true, 2)\
_(StoreFixedSlot, 1 + 1 + 1, true, 6)\
_(StoreDynamicSlot, 1 + 1 + 1, true, 6)\
_(AddAndStoreFixedSlot, 1 + 1 + 1 + 1, true, 6)\
_(AddAndStoreDynamicSlot, 1 + 1 + 1 + 1, true, 6)\
_(AllocateAndStoreDynamicSlot, 1 + 1 + 1 + 1 + 1, true, 6)\
_(StoreDenseElement, 1 + 1 + 1, true, 6)\
_(StoreDenseElementHole, 1 + 1 + 1 + 1, true, 6)\
_(ArrayPush, 1 + 1, true, 6)\
_(ArrayJoinResult, 1 + 1, true, 5)\
_(PackedArrayPopResult, 1, true, 2)\
_(PackedArrayShiftResult, 1, true, 4)\
_(PackedArraySliceResult, 1 + 1 + 1 + 1, true, 5)\
_(IsArrayResult, 1, true, 5)\
_(StoreFixedSlotUndefinedResult, 1 + 1 + 1, true, 4294967295)\
_(IsObjectResult, 1, true, 1)\
_(IsPackedArrayResult, 1, true, 2)\
_(IsCallableResult, 1, true, 4)\
_(IsConstructorResult, 1, true, 4)\
_(IsCrossRealmArrayConstructorResult, 1, true, 2)\
_(IsTypedArrayResult, 1 + 1, true, 5)\
_(IsTypedArrayConstructorResult, 1, true, 2)\
_(ArrayBufferViewByteOffsetInt32Result, 1, true, 1)\
_(ArrayBufferViewByteOffsetDoubleResult, 1, true, 1)\
_(TypedArrayByteLengthInt32Result, 1, true, 2)\
_(TypedArrayByteLengthDoubleResult, 1, true, 2)\
_(TypedArrayElementSizeResult, 1, true, 2)\
_(GuardHasAttachedArrayBuffer, 1, true, 2)\
_(FinishBoundFunctionInitResult, 1 + 1 + 1, true, 5)\
_(NewArrayIteratorResult, 1, true, 5)\
_(NewStringIteratorResult, 1, true, 5)\
_(NewRegExpStringIteratorResult, 1, true, 5)\
_(ObjectCreateResult, 1, true, 5)\
_(NewArrayFromLengthResult, 1 + 1, true, 5)\
_(NewTypedArrayFromLengthResult, 1 + 1, true, 5)\
_(NewTypedArrayFromArrayBufferResult, 1 + 1 + 1 + 1, true, 5)\
_(NewTypedArrayFromArrayResult, 1 + 1, true, 5)\
_(NewStringObjectResult, 1 + 1, true, 5)\
_(StringFromCharCodeResult, 1, true, 5)\
_(StringFromCodePointResult, 1, true, 5)\
_(StringToLowerCaseResult, 1, true, 5)\
_(StringToUpperCaseResult, 1, true, 5)\
_(MathAbsInt32Result, 1, true, 2)\
_(MathAbsNumberResult, 1, true, 1)\
_(MathClz32Result, 1, true, 1)\
_(MathSignInt32Result, 1, true, 1)\
_(MathSignNumberResult, 1, true, 2)\
_(MathSignNumberToInt32Result, 1, true, 2)\
_(MathImulResult, 1 + 1, true, 1)\
_(MathSqrtNumberResult, 1, true, 1)\
_(MathFRoundNumberResult, 1, true, 1)\
_(MathRandomResult, 1, true, 3)\
_(MathHypot2NumberResult, 1 + 1, true, 4)\
_(MathHypot3NumberResult, 1 + 1 + 1, true, 4)\
_(MathHypot4NumberResult, 1 + 1 + 1 + 1, true, 4)\
_(MathAtan2NumberResult, 1 + 1, true, 4)\
_(MathFloorNumberResult, 1, true, 4)\
_(MathCeilNumberResult, 1, true, 4)\
_(MathTruncNumberResult, 1, true, 4)\
_(MathFloorToInt32Result, 1, true, 3)\
_(MathCeilToInt32Result, 1, true, 1)\
_(MathTruncToInt32Result, 1, true, 4294967295)\
_(MathRoundToInt32Result, 1, true, 1)\
_(Int32MinMax, 1 + 1 + 1 + 1, true, 1)\
_(NumberMinMax, 1 + 1 + 1 + 1, true, 1)\
_(Int32MinMaxArrayResult, 1 + 1, true, 3)\
_(NumberMinMaxArrayResult, 1 + 1, true, 3)\
_(MathFunctionNumberResult, 1 + 1, true, 4)\
_(ObjectToStringResult, 1, true, 4)\
_(ReflectGetPrototypeOfResult, 1, true, 5)\
_(StoreTypedArrayElement, 1 + 1 + 1 + 1 + 1, true, 3)\
_(AtomicsCompareExchangeResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsExchangeResult, 1 + 1 + 1 + 1, true, 4)\
_(AtomicsAddResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsSubResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsAndResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsOrResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsXorResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsLoadResult, 1 + 1 + 1, true, 2)\
_(AtomicsStoreResult, 1 + 1 + 1 + 1, true, 2)\
_(AtomicsIsLockFreeResult, 1, true, 1)\
_(CallNativeSetter, 1 + 1 + 1 + 1 + 1, true, 5)\
_(CallScriptedSetter, 1 + 1 + 1 + 1 + 1, true, 3)\
_(CallInlinedSetter, 1 + 1 + 1 + 1 + 1 + 1, true, 3)\
_(CallDOMSetter, 1 + 1 + 1, true, 4)\
_(CallSetArrayLength, 1 + 1 + 1, true, 5)\
_(ProxySet, 1 + 1 + 1 + 1, true, 5)\
_(ProxySetByValue, 1 + 1 + 1 + 1, true, 5)\
_(CallAddOrUpdateSparseElementHelper, 1 + 1 + 1 + 1, true, 5)\
_(CallInt32ToString, 1 + 1, true, 4)\
_(CallNumberToString, 1 + 1, true, 4)\
_(BooleanToString, 1 + 1, true, 2)\
_(CallScriptedFunction, 1 + 1 + 1, true, 3)\
_(CallWasmFunction, 1 + 1 + 1 + 1 + 1, true, 3)\
_(GuardWasmArg, 1 + 1, true, 2)\
_(CallNativeFunction, 1 + 1 + 1 + 1, true, 4)\
_(CallDOMFunction, 1 + 1 + 1 + 1, true, 4)\
_(CallClassHook, 1 + 1 + 1 + 1, false, 4)\
_(CallInlinedFunction, 1 + 1 + 1 + 1, true, 4)\
_(MetaTwoByte, 1 + 1, true, 0)\
_(LoadFixedSlotResult, 1 + 1, true, 1)\
_(LoadFixedSlotTypedResult, 1 + 1 + 1, true, 1)\
_(LoadDynamicSlotResult, 1 + 1, true, 1)\
_(LoadDenseElementResult, 1 + 1, true, 2)\
_(LoadDenseElementHoleResult, 1 + 1, true, 2)\
_(CallGetSparseElementResult, 1 + 1, true, 5)\
_(LoadDenseElementExistsResult, 1 + 1, true, 1)\
_(LoadTypedArrayElementExistsResult, 1 + 1, true, 2)\
_(LoadDenseElementHoleExistsResult, 1 + 1, true, 2)\
_(LoadTypedArrayElementResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(LoadDataViewValueResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(StoreDataViewValueResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(LoadInt32ArrayLengthResult, 1, true, 1)\
_(LoadInt32ArrayLength, 1 + 1, true, 1)\
_(LoadArgumentsObjectArgResult, 1 + 1, true, 2)\
_(LoadArgumentsObjectLengthResult, 1, true, 1)\
_(LoadFunctionLengthResult, 1, true, 2)\
_(LoadFunctionNameResult, 1, true, 2)\
_(LoadArrayBufferByteLengthInt32Result, 1, true, 1)\
_(LoadArrayBufferByteLengthDoubleResult, 1, true, 1)\
_(LoadArrayBufferViewLengthInt32Result, 1, true, 1)\
_(LoadArrayBufferViewLengthDoubleResult, 1, true, 1)\
_(LoadStringCharResult, 1 + 1, true, 5)\
_(LoadStringCharCodeResult, 1 + 1, true, 3)\
_(LoadStringLengthResult, 1, true, 1)\
_(FrameIsConstructingResult, 0, true, 1)\
_(LoadEnvironmentFixedSlotResult, 1 + 1, true, 1)\
_(LoadEnvironmentDynamicSlotResult, 1 + 1, true, 1)\
_(LoadObjectResult, 1, true, 1)\
_(LoadStringResult, 1, true, 1)\
_(LoadSymbolResult, 1, true, 1)\
_(LoadInt32Result, 1, true, 1)\
_(LoadDoubleResult, 1, true, 2)\
_(LoadBigIntResult, 1, true, 1)\
_(CallScriptedGetterResult, 1 + 1 + 1 + 1, true, 5)\
_(CallInlinedGetterResult, 1 + 1 + 1 + 1 + 1, true, 5)\
_(CallNativeGetterResult, 1 + 1 + 1 + 1, true, 5)\
_(CallDOMGetterResult, 1 + 1, true, 4)\
_(ProxyGetResult, 1 + 1, true, 5)\
_(ProxyGetByValueResult, 1 + 1, true, 5)\
_(ProxyHasPropResult, 1 + 1 + 1, true, 5)\
_(CallObjectHasSparseElementResult, 1 + 1, true, 4)\
_(CallNativeGetElementResult, 1 + 1, true, 5)\
_(GetNextMapSetEntryForIteratorResult, 1 + 1 + 1, true, 4)\
_(LoadUndefinedResult, 0, true, 1)\
_(LoadBooleanResult, 1, true, 1)\
_(LoadInt32Constant, 1 + 1, true, 1)\
_(LoadBooleanConstant, 1 + 1, true, 1)\
_(LoadUndefined, 1, true, 1)\
_(LoadConstantString, 1 + 1, true, 1)\
_(LoadConstantStringResult, 1, true, 1)\
_(LoadInstanceOfObjectResult, 1 + 1, true, 3)\
_(LoadTypeOfObjectResult, 1, true, 4)\
_(DoubleAddResult, 1 + 1, true, 2)\
_(DoubleSubResult, 1 + 1, true, 2)\
_(DoubleMulResult, 1 + 1, true, 2)\
_(DoubleDivResult, 1 + 1, true, 2)\
_(DoubleModResult, 1 + 1, true, 4)\
_(DoublePowResult, 1 + 1, true, 4)\
_(Int32AddResult, 1 + 1, true, 1)\
_(Int32SubResult, 1 + 1, true, 1)\
_(Int32MulResult, 1 + 1, true, 2)\
_(Int32DivResult, 1 + 1, true, 2)\
_(Int32ModResult, 1 + 1, true, 2)\
_(Int32PowResult, 1 + 1, true, 1)\
_(BigIntAddResult, 1 + 1, true, 5)\
_(BigIntSubResult, 1 + 1, true, 5)\
_(BigIntMulResult, 1 + 1, true, 5)\
_(BigIntDivResult, 1 + 1, true, 5)\
_(BigIntModResult, 1 + 1, true, 5)\
_(BigIntPowResult, 1 + 1, true, 5)\
_(Int32BitOrResult, 1 + 1, true, 1)\
_(Int32BitXorResult, 1 + 1, true, 1)\
_(Int32BitAndResult, 1 + 1, true, 1)\
_(Int32LeftShiftResult, 1 + 1, true, 1)\
_(Int32RightShiftResult, 1 + 1, true, 1)\
_(Int32URightShiftResult, 1 + 1 + 1, true, 2)\
_(Int32NotResult, 1, true, 1)\
_(BigIntBitOrResult, 1 + 1, true, 5)\
_(BigIntBitXorResult, 1 + 1, true, 5)\
_(BigIntBitAndResult, 1 + 1, true, 5)\
_(BigIntLeftShiftResult, 1 + 1, true, 5)\
_(BigIntRightShiftResult, 1 + 1, true, 5)\
_(BigIntNotResult, 1, true, 5)\
_(Int32NegationResult, 1, true, 1)\
_(DoubleNegationResult, 1, true, 1)\
_(BigIntNegationResult, 1, true, 5)\
_(Int32IncResult, 1, true, 1)\
_(Int32DecResult, 1, true, 1)\
_(DoubleIncResult, 1, true, 1)\
_(DoubleDecResult, 1, true, 1)\
_(BigIntIncResult, 1, true, 5)\
_(BigIntDecResult, 1, true, 5)\
_(LoadInt32TruthyResult, 1, true, 2)\
_(LoadDoubleTruthyResult, 1, true, 2)\
_(LoadStringTruthyResult, 1, true, 2)\
_(LoadObjectTruthyResult, 1, true, 4)\
_(LoadBigIntTruthyResult, 1, true, 2)\
_(LoadValueTruthyResult, 1, true, 4)\
_(LoadValueResult, 1, false, 1)\
_(LoadOperandResult, 1, true, 1)\
_(NewPlainObjectResult, 4 + 4 + 1 + 1 + 1, true, 4)\
_(NewArrayObjectResult, 4 + 1 + 1, true, 4)\
_(CallStringConcatResult, 1 + 1, true, 5)\
_(CallStringObjectConcatResult, 1 + 1, false, 5)\
_(CallIsSuspendedGeneratorResult, 1, false, 2)\
_(CompareStringResult, 1 + 1 + 1, true, 5)\
_(CompareObjectResult, 1 + 1 + 1, true, 2)\
_(CompareSymbolResult, 1 + 1 + 1, true, 2)\
_(CompareInt32Result, 1 + 1 + 1, true, 2)\
_(CompareDoubleResult, 1 + 1 + 1, true, 2)\
_(CompareBigIntResult, 1 + 1 + 1, true, 4)\
_(CompareBigIntInt32Result, 1 + 1 + 1, true, 3)\
_(CompareBigIntNumberResult, 1 + 1 + 1, true, 4)\
_(CompareBigIntStringResult, 1 + 1 + 1, true, 5)\
_(CompareNullUndefinedResult, 1 + 1 + 1, true, 2)\
_(CompareDoubleSameValueResult, 1 + 1, true, 3)\
_(SameValueResult, 1 + 1, true, 4)\
_(IndirectTruncateInt32Result, 1, true, 1)\
_(BigIntAsIntNResult, 1 + 1, true, 5)\
_(BigIntAsUintNResult, 1 + 1, true, 5)\
_(CallPrintString, sizeof(uintptr_t), false, 1)\
_(Breakpoint, 0, false, 1)\
_(WrapResult, 0, false, 4)\
_(Bailout, 0, true, 0)\
_(AssertRecoveredOnBailoutResult, 1 + 1, true, 1)

#define CACHE_IR_WRITER_GENERATED \
void returnFromIC() {\
  writeOp(CacheOp::ReturnFromIC);\
  assertLengthMatches();\
}\
private:\
void guardToObject_(ValOperandId input) {\
  writeOp(CacheOp::GuardToObject);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
void guardIsNullOrUndefined(ValOperandId input) {\
  writeOp(CacheOp::GuardIsNullOrUndefined);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void guardIsNull(ValOperandId input) {\
  writeOp(CacheOp::GuardIsNull);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void guardIsUndefined(ValOperandId input) {\
  writeOp(CacheOp::GuardIsUndefined);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
private:\
void guardToBoolean_(ValOperandId input) {\
  writeOp(CacheOp::GuardToBoolean);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardToString_(ValOperandId input) {\
  writeOp(CacheOp::GuardToString);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardToSymbol_(ValOperandId input) {\
  writeOp(CacheOp::GuardToSymbol);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardToBigInt_(ValOperandId input) {\
  writeOp(CacheOp::GuardToBigInt);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardIsNumber_(ValOperandId input) {\
  writeOp(CacheOp::GuardIsNumber);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardToInt32_(ValOperandId input) {\
  writeOp(CacheOp::GuardToInt32);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
Int32OperandId guardBooleanToInt32(ValOperandId input) {\
  writeOp(CacheOp::GuardBooleanToInt32);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId guardToInt32Index(ValOperandId input) {\
  writeOp(CacheOp::GuardToInt32Index);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId int32ToIntPtr(Int32OperandId input) {\
  writeOp(CacheOp::Int32ToIntPtr);\
  writeOperandId(input);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId guardNumberToIntPtrIndex(NumberOperandId input, bool supportOOB) {\
  writeOp(CacheOp::GuardNumberToIntPtrIndex);\
  writeOperandId(input);\
  writeBoolImm(supportOOB);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId guardToInt32ModUint32(ValOperandId input) {\
  writeOp(CacheOp::GuardToInt32ModUint32);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId guardToUint8Clamped(ValOperandId input) {\
  writeOp(CacheOp::GuardToUint8Clamped);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void guardNonDoubleType(ValOperandId input, ValueType type) {\
  writeOp(CacheOp::GuardNonDoubleType);\
  writeOperandId(input);\
  writeValueTypeImm(type);\
  assertLengthMatches();\
}\
void guardShape(ObjOperandId obj, Shape* shape) {\
  writeOp(CacheOp::GuardShape);\
  writeOperandId(obj);\
  writeShapeField(shape);\
  assertLengthMatches();\
}\
void guardProto(ObjOperandId obj, JSObject* proto) {\
  writeOp(CacheOp::GuardProto);\
  writeOperandId(obj);\
  writeObjectField(proto);\
  assertLengthMatches();\
}\
void guardNullProto(ObjOperandId obj) {\
  writeOp(CacheOp::GuardNullProto);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardClass(ObjOperandId obj, GuardClassKind kind) {\
  writeOp(CacheOp::GuardClass);\
  writeOperandId(obj);\
  writeGuardClassKindImm(kind);\
  assertLengthMatches();\
}\
void guardAnyClass(ObjOperandId obj, const void* clasp) {\
  writeOp(CacheOp::GuardAnyClass);\
  writeOperandId(obj);\
  writeRawPointerField(clasp);\
  assertLengthMatches();\
}\
void hasClassResult(ObjOperandId obj, const void* clasp) {\
  writeOp(CacheOp::HasClassResult);\
  writeOperandId(obj);\
  writeRawPointerField(clasp);\
  assertLengthMatches();\
}\
void callRegExpMatcherResult(ObjOperandId regexp, StringOperandId input, Int32OperandId lastIndex) {\
  writeOp(CacheOp::CallRegExpMatcherResult);\
  writeOperandId(regexp);\
  writeOperandId(input);\
  writeOperandId(lastIndex);\
  assertLengthMatches();\
}\
void callRegExpSearcherResult(ObjOperandId regexp, StringOperandId input, Int32OperandId lastIndex) {\
  writeOp(CacheOp::CallRegExpSearcherResult);\
  writeOperandId(regexp);\
  writeOperandId(input);\
  writeOperandId(lastIndex);\
  assertLengthMatches();\
}\
void callRegExpTesterResult(ObjOperandId regexp, StringOperandId input, Int32OperandId lastIndex) {\
  writeOp(CacheOp::CallRegExpTesterResult);\
  writeOperandId(regexp);\
  writeOperandId(input);\
  writeOperandId(lastIndex);\
  assertLengthMatches();\
}\
void regExpFlagResult(ObjOperandId regexp, int32_t flagsMask) {\
  writeOp(CacheOp::RegExpFlagResult);\
  writeOperandId(regexp);\
  writeInt32Imm(flagsMask);\
  assertLengthMatches();\
}\
void callSubstringKernelResult(StringOperandId str, Int32OperandId begin, Int32OperandId length) {\
  writeOp(CacheOp::CallSubstringKernelResult);\
  writeOperandId(str);\
  writeOperandId(begin);\
  writeOperandId(length);\
  assertLengthMatches();\
}\
void stringReplaceStringResult(StringOperandId str, StringOperandId pattern, StringOperandId replacement) {\
  writeOp(CacheOp::StringReplaceStringResult);\
  writeOperandId(str);\
  writeOperandId(pattern);\
  writeOperandId(replacement);\
  assertLengthMatches();\
}\
void stringSplitStringResult(StringOperandId str, StringOperandId separator) {\
  writeOp(CacheOp::StringSplitStringResult);\
  writeOperandId(str);\
  writeOperandId(separator);\
  assertLengthMatches();\
}\
void regExpPrototypeOptimizableResult(ObjOperandId proto) {\
  writeOp(CacheOp::RegExpPrototypeOptimizableResult);\
  writeOperandId(proto);\
  assertLengthMatches();\
}\
void regExpInstanceOptimizableResult(ObjOperandId regexp, ObjOperandId proto) {\
  writeOp(CacheOp::RegExpInstanceOptimizableResult);\
  writeOperandId(regexp);\
  writeOperandId(proto);\
  assertLengthMatches();\
}\
void getFirstDollarIndexResult(StringOperandId str) {\
  writeOp(CacheOp::GetFirstDollarIndexResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void guardCompartment(ObjOperandId obj, JSObject* global, const void* compartment) {\
  writeOp(CacheOp::GuardCompartment);\
  writeOperandId(obj);\
  writeObjectField(global);\
  writeRawPointerField(compartment);\
  assertLengthMatches();\
}\
void guardIsExtensible(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsExtensible);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsNativeObject(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsNativeObject);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsProxy(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsProxy);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsNotProxy(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsNotProxy);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsNotArrayBufferMaybeShared(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsNotArrayBufferMaybeShared);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsTypedArray(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsTypedArray);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardHasProxyHandler(ObjOperandId obj, const void* handler) {\
  writeOp(CacheOp::GuardHasProxyHandler);\
  writeOperandId(obj);\
  writeRawPointerField(handler);\
  assertLengthMatches();\
}\
void guardIsNotDOMProxy(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsNotDOMProxy);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardSpecificObject(ObjOperandId obj, JSObject* expected) {\
  writeOp(CacheOp::GuardSpecificObject);\
  writeOperandId(obj);\
  writeObjectField(expected);\
  assertLengthMatches();\
}\
private:\
void guardSpecificFunction_(ObjOperandId fun, JSObject* expected, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::GuardSpecificFunction);\
  writeOperandId(fun);\
  writeObjectField(expected);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void guardFunctionScript_(ObjOperandId obj, BaseScript* expected, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::GuardFunctionScript);\
  writeOperandId(obj);\
  writeBaseScriptField(expected);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
void guardSpecificAtom(StringOperandId str, JSAtom* expected) {\
  writeOp(CacheOp::GuardSpecificAtom);\
  writeOperandId(str);\
  writeStringField(expected);\
  assertLengthMatches();\
}\
void guardSpecificSymbol(SymbolOperandId sym, JS::Symbol* expected) {\
  writeOp(CacheOp::GuardSpecificSymbol);\
  writeOperandId(sym);\
  writeSymbolField(expected);\
  assertLengthMatches();\
}\
void guardNoDenseElements(ObjOperandId obj) {\
  writeOp(CacheOp::GuardNoDenseElements);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
Int32OperandId guardStringToIndex(StringOperandId str) {\
  writeOp(CacheOp::GuardStringToIndex);\
  writeOperandId(str);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId guardStringToInt32(StringOperandId str) {\
  writeOp(CacheOp::GuardStringToInt32);\
  writeOperandId(str);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
NumberOperandId guardStringToNumber(StringOperandId str) {\
  writeOp(CacheOp::GuardStringToNumber);\
  writeOperandId(str);\
  NumberOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
NumberOperandId booleanToNumber(BooleanOperandId boolean) {\
  writeOp(CacheOp::BooleanToNumber);\
  writeOperandId(boolean);\
  NumberOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId guardAndGetIterator(ObjOperandId obj, JSObject* iter, const void* enumeratorsAddr) {\
  writeOp(CacheOp::GuardAndGetIterator);\
  writeOperandId(obj);\
  writeObjectField(iter);\
  writeRawPointerField(enumeratorsAddr);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void guardHasGetterSetter(ObjOperandId obj, jsid id, GetterSetter* getterSetter) {\
  writeOp(CacheOp::GuardHasGetterSetter);\
  writeOperandId(obj);\
  writeIdField(id);\
  writeGetterSetterField(getterSetter);\
  assertLengthMatches();\
}\
void guardInt32IsNonNegative(Int32OperandId index) {\
  writeOp(CacheOp::GuardInt32IsNonNegative);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void guardIndexIsValidUpdateOrAdd(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::GuardIndexIsValidUpdateOrAdd);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void guardIndexGreaterThanDenseInitLength(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::GuardIndexGreaterThanDenseInitLength);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void guardTagNotEqual(ValueTagOperandId lhs, ValueTagOperandId rhs) {\
  writeOp(CacheOp::GuardTagNotEqual);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void guardXrayExpandoShapeAndDefaultProto(ObjOperandId obj, JSObject* shapeWrapper) {\
  writeOp(CacheOp::GuardXrayExpandoShapeAndDefaultProto);\
  writeOperandId(obj);\
  writeObjectField(shapeWrapper);\
  assertLengthMatches();\
}\
void guardXrayNoExpando(ObjOperandId obj) {\
  writeOp(CacheOp::GuardXrayNoExpando);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardDynamicSlotIsSpecificObject(ObjOperandId obj, ObjOperandId expected, uint32_t slot) {\
  writeOp(CacheOp::GuardDynamicSlotIsSpecificObject);\
  writeOperandId(obj);\
  writeOperandId(expected);\
  writeRawInt32Field(slot);\
  assertLengthMatches();\
}\
void guardFixedSlotValue(ObjOperandId obj, uint32_t offset, const Value& val) {\
  writeOp(CacheOp::GuardFixedSlotValue);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeValueField(val);\
  assertLengthMatches();\
}\
void guardDynamicSlotValue(ObjOperandId obj, uint32_t offset, const Value& val) {\
  writeOp(CacheOp::GuardDynamicSlotValue);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeValueField(val);\
  assertLengthMatches();\
}\
void guardNoAllocationMetadataBuilder(const void* builderAddr) {\
  writeOp(CacheOp::GuardNoAllocationMetadataBuilder);\
  writeRawPointerField(builderAddr);\
  assertLengthMatches();\
}\
void guardFunctionHasJitEntry(ObjOperandId fun, bool constructing) {\
  writeOp(CacheOp::GuardFunctionHasJitEntry);\
  writeOperandId(fun);\
  writeBoolImm(constructing);\
  assertLengthMatches();\
}\
void guardFunctionHasNoJitEntry(ObjOperandId fun) {\
  writeOp(CacheOp::GuardFunctionHasNoJitEntry);\
  writeOperandId(fun);\
  assertLengthMatches();\
}\
void guardFunctionIsNonBuiltinCtor(ObjOperandId fun) {\
  writeOp(CacheOp::GuardFunctionIsNonBuiltinCtor);\
  writeOperandId(fun);\
  assertLengthMatches();\
}\
void guardFunctionIsConstructor(ObjOperandId fun) {\
  writeOp(CacheOp::GuardFunctionIsConstructor);\
  writeOperandId(fun);\
  assertLengthMatches();\
}\
void guardNotClassConstructor(ObjOperandId fun) {\
  writeOp(CacheOp::GuardNotClassConstructor);\
  writeOperandId(fun);\
  assertLengthMatches();\
}\
void guardArrayIsPacked(ObjOperandId array) {\
  writeOp(CacheOp::GuardArrayIsPacked);\
  writeOperandId(array);\
  assertLengthMatches();\
}\
void guardArgumentsObjectFlags(ObjOperandId obj, uint32_t flags) {\
  writeOp(CacheOp::GuardArgumentsObjectFlags);\
  writeOperandId(obj);\
  writeByteImm(flags);\
  assertLengthMatches();\
}\
ObjOperandId loadObject(JSObject* obj) {\
  writeOp(CacheOp::LoadObject);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  writeObjectField(obj);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId loadProto(ObjOperandId obj) {\
  writeOp(CacheOp::LoadProto);\
  writeOperandId(obj);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId loadEnclosingEnvironment(ObjOperandId obj) {\
  writeOp(CacheOp::LoadEnclosingEnvironment);\
  writeOperandId(obj);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId loadWrapperTarget(ObjOperandId obj) {\
  writeOp(CacheOp::LoadWrapperTarget);\
  writeOperandId(obj);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ValueTagOperandId loadValueTag(ValOperandId val) {\
  writeOp(CacheOp::LoadValueTag);\
  writeOperandId(val);\
  ValueTagOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
private:\
ValOperandId loadArgumentFixedSlot_(uint32_t slotIndex) {\
  writeOp(CacheOp::LoadArgumentFixedSlot);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  writeByteImm(slotIndex);\
  assertLengthMatches();\
  return result;\
}\
public:\
private:\
ValOperandId loadArgumentDynamicSlot_(Int32OperandId argc, uint32_t slotIndex) {\
  writeOp(CacheOp::LoadArgumentDynamicSlot);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  writeOperandId(argc);\
  writeByteImm(slotIndex);\
  assertLengthMatches();\
  return result;\
}\
public:\
Int32OperandId truncateDoubleToUInt32(NumberOperandId input) {\
  writeOp(CacheOp::TruncateDoubleToUInt32);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void megamorphicLoadSlotResult(ObjOperandId obj, PropertyName* name) {\
  writeOp(CacheOp::MegamorphicLoadSlotResult);\
  writeOperandId(obj);\
  writeStringField(name);\
  assertLengthMatches();\
}\
void megamorphicLoadSlotByValueResult(ObjOperandId obj, ValOperandId id) {\
  writeOp(CacheOp::MegamorphicLoadSlotByValueResult);\
  writeOperandId(obj);\
  writeOperandId(id);\
  assertLengthMatches();\
}\
void megamorphicStoreSlot(ObjOperandId obj, PropertyName* name, ValOperandId rhs) {\
  writeOp(CacheOp::MegamorphicStoreSlot);\
  writeOperandId(obj);\
  writeStringField(name);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void megamorphicSetElement(ObjOperandId obj, ValOperandId id, ValOperandId rhs, bool strict) {\
  writeOp(CacheOp::MegamorphicSetElement);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeOperandId(rhs);\
  writeBoolImm(strict);\
  assertLengthMatches();\
}\
void megamorphicHasPropResult(ObjOperandId obj, ValOperandId id, bool hasOwn) {\
  writeOp(CacheOp::MegamorphicHasPropResult);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeBoolImm(hasOwn);\
  assertLengthMatches();\
}\
ValOperandId loadDOMExpandoValue(ObjOperandId obj) {\
  writeOp(CacheOp::LoadDOMExpandoValue);\
  writeOperandId(obj);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId loadDOMExpandoValueGuardGeneration(ObjOperandId obj, const void* expandoAndGeneration, uint64_t generation) {\
  writeOp(CacheOp::LoadDOMExpandoValueGuardGeneration);\
  writeOperandId(obj);\
  writeRawPointerField(expandoAndGeneration);\
  writeRawInt64Field(generation);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId loadDOMExpandoValueIgnoreGeneration(ObjOperandId obj) {\
  writeOp(CacheOp::LoadDOMExpandoValueIgnoreGeneration);\
  writeOperandId(obj);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void guardDOMExpandoMissingOrGuardShape(ValOperandId expando, Shape* shape) {\
  writeOp(CacheOp::GuardDOMExpandoMissingOrGuardShape);\
  writeOperandId(expando);\
  writeShapeField(shape);\
  assertLengthMatches();\
}\
void storeFixedSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs) {\
  writeOp(CacheOp::StoreFixedSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void storeDynamicSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs) {\
  writeOp(CacheOp::StoreDynamicSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void addAndStoreFixedSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs, Shape* newShape) {\
  writeOp(CacheOp::AddAndStoreFixedSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  writeShapeField(newShape);\
  assertLengthMatches();\
}\
void addAndStoreDynamicSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs, Shape* newShape) {\
  writeOp(CacheOp::AddAndStoreDynamicSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  writeShapeField(newShape);\
  assertLengthMatches();\
}\
void allocateAndStoreDynamicSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs, Shape* newShape, uint32_t numNewSlots) {\
  writeOp(CacheOp::AllocateAndStoreDynamicSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  writeShapeField(newShape);\
  writeRawInt32Field(numNewSlots);\
  assertLengthMatches();\
}\
void storeDenseElement(ObjOperandId obj, Int32OperandId index, ValOperandId rhs) {\
  writeOp(CacheOp::StoreDenseElement);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void storeDenseElementHole(ObjOperandId obj, Int32OperandId index, ValOperandId rhs, bool handleAdd) {\
  writeOp(CacheOp::StoreDenseElementHole);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(rhs);\
  writeBoolImm(handleAdd);\
  assertLengthMatches();\
}\
void arrayPush(ObjOperandId obj, ValOperandId rhs) {\
  writeOp(CacheOp::ArrayPush);\
  writeOperandId(obj);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void arrayJoinResult(ObjOperandId obj, StringOperandId sep) {\
  writeOp(CacheOp::ArrayJoinResult);\
  writeOperandId(obj);\
  writeOperandId(sep);\
  assertLengthMatches();\
}\
void packedArrayPopResult(ObjOperandId array) {\
  writeOp(CacheOp::PackedArrayPopResult);\
  writeOperandId(array);\
  assertLengthMatches();\
}\
void packedArrayShiftResult(ObjOperandId array) {\
  writeOp(CacheOp::PackedArrayShiftResult);\
  writeOperandId(array);\
  assertLengthMatches();\
}\
void packedArraySliceResult(JSObject* templateObject, ObjOperandId array, Int32OperandId begin, Int32OperandId end) {\
  writeOp(CacheOp::PackedArraySliceResult);\
  writeObjectField(templateObject);\
  writeOperandId(array);\
  writeOperandId(begin);\
  writeOperandId(end);\
  assertLengthMatches();\
}\
void isArrayResult(ValOperandId input) {\
  writeOp(CacheOp::IsArrayResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void storeFixedSlotUndefinedResult(ObjOperandId obj, uint32_t offset, ValOperandId rhs) {\
  writeOp(CacheOp::StoreFixedSlotUndefinedResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void isObjectResult(ValOperandId input) {\
  writeOp(CacheOp::IsObjectResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void isPackedArrayResult(ObjOperandId obj) {\
  writeOp(CacheOp::IsPackedArrayResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void isCallableResult(ValOperandId input) {\
  writeOp(CacheOp::IsCallableResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void isConstructorResult(ObjOperandId obj) {\
  writeOp(CacheOp::IsConstructorResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void isCrossRealmArrayConstructorResult(ObjOperandId obj) {\
  writeOp(CacheOp::IsCrossRealmArrayConstructorResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void isTypedArrayResult(ObjOperandId obj, bool isPossiblyWrapped) {\
  writeOp(CacheOp::IsTypedArrayResult);\
  writeOperandId(obj);\
  writeBoolImm(isPossiblyWrapped);\
  assertLengthMatches();\
}\
void isTypedArrayConstructorResult(ObjOperandId obj) {\
  writeOp(CacheOp::IsTypedArrayConstructorResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void arrayBufferViewByteOffsetInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::ArrayBufferViewByteOffsetInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void arrayBufferViewByteOffsetDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::ArrayBufferViewByteOffsetDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void typedArrayByteLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::TypedArrayByteLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void typedArrayByteLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::TypedArrayByteLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void typedArrayElementSizeResult(ObjOperandId obj) {\
  writeOp(CacheOp::TypedArrayElementSizeResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardHasAttachedArrayBuffer(ObjOperandId obj) {\
  writeOp(CacheOp::GuardHasAttachedArrayBuffer);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void finishBoundFunctionInitResult(ObjOperandId bound, ObjOperandId target, Int32OperandId argCount) {\
  writeOp(CacheOp::FinishBoundFunctionInitResult);\
  writeOperandId(bound);\
  writeOperandId(target);\
  writeOperandId(argCount);\
  assertLengthMatches();\
}\
void newArrayIteratorResult(JSObject* templateObject) {\
  writeOp(CacheOp::NewArrayIteratorResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void newStringIteratorResult(JSObject* templateObject) {\
  writeOp(CacheOp::NewStringIteratorResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void newRegExpStringIteratorResult(JSObject* templateObject) {\
  writeOp(CacheOp::NewRegExpStringIteratorResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void objectCreateResult(JSObject* templateObject) {\
  writeOp(CacheOp::ObjectCreateResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void newArrayFromLengthResult(JSObject* templateObject, Int32OperandId length) {\
  writeOp(CacheOp::NewArrayFromLengthResult);\
  writeObjectField(templateObject);\
  writeOperandId(length);\
  assertLengthMatches();\
}\
void newTypedArrayFromLengthResult(JSObject* templateObject, Int32OperandId length) {\
  writeOp(CacheOp::NewTypedArrayFromLengthResult);\
  writeObjectField(templateObject);\
  writeOperandId(length);\
  assertLengthMatches();\
}\
void newTypedArrayFromArrayBufferResult(JSObject* templateObject, ObjOperandId buffer, ValOperandId byteOffset, ValOperandId length) {\
  writeOp(CacheOp::NewTypedArrayFromArrayBufferResult);\
  writeObjectField(templateObject);\
  writeOperandId(buffer);\
  writeOperandId(byteOffset);\
  writeOperandId(length);\
  assertLengthMatches();\
}\
void newTypedArrayFromArrayResult(JSObject* templateObject, ObjOperandId array) {\
  writeOp(CacheOp::NewTypedArrayFromArrayResult);\
  writeObjectField(templateObject);\
  writeOperandId(array);\
  assertLengthMatches();\
}\
void newStringObjectResult(JSObject* templateObject, StringOperandId str) {\
  writeOp(CacheOp::NewStringObjectResult);\
  writeObjectField(templateObject);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void stringFromCharCodeResult(Int32OperandId code) {\
  writeOp(CacheOp::StringFromCharCodeResult);\
  writeOperandId(code);\
  assertLengthMatches();\
}\
void stringFromCodePointResult(Int32OperandId code) {\
  writeOp(CacheOp::StringFromCodePointResult);\
  writeOperandId(code);\
  assertLengthMatches();\
}\
void stringToLowerCaseResult(StringOperandId str) {\
  writeOp(CacheOp::StringToLowerCaseResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void stringToUpperCaseResult(StringOperandId str) {\
  writeOp(CacheOp::StringToUpperCaseResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void mathAbsInt32Result(Int32OperandId input) {\
  writeOp(CacheOp::MathAbsInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathAbsNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathAbsNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathClz32Result(Int32OperandId input) {\
  writeOp(CacheOp::MathClz32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathSignInt32Result(Int32OperandId input) {\
  writeOp(CacheOp::MathSignInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathSignNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathSignNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathSignNumberToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathSignNumberToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathImulResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::MathImulResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void mathSqrtNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathSqrtNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathFRoundNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathFRoundNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathRandomResult(const void* rng) {\
  writeOp(CacheOp::MathRandomResult);\
  writeRawPointerField(rng);\
  assertLengthMatches();\
}\
void mathHypot2NumberResult(NumberOperandId first, NumberOperandId second) {\
  writeOp(CacheOp::MathHypot2NumberResult);\
  writeOperandId(first);\
  writeOperandId(second);\
  assertLengthMatches();\
}\
void mathHypot3NumberResult(NumberOperandId first, NumberOperandId second, NumberOperandId third) {\
  writeOp(CacheOp::MathHypot3NumberResult);\
  writeOperandId(first);\
  writeOperandId(second);\
  writeOperandId(third);\
  assertLengthMatches();\
}\
void mathHypot4NumberResult(NumberOperandId first, NumberOperandId second, NumberOperandId third, NumberOperandId fourth) {\
  writeOp(CacheOp::MathHypot4NumberResult);\
  writeOperandId(first);\
  writeOperandId(second);\
  writeOperandId(third);\
  writeOperandId(fourth);\
  assertLengthMatches();\
}\
void mathAtan2NumberResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::MathAtan2NumberResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void mathFloorNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathFloorNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathCeilNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathCeilNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathTruncNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathTruncNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathFloorToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathFloorToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathCeilToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathCeilToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathTruncToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathTruncToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathRoundToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathRoundToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
Int32OperandId int32MinMax(bool isMax, Int32OperandId first, Int32OperandId second) {\
  writeOp(CacheOp::Int32MinMax);\
  writeBoolImm(isMax);\
  writeOperandId(first);\
  writeOperandId(second);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
NumberOperandId numberMinMax(bool isMax, NumberOperandId first, NumberOperandId second) {\
  writeOp(CacheOp::NumberMinMax);\
  writeBoolImm(isMax);\
  writeOperandId(first);\
  writeOperandId(second);\
  NumberOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void int32MinMaxArrayResult(ObjOperandId array, bool isMax) {\
  writeOp(CacheOp::Int32MinMaxArrayResult);\
  writeOperandId(array);\
  writeBoolImm(isMax);\
  assertLengthMatches();\
}\
void numberMinMaxArrayResult(ObjOperandId array, bool isMax) {\
  writeOp(CacheOp::NumberMinMaxArrayResult);\
  writeOperandId(array);\
  writeBoolImm(isMax);\
  assertLengthMatches();\
}\
void mathFunctionNumberResult(NumberOperandId input, UnaryMathFunction fun) {\
  writeOp(CacheOp::MathFunctionNumberResult);\
  writeOperandId(input);\
  writeUnaryMathFunctionImm(fun);\
  assertLengthMatches();\
}\
void objectToStringResult(ObjOperandId obj) {\
  writeOp(CacheOp::ObjectToStringResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void reflectGetPrototypeOfResult(ObjOperandId obj) {\
  writeOp(CacheOp::ReflectGetPrototypeOfResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void storeTypedArrayElement(ObjOperandId obj, Scalar::Type elementType, IntPtrOperandId index, OperandId rhs, bool handleOOB) {\
  writeOp(CacheOp::StoreTypedArrayElement);\
  writeOperandId(obj);\
  writeScalarTypeImm(elementType);\
  writeOperandId(index);\
  writeOperandId(rhs);\
  writeBoolImm(handleOOB);\
  assertLengthMatches();\
}\
void atomicsCompareExchangeResult(ObjOperandId obj, IntPtrOperandId index, OperandId expected, OperandId replacement, Scalar::Type elementType) {\
  writeOp(CacheOp::AtomicsCompareExchangeResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(expected);\
  writeOperandId(replacement);\
  writeScalarTypeImm(elementType);\
  assertLengthMatches();\
}\
void atomicsExchangeResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType) {\
  writeOp(CacheOp::AtomicsExchangeResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  assertLengthMatches();\
}\
void atomicsAddResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect) {\
  writeOp(CacheOp::AtomicsAddResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  assertLengthMatches();\
}\
void atomicsSubResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect) {\
  writeOp(CacheOp::AtomicsSubResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  assertLengthMatches();\
}\
void atomicsAndResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect) {\
  writeOp(CacheOp::AtomicsAndResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  assertLengthMatches();\
}\
void atomicsOrResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect) {\
  writeOp(CacheOp::AtomicsOrResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  assertLengthMatches();\
}\
void atomicsXorResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect) {\
  writeOp(CacheOp::AtomicsXorResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  assertLengthMatches();\
}\
void atomicsLoadResult(ObjOperandId obj, IntPtrOperandId index, Scalar::Type elementType) {\
  writeOp(CacheOp::AtomicsLoadResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeScalarTypeImm(elementType);\
  assertLengthMatches();\
}\
void atomicsStoreResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType) {\
  writeOp(CacheOp::AtomicsStoreResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  assertLengthMatches();\
}\
void atomicsIsLockFreeResult(Int32OperandId value) {\
  writeOp(CacheOp::AtomicsIsLockFreeResult);\
  writeOperandId(value);\
  assertLengthMatches();\
}\
private:\
void callNativeSetter_(ObjOperandId receiver, JSObject* setter, ValOperandId rhs, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallNativeSetter);\
  writeOperandId(receiver);\
  writeObjectField(setter);\
  writeOperandId(rhs);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void callScriptedSetter_(ObjOperandId receiver, JSObject* setter, ValOperandId rhs, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallScriptedSetter);\
  writeOperandId(receiver);\
  writeObjectField(setter);\
  writeOperandId(rhs);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void callInlinedSetter_(ObjOperandId receiver, JSObject* setter, ValOperandId rhs, const void* icScript, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallInlinedSetter);\
  writeOperandId(receiver);\
  writeObjectField(setter);\
  writeOperandId(rhs);\
  writeRawPointerField(icScript);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
void callDOMSetter(ObjOperandId obj, const void* jitInfo, ValOperandId rhs) {\
  writeOp(CacheOp::CallDOMSetter);\
  writeOperandId(obj);\
  writeRawPointerField(jitInfo);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void callSetArrayLength(ObjOperandId obj, bool strict, ValOperandId rhs) {\
  writeOp(CacheOp::CallSetArrayLength);\
  writeOperandId(obj);\
  writeBoolImm(strict);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void proxySet(ObjOperandId obj, jsid id, ValOperandId rhs, bool strict) {\
  writeOp(CacheOp::ProxySet);\
  writeOperandId(obj);\
  writeIdField(id);\
  writeOperandId(rhs);\
  writeBoolImm(strict);\
  assertLengthMatches();\
}\
void proxySetByValue(ObjOperandId obj, ValOperandId id, ValOperandId rhs, bool strict) {\
  writeOp(CacheOp::ProxySetByValue);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeOperandId(rhs);\
  writeBoolImm(strict);\
  assertLengthMatches();\
}\
void callAddOrUpdateSparseElementHelper(ObjOperandId obj, Int32OperandId id, ValOperandId rhs, bool strict) {\
  writeOp(CacheOp::CallAddOrUpdateSparseElementHelper);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeOperandId(rhs);\
  writeBoolImm(strict);\
  assertLengthMatches();\
}\
StringOperandId callInt32ToString(Int32OperandId input) {\
  writeOp(CacheOp::CallInt32ToString);\
  writeOperandId(input);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
StringOperandId callNumberToString(NumberOperandId input) {\
  writeOp(CacheOp::CallNumberToString);\
  writeOperandId(input);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
StringOperandId booleanToString(BooleanOperandId input) {\
  writeOp(CacheOp::BooleanToString);\
  writeOperandId(input);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
private:\
void callScriptedFunction_(ObjOperandId callee, Int32OperandId argc, CallFlags flags) {\
  writeOp(CacheOp::CallScriptedFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeCallFlagsImm(flags);\
  assertLengthMatches();\
}\
public:\
void callWasmFunction(ObjOperandId callee, Int32OperandId argc, CallFlags flags, const void* funcExport, JSObject* instance) {\
  writeOp(CacheOp::CallWasmFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeCallFlagsImm(flags);\
  writeRawPointerField(funcExport);\
  writeObjectField(instance);\
  assertLengthMatches();\
}\
void guardWasmArg(ValOperandId arg, wasm::ValType::Kind type) {\
  writeOp(CacheOp::GuardWasmArg);\
  writeOperandId(arg);\
  writeWasmValTypeImm(type);\
  assertLengthMatches();\
}\
private:\
void callNativeFunction_(ObjOperandId callee, Int32OperandId argc, CallFlags flags, bool ignoresReturnValue) {\
  writeOp(CacheOp::CallNativeFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeCallFlagsImm(flags);\
  writeBoolImm(ignoresReturnValue);\
  assertLengthMatches();\
}\
public:\
private:\
void callDOMFunction_(ObjOperandId callee, Int32OperandId argc, ObjOperandId thisObj, CallFlags flags) {\
  writeOp(CacheOp::CallDOMFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeOperandId(thisObj);\
  writeCallFlagsImm(flags);\
  assertLengthMatches();\
}\
public:\
private:\
void callClassHook_(ObjOperandId callee, Int32OperandId argc, CallFlags flags, const void* target) {\
  writeOp(CacheOp::CallClassHook);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeCallFlagsImm(flags);\
  writeRawPointerField(target);\
  assertLengthMatches();\
}\
public:\
private:\
void callInlinedFunction_(ObjOperandId callee, Int32OperandId argc, const void* icScript, CallFlags flags) {\
  writeOp(CacheOp::CallInlinedFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeRawPointerField(icScript);\
  writeCallFlagsImm(flags);\
  assertLengthMatches();\
}\
public:\
private:\
void metaTwoByte_(JSObject* functionObject, JSObject* templateObject) {\
  writeOp(CacheOp::MetaTwoByte);\
  writeObjectField(functionObject);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
public:\
void loadFixedSlotResult(ObjOperandId obj, uint32_t offset) {\
  writeOp(CacheOp::LoadFixedSlotResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  assertLengthMatches();\
}\
void loadFixedSlotTypedResult(ObjOperandId obj, uint32_t offset, ValueType type) {\
  writeOp(CacheOp::LoadFixedSlotTypedResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeValueTypeImm(type);\
  assertLengthMatches();\
}\
void loadDynamicSlotResult(ObjOperandId obj, uint32_t offset) {\
  writeOp(CacheOp::LoadDynamicSlotResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  assertLengthMatches();\
}\
void loadDenseElementResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadDenseElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadDenseElementHoleResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadDenseElementHoleResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void callGetSparseElementResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::CallGetSparseElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadDenseElementExistsResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadDenseElementExistsResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadTypedArrayElementExistsResult(ObjOperandId obj, IntPtrOperandId index) {\
  writeOp(CacheOp::LoadTypedArrayElementExistsResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadDenseElementHoleExistsResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadDenseElementHoleExistsResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadTypedArrayElementResult(ObjOperandId obj, IntPtrOperandId index, Scalar::Type elementType, bool handleOOB, bool forceDoubleForUint32) {\
  writeOp(CacheOp::LoadTypedArrayElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(handleOOB);\
  writeBoolImm(forceDoubleForUint32);\
  assertLengthMatches();\
}\
void loadDataViewValueResult(ObjOperandId obj, IntPtrOperandId offset, BooleanOperandId littleEndian, Scalar::Type elementType, bool forceDoubleForUint32) {\
  writeOp(CacheOp::LoadDataViewValueResult);\
  writeOperandId(obj);\
  writeOperandId(offset);\
  writeOperandId(littleEndian);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forceDoubleForUint32);\
  assertLengthMatches();\
}\
void storeDataViewValueResult(ObjOperandId obj, IntPtrOperandId offset, OperandId value, BooleanOperandId littleEndian, Scalar::Type elementType) {\
  writeOp(CacheOp::StoreDataViewValueResult);\
  writeOperandId(obj);\
  writeOperandId(offset);\
  writeOperandId(value);\
  writeOperandId(littleEndian);\
  writeScalarTypeImm(elementType);\
  assertLengthMatches();\
}\
void loadInt32ArrayLengthResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadInt32ArrayLengthResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
Int32OperandId loadInt32ArrayLength(ObjOperandId obj) {\
  writeOp(CacheOp::LoadInt32ArrayLength);\
  writeOperandId(obj);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void loadArgumentsObjectArgResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadArgumentsObjectArgResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadArgumentsObjectLengthResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArgumentsObjectLengthResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadFunctionLengthResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadFunctionLengthResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadFunctionNameResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadFunctionNameResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadArrayBufferByteLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArrayBufferByteLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadArrayBufferByteLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArrayBufferByteLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadArrayBufferViewLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArrayBufferViewLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadArrayBufferViewLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArrayBufferViewLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadStringCharResult(StringOperandId str, Int32OperandId index) {\
  writeOp(CacheOp::LoadStringCharResult);\
  writeOperandId(str);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadStringCharCodeResult(StringOperandId str, Int32OperandId index) {\
  writeOp(CacheOp::LoadStringCharCodeResult);\
  writeOperandId(str);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadStringLengthResult(StringOperandId str) {\
  writeOp(CacheOp::LoadStringLengthResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void frameIsConstructingResult() {\
  writeOp(CacheOp::FrameIsConstructingResult);\
  assertLengthMatches();\
}\
void loadEnvironmentFixedSlotResult(ObjOperandId obj, uint32_t offset) {\
  writeOp(CacheOp::LoadEnvironmentFixedSlotResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  assertLengthMatches();\
}\
void loadEnvironmentDynamicSlotResult(ObjOperandId obj, uint32_t offset) {\
  writeOp(CacheOp::LoadEnvironmentDynamicSlotResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  assertLengthMatches();\
}\
void loadObjectResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadObjectResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadStringResult(StringOperandId str) {\
  writeOp(CacheOp::LoadStringResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void loadSymbolResult(SymbolOperandId sym) {\
  writeOp(CacheOp::LoadSymbolResult);\
  writeOperandId(sym);\
  assertLengthMatches();\
}\
void loadInt32Result(Int32OperandId val) {\
  writeOp(CacheOp::LoadInt32Result);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void loadDoubleResult(NumberOperandId val) {\
  writeOp(CacheOp::LoadDoubleResult);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void loadBigIntResult(BigIntOperandId val) {\
  writeOp(CacheOp::LoadBigIntResult);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
private:\
void callScriptedGetterResult_(ValOperandId receiver, JSObject* getter, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallScriptedGetterResult);\
  writeOperandId(receiver);\
  writeObjectField(getter);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void callInlinedGetterResult_(ValOperandId receiver, JSObject* getter, const void* icScript, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallInlinedGetterResult);\
  writeOperandId(receiver);\
  writeObjectField(getter);\
  writeRawPointerField(icScript);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void callNativeGetterResult_(ValOperandId receiver, JSObject* getter, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallNativeGetterResult);\
  writeOperandId(receiver);\
  writeObjectField(getter);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
void callDOMGetterResult(ObjOperandId obj, const void* jitInfo) {\
  writeOp(CacheOp::CallDOMGetterResult);\
  writeOperandId(obj);\
  writeRawPointerField(jitInfo);\
  assertLengthMatches();\
}\
void proxyGetResult(ObjOperandId obj, jsid id) {\
  writeOp(CacheOp::ProxyGetResult);\
  writeOperandId(obj);\
  writeIdField(id);\
  assertLengthMatches();\
}\
void proxyGetByValueResult(ObjOperandId obj, ValOperandId id) {\
  writeOp(CacheOp::ProxyGetByValueResult);\
  writeOperandId(obj);\
  writeOperandId(id);\
  assertLengthMatches();\
}\
void proxyHasPropResult(ObjOperandId obj, ValOperandId id, bool hasOwn) {\
  writeOp(CacheOp::ProxyHasPropResult);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeBoolImm(hasOwn);\
  assertLengthMatches();\
}\
void callObjectHasSparseElementResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::CallObjectHasSparseElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void callNativeGetElementResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::CallNativeGetElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void getNextMapSetEntryForIteratorResult(ObjOperandId iter, ObjOperandId resultArr, bool isMap) {\
  writeOp(CacheOp::GetNextMapSetEntryForIteratorResult);\
  writeOperandId(iter);\
  writeOperandId(resultArr);\
  writeBoolImm(isMap);\
  assertLengthMatches();\
}\
void loadUndefinedResult() {\
  writeOp(CacheOp::LoadUndefinedResult);\
  assertLengthMatches();\
}\
void loadBooleanResult(bool val) {\
  writeOp(CacheOp::LoadBooleanResult);\
  writeBoolImm(val);\
  assertLengthMatches();\
}\
Int32OperandId loadInt32Constant(uint32_t val) {\
  writeOp(CacheOp::LoadInt32Constant);\
  writeRawInt32Field(val);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
BooleanOperandId loadBooleanConstant(bool val) {\
  writeOp(CacheOp::LoadBooleanConstant);\
  writeBoolImm(val);\
  BooleanOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId loadUndefined() {\
  writeOp(CacheOp::LoadUndefined);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
StringOperandId loadConstantString(JSString* str) {\
  writeOp(CacheOp::LoadConstantString);\
  writeStringField(str);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void loadConstantStringResult(JSString* str) {\
  writeOp(CacheOp::LoadConstantStringResult);\
  writeStringField(str);\
  assertLengthMatches();\
}\
void loadInstanceOfObjectResult(ValOperandId lhs, ObjOperandId proto) {\
  writeOp(CacheOp::LoadInstanceOfObjectResult);\
  writeOperandId(lhs);\
  writeOperandId(proto);\
  assertLengthMatches();\
}\
void loadTypeOfObjectResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadTypeOfObjectResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void doubleAddResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleAddResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doubleSubResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleSubResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doubleMulResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleMulResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doubleDivResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleDivResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doubleModResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleModResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doublePowResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoublePowResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32AddResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32AddResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32SubResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32SubResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32MulResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32MulResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32DivResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32DivResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32ModResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32ModResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32PowResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32PowResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntAddResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntAddResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntSubResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntSubResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntMulResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntMulResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntDivResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntDivResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntModResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntModResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntPowResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntPowResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32BitOrResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32BitOrResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32BitXorResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32BitXorResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32BitAndResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32BitAndResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32LeftShiftResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32LeftShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32RightShiftResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32RightShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32URightShiftResult(Int32OperandId lhs, Int32OperandId rhs, bool forceDouble) {\
  writeOp(CacheOp::Int32URightShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  writeBoolImm(forceDouble);\
  assertLengthMatches();\
}\
void int32NotResult(Int32OperandId input) {\
  writeOp(CacheOp::Int32NotResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void bigIntBitOrResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntBitOrResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntBitXorResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntBitXorResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntBitAndResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntBitAndResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntLeftShiftResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntLeftShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntRightShiftResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntRightShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntNotResult(BigIntOperandId input) {\
  writeOp(CacheOp::BigIntNotResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void int32NegationResult(Int32OperandId input) {\
  writeOp(CacheOp::Int32NegationResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void doubleNegationResult(NumberOperandId input) {\
  writeOp(CacheOp::DoubleNegationResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void bigIntNegationResult(BigIntOperandId input) {\
  writeOp(CacheOp::BigIntNegationResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void int32IncResult(Int32OperandId input) {\
  writeOp(CacheOp::Int32IncResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void int32DecResult(Int32OperandId input) {\
  writeOp(CacheOp::Int32DecResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void doubleIncResult(NumberOperandId input) {\
  writeOp(CacheOp::DoubleIncResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void doubleDecResult(NumberOperandId input) {\
  writeOp(CacheOp::DoubleDecResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void bigIntIncResult(BigIntOperandId input) {\
  writeOp(CacheOp::BigIntIncResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void bigIntDecResult(BigIntOperandId input) {\
  writeOp(CacheOp::BigIntDecResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void loadInt32TruthyResult(ValOperandId input) {\
  writeOp(CacheOp::LoadInt32TruthyResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void loadDoubleTruthyResult(NumberOperandId input) {\
  writeOp(CacheOp::LoadDoubleTruthyResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void loadStringTruthyResult(StringOperandId str) {\
  writeOp(CacheOp::LoadStringTruthyResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void loadObjectTruthyResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadObjectTruthyResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadBigIntTruthyResult(BigIntOperandId bigInt) {\
  writeOp(CacheOp::LoadBigIntTruthyResult);\
  writeOperandId(bigInt);\
  assertLengthMatches();\
}\
void loadValueTruthyResult(ValOperandId input) {\
  writeOp(CacheOp::LoadValueTruthyResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void loadValueResult(const Value& val) {\
  writeOp(CacheOp::LoadValueResult);\
  writeValueField(val);\
  assertLengthMatches();\
}\
void loadOperandResult(ValOperandId input) {\
  writeOp(CacheOp::LoadOperandResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void newPlainObjectResult(uint32_t numFixedSlots, uint32_t numDynamicSlots, gc::AllocKind allocKind, Shape* shape, gc::AllocSite* site) {\
  writeOp(CacheOp::NewPlainObjectResult);\
  writeUInt32Imm(numFixedSlots);\
  writeUInt32Imm(numDynamicSlots);\
  writeAllocKindImm(allocKind);\
  writeShapeField(shape);\
  writeAllocSiteField(site);\
  assertLengthMatches();\
}\
void newArrayObjectResult(uint32_t arrayLength, Shape* shape, gc::AllocSite* site) {\
  writeOp(CacheOp::NewArrayObjectResult);\
  writeUInt32Imm(arrayLength);\
  writeShapeField(shape);\
  writeAllocSiteField(site);\
  assertLengthMatches();\
}\
void callStringConcatResult(StringOperandId lhs, StringOperandId rhs) {\
  writeOp(CacheOp::CallStringConcatResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void callStringObjectConcatResult(ValOperandId lhs, ValOperandId rhs) {\
  writeOp(CacheOp::CallStringObjectConcatResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void callIsSuspendedGeneratorResult(ValOperandId val) {\
  writeOp(CacheOp::CallIsSuspendedGeneratorResult);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void compareStringResult(JSOp op, StringOperandId lhs, StringOperandId rhs) {\
  writeOp(CacheOp::CompareStringResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareObjectResult(JSOp op, ObjOperandId lhs, ObjOperandId rhs) {\
  writeOp(CacheOp::CompareObjectResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareSymbolResult(JSOp op, SymbolOperandId lhs, SymbolOperandId rhs) {\
  writeOp(CacheOp::CompareSymbolResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareInt32Result(JSOp op, Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::CompareInt32Result);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareDoubleResult(JSOp op, NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::CompareDoubleResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareBigIntResult(JSOp op, BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::CompareBigIntResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareBigIntInt32Result(JSOp op, BigIntOperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::CompareBigIntInt32Result);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareBigIntNumberResult(JSOp op, BigIntOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::CompareBigIntNumberResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareBigIntStringResult(JSOp op, BigIntOperandId lhs, StringOperandId rhs) {\
  writeOp(CacheOp::CompareBigIntStringResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareNullUndefinedResult(JSOp op, bool isUndefined, ValOperandId input) {\
  writeOp(CacheOp::CompareNullUndefinedResult);\
  writeJSOpImm(op);\
  writeBoolImm(isUndefined);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void compareDoubleSameValueResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::CompareDoubleSameValueResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void sameValueResult(ValOperandId lhs, ValOperandId rhs) {\
  writeOp(CacheOp::SameValueResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void indirectTruncateInt32Result(Int32OperandId val) {\
  writeOp(CacheOp::IndirectTruncateInt32Result);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void bigIntAsIntNResult(Int32OperandId bits, BigIntOperandId bigInt) {\
  writeOp(CacheOp::BigIntAsIntNResult);\
  writeOperandId(bits);\
  writeOperandId(bigInt);\
  assertLengthMatches();\
}\
void bigIntAsUintNResult(Int32OperandId bits, BigIntOperandId bigInt) {\
  writeOp(CacheOp::BigIntAsUintNResult);\
  writeOperandId(bits);\
  writeOperandId(bigInt);\
  assertLengthMatches();\
}\
void callPrintString(const char* str) {\
  writeOp(CacheOp::CallPrintString);\
  writeStaticStringImm(str);\
  assertLengthMatches();\
}\
void breakpoint() {\
  writeOp(CacheOp::Breakpoint);\
  assertLengthMatches();\
}\
void wrapResult() {\
  writeOp(CacheOp::WrapResult);\
  assertLengthMatches();\
}\
void bailout() {\
  writeOp(CacheOp::Bailout);\
  assertLengthMatches();\
}\
void assertRecoveredOnBailoutResult(ValOperandId val, bool mustBeRecovered) {\
  writeOp(CacheOp::AssertRecoveredOnBailoutResult);\
  writeOperandId(val);\
  writeBoolImm(mustBeRecovered);\
  assertLengthMatches();\
}

#define CACHE_IR_COMPILER_SHARED_GENERATED \
[[nodiscard]] bool emitGuardToObject(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToObject(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToObject(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNullOrUndefined(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNullOrUndefined(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNullOrUndefined(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNull(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNull(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNull(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsUndefined(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsUndefined(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsUndefined(inputId);\
}\
\
[[nodiscard]] bool emitGuardToBoolean(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToBoolean(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToBoolean(inputId);\
}\
\
[[nodiscard]] bool emitGuardToString(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToString(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToString(inputId);\
}\
\
[[nodiscard]] bool emitGuardToSymbol(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToSymbol(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToSymbol(inputId);\
}\
\
[[nodiscard]] bool emitGuardToBigInt(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToBigInt(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToBigInt(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNumber(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNumber(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNumber(inputId);\
}\
\
[[nodiscard]] bool emitGuardToInt32(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToInt32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToInt32(inputId);\
}\
\
[[nodiscard]] bool emitGuardBooleanToInt32(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardBooleanToInt32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardBooleanToInt32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardToInt32Index(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToInt32Index(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToInt32Index(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32ToIntPtr(Int32OperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitInt32ToIntPtr(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitInt32ToIntPtr(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardNumberToIntPtrIndex(NumberOperandId inputId, bool supportOOB, IntPtrOperandId resultId);\
[[nodiscard]] bool emitGuardNumberToIntPtrIndex(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  bool supportOOB = reader.readBool();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitGuardNumberToIntPtrIndex(inputId, supportOOB, resultId);\
}\
\
[[nodiscard]] bool emitGuardToInt32ModUint32(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToInt32ModUint32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToInt32ModUint32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardToUint8Clamped(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToUint8Clamped(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToUint8Clamped(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardNonDoubleType(ValOperandId inputId, ValueType type);\
[[nodiscard]] bool emitGuardNonDoubleType(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  ValueType type = reader.valueType();\
  return emitGuardNonDoubleType(inputId, type);\
}\
\
[[nodiscard]] bool emitGuardNullProto(ObjOperandId objId);\
[[nodiscard]] bool emitGuardNullProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardNullProto(objId);\
}\
\
[[nodiscard]] bool emitGuardClass(ObjOperandId objId, GuardClassKind kind);\
[[nodiscard]] bool emitGuardClass(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  GuardClassKind kind = reader.guardClassKind();\
  return emitGuardClass(objId, kind);\
}\
\
[[nodiscard]] bool emitCallRegExpMatcherResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId);\
[[nodiscard]] bool emitCallRegExpMatcherResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  return emitCallRegExpMatcherResult(regexpId, inputId, lastIndexId);\
}\
\
[[nodiscard]] bool emitCallRegExpSearcherResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId);\
[[nodiscard]] bool emitCallRegExpSearcherResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  return emitCallRegExpSearcherResult(regexpId, inputId, lastIndexId);\
}\
\
[[nodiscard]] bool emitCallRegExpTesterResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId);\
[[nodiscard]] bool emitCallRegExpTesterResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  return emitCallRegExpTesterResult(regexpId, inputId, lastIndexId);\
}\
\
[[nodiscard]] bool emitRegExpFlagResult(ObjOperandId regexpId, int32_t flagsMask);\
[[nodiscard]] bool emitRegExpFlagResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  int32_t flagsMask = reader.int32Immediate();\
  return emitRegExpFlagResult(regexpId, flagsMask);\
}\
\
[[nodiscard]] bool emitCallSubstringKernelResult(StringOperandId strId, Int32OperandId beginId, Int32OperandId lengthId);\
[[nodiscard]] bool emitCallSubstringKernelResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitCallSubstringKernelResult(strId, beginId, lengthId);\
}\
\
[[nodiscard]] bool emitStringReplaceStringResult(StringOperandId strId, StringOperandId patternId, StringOperandId replacementId);\
[[nodiscard]] bool emitStringReplaceStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId patternId = reader.stringOperandId();\
  StringOperandId replacementId = reader.stringOperandId();\
  return emitStringReplaceStringResult(strId, patternId, replacementId);\
}\
\
[[nodiscard]] bool emitStringSplitStringResult(StringOperandId strId, StringOperandId separatorId);\
[[nodiscard]] bool emitStringSplitStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId separatorId = reader.stringOperandId();\
  return emitStringSplitStringResult(strId, separatorId);\
}\
\
[[nodiscard]] bool emitRegExpPrototypeOptimizableResult(ObjOperandId protoId);\
[[nodiscard]] bool emitRegExpPrototypeOptimizableResult(CacheIRReader& reader) {\
  ObjOperandId protoId = reader.objOperandId();\
  return emitRegExpPrototypeOptimizableResult(protoId);\
}\
\
[[nodiscard]] bool emitRegExpInstanceOptimizableResult(ObjOperandId regexpId, ObjOperandId protoId);\
[[nodiscard]] bool emitRegExpInstanceOptimizableResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  ObjOperandId protoId = reader.objOperandId();\
  return emitRegExpInstanceOptimizableResult(regexpId, protoId);\
}\
\
[[nodiscard]] bool emitGetFirstDollarIndexResult(StringOperandId strId);\
[[nodiscard]] bool emitGetFirstDollarIndexResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitGetFirstDollarIndexResult(strId);\
}\
\
[[nodiscard]] bool emitGuardIsExtensible(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsExtensible(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsExtensible(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNativeObject(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNativeObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNativeObject(objId);\
}\
\
[[nodiscard]] bool emitGuardIsProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotArrayBufferMaybeShared(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotArrayBufferMaybeShared(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotArrayBufferMaybeShared(objId);\
}\
\
[[nodiscard]] bool emitGuardIsTypedArray(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsTypedArray(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsTypedArray(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotDOMProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotDOMProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotDOMProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardNoDenseElements(ObjOperandId objId);\
[[nodiscard]] bool emitGuardNoDenseElements(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardNoDenseElements(objId);\
}\
\
[[nodiscard]] bool emitGuardStringToIndex(StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardStringToIndex(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardStringToIndex(strId, resultId);\
}\
\
[[nodiscard]] bool emitGuardStringToInt32(StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardStringToInt32(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardStringToInt32(strId, resultId);\
}\
\
[[nodiscard]] bool emitGuardStringToNumber(StringOperandId strId, NumberOperandId resultId);\
[[nodiscard]] bool emitGuardStringToNumber(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitGuardStringToNumber(strId, resultId);\
}\
\
[[nodiscard]] bool emitBooleanToNumber(BooleanOperandId booleanId, NumberOperandId resultId);\
[[nodiscard]] bool emitBooleanToNumber(CacheIRReader& reader) {\
  BooleanOperandId booleanId = reader.booleanOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitBooleanToNumber(booleanId, resultId);\
}\
\
[[nodiscard]] bool emitGuardHasGetterSetter(ObjOperandId objId, uint32_t idOffset, uint32_t getterSetterOffset);\
[[nodiscard]] bool emitGuardHasGetterSetter(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  uint32_t getterSetterOffset = reader.stubOffset();\
  return emitGuardHasGetterSetter(objId, idOffset, getterSetterOffset);\
}\
\
[[nodiscard]] bool emitGuardInt32IsNonNegative(Int32OperandId indexId);\
[[nodiscard]] bool emitGuardInt32IsNonNegative(CacheIRReader& reader) {\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardInt32IsNonNegative(indexId);\
}\
\
[[nodiscard]] bool emitGuardIndexIsValidUpdateOrAdd(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitGuardIndexIsValidUpdateOrAdd(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardIndexIsValidUpdateOrAdd(objId, indexId);\
}\
\
[[nodiscard]] bool emitGuardIndexGreaterThanDenseInitLength(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitGuardIndexGreaterThanDenseInitLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardIndexGreaterThanDenseInitLength(objId, indexId);\
}\
\
[[nodiscard]] bool emitGuardTagNotEqual(ValueTagOperandId lhsId, ValueTagOperandId rhsId);\
[[nodiscard]] bool emitGuardTagNotEqual(CacheIRReader& reader) {\
  ValueTagOperandId lhsId = reader.valueTagOperandId();\
  ValueTagOperandId rhsId = reader.valueTagOperandId();\
  return emitGuardTagNotEqual(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitGuardXrayExpandoShapeAndDefaultProto(ObjOperandId objId, uint32_t shapeWrapperOffset);\
[[nodiscard]] bool emitGuardXrayExpandoShapeAndDefaultProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeWrapperOffset = reader.stubOffset();\
  return emitGuardXrayExpandoShapeAndDefaultProto(objId, shapeWrapperOffset);\
}\
\
[[nodiscard]] bool emitGuardXrayNoExpando(ObjOperandId objId);\
[[nodiscard]] bool emitGuardXrayNoExpando(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardXrayNoExpando(objId);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotIsSpecificObject(ObjOperandId objId, ObjOperandId expectedId, uint32_t slotOffset);\
[[nodiscard]] bool emitGuardDynamicSlotIsSpecificObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId expectedId = reader.objOperandId();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitGuardDynamicSlotIsSpecificObject(objId, expectedId, slotOffset);\
}\
\
[[nodiscard]] bool emitGuardFixedSlotValue(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitGuardFixedSlotValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitGuardFixedSlotValue(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotValue(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitGuardDynamicSlotValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitGuardDynamicSlotValue(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitGuardNoAllocationMetadataBuilder(uint32_t builderAddrOffset);\
[[nodiscard]] bool emitGuardNoAllocationMetadataBuilder(CacheIRReader& reader) {\
  uint32_t builderAddrOffset = reader.stubOffset();\
  return emitGuardNoAllocationMetadataBuilder(builderAddrOffset);\
}\
\
[[nodiscard]] bool emitGuardFunctionHasJitEntry(ObjOperandId funId, bool constructing);\
[[nodiscard]] bool emitGuardFunctionHasJitEntry(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  bool constructing = reader.readBool();\
  return emitGuardFunctionHasJitEntry(funId, constructing);\
}\
\
[[nodiscard]] bool emitGuardFunctionHasNoJitEntry(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionHasNoJitEntry(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionHasNoJitEntry(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionIsNonBuiltinCtor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionIsNonBuiltinCtor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionIsNonBuiltinCtor(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionIsConstructor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionIsConstructor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionIsConstructor(funId);\
}\
\
[[nodiscard]] bool emitGuardNotClassConstructor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardNotClassConstructor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardNotClassConstructor(funId);\
}\
\
[[nodiscard]] bool emitGuardArrayIsPacked(ObjOperandId arrayId);\
[[nodiscard]] bool emitGuardArrayIsPacked(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitGuardArrayIsPacked(arrayId);\
}\
\
[[nodiscard]] bool emitGuardArgumentsObjectFlags(ObjOperandId objId, uint8_t flags);\
[[nodiscard]] bool emitGuardArgumentsObjectFlags(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint8_t flags = reader.readByte();\
  return emitGuardArgumentsObjectFlags(objId, flags);\
}\
\
[[nodiscard]] bool emitLoadObject(ObjOperandId resultId, uint32_t objOffset);\
[[nodiscard]] bool emitLoadObject(CacheIRReader& reader) {\
  ObjOperandId resultId = reader.objOperandId();\
  uint32_t objOffset = reader.stubOffset();\
  return emitLoadObject(resultId, objOffset);\
}\
\
[[nodiscard]] bool emitLoadProto(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadProto(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadEnclosingEnvironment(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadEnclosingEnvironment(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadEnclosingEnvironment(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadWrapperTarget(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadWrapperTarget(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadWrapperTarget(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadValueTag(ValOperandId valId, ValueTagOperandId resultId);\
[[nodiscard]] bool emitLoadValueTag(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  ValueTagOperandId resultId = reader.valueTagOperandId();\
  return emitLoadValueTag(valId, resultId);\
}\
\
[[nodiscard]] bool emitTruncateDoubleToUInt32(NumberOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitTruncateDoubleToUInt32(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitTruncateDoubleToUInt32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotResult(ObjOperandId objId, uint32_t nameOffset);\
[[nodiscard]] bool emitMegamorphicLoadSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  return emitMegamorphicLoadSlotResult(objId, nameOffset);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotByValueResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitMegamorphicLoadSlotByValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitMegamorphicLoadSlotByValueResult(objId, idId);\
}\
\
[[nodiscard]] bool emitMegamorphicStoreSlot(ObjOperandId objId, uint32_t nameOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitMegamorphicStoreSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitMegamorphicStoreSlot(objId, nameOffset, rhsId);\
}\
\
[[nodiscard]] bool emitMegamorphicHasPropResult(ObjOperandId objId, ValOperandId idId, bool hasOwn);\
[[nodiscard]] bool emitMegamorphicHasPropResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  bool hasOwn = reader.readBool();\
  return emitMegamorphicHasPropResult(objId, idId, hasOwn);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValue(ObjOperandId objId, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValue(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValueIgnoreGeneration(ObjOperandId objId, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValueIgnoreGeneration(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValueIgnoreGeneration(objId, resultId);\
}\
\
[[nodiscard]] bool emitStoreDenseElement(ObjOperandId objId, Int32OperandId indexId, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreDenseElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreDenseElement(objId, indexId, rhsId);\
}\
\
[[nodiscard]] bool emitStoreDenseElementHole(ObjOperandId objId, Int32OperandId indexId, ValOperandId rhsId, bool handleAdd);\
[[nodiscard]] bool emitStoreDenseElementHole(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool handleAdd = reader.readBool();\
  return emitStoreDenseElementHole(objId, indexId, rhsId, handleAdd);\
}\
\
[[nodiscard]] bool emitArrayPush(ObjOperandId objId, ValOperandId rhsId);\
[[nodiscard]] bool emitArrayPush(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitArrayPush(objId, rhsId);\
}\
\
[[nodiscard]] bool emitPackedArrayPopResult(ObjOperandId arrayId);\
[[nodiscard]] bool emitPackedArrayPopResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitPackedArrayPopResult(arrayId);\
}\
\
[[nodiscard]] bool emitPackedArrayShiftResult(ObjOperandId arrayId);\
[[nodiscard]] bool emitPackedArrayShiftResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitPackedArrayShiftResult(arrayId);\
}\
\
[[nodiscard]] bool emitStoreFixedSlotUndefinedResult(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreFixedSlotUndefinedResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreFixedSlotUndefinedResult(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitIsObjectResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsObjectResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsObjectResult(inputId);\
}\
\
[[nodiscard]] bool emitIsPackedArrayResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsPackedArrayResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsPackedArrayResult(objId);\
}\
\
[[nodiscard]] bool emitIsCallableResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsCallableResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsCallableResult(inputId);\
}\
\
[[nodiscard]] bool emitIsConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitIsCrossRealmArrayConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsCrossRealmArrayConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsCrossRealmArrayConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitIsTypedArrayConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsTypedArrayConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsTypedArrayConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitArrayBufferViewByteOffsetInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitArrayBufferViewByteOffsetInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitArrayBufferViewByteOffsetInt32Result(objId);\
}\
\
[[nodiscard]] bool emitArrayBufferViewByteOffsetDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitArrayBufferViewByteOffsetDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitArrayBufferViewByteOffsetDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayElementSizeResult(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayElementSizeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayElementSizeResult(objId);\
}\
\
[[nodiscard]] bool emitGuardHasAttachedArrayBuffer(ObjOperandId objId);\
[[nodiscard]] bool emitGuardHasAttachedArrayBuffer(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardHasAttachedArrayBuffer(objId);\
}\
\
[[nodiscard]] bool emitFinishBoundFunctionInitResult(ObjOperandId boundId, ObjOperandId targetId, Int32OperandId argCountId);\
[[nodiscard]] bool emitFinishBoundFunctionInitResult(CacheIRReader& reader) {\
  ObjOperandId boundId = reader.objOperandId();\
  ObjOperandId targetId = reader.objOperandId();\
  Int32OperandId argCountId = reader.int32OperandId();\
  return emitFinishBoundFunctionInitResult(boundId, targetId, argCountId);\
}\
\
[[nodiscard]] bool emitNewArrayIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewArrayIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewArrayIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewStringIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewStringIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewStringIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewRegExpStringIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewRegExpStringIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewRegExpStringIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitObjectCreateResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitObjectCreateResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitObjectCreateResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewArrayFromLengthResult(uint32_t templateObjectOffset, Int32OperandId lengthId);\
[[nodiscard]] bool emitNewArrayFromLengthResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitNewArrayFromLengthResult(templateObjectOffset, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromLengthResult(uint32_t templateObjectOffset, Int32OperandId lengthId);\
[[nodiscard]] bool emitNewTypedArrayFromLengthResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitNewTypedArrayFromLengthResult(templateObjectOffset, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromArrayBufferResult(uint32_t templateObjectOffset, ObjOperandId bufferId, ValOperandId byteOffsetId, ValOperandId lengthId);\
[[nodiscard]] bool emitNewTypedArrayFromArrayBufferResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId bufferId = reader.objOperandId();\
  ValOperandId byteOffsetId = reader.valOperandId();\
  ValOperandId lengthId = reader.valOperandId();\
  return emitNewTypedArrayFromArrayBufferResult(templateObjectOffset, bufferId, byteOffsetId, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromArrayResult(uint32_t templateObjectOffset, ObjOperandId arrayId);\
[[nodiscard]] bool emitNewTypedArrayFromArrayResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitNewTypedArrayFromArrayResult(templateObjectOffset, arrayId);\
}\
\
[[nodiscard]] bool emitNewStringObjectResult(uint32_t templateObjectOffset, StringOperandId strId);\
[[nodiscard]] bool emitNewStringObjectResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  StringOperandId strId = reader.stringOperandId();\
  return emitNewStringObjectResult(templateObjectOffset, strId);\
}\
\
[[nodiscard]] bool emitStringToLowerCaseResult(StringOperandId strId);\
[[nodiscard]] bool emitStringToLowerCaseResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToLowerCaseResult(strId);\
}\
\
[[nodiscard]] bool emitStringToUpperCaseResult(StringOperandId strId);\
[[nodiscard]] bool emitStringToUpperCaseResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToUpperCaseResult(strId);\
}\
\
[[nodiscard]] bool emitMathAbsInt32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathAbsInt32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathAbsInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathAbsNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathAbsNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathAbsNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathClz32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathClz32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathClz32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathSignInt32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathSignInt32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathSignInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathSignNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSignNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSignNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathSignNumberToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSignNumberToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSignNumberToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathImulResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitMathImulResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitMathImulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitMathSqrtNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSqrtNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSqrtNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathFRoundNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFRoundNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFRoundNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathHypot2NumberResult(NumberOperandId firstId, NumberOperandId secondId);\
[[nodiscard]] bool emitMathHypot2NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  return emitMathHypot2NumberResult(firstId, secondId);\
}\
\
[[nodiscard]] bool emitMathHypot3NumberResult(NumberOperandId firstId, NumberOperandId secondId, NumberOperandId thirdId);\
[[nodiscard]] bool emitMathHypot3NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId thirdId = reader.numberOperandId();\
  return emitMathHypot3NumberResult(firstId, secondId, thirdId);\
}\
\
[[nodiscard]] bool emitMathHypot4NumberResult(NumberOperandId firstId, NumberOperandId secondId, NumberOperandId thirdId, NumberOperandId fourthId);\
[[nodiscard]] bool emitMathHypot4NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId thirdId = reader.numberOperandId();\
  NumberOperandId fourthId = reader.numberOperandId();\
  return emitMathHypot4NumberResult(firstId, secondId, thirdId, fourthId);\
}\
\
[[nodiscard]] bool emitMathAtan2NumberResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitMathAtan2NumberResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitMathAtan2NumberResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitMathFloorNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFloorNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFloorNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathCeilNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathCeilNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathCeilNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathTruncNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathTruncNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathTruncNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathFloorToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFloorToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFloorToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathCeilToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathCeilToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathCeilToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathTruncToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathTruncToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathTruncToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathRoundToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathRoundToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathRoundToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitInt32MinMax(bool isMax, Int32OperandId firstId, Int32OperandId secondId, Int32OperandId resultId);\
[[nodiscard]] bool emitInt32MinMax(CacheIRReader& reader) {\
  bool isMax = reader.readBool();\
  Int32OperandId firstId = reader.int32OperandId();\
  Int32OperandId secondId = reader.int32OperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitInt32MinMax(isMax, firstId, secondId, resultId);\
}\
\
[[nodiscard]] bool emitNumberMinMax(bool isMax, NumberOperandId firstId, NumberOperandId secondId, NumberOperandId resultId);\
[[nodiscard]] bool emitNumberMinMax(CacheIRReader& reader) {\
  bool isMax = reader.readBool();\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitNumberMinMax(isMax, firstId, secondId, resultId);\
}\
\
[[nodiscard]] bool emitInt32MinMaxArrayResult(ObjOperandId arrayId, bool isMax);\
[[nodiscard]] bool emitInt32MinMaxArrayResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  bool isMax = reader.readBool();\
  return emitInt32MinMaxArrayResult(arrayId, isMax);\
}\
\
[[nodiscard]] bool emitNumberMinMaxArrayResult(ObjOperandId arrayId, bool isMax);\
[[nodiscard]] bool emitNumberMinMaxArrayResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  bool isMax = reader.readBool();\
  return emitNumberMinMaxArrayResult(arrayId, isMax);\
}\
\
[[nodiscard]] bool emitMathFunctionNumberResult(NumberOperandId inputId, UnaryMathFunction fun);\
[[nodiscard]] bool emitMathFunctionNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  UnaryMathFunction fun = reader.unaryMathFunction();\
  return emitMathFunctionNumberResult(inputId, fun);\
}\
\
[[nodiscard]] bool emitObjectToStringResult(ObjOperandId objId);\
[[nodiscard]] bool emitObjectToStringResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitObjectToStringResult(objId);\
}\
\
[[nodiscard]] bool emitStoreTypedArrayElement(ObjOperandId objId, Scalar::Type elementType, IntPtrOperandId indexId, uint32_t rhsId, bool handleOOB);\
[[nodiscard]] bool emitStoreTypedArrayElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t rhsId = reader.rawOperandId();\
  bool handleOOB = reader.readBool();\
  return emitStoreTypedArrayElement(objId, elementType, indexId, rhsId, handleOOB);\
}\
\
[[nodiscard]] bool emitAtomicsCompareExchangeResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t expectedId, uint32_t replacementId, Scalar::Type elementType);\
[[nodiscard]] bool emitAtomicsCompareExchangeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t expectedId = reader.rawOperandId();\
  uint32_t replacementId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitAtomicsCompareExchangeResult(objId, indexId, expectedId, replacementId, elementType);\
}\
\
[[nodiscard]] bool emitAtomicsExchangeResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType);\
[[nodiscard]] bool emitAtomicsExchangeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitAtomicsExchangeResult(objId, indexId, valueId, elementType);\
}\
\
[[nodiscard]] bool emitAtomicsAddResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsAddResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsAddResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsSubResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsSubResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsSubResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsAndResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsAndResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsAndResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsOrResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsOrResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsOrResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsXorResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsXorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsXorResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsLoadResult(ObjOperandId objId, IntPtrOperandId indexId, Scalar::Type elementType);\
[[nodiscard]] bool emitAtomicsLoadResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitAtomicsLoadResult(objId, indexId, elementType);\
}\
\
[[nodiscard]] bool emitAtomicsStoreResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType);\
[[nodiscard]] bool emitAtomicsStoreResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitAtomicsStoreResult(objId, indexId, valueId, elementType);\
}\
\
[[nodiscard]] bool emitAtomicsIsLockFreeResult(Int32OperandId valueId);\
[[nodiscard]] bool emitAtomicsIsLockFreeResult(CacheIRReader& reader) {\
  Int32OperandId valueId = reader.int32OperandId();\
  return emitAtomicsIsLockFreeResult(valueId);\
}\
\
[[nodiscard]] bool emitCallInt32ToString(Int32OperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitCallInt32ToString(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitCallInt32ToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitCallNumberToString(NumberOperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitCallNumberToString(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitCallNumberToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitBooleanToString(BooleanOperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitBooleanToString(CacheIRReader& reader) {\
  BooleanOperandId inputId = reader.booleanOperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitBooleanToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardWasmArg(ValOperandId argId, wasm::ValType::Kind type);\
[[nodiscard]] bool emitGuardWasmArg(CacheIRReader& reader) {\
  ValOperandId argId = reader.valOperandId();\
  wasm::ValType::Kind type = reader.wasmValType();\
  return emitGuardWasmArg(argId, type);\
}\
\
[[nodiscard]] bool emitMetaTwoByte(uint32_t functionObjectOffset, uint32_t templateObjectOffset);\
[[nodiscard]] bool emitMetaTwoByte(CacheIRReader& reader) {\
  uint32_t functionObjectOffset = reader.stubOffset();\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitMetaTwoByte(functionObjectOffset, templateObjectOffset);\
}\
\
[[nodiscard]] bool emitLoadDenseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadDenseElementHoleResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementHoleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementHoleResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallGetSparseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallGetSparseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallGetSparseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadDenseElementExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadTypedArrayElementExistsResult(ObjOperandId objId, IntPtrOperandId indexId);\
[[nodiscard]] bool emitLoadTypedArrayElementExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  return emitLoadTypedArrayElementExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadDenseElementHoleExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementHoleExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementHoleExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadTypedArrayElementResult(ObjOperandId objId, IntPtrOperandId indexId, Scalar::Type elementType, bool handleOOB, bool forceDoubleForUint32);\
[[nodiscard]] bool emitLoadTypedArrayElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool handleOOB = reader.readBool();\
  bool forceDoubleForUint32 = reader.readBool();\
  return emitLoadTypedArrayElementResult(objId, indexId, elementType, handleOOB, forceDoubleForUint32);\
}\
\
[[nodiscard]] bool emitLoadDataViewValueResult(ObjOperandId objId, IntPtrOperandId offsetId, BooleanOperandId littleEndianId, Scalar::Type elementType, bool forceDoubleForUint32);\
[[nodiscard]] bool emitLoadDataViewValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forceDoubleForUint32 = reader.readBool();\
  return emitLoadDataViewValueResult(objId, offsetId, littleEndianId, elementType, forceDoubleForUint32);\
}\
\
[[nodiscard]] bool emitStoreDataViewValueResult(ObjOperandId objId, IntPtrOperandId offsetId, uint32_t valueId, BooleanOperandId littleEndianId, Scalar::Type elementType);\
[[nodiscard]] bool emitStoreDataViewValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitStoreDataViewValueResult(objId, offsetId, valueId, littleEndianId, elementType);\
}\
\
[[nodiscard]] bool emitLoadInt32ArrayLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadInt32ArrayLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadInt32ArrayLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadInt32ArrayLength(ObjOperandId objId, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadInt32ArrayLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadInt32ArrayLength(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectArgResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadArgumentsObjectArgResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadArgumentsObjectArgResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArgumentsObjectLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArgumentsObjectLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadFunctionLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadFunctionLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadFunctionLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadFunctionNameResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadFunctionNameResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadFunctionNameResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferViewLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferViewLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferViewLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferViewLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitLoadStringCharCodeResult(StringOperandId strId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadStringCharCodeResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadStringCharCodeResult(strId, indexId);\
}\
\
[[nodiscard]] bool emitLoadStringLengthResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringLengthResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringLengthResult(strId);\
}\
\
[[nodiscard]] bool emitLoadObjectResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadObjectResult(objId);\
}\
\
[[nodiscard]] bool emitLoadStringResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringResult(strId);\
}\
\
[[nodiscard]] bool emitLoadSymbolResult(SymbolOperandId symId);\
[[nodiscard]] bool emitLoadSymbolResult(CacheIRReader& reader) {\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitLoadSymbolResult(symId);\
}\
\
[[nodiscard]] bool emitLoadInt32Result(Int32OperandId valId);\
[[nodiscard]] bool emitLoadInt32Result(CacheIRReader& reader) {\
  Int32OperandId valId = reader.int32OperandId();\
  return emitLoadInt32Result(valId);\
}\
\
[[nodiscard]] bool emitLoadDoubleResult(NumberOperandId valId);\
[[nodiscard]] bool emitLoadDoubleResult(CacheIRReader& reader) {\
  NumberOperandId valId = reader.numberOperandId();\
  return emitLoadDoubleResult(valId);\
}\
\
[[nodiscard]] bool emitLoadBigIntResult(BigIntOperandId valId);\
[[nodiscard]] bool emitLoadBigIntResult(CacheIRReader& reader) {\
  BigIntOperandId valId = reader.bigIntOperandId();\
  return emitLoadBigIntResult(valId);\
}\
\
[[nodiscard]] bool emitProxyGetByValueResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitProxyGetByValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitProxyGetByValueResult(objId, idId);\
}\
\
[[nodiscard]] bool emitProxyHasPropResult(ObjOperandId objId, ValOperandId idId, bool hasOwn);\
[[nodiscard]] bool emitProxyHasPropResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  bool hasOwn = reader.readBool();\
  return emitProxyHasPropResult(objId, idId, hasOwn);\
}\
\
[[nodiscard]] bool emitCallObjectHasSparseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallObjectHasSparseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallObjectHasSparseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallNativeGetElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallNativeGetElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallNativeGetElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitGetNextMapSetEntryForIteratorResult(ObjOperandId iterId, ObjOperandId resultArrId, bool isMap);\
[[nodiscard]] bool emitGetNextMapSetEntryForIteratorResult(CacheIRReader& reader) {\
  ObjOperandId iterId = reader.objOperandId();\
  ObjOperandId resultArrId = reader.objOperandId();\
  bool isMap = reader.readBool();\
  return emitGetNextMapSetEntryForIteratorResult(iterId, resultArrId, isMap);\
}\
\
[[nodiscard]] bool emitLoadUndefinedResult();\
[[nodiscard]] bool emitLoadUndefinedResult(CacheIRReader& reader) {\
  return emitLoadUndefinedResult();\
}\
\
[[nodiscard]] bool emitLoadBooleanResult(bool val);\
[[nodiscard]] bool emitLoadBooleanResult(CacheIRReader& reader) {\
  bool val = reader.readBool();\
  return emitLoadBooleanResult(val);\
}\
\
[[nodiscard]] bool emitLoadInt32Constant(uint32_t valOffset, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadInt32Constant(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadInt32Constant(valOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadBooleanConstant(bool val, BooleanOperandId resultId);\
[[nodiscard]] bool emitLoadBooleanConstant(CacheIRReader& reader) {\
  bool val = reader.readBool();\
  BooleanOperandId resultId = reader.booleanOperandId();\
  return emitLoadBooleanConstant(val, resultId);\
}\
\
[[nodiscard]] bool emitLoadUndefined(ValOperandId resultId);\
[[nodiscard]] bool emitLoadUndefined(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadUndefined(resultId);\
}\
\
[[nodiscard]] bool emitLoadConstantString(uint32_t strOffset, StringOperandId resultId);\
[[nodiscard]] bool emitLoadConstantString(CacheIRReader& reader) {\
  uint32_t strOffset = reader.stubOffset();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitLoadConstantString(strOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadInstanceOfObjectResult(ValOperandId lhsId, ObjOperandId protoId);\
[[nodiscard]] bool emitLoadInstanceOfObjectResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ObjOperandId protoId = reader.objOperandId();\
  return emitLoadInstanceOfObjectResult(lhsId, protoId);\
}\
\
[[nodiscard]] bool emitLoadTypeOfObjectResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadTypeOfObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadTypeOfObjectResult(objId);\
}\
\
[[nodiscard]] bool emitDoubleAddResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleAddResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleAddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleSubResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleSubResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleSubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleMulResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleMulResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleMulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleDivResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleDivResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleDivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleModResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleModResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoublePowResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoublePowResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoublePowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32AddResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32AddResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32AddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32SubResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32SubResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32SubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32MulResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32MulResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32MulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32DivResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32DivResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32DivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32ModResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32ModResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32ModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32PowResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32PowResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32PowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntAddResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntAddResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntAddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntSubResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntSubResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntSubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntMulResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntMulResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntMulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntDivResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntDivResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntDivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntModResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntModResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntPowResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntPowResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntPowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitOrResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitOrResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitOrResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitXorResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitXorResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitXorResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitAndResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitAndResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitAndResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32LeftShiftResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32LeftShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32LeftShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32RightShiftResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32RightShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32RightShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32URightShiftResult(Int32OperandId lhsId, Int32OperandId rhsId, bool forceDouble);\
[[nodiscard]] bool emitInt32URightShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  bool forceDouble = reader.readBool();\
  return emitInt32URightShiftResult(lhsId, rhsId, forceDouble);\
}\
\
[[nodiscard]] bool emitInt32NotResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32NotResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32NotResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntBitOrResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitOrResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitOrResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntBitXorResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitXorResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitXorResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntBitAndResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitAndResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitAndResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntLeftShiftResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntLeftShiftResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntLeftShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntRightShiftResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntRightShiftResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntRightShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntNotResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntNotResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntNotResult(inputId);\
}\
\
[[nodiscard]] bool emitInt32NegationResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32NegationResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32NegationResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleNegationResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleNegationResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleNegationResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntNegationResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntNegationResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntNegationResult(inputId);\
}\
\
[[nodiscard]] bool emitInt32IncResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32IncResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32IncResult(inputId);\
}\
\
[[nodiscard]] bool emitInt32DecResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32DecResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32DecResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleIncResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleIncResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleIncResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleDecResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleDecResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleDecResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntIncResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntIncResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntIncResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntDecResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntDecResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntDecResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadInt32TruthyResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadInt32TruthyResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadInt32TruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadDoubleTruthyResult(NumberOperandId inputId);\
[[nodiscard]] bool emitLoadDoubleTruthyResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitLoadDoubleTruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadStringTruthyResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringTruthyResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringTruthyResult(strId);\
}\
\
[[nodiscard]] bool emitLoadObjectTruthyResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadObjectTruthyResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadObjectTruthyResult(objId);\
}\
\
[[nodiscard]] bool emitLoadBigIntTruthyResult(BigIntOperandId bigIntId);\
[[nodiscard]] bool emitLoadBigIntTruthyResult(CacheIRReader& reader) {\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitLoadBigIntTruthyResult(bigIntId);\
}\
\
[[nodiscard]] bool emitLoadValueTruthyResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadValueTruthyResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadValueTruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadOperandResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadOperandResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadOperandResult(inputId);\
}\
\
[[nodiscard]] bool emitCallStringConcatResult(StringOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCallStringConcatResult(CacheIRReader& reader) {\
  StringOperandId lhsId = reader.stringOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCallStringConcatResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCallIsSuspendedGeneratorResult(ValOperandId valId);\
[[nodiscard]] bool emitCallIsSuspendedGeneratorResult(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  return emitCallIsSuspendedGeneratorResult(valId);\
}\
\
[[nodiscard]] bool emitCompareObjectResult(JSOp op, ObjOperandId lhsId, ObjOperandId rhsId);\
[[nodiscard]] bool emitCompareObjectResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  ObjOperandId lhsId = reader.objOperandId();\
  ObjOperandId rhsId = reader.objOperandId();\
  return emitCompareObjectResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareSymbolResult(JSOp op, SymbolOperandId lhsId, SymbolOperandId rhsId);\
[[nodiscard]] bool emitCompareSymbolResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  SymbolOperandId lhsId = reader.symbolOperandId();\
  SymbolOperandId rhsId = reader.symbolOperandId();\
  return emitCompareSymbolResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareInt32Result(JSOp op, Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitCompareInt32Result(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitCompareInt32Result(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareDoubleResult(JSOp op, NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareDoubleResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareDoubleResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntResult(JSOp op, BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitCompareBigIntResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntInt32Result(JSOp op, BigIntOperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntInt32Result(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitCompareBigIntInt32Result(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntNumberResult(JSOp op, BigIntOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntNumberResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareBigIntNumberResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntStringResult(JSOp op, BigIntOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntStringResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCompareBigIntStringResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareNullUndefinedResult(JSOp op, bool isUndefined, ValOperandId inputId);\
[[nodiscard]] bool emitCompareNullUndefinedResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  bool isUndefined = reader.readBool();\
  ValOperandId inputId = reader.valOperandId();\
  return emitCompareNullUndefinedResult(op, isUndefined, inputId);\
}\
\
[[nodiscard]] bool emitCompareDoubleSameValueResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareDoubleSameValueResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareDoubleSameValueResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitIndirectTruncateInt32Result(Int32OperandId valId);\
[[nodiscard]] bool emitIndirectTruncateInt32Result(CacheIRReader& reader) {\
  Int32OperandId valId = reader.int32OperandId();\
  return emitIndirectTruncateInt32Result(valId);\
}\
\
[[nodiscard]] bool emitBigIntAsIntNResult(Int32OperandId bitsId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitBigIntAsIntNResult(CacheIRReader& reader) {\
  Int32OperandId bitsId = reader.int32OperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitBigIntAsIntNResult(bitsId, bigIntId);\
}\
\
[[nodiscard]] bool emitBigIntAsUintNResult(Int32OperandId bitsId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitBigIntAsUintNResult(CacheIRReader& reader) {\
  Int32OperandId bitsId = reader.int32OperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitBigIntAsUintNResult(bitsId, bigIntId);\
}\
\
[[nodiscard]] bool emitCallPrintString(const char* str);\
[[nodiscard]] bool emitCallPrintString(CacheIRReader& reader) {\
  const char* str = reinterpret_cast<char*>(reader.pointer());\
  return emitCallPrintString(str);\
}\
\
[[nodiscard]] bool emitBreakpoint();\
[[nodiscard]] bool emitBreakpoint(CacheIRReader& reader) {\
  return emitBreakpoint();\
}\
\
[[nodiscard]] bool emitWrapResult();\
[[nodiscard]] bool emitWrapResult(CacheIRReader& reader) {\
  return emitWrapResult();\
}\
\
[[nodiscard]] bool emitBailout();\
[[nodiscard]] bool emitBailout(CacheIRReader& reader) {\
  return emitBailout();\
}\
\
[[nodiscard]] bool emitAssertRecoveredOnBailoutResult(ValOperandId valId, bool mustBeRecovered);\
[[nodiscard]] bool emitAssertRecoveredOnBailoutResult(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  bool mustBeRecovered = reader.readBool();\
  return emitAssertRecoveredOnBailoutResult(valId, mustBeRecovered);\
}\


#define CACHE_IR_COMPILER_UNSHARED_GENERATED \
[[nodiscard]] bool emitReturnFromIC();\
[[nodiscard]] bool emitReturnFromIC(CacheIRReader& reader) {\
  return emitReturnFromIC();\
}\
\
[[nodiscard]] bool emitGuardShape(ObjOperandId objId, uint32_t shapeOffset);\
[[nodiscard]] bool emitGuardShape(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitGuardShape(objId, shapeOffset);\
}\
\
[[nodiscard]] bool emitGuardProto(ObjOperandId objId, uint32_t protoOffset);\
[[nodiscard]] bool emitGuardProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t protoOffset = reader.stubOffset();\
  return emitGuardProto(objId, protoOffset);\
}\
\
[[nodiscard]] bool emitGuardAnyClass(ObjOperandId objId, uint32_t claspOffset);\
[[nodiscard]] bool emitGuardAnyClass(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t claspOffset = reader.stubOffset();\
  return emitGuardAnyClass(objId, claspOffset);\
}\
\
[[nodiscard]] bool emitHasClassResult(ObjOperandId objId, uint32_t claspOffset);\
[[nodiscard]] bool emitHasClassResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t claspOffset = reader.stubOffset();\
  return emitHasClassResult(objId, claspOffset);\
}\
\
[[nodiscard]] bool emitGuardCompartment(ObjOperandId objId, uint32_t globalOffset, uint32_t compartmentOffset);\
[[nodiscard]] bool emitGuardCompartment(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t globalOffset = reader.stubOffset();\
  uint32_t compartmentOffset = reader.stubOffset();\
  return emitGuardCompartment(objId, globalOffset, compartmentOffset);\
}\
\
[[nodiscard]] bool emitGuardHasProxyHandler(ObjOperandId objId, uint32_t handlerOffset);\
[[nodiscard]] bool emitGuardHasProxyHandler(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t handlerOffset = reader.stubOffset();\
  return emitGuardHasProxyHandler(objId, handlerOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificObject(ObjOperandId objId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificObject(objId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificFunction(ObjOperandId funId, uint32_t expectedOffset, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitGuardSpecificFunction(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitGuardSpecificFunction(funId, expectedOffset, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitGuardFunctionScript(ObjOperandId objId, uint32_t expectedOffset, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitGuardFunctionScript(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitGuardFunctionScript(objId, expectedOffset, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificAtom(StringOperandId strId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificAtom(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificAtom(strId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificSymbol(SymbolOperandId symId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificSymbol(CacheIRReader& reader) {\
  SymbolOperandId symId = reader.symbolOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificSymbol(symId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardAndGetIterator(ObjOperandId objId, uint32_t iterOffset, uint32_t enumeratorsAddrOffset, ObjOperandId resultId);\
[[nodiscard]] bool emitGuardAndGetIterator(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t iterOffset = reader.stubOffset();\
  uint32_t enumeratorsAddrOffset = reader.stubOffset();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitGuardAndGetIterator(objId, iterOffset, enumeratorsAddrOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadArgumentFixedSlot(ValOperandId resultId, uint8_t slotIndex);\
[[nodiscard]] bool emitLoadArgumentFixedSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  uint8_t slotIndex = reader.readByte();\
  return emitLoadArgumentFixedSlot(resultId, slotIndex);\
}\
\
[[nodiscard]] bool emitLoadArgumentDynamicSlot(ValOperandId resultId, Int32OperandId argcId, uint8_t slotIndex);\
[[nodiscard]] bool emitLoadArgumentDynamicSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  uint8_t slotIndex = reader.readByte();\
  return emitLoadArgumentDynamicSlot(resultId, argcId, slotIndex);\
}\
\
[[nodiscard]] bool emitMegamorphicSetElement(ObjOperandId objId, ValOperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitMegamorphicSetElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitMegamorphicSetElement(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValueGuardGeneration(ObjOperandId objId, uint32_t expandoAndGenerationOffset, uint32_t generationOffset, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValueGuardGeneration(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expandoAndGenerationOffset = reader.stubOffset();\
  uint32_t generationOffset = reader.stubOffset();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValueGuardGeneration(objId, expandoAndGenerationOffset, generationOffset, resultId);\
}\
\
[[nodiscard]] bool emitGuardDOMExpandoMissingOrGuardShape(ValOperandId expandoId, uint32_t shapeOffset);\
[[nodiscard]] bool emitGuardDOMExpandoMissingOrGuardShape(CacheIRReader& reader) {\
  ValOperandId expandoId = reader.valOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitGuardDOMExpandoMissingOrGuardShape(expandoId, shapeOffset);\
}\
\
[[nodiscard]] bool emitStoreFixedSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreFixedSlot(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreDynamicSlot(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitAddAndStoreFixedSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset);\
[[nodiscard]] bool emitAddAndStoreFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  return emitAddAndStoreFixedSlot(objId, offsetOffset, rhsId, newShapeOffset);\
}\
\
[[nodiscard]] bool emitAddAndStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset);\
[[nodiscard]] bool emitAddAndStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  return emitAddAndStoreDynamicSlot(objId, offsetOffset, rhsId, newShapeOffset);\
}\
\
[[nodiscard]] bool emitAllocateAndStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset, uint32_t numNewSlotsOffset);\
[[nodiscard]] bool emitAllocateAndStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  uint32_t numNewSlotsOffset = reader.stubOffset();\
  return emitAllocateAndStoreDynamicSlot(objId, offsetOffset, rhsId, newShapeOffset, numNewSlotsOffset);\
}\
\
[[nodiscard]] bool emitArrayJoinResult(ObjOperandId objId, StringOperandId sepId);\
[[nodiscard]] bool emitArrayJoinResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  StringOperandId sepId = reader.stringOperandId();\
  return emitArrayJoinResult(objId, sepId);\
}\
\
[[nodiscard]] bool emitPackedArraySliceResult(uint32_t templateObjectOffset, ObjOperandId arrayId, Int32OperandId beginId, Int32OperandId endId);\
[[nodiscard]] bool emitPackedArraySliceResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId arrayId = reader.objOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId endId = reader.int32OperandId();\
  return emitPackedArraySliceResult(templateObjectOffset, arrayId, beginId, endId);\
}\
\
[[nodiscard]] bool emitIsArrayResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsArrayResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsArrayResult(inputId);\
}\
\
[[nodiscard]] bool emitIsTypedArrayResult(ObjOperandId objId, bool isPossiblyWrapped);\
[[nodiscard]] bool emitIsTypedArrayResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  bool isPossiblyWrapped = reader.readBool();\
  return emitIsTypedArrayResult(objId, isPossiblyWrapped);\
}\
\
[[nodiscard]] bool emitStringFromCharCodeResult(Int32OperandId codeId);\
[[nodiscard]] bool emitStringFromCharCodeResult(CacheIRReader& reader) {\
  Int32OperandId codeId = reader.int32OperandId();\
  return emitStringFromCharCodeResult(codeId);\
}\
\
[[nodiscard]] bool emitStringFromCodePointResult(Int32OperandId codeId);\
[[nodiscard]] bool emitStringFromCodePointResult(CacheIRReader& reader) {\
  Int32OperandId codeId = reader.int32OperandId();\
  return emitStringFromCodePointResult(codeId);\
}\
\
[[nodiscard]] bool emitMathRandomResult(uint32_t rngOffset);\
[[nodiscard]] bool emitMathRandomResult(CacheIRReader& reader) {\
  uint32_t rngOffset = reader.stubOffset();\
  return emitMathRandomResult(rngOffset);\
}\
\
[[nodiscard]] bool emitReflectGetPrototypeOfResult(ObjOperandId objId);\
[[nodiscard]] bool emitReflectGetPrototypeOfResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitReflectGetPrototypeOfResult(objId);\
}\
\
[[nodiscard]] bool emitCallNativeSetter(ObjOperandId receiverId, uint32_t setterOffset, ValOperandId rhsId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallNativeSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  uint32_t setterOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallNativeSetter(receiverId, setterOffset, rhsId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallScriptedSetter(ObjOperandId receiverId, uint32_t setterOffset, ValOperandId rhsId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallScriptedSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  uint32_t setterOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallScriptedSetter(receiverId, setterOffset, rhsId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedSetter(ObjOperandId receiverId, uint32_t setterOffset, ValOperandId rhsId, uint32_t icScriptOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallInlinedSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  uint32_t setterOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallInlinedSetter(receiverId, setterOffset, rhsId, icScriptOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallDOMSetter(ObjOperandId objId, uint32_t jitInfoOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitCallDOMSetter(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t jitInfoOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallDOMSetter(objId, jitInfoOffset, rhsId);\
}\
\
[[nodiscard]] bool emitCallSetArrayLength(ObjOperandId objId, bool strict, ValOperandId rhsId);\
[[nodiscard]] bool emitCallSetArrayLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  bool strict = reader.readBool();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallSetArrayLength(objId, strict, rhsId);\
}\
\
[[nodiscard]] bool emitProxySet(ObjOperandId objId, uint32_t idOffset, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitProxySet(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitProxySet(objId, idOffset, rhsId, strict);\
}\
\
[[nodiscard]] bool emitProxySetByValue(ObjOperandId objId, ValOperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitProxySetByValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitProxySetByValue(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitCallAddOrUpdateSparseElementHelper(ObjOperandId objId, Int32OperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitCallAddOrUpdateSparseElementHelper(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId idId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitCallAddOrUpdateSparseElementHelper(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitCallScriptedFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags);\
[[nodiscard]] bool emitCallScriptedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  return emitCallScriptedFunction(calleeId, argcId, flags);\
}\
\
[[nodiscard]] bool emitCallWasmFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t funcExportOffset, uint32_t instanceOffset);\
[[nodiscard]] bool emitCallWasmFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t funcExportOffset = reader.stubOffset();\
  uint32_t instanceOffset = reader.stubOffset();\
  return emitCallWasmFunction(calleeId, argcId, flags, funcExportOffset, instanceOffset);\
}\
\
[[nodiscard]] bool emitCallNativeFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, bool ignoresReturnValue);\
[[nodiscard]] bool emitCallNativeFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  bool ignoresReturnValue = reader.readBool();\
  return emitCallNativeFunction(calleeId, argcId, flags, ignoresReturnValue);\
}\
\
[[nodiscard]] bool emitCallDOMFunction(ObjOperandId calleeId, Int32OperandId argcId, ObjOperandId thisObjId, CallFlags flags);\
[[nodiscard]] bool emitCallDOMFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  ObjOperandId thisObjId = reader.objOperandId();\
  CallFlags flags = reader.callFlags();\
  return emitCallDOMFunction(calleeId, argcId, thisObjId, flags);\
}\
\
[[nodiscard]] bool emitCallClassHook(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t targetOffset);\
[[nodiscard]] bool emitCallClassHook(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t targetOffset = reader.stubOffset();\
  return emitCallClassHook(calleeId, argcId, flags, targetOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedFunction(ObjOperandId calleeId, Int32OperandId argcId, uint32_t icScriptOffset, CallFlags flags);\
[[nodiscard]] bool emitCallInlinedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  CallFlags flags = reader.callFlags();\
  return emitCallInlinedFunction(calleeId, argcId, icScriptOffset, flags);\
}\
\
[[nodiscard]] bool emitLoadFixedSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadFixedSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadFixedSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadFixedSlotTypedResult(ObjOperandId objId, uint32_t offsetOffset, ValueType type);\
[[nodiscard]] bool emitLoadFixedSlotTypedResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValueType type = reader.valueType();\
  return emitLoadFixedSlotTypedResult(objId, offsetOffset, type);\
}\
\
[[nodiscard]] bool emitLoadDynamicSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadDynamicSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadDynamicSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadStringCharResult(StringOperandId strId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadStringCharResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadStringCharResult(strId, indexId);\
}\
\
[[nodiscard]] bool emitFrameIsConstructingResult();\
[[nodiscard]] bool emitFrameIsConstructingResult(CacheIRReader& reader) {\
  return emitFrameIsConstructingResult();\
}\
\
[[nodiscard]] bool emitLoadEnvironmentFixedSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadEnvironmentFixedSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadEnvironmentFixedSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadEnvironmentDynamicSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadEnvironmentDynamicSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadEnvironmentDynamicSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitCallScriptedGetterResult(ValOperandId receiverId, uint32_t getterOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallScriptedGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  uint32_t getterOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallScriptedGetterResult(receiverId, getterOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedGetterResult(ValOperandId receiverId, uint32_t getterOffset, uint32_t icScriptOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallInlinedGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  uint32_t getterOffset = reader.stubOffset();\
  uint32_t icScriptOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallInlinedGetterResult(receiverId, getterOffset, icScriptOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallNativeGetterResult(ValOperandId receiverId, uint32_t getterOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallNativeGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  uint32_t getterOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallNativeGetterResult(receiverId, getterOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallDOMGetterResult(ObjOperandId objId, uint32_t jitInfoOffset);\
[[nodiscard]] bool emitCallDOMGetterResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t jitInfoOffset = reader.stubOffset();\
  return emitCallDOMGetterResult(objId, jitInfoOffset);\
}\
\
[[nodiscard]] bool emitProxyGetResult(ObjOperandId objId, uint32_t idOffset);\
[[nodiscard]] bool emitProxyGetResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  return emitProxyGetResult(objId, idOffset);\
}\
\
[[nodiscard]] bool emitLoadConstantStringResult(uint32_t strOffset);\
[[nodiscard]] bool emitLoadConstantStringResult(CacheIRReader& reader) {\
  uint32_t strOffset = reader.stubOffset();\
  return emitLoadConstantStringResult(strOffset);\
}\
\
[[nodiscard]] bool emitLoadValueResult(uint32_t valOffset);\
[[nodiscard]] bool emitLoadValueResult(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  return emitLoadValueResult(valOffset);\
}\
\
[[nodiscard]] bool emitNewPlainObjectResult(uint32_t numFixedSlots, uint32_t numDynamicSlots, gc::AllocKind allocKind, uint32_t shapeOffset, uint32_t siteOffset);\
[[nodiscard]] bool emitNewPlainObjectResult(CacheIRReader& reader) {\
  uint32_t numFixedSlots = reader.uint32Immediate();\
  uint32_t numDynamicSlots = reader.uint32Immediate();\
  gc::AllocKind allocKind = reader.allocKind();\
  uint32_t shapeOffset = reader.stubOffset();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewPlainObjectResult(numFixedSlots, numDynamicSlots, allocKind, shapeOffset, siteOffset);\
}\
\
[[nodiscard]] bool emitNewArrayObjectResult(uint32_t arrayLength, uint32_t shapeOffset, uint32_t siteOffset);\
[[nodiscard]] bool emitNewArrayObjectResult(CacheIRReader& reader) {\
  uint32_t arrayLength = reader.uint32Immediate();\
  uint32_t shapeOffset = reader.stubOffset();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewArrayObjectResult(arrayLength, shapeOffset, siteOffset);\
}\
\
[[nodiscard]] bool emitCallStringObjectConcatResult(ValOperandId lhsId, ValOperandId rhsId);\
[[nodiscard]] bool emitCallStringObjectConcatResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallStringObjectConcatResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareStringResult(JSOp op, StringOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCompareStringResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  StringOperandId lhsId = reader.stringOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCompareStringResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitSameValueResult(ValOperandId lhsId, ValOperandId rhsId);\
[[nodiscard]] bool emitSameValueResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitSameValueResult(lhsId, rhsId);\
}\


#define CACHE_IR_TRANSPILER_GENERATED \
[[nodiscard]] bool emitReturnFromIC();\
[[nodiscard]] bool emitReturnFromIC(CacheIRReader& reader) {\
  return emitReturnFromIC();\
}\
\
[[nodiscard]] bool emitGuardToObject(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToObject(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToObject(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNullOrUndefined(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNullOrUndefined(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNullOrUndefined(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNull(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNull(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNull(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsUndefined(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsUndefined(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsUndefined(inputId);\
}\
\
[[nodiscard]] bool emitGuardToBoolean(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToBoolean(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToBoolean(inputId);\
}\
\
[[nodiscard]] bool emitGuardToString(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToString(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToString(inputId);\
}\
\
[[nodiscard]] bool emitGuardToSymbol(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToSymbol(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToSymbol(inputId);\
}\
\
[[nodiscard]] bool emitGuardToBigInt(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToBigInt(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToBigInt(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNumber(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNumber(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNumber(inputId);\
}\
\
[[nodiscard]] bool emitGuardToInt32(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToInt32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToInt32(inputId);\
}\
\
[[nodiscard]] bool emitGuardBooleanToInt32(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardBooleanToInt32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardBooleanToInt32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardToInt32Index(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToInt32Index(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToInt32Index(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32ToIntPtr(Int32OperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitInt32ToIntPtr(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitInt32ToIntPtr(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardNumberToIntPtrIndex(NumberOperandId inputId, bool supportOOB, IntPtrOperandId resultId);\
[[nodiscard]] bool emitGuardNumberToIntPtrIndex(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  bool supportOOB = reader.readBool();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitGuardNumberToIntPtrIndex(inputId, supportOOB, resultId);\
}\
\
[[nodiscard]] bool emitGuardToInt32ModUint32(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToInt32ModUint32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToInt32ModUint32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardToUint8Clamped(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToUint8Clamped(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToUint8Clamped(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardNonDoubleType(ValOperandId inputId, ValueType type);\
[[nodiscard]] bool emitGuardNonDoubleType(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  ValueType type = reader.valueType();\
  return emitGuardNonDoubleType(inputId, type);\
}\
\
[[nodiscard]] bool emitGuardShape(ObjOperandId objId, uint32_t shapeOffset);\
[[nodiscard]] bool emitGuardShape(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitGuardShape(objId, shapeOffset);\
}\
\
[[nodiscard]] bool emitGuardProto(ObjOperandId objId, uint32_t protoOffset);\
[[nodiscard]] bool emitGuardProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t protoOffset = reader.stubOffset();\
  return emitGuardProto(objId, protoOffset);\
}\
\
[[nodiscard]] bool emitGuardNullProto(ObjOperandId objId);\
[[nodiscard]] bool emitGuardNullProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardNullProto(objId);\
}\
\
[[nodiscard]] bool emitGuardClass(ObjOperandId objId, GuardClassKind kind);\
[[nodiscard]] bool emitGuardClass(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  GuardClassKind kind = reader.guardClassKind();\
  return emitGuardClass(objId, kind);\
}\
\
[[nodiscard]] bool emitGuardAnyClass(ObjOperandId objId, uint32_t claspOffset);\
[[nodiscard]] bool emitGuardAnyClass(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t claspOffset = reader.stubOffset();\
  return emitGuardAnyClass(objId, claspOffset);\
}\
\
[[nodiscard]] bool emitHasClassResult(ObjOperandId objId, uint32_t claspOffset);\
[[nodiscard]] bool emitHasClassResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t claspOffset = reader.stubOffset();\
  return emitHasClassResult(objId, claspOffset);\
}\
\
[[nodiscard]] bool emitCallRegExpMatcherResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId);\
[[nodiscard]] bool emitCallRegExpMatcherResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  return emitCallRegExpMatcherResult(regexpId, inputId, lastIndexId);\
}\
\
[[nodiscard]] bool emitCallRegExpSearcherResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId);\
[[nodiscard]] bool emitCallRegExpSearcherResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  return emitCallRegExpSearcherResult(regexpId, inputId, lastIndexId);\
}\
\
[[nodiscard]] bool emitCallRegExpTesterResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId);\
[[nodiscard]] bool emitCallRegExpTesterResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  return emitCallRegExpTesterResult(regexpId, inputId, lastIndexId);\
}\
\
[[nodiscard]] bool emitRegExpFlagResult(ObjOperandId regexpId, int32_t flagsMask);\
[[nodiscard]] bool emitRegExpFlagResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  int32_t flagsMask = reader.int32Immediate();\
  return emitRegExpFlagResult(regexpId, flagsMask);\
}\
\
[[nodiscard]] bool emitCallSubstringKernelResult(StringOperandId strId, Int32OperandId beginId, Int32OperandId lengthId);\
[[nodiscard]] bool emitCallSubstringKernelResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitCallSubstringKernelResult(strId, beginId, lengthId);\
}\
\
[[nodiscard]] bool emitStringReplaceStringResult(StringOperandId strId, StringOperandId patternId, StringOperandId replacementId);\
[[nodiscard]] bool emitStringReplaceStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId patternId = reader.stringOperandId();\
  StringOperandId replacementId = reader.stringOperandId();\
  return emitStringReplaceStringResult(strId, patternId, replacementId);\
}\
\
[[nodiscard]] bool emitStringSplitStringResult(StringOperandId strId, StringOperandId separatorId);\
[[nodiscard]] bool emitStringSplitStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId separatorId = reader.stringOperandId();\
  return emitStringSplitStringResult(strId, separatorId);\
}\
\
[[nodiscard]] bool emitRegExpPrototypeOptimizableResult(ObjOperandId protoId);\
[[nodiscard]] bool emitRegExpPrototypeOptimizableResult(CacheIRReader& reader) {\
  ObjOperandId protoId = reader.objOperandId();\
  return emitRegExpPrototypeOptimizableResult(protoId);\
}\
\
[[nodiscard]] bool emitRegExpInstanceOptimizableResult(ObjOperandId regexpId, ObjOperandId protoId);\
[[nodiscard]] bool emitRegExpInstanceOptimizableResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  ObjOperandId protoId = reader.objOperandId();\
  return emitRegExpInstanceOptimizableResult(regexpId, protoId);\
}\
\
[[nodiscard]] bool emitGetFirstDollarIndexResult(StringOperandId strId);\
[[nodiscard]] bool emitGetFirstDollarIndexResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitGetFirstDollarIndexResult(strId);\
}\
\
[[nodiscard]] bool emitGuardIsExtensible(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsExtensible(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsExtensible(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNativeObject(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNativeObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNativeObject(objId);\
}\
\
[[nodiscard]] bool emitGuardIsProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotArrayBufferMaybeShared(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotArrayBufferMaybeShared(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotArrayBufferMaybeShared(objId);\
}\
\
[[nodiscard]] bool emitGuardIsTypedArray(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsTypedArray(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsTypedArray(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotDOMProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotDOMProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotDOMProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardSpecificObject(ObjOperandId objId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificObject(objId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificFunction(ObjOperandId funId, uint32_t expectedOffset, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitGuardSpecificFunction(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitGuardSpecificFunction(funId, expectedOffset, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitGuardFunctionScript(ObjOperandId objId, uint32_t expectedOffset, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitGuardFunctionScript(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitGuardFunctionScript(objId, expectedOffset, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificAtom(StringOperandId strId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificAtom(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificAtom(strId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificSymbol(SymbolOperandId symId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificSymbol(CacheIRReader& reader) {\
  SymbolOperandId symId = reader.symbolOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificSymbol(symId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardNoDenseElements(ObjOperandId objId);\
[[nodiscard]] bool emitGuardNoDenseElements(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardNoDenseElements(objId);\
}\
\
[[nodiscard]] bool emitGuardStringToIndex(StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardStringToIndex(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardStringToIndex(strId, resultId);\
}\
\
[[nodiscard]] bool emitGuardStringToInt32(StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardStringToInt32(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardStringToInt32(strId, resultId);\
}\
\
[[nodiscard]] bool emitGuardStringToNumber(StringOperandId strId, NumberOperandId resultId);\
[[nodiscard]] bool emitGuardStringToNumber(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitGuardStringToNumber(strId, resultId);\
}\
\
[[nodiscard]] bool emitBooleanToNumber(BooleanOperandId booleanId, NumberOperandId resultId);\
[[nodiscard]] bool emitBooleanToNumber(CacheIRReader& reader) {\
  BooleanOperandId booleanId = reader.booleanOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitBooleanToNumber(booleanId, resultId);\
}\
\
[[nodiscard]] bool emitGuardHasGetterSetter(ObjOperandId objId, uint32_t idOffset, uint32_t getterSetterOffset);\
[[nodiscard]] bool emitGuardHasGetterSetter(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  uint32_t getterSetterOffset = reader.stubOffset();\
  return emitGuardHasGetterSetter(objId, idOffset, getterSetterOffset);\
}\
\
[[nodiscard]] bool emitGuardInt32IsNonNegative(Int32OperandId indexId);\
[[nodiscard]] bool emitGuardInt32IsNonNegative(CacheIRReader& reader) {\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardInt32IsNonNegative(indexId);\
}\
\
[[nodiscard]] bool emitGuardIndexIsValidUpdateOrAdd(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitGuardIndexIsValidUpdateOrAdd(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardIndexIsValidUpdateOrAdd(objId, indexId);\
}\
\
[[nodiscard]] bool emitGuardIndexGreaterThanDenseInitLength(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitGuardIndexGreaterThanDenseInitLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardIndexGreaterThanDenseInitLength(objId, indexId);\
}\
\
[[nodiscard]] bool emitGuardTagNotEqual(ValueTagOperandId lhsId, ValueTagOperandId rhsId);\
[[nodiscard]] bool emitGuardTagNotEqual(CacheIRReader& reader) {\
  ValueTagOperandId lhsId = reader.valueTagOperandId();\
  ValueTagOperandId rhsId = reader.valueTagOperandId();\
  return emitGuardTagNotEqual(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotIsSpecificObject(ObjOperandId objId, ObjOperandId expectedId, uint32_t slotOffset);\
[[nodiscard]] bool emitGuardDynamicSlotIsSpecificObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId expectedId = reader.objOperandId();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitGuardDynamicSlotIsSpecificObject(objId, expectedId, slotOffset);\
}\
\
[[nodiscard]] bool emitGuardFixedSlotValue(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitGuardFixedSlotValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitGuardFixedSlotValue(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotValue(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitGuardDynamicSlotValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitGuardDynamicSlotValue(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitGuardNoAllocationMetadataBuilder(uint32_t builderAddrOffset);\
[[nodiscard]] bool emitGuardNoAllocationMetadataBuilder(CacheIRReader& reader) {\
  uint32_t builderAddrOffset = reader.stubOffset();\
  return emitGuardNoAllocationMetadataBuilder(builderAddrOffset);\
}\
\
[[nodiscard]] bool emitGuardFunctionHasJitEntry(ObjOperandId funId, bool constructing);\
[[nodiscard]] bool emitGuardFunctionHasJitEntry(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  bool constructing = reader.readBool();\
  return emitGuardFunctionHasJitEntry(funId, constructing);\
}\
\
[[nodiscard]] bool emitGuardFunctionHasNoJitEntry(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionHasNoJitEntry(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionHasNoJitEntry(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionIsNonBuiltinCtor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionIsNonBuiltinCtor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionIsNonBuiltinCtor(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionIsConstructor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionIsConstructor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionIsConstructor(funId);\
}\
\
[[nodiscard]] bool emitGuardNotClassConstructor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardNotClassConstructor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardNotClassConstructor(funId);\
}\
\
[[nodiscard]] bool emitGuardArrayIsPacked(ObjOperandId arrayId);\
[[nodiscard]] bool emitGuardArrayIsPacked(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitGuardArrayIsPacked(arrayId);\
}\
\
[[nodiscard]] bool emitGuardArgumentsObjectFlags(ObjOperandId objId, uint8_t flags);\
[[nodiscard]] bool emitGuardArgumentsObjectFlags(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint8_t flags = reader.readByte();\
  return emitGuardArgumentsObjectFlags(objId, flags);\
}\
\
[[nodiscard]] bool emitLoadObject(ObjOperandId resultId, uint32_t objOffset);\
[[nodiscard]] bool emitLoadObject(CacheIRReader& reader) {\
  ObjOperandId resultId = reader.objOperandId();\
  uint32_t objOffset = reader.stubOffset();\
  return emitLoadObject(resultId, objOffset);\
}\
\
[[nodiscard]] bool emitLoadProto(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadProto(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadEnclosingEnvironment(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadEnclosingEnvironment(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadEnclosingEnvironment(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadWrapperTarget(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadWrapperTarget(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadWrapperTarget(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadValueTag(ValOperandId valId, ValueTagOperandId resultId);\
[[nodiscard]] bool emitLoadValueTag(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  ValueTagOperandId resultId = reader.valueTagOperandId();\
  return emitLoadValueTag(valId, resultId);\
}\
\
[[nodiscard]] bool emitLoadArgumentFixedSlot(ValOperandId resultId, uint8_t slotIndex);\
[[nodiscard]] bool emitLoadArgumentFixedSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  uint8_t slotIndex = reader.readByte();\
  return emitLoadArgumentFixedSlot(resultId, slotIndex);\
}\
\
[[nodiscard]] bool emitLoadArgumentDynamicSlot(ValOperandId resultId, Int32OperandId argcId, uint8_t slotIndex);\
[[nodiscard]] bool emitLoadArgumentDynamicSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  uint8_t slotIndex = reader.readByte();\
  return emitLoadArgumentDynamicSlot(resultId, argcId, slotIndex);\
}\
\
[[nodiscard]] bool emitTruncateDoubleToUInt32(NumberOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitTruncateDoubleToUInt32(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitTruncateDoubleToUInt32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotResult(ObjOperandId objId, uint32_t nameOffset);\
[[nodiscard]] bool emitMegamorphicLoadSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  return emitMegamorphicLoadSlotResult(objId, nameOffset);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotByValueResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitMegamorphicLoadSlotByValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitMegamorphicLoadSlotByValueResult(objId, idId);\
}\
\
[[nodiscard]] bool emitMegamorphicStoreSlot(ObjOperandId objId, uint32_t nameOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitMegamorphicStoreSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitMegamorphicStoreSlot(objId, nameOffset, rhsId);\
}\
\
[[nodiscard]] bool emitMegamorphicSetElement(ObjOperandId objId, ValOperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitMegamorphicSetElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitMegamorphicSetElement(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitMegamorphicHasPropResult(ObjOperandId objId, ValOperandId idId, bool hasOwn);\
[[nodiscard]] bool emitMegamorphicHasPropResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  bool hasOwn = reader.readBool();\
  return emitMegamorphicHasPropResult(objId, idId, hasOwn);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValue(ObjOperandId objId, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValue(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValueGuardGeneration(ObjOperandId objId, uint32_t expandoAndGenerationOffset, uint32_t generationOffset, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValueGuardGeneration(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expandoAndGenerationOffset = reader.stubOffset();\
  uint32_t generationOffset = reader.stubOffset();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValueGuardGeneration(objId, expandoAndGenerationOffset, generationOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValueIgnoreGeneration(ObjOperandId objId, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValueIgnoreGeneration(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValueIgnoreGeneration(objId, resultId);\
}\
\
[[nodiscard]] bool emitGuardDOMExpandoMissingOrGuardShape(ValOperandId expandoId, uint32_t shapeOffset);\
[[nodiscard]] bool emitGuardDOMExpandoMissingOrGuardShape(CacheIRReader& reader) {\
  ValOperandId expandoId = reader.valOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitGuardDOMExpandoMissingOrGuardShape(expandoId, shapeOffset);\
}\
\
[[nodiscard]] bool emitStoreFixedSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreFixedSlot(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreDynamicSlot(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitAddAndStoreFixedSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset);\
[[nodiscard]] bool emitAddAndStoreFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  return emitAddAndStoreFixedSlot(objId, offsetOffset, rhsId, newShapeOffset);\
}\
\
[[nodiscard]] bool emitAddAndStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset);\
[[nodiscard]] bool emitAddAndStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  return emitAddAndStoreDynamicSlot(objId, offsetOffset, rhsId, newShapeOffset);\
}\
\
[[nodiscard]] bool emitAllocateAndStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset, uint32_t numNewSlotsOffset);\
[[nodiscard]] bool emitAllocateAndStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  uint32_t numNewSlotsOffset = reader.stubOffset();\
  return emitAllocateAndStoreDynamicSlot(objId, offsetOffset, rhsId, newShapeOffset, numNewSlotsOffset);\
}\
\
[[nodiscard]] bool emitStoreDenseElement(ObjOperandId objId, Int32OperandId indexId, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreDenseElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreDenseElement(objId, indexId, rhsId);\
}\
\
[[nodiscard]] bool emitStoreDenseElementHole(ObjOperandId objId, Int32OperandId indexId, ValOperandId rhsId, bool handleAdd);\
[[nodiscard]] bool emitStoreDenseElementHole(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool handleAdd = reader.readBool();\
  return emitStoreDenseElementHole(objId, indexId, rhsId, handleAdd);\
}\
\
[[nodiscard]] bool emitArrayPush(ObjOperandId objId, ValOperandId rhsId);\
[[nodiscard]] bool emitArrayPush(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitArrayPush(objId, rhsId);\
}\
\
[[nodiscard]] bool emitArrayJoinResult(ObjOperandId objId, StringOperandId sepId);\
[[nodiscard]] bool emitArrayJoinResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  StringOperandId sepId = reader.stringOperandId();\
  return emitArrayJoinResult(objId, sepId);\
}\
\
[[nodiscard]] bool emitPackedArrayPopResult(ObjOperandId arrayId);\
[[nodiscard]] bool emitPackedArrayPopResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitPackedArrayPopResult(arrayId);\
}\
\
[[nodiscard]] bool emitPackedArrayShiftResult(ObjOperandId arrayId);\
[[nodiscard]] bool emitPackedArrayShiftResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitPackedArrayShiftResult(arrayId);\
}\
\
[[nodiscard]] bool emitPackedArraySliceResult(uint32_t templateObjectOffset, ObjOperandId arrayId, Int32OperandId beginId, Int32OperandId endId);\
[[nodiscard]] bool emitPackedArraySliceResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId arrayId = reader.objOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId endId = reader.int32OperandId();\
  return emitPackedArraySliceResult(templateObjectOffset, arrayId, beginId, endId);\
}\
\
[[nodiscard]] bool emitIsArrayResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsArrayResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsArrayResult(inputId);\
}\
\
[[nodiscard]] bool emitStoreFixedSlotUndefinedResult(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreFixedSlotUndefinedResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreFixedSlotUndefinedResult(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitIsObjectResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsObjectResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsObjectResult(inputId);\
}\
\
[[nodiscard]] bool emitIsPackedArrayResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsPackedArrayResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsPackedArrayResult(objId);\
}\
\
[[nodiscard]] bool emitIsCallableResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsCallableResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsCallableResult(inputId);\
}\
\
[[nodiscard]] bool emitIsConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitIsCrossRealmArrayConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsCrossRealmArrayConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsCrossRealmArrayConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitIsTypedArrayResult(ObjOperandId objId, bool isPossiblyWrapped);\
[[nodiscard]] bool emitIsTypedArrayResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  bool isPossiblyWrapped = reader.readBool();\
  return emitIsTypedArrayResult(objId, isPossiblyWrapped);\
}\
\
[[nodiscard]] bool emitIsTypedArrayConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsTypedArrayConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsTypedArrayConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitArrayBufferViewByteOffsetInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitArrayBufferViewByteOffsetInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitArrayBufferViewByteOffsetInt32Result(objId);\
}\
\
[[nodiscard]] bool emitArrayBufferViewByteOffsetDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitArrayBufferViewByteOffsetDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitArrayBufferViewByteOffsetDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayElementSizeResult(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayElementSizeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayElementSizeResult(objId);\
}\
\
[[nodiscard]] bool emitGuardHasAttachedArrayBuffer(ObjOperandId objId);\
[[nodiscard]] bool emitGuardHasAttachedArrayBuffer(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardHasAttachedArrayBuffer(objId);\
}\
\
[[nodiscard]] bool emitFinishBoundFunctionInitResult(ObjOperandId boundId, ObjOperandId targetId, Int32OperandId argCountId);\
[[nodiscard]] bool emitFinishBoundFunctionInitResult(CacheIRReader& reader) {\
  ObjOperandId boundId = reader.objOperandId();\
  ObjOperandId targetId = reader.objOperandId();\
  Int32OperandId argCountId = reader.int32OperandId();\
  return emitFinishBoundFunctionInitResult(boundId, targetId, argCountId);\
}\
\
[[nodiscard]] bool emitNewArrayIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewArrayIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewArrayIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewStringIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewStringIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewStringIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewRegExpStringIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewRegExpStringIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewRegExpStringIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitObjectCreateResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitObjectCreateResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitObjectCreateResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewArrayFromLengthResult(uint32_t templateObjectOffset, Int32OperandId lengthId);\
[[nodiscard]] bool emitNewArrayFromLengthResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitNewArrayFromLengthResult(templateObjectOffset, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromLengthResult(uint32_t templateObjectOffset, Int32OperandId lengthId);\
[[nodiscard]] bool emitNewTypedArrayFromLengthResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitNewTypedArrayFromLengthResult(templateObjectOffset, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromArrayBufferResult(uint32_t templateObjectOffset, ObjOperandId bufferId, ValOperandId byteOffsetId, ValOperandId lengthId);\
[[nodiscard]] bool emitNewTypedArrayFromArrayBufferResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId bufferId = reader.objOperandId();\
  ValOperandId byteOffsetId = reader.valOperandId();\
  ValOperandId lengthId = reader.valOperandId();\
  return emitNewTypedArrayFromArrayBufferResult(templateObjectOffset, bufferId, byteOffsetId, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromArrayResult(uint32_t templateObjectOffset, ObjOperandId arrayId);\
[[nodiscard]] bool emitNewTypedArrayFromArrayResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitNewTypedArrayFromArrayResult(templateObjectOffset, arrayId);\
}\
\
[[nodiscard]] bool emitNewStringObjectResult(uint32_t templateObjectOffset, StringOperandId strId);\
[[nodiscard]] bool emitNewStringObjectResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  StringOperandId strId = reader.stringOperandId();\
  return emitNewStringObjectResult(templateObjectOffset, strId);\
}\
\
[[nodiscard]] bool emitStringFromCharCodeResult(Int32OperandId codeId);\
[[nodiscard]] bool emitStringFromCharCodeResult(CacheIRReader& reader) {\
  Int32OperandId codeId = reader.int32OperandId();\
  return emitStringFromCharCodeResult(codeId);\
}\
\
[[nodiscard]] bool emitStringFromCodePointResult(Int32OperandId codeId);\
[[nodiscard]] bool emitStringFromCodePointResult(CacheIRReader& reader) {\
  Int32OperandId codeId = reader.int32OperandId();\
  return emitStringFromCodePointResult(codeId);\
}\
\
[[nodiscard]] bool emitStringToLowerCaseResult(StringOperandId strId);\
[[nodiscard]] bool emitStringToLowerCaseResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToLowerCaseResult(strId);\
}\
\
[[nodiscard]] bool emitStringToUpperCaseResult(StringOperandId strId);\
[[nodiscard]] bool emitStringToUpperCaseResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToUpperCaseResult(strId);\
}\
\
[[nodiscard]] bool emitMathAbsInt32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathAbsInt32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathAbsInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathAbsNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathAbsNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathAbsNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathClz32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathClz32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathClz32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathSignInt32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathSignInt32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathSignInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathSignNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSignNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSignNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathSignNumberToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSignNumberToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSignNumberToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathImulResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitMathImulResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitMathImulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitMathSqrtNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSqrtNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSqrtNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathFRoundNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFRoundNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFRoundNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathRandomResult(uint32_t rngOffset);\
[[nodiscard]] bool emitMathRandomResult(CacheIRReader& reader) {\
  uint32_t rngOffset = reader.stubOffset();\
  return emitMathRandomResult(rngOffset);\
}\
\
[[nodiscard]] bool emitMathHypot2NumberResult(NumberOperandId firstId, NumberOperandId secondId);\
[[nodiscard]] bool emitMathHypot2NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  return emitMathHypot2NumberResult(firstId, secondId);\
}\
\
[[nodiscard]] bool emitMathHypot3NumberResult(NumberOperandId firstId, NumberOperandId secondId, NumberOperandId thirdId);\
[[nodiscard]] bool emitMathHypot3NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId thirdId = reader.numberOperandId();\
  return emitMathHypot3NumberResult(firstId, secondId, thirdId);\
}\
\
[[nodiscard]] bool emitMathHypot4NumberResult(NumberOperandId firstId, NumberOperandId secondId, NumberOperandId thirdId, NumberOperandId fourthId);\
[[nodiscard]] bool emitMathHypot4NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId thirdId = reader.numberOperandId();\
  NumberOperandId fourthId = reader.numberOperandId();\
  return emitMathHypot4NumberResult(firstId, secondId, thirdId, fourthId);\
}\
\
[[nodiscard]] bool emitMathAtan2NumberResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitMathAtan2NumberResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitMathAtan2NumberResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitMathFloorNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFloorNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFloorNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathCeilNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathCeilNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathCeilNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathTruncNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathTruncNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathTruncNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathFloorToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFloorToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFloorToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathCeilToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathCeilToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathCeilToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathTruncToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathTruncToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathTruncToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathRoundToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathRoundToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathRoundToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitInt32MinMax(bool isMax, Int32OperandId firstId, Int32OperandId secondId, Int32OperandId resultId);\
[[nodiscard]] bool emitInt32MinMax(CacheIRReader& reader) {\
  bool isMax = reader.readBool();\
  Int32OperandId firstId = reader.int32OperandId();\
  Int32OperandId secondId = reader.int32OperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitInt32MinMax(isMax, firstId, secondId, resultId);\
}\
\
[[nodiscard]] bool emitNumberMinMax(bool isMax, NumberOperandId firstId, NumberOperandId secondId, NumberOperandId resultId);\
[[nodiscard]] bool emitNumberMinMax(CacheIRReader& reader) {\
  bool isMax = reader.readBool();\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitNumberMinMax(isMax, firstId, secondId, resultId);\
}\
\
[[nodiscard]] bool emitInt32MinMaxArrayResult(ObjOperandId arrayId, bool isMax);\
[[nodiscard]] bool emitInt32MinMaxArrayResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  bool isMax = reader.readBool();\
  return emitInt32MinMaxArrayResult(arrayId, isMax);\
}\
\
[[nodiscard]] bool emitNumberMinMaxArrayResult(ObjOperandId arrayId, bool isMax);\
[[nodiscard]] bool emitNumberMinMaxArrayResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  bool isMax = reader.readBool();\
  return emitNumberMinMaxArrayResult(arrayId, isMax);\
}\
\
[[nodiscard]] bool emitMathFunctionNumberResult(NumberOperandId inputId, UnaryMathFunction fun);\
[[nodiscard]] bool emitMathFunctionNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  UnaryMathFunction fun = reader.unaryMathFunction();\
  return emitMathFunctionNumberResult(inputId, fun);\
}\
\
[[nodiscard]] bool emitObjectToStringResult(ObjOperandId objId);\
[[nodiscard]] bool emitObjectToStringResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitObjectToStringResult(objId);\
}\
\
[[nodiscard]] bool emitReflectGetPrototypeOfResult(ObjOperandId objId);\
[[nodiscard]] bool emitReflectGetPrototypeOfResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitReflectGetPrototypeOfResult(objId);\
}\
\
[[nodiscard]] bool emitStoreTypedArrayElement(ObjOperandId objId, Scalar::Type elementType, IntPtrOperandId indexId, uint32_t rhsId, bool handleOOB);\
[[nodiscard]] bool emitStoreTypedArrayElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t rhsId = reader.rawOperandId();\
  bool handleOOB = reader.readBool();\
  return emitStoreTypedArrayElement(objId, elementType, indexId, rhsId, handleOOB);\
}\
\
[[nodiscard]] bool emitAtomicsCompareExchangeResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t expectedId, uint32_t replacementId, Scalar::Type elementType);\
[[nodiscard]] bool emitAtomicsCompareExchangeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t expectedId = reader.rawOperandId();\
  uint32_t replacementId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitAtomicsCompareExchangeResult(objId, indexId, expectedId, replacementId, elementType);\
}\
\
[[nodiscard]] bool emitAtomicsExchangeResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType);\
[[nodiscard]] bool emitAtomicsExchangeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitAtomicsExchangeResult(objId, indexId, valueId, elementType);\
}\
\
[[nodiscard]] bool emitAtomicsAddResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsAddResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsAddResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsSubResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsSubResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsSubResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsAndResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsAndResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsAndResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsOrResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsOrResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsOrResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsXorResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect);\
[[nodiscard]] bool emitAtomicsXorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  return emitAtomicsXorResult(objId, indexId, valueId, elementType, forEffect);\
}\
\
[[nodiscard]] bool emitAtomicsLoadResult(ObjOperandId objId, IntPtrOperandId indexId, Scalar::Type elementType);\
[[nodiscard]] bool emitAtomicsLoadResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitAtomicsLoadResult(objId, indexId, elementType);\
}\
\
[[nodiscard]] bool emitAtomicsStoreResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType);\
[[nodiscard]] bool emitAtomicsStoreResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitAtomicsStoreResult(objId, indexId, valueId, elementType);\
}\
\
[[nodiscard]] bool emitAtomicsIsLockFreeResult(Int32OperandId valueId);\
[[nodiscard]] bool emitAtomicsIsLockFreeResult(CacheIRReader& reader) {\
  Int32OperandId valueId = reader.int32OperandId();\
  return emitAtomicsIsLockFreeResult(valueId);\
}\
\
[[nodiscard]] bool emitCallNativeSetter(ObjOperandId receiverId, uint32_t setterOffset, ValOperandId rhsId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallNativeSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  uint32_t setterOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallNativeSetter(receiverId, setterOffset, rhsId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallScriptedSetter(ObjOperandId receiverId, uint32_t setterOffset, ValOperandId rhsId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallScriptedSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  uint32_t setterOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallScriptedSetter(receiverId, setterOffset, rhsId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedSetter(ObjOperandId receiverId, uint32_t setterOffset, ValOperandId rhsId, uint32_t icScriptOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallInlinedSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  uint32_t setterOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallInlinedSetter(receiverId, setterOffset, rhsId, icScriptOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallDOMSetter(ObjOperandId objId, uint32_t jitInfoOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitCallDOMSetter(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t jitInfoOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallDOMSetter(objId, jitInfoOffset, rhsId);\
}\
\
[[nodiscard]] bool emitCallSetArrayLength(ObjOperandId objId, bool strict, ValOperandId rhsId);\
[[nodiscard]] bool emitCallSetArrayLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  bool strict = reader.readBool();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallSetArrayLength(objId, strict, rhsId);\
}\
\
[[nodiscard]] bool emitProxySet(ObjOperandId objId, uint32_t idOffset, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitProxySet(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitProxySet(objId, idOffset, rhsId, strict);\
}\
\
[[nodiscard]] bool emitProxySetByValue(ObjOperandId objId, ValOperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitProxySetByValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitProxySetByValue(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitCallAddOrUpdateSparseElementHelper(ObjOperandId objId, Int32OperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitCallAddOrUpdateSparseElementHelper(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId idId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitCallAddOrUpdateSparseElementHelper(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitCallInt32ToString(Int32OperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitCallInt32ToString(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitCallInt32ToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitCallNumberToString(NumberOperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitCallNumberToString(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitCallNumberToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitBooleanToString(BooleanOperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitBooleanToString(CacheIRReader& reader) {\
  BooleanOperandId inputId = reader.booleanOperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitBooleanToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitCallScriptedFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags);\
[[nodiscard]] bool emitCallScriptedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  return emitCallScriptedFunction(calleeId, argcId, flags);\
}\
\
[[nodiscard]] bool emitCallWasmFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t funcExportOffset, uint32_t instanceOffset);\
[[nodiscard]] bool emitCallWasmFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t funcExportOffset = reader.stubOffset();\
  uint32_t instanceOffset = reader.stubOffset();\
  return emitCallWasmFunction(calleeId, argcId, flags, funcExportOffset, instanceOffset);\
}\
\
[[nodiscard]] bool emitGuardWasmArg(ValOperandId argId, wasm::ValType::Kind type);\
[[nodiscard]] bool emitGuardWasmArg(CacheIRReader& reader) {\
  ValOperandId argId = reader.valOperandId();\
  wasm::ValType::Kind type = reader.wasmValType();\
  return emitGuardWasmArg(argId, type);\
}\
\
[[nodiscard]] bool emitCallNativeFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, bool ignoresReturnValue);\
[[nodiscard]] bool emitCallNativeFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  bool ignoresReturnValue = reader.readBool();\
  return emitCallNativeFunction(calleeId, argcId, flags, ignoresReturnValue);\
}\
\
[[nodiscard]] bool emitCallDOMFunction(ObjOperandId calleeId, Int32OperandId argcId, ObjOperandId thisObjId, CallFlags flags);\
[[nodiscard]] bool emitCallDOMFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  ObjOperandId thisObjId = reader.objOperandId();\
  CallFlags flags = reader.callFlags();\
  return emitCallDOMFunction(calleeId, argcId, thisObjId, flags);\
}\
\
[[nodiscard]] bool emitCallInlinedFunction(ObjOperandId calleeId, Int32OperandId argcId, uint32_t icScriptOffset, CallFlags flags);\
[[nodiscard]] bool emitCallInlinedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  CallFlags flags = reader.callFlags();\
  return emitCallInlinedFunction(calleeId, argcId, icScriptOffset, flags);\
}\
\
[[nodiscard]] bool emitMetaTwoByte(uint32_t functionObjectOffset, uint32_t templateObjectOffset);\
[[nodiscard]] bool emitMetaTwoByte(CacheIRReader& reader) {\
  uint32_t functionObjectOffset = reader.stubOffset();\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitMetaTwoByte(functionObjectOffset, templateObjectOffset);\
}\
\
[[nodiscard]] bool emitLoadFixedSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadFixedSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadFixedSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadFixedSlotTypedResult(ObjOperandId objId, uint32_t offsetOffset, ValueType type);\
[[nodiscard]] bool emitLoadFixedSlotTypedResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValueType type = reader.valueType();\
  return emitLoadFixedSlotTypedResult(objId, offsetOffset, type);\
}\
\
[[nodiscard]] bool emitLoadDynamicSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadDynamicSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadDynamicSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadDenseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadDenseElementHoleResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementHoleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementHoleResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallGetSparseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallGetSparseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallGetSparseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadDenseElementExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadTypedArrayElementExistsResult(ObjOperandId objId, IntPtrOperandId indexId);\
[[nodiscard]] bool emitLoadTypedArrayElementExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  return emitLoadTypedArrayElementExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadDenseElementHoleExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementHoleExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementHoleExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadTypedArrayElementResult(ObjOperandId objId, IntPtrOperandId indexId, Scalar::Type elementType, bool handleOOB, bool forceDoubleForUint32);\
[[nodiscard]] bool emitLoadTypedArrayElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool handleOOB = reader.readBool();\
  bool forceDoubleForUint32 = reader.readBool();\
  return emitLoadTypedArrayElementResult(objId, indexId, elementType, handleOOB, forceDoubleForUint32);\
}\
\
[[nodiscard]] bool emitLoadDataViewValueResult(ObjOperandId objId, IntPtrOperandId offsetId, BooleanOperandId littleEndianId, Scalar::Type elementType, bool forceDoubleForUint32);\
[[nodiscard]] bool emitLoadDataViewValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forceDoubleForUint32 = reader.readBool();\
  return emitLoadDataViewValueResult(objId, offsetId, littleEndianId, elementType, forceDoubleForUint32);\
}\
\
[[nodiscard]] bool emitStoreDataViewValueResult(ObjOperandId objId, IntPtrOperandId offsetId, uint32_t valueId, BooleanOperandId littleEndianId, Scalar::Type elementType);\
[[nodiscard]] bool emitStoreDataViewValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitStoreDataViewValueResult(objId, offsetId, valueId, littleEndianId, elementType);\
}\
\
[[nodiscard]] bool emitLoadInt32ArrayLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadInt32ArrayLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadInt32ArrayLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadInt32ArrayLength(ObjOperandId objId, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadInt32ArrayLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadInt32ArrayLength(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectArgResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadArgumentsObjectArgResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadArgumentsObjectArgResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArgumentsObjectLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArgumentsObjectLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadFunctionLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadFunctionLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadFunctionLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadFunctionNameResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadFunctionNameResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadFunctionNameResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferViewLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferViewLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferViewLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferViewLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitLoadStringCharResult(StringOperandId strId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadStringCharResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadStringCharResult(strId, indexId);\
}\
\
[[nodiscard]] bool emitLoadStringCharCodeResult(StringOperandId strId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadStringCharCodeResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadStringCharCodeResult(strId, indexId);\
}\
\
[[nodiscard]] bool emitLoadStringLengthResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringLengthResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringLengthResult(strId);\
}\
\
[[nodiscard]] bool emitFrameIsConstructingResult();\
[[nodiscard]] bool emitFrameIsConstructingResult(CacheIRReader& reader) {\
  return emitFrameIsConstructingResult();\
}\
\
[[nodiscard]] bool emitLoadEnvironmentFixedSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadEnvironmentFixedSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadEnvironmentFixedSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadEnvironmentDynamicSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadEnvironmentDynamicSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadEnvironmentDynamicSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadObjectResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadObjectResult(objId);\
}\
\
[[nodiscard]] bool emitLoadStringResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringResult(strId);\
}\
\
[[nodiscard]] bool emitLoadSymbolResult(SymbolOperandId symId);\
[[nodiscard]] bool emitLoadSymbolResult(CacheIRReader& reader) {\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitLoadSymbolResult(symId);\
}\
\
[[nodiscard]] bool emitLoadInt32Result(Int32OperandId valId);\
[[nodiscard]] bool emitLoadInt32Result(CacheIRReader& reader) {\
  Int32OperandId valId = reader.int32OperandId();\
  return emitLoadInt32Result(valId);\
}\
\
[[nodiscard]] bool emitLoadDoubleResult(NumberOperandId valId);\
[[nodiscard]] bool emitLoadDoubleResult(CacheIRReader& reader) {\
  NumberOperandId valId = reader.numberOperandId();\
  return emitLoadDoubleResult(valId);\
}\
\
[[nodiscard]] bool emitLoadBigIntResult(BigIntOperandId valId);\
[[nodiscard]] bool emitLoadBigIntResult(CacheIRReader& reader) {\
  BigIntOperandId valId = reader.bigIntOperandId();\
  return emitLoadBigIntResult(valId);\
}\
\
[[nodiscard]] bool emitCallScriptedGetterResult(ValOperandId receiverId, uint32_t getterOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallScriptedGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  uint32_t getterOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallScriptedGetterResult(receiverId, getterOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedGetterResult(ValOperandId receiverId, uint32_t getterOffset, uint32_t icScriptOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallInlinedGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  uint32_t getterOffset = reader.stubOffset();\
  uint32_t icScriptOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallInlinedGetterResult(receiverId, getterOffset, icScriptOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallNativeGetterResult(ValOperandId receiverId, uint32_t getterOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallNativeGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  uint32_t getterOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallNativeGetterResult(receiverId, getterOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallDOMGetterResult(ObjOperandId objId, uint32_t jitInfoOffset);\
[[nodiscard]] bool emitCallDOMGetterResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t jitInfoOffset = reader.stubOffset();\
  return emitCallDOMGetterResult(objId, jitInfoOffset);\
}\
\
[[nodiscard]] bool emitProxyGetResult(ObjOperandId objId, uint32_t idOffset);\
[[nodiscard]] bool emitProxyGetResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  return emitProxyGetResult(objId, idOffset);\
}\
\
[[nodiscard]] bool emitProxyGetByValueResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitProxyGetByValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitProxyGetByValueResult(objId, idId);\
}\
\
[[nodiscard]] bool emitProxyHasPropResult(ObjOperandId objId, ValOperandId idId, bool hasOwn);\
[[nodiscard]] bool emitProxyHasPropResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  bool hasOwn = reader.readBool();\
  return emitProxyHasPropResult(objId, idId, hasOwn);\
}\
\
[[nodiscard]] bool emitCallObjectHasSparseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallObjectHasSparseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallObjectHasSparseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallNativeGetElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallNativeGetElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallNativeGetElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitGetNextMapSetEntryForIteratorResult(ObjOperandId iterId, ObjOperandId resultArrId, bool isMap);\
[[nodiscard]] bool emitGetNextMapSetEntryForIteratorResult(CacheIRReader& reader) {\
  ObjOperandId iterId = reader.objOperandId();\
  ObjOperandId resultArrId = reader.objOperandId();\
  bool isMap = reader.readBool();\
  return emitGetNextMapSetEntryForIteratorResult(iterId, resultArrId, isMap);\
}\
\
[[nodiscard]] bool emitLoadUndefinedResult();\
[[nodiscard]] bool emitLoadUndefinedResult(CacheIRReader& reader) {\
  return emitLoadUndefinedResult();\
}\
\
[[nodiscard]] bool emitLoadBooleanResult(bool val);\
[[nodiscard]] bool emitLoadBooleanResult(CacheIRReader& reader) {\
  bool val = reader.readBool();\
  return emitLoadBooleanResult(val);\
}\
\
[[nodiscard]] bool emitLoadInt32Constant(uint32_t valOffset, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadInt32Constant(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadInt32Constant(valOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadBooleanConstant(bool val, BooleanOperandId resultId);\
[[nodiscard]] bool emitLoadBooleanConstant(CacheIRReader& reader) {\
  bool val = reader.readBool();\
  BooleanOperandId resultId = reader.booleanOperandId();\
  return emitLoadBooleanConstant(val, resultId);\
}\
\
[[nodiscard]] bool emitLoadUndefined(ValOperandId resultId);\
[[nodiscard]] bool emitLoadUndefined(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadUndefined(resultId);\
}\
\
[[nodiscard]] bool emitLoadConstantString(uint32_t strOffset, StringOperandId resultId);\
[[nodiscard]] bool emitLoadConstantString(CacheIRReader& reader) {\
  uint32_t strOffset = reader.stubOffset();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitLoadConstantString(strOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadConstantStringResult(uint32_t strOffset);\
[[nodiscard]] bool emitLoadConstantStringResult(CacheIRReader& reader) {\
  uint32_t strOffset = reader.stubOffset();\
  return emitLoadConstantStringResult(strOffset);\
}\
\
[[nodiscard]] bool emitLoadInstanceOfObjectResult(ValOperandId lhsId, ObjOperandId protoId);\
[[nodiscard]] bool emitLoadInstanceOfObjectResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ObjOperandId protoId = reader.objOperandId();\
  return emitLoadInstanceOfObjectResult(lhsId, protoId);\
}\
\
[[nodiscard]] bool emitLoadTypeOfObjectResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadTypeOfObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadTypeOfObjectResult(objId);\
}\
\
[[nodiscard]] bool emitDoubleAddResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleAddResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleAddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleSubResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleSubResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleSubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleMulResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleMulResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleMulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleDivResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleDivResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleDivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleModResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleModResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoublePowResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoublePowResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoublePowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32AddResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32AddResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32AddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32SubResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32SubResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32SubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32MulResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32MulResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32MulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32DivResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32DivResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32DivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32ModResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32ModResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32ModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32PowResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32PowResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32PowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntAddResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntAddResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntAddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntSubResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntSubResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntSubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntMulResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntMulResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntMulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntDivResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntDivResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntDivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntModResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntModResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntPowResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntPowResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntPowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitOrResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitOrResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitOrResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitXorResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitXorResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitXorResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitAndResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitAndResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitAndResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32LeftShiftResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32LeftShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32LeftShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32RightShiftResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32RightShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32RightShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32URightShiftResult(Int32OperandId lhsId, Int32OperandId rhsId, bool forceDouble);\
[[nodiscard]] bool emitInt32URightShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  bool forceDouble = reader.readBool();\
  return emitInt32URightShiftResult(lhsId, rhsId, forceDouble);\
}\
\
[[nodiscard]] bool emitInt32NotResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32NotResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32NotResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntBitOrResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitOrResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitOrResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntBitXorResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitXorResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitXorResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntBitAndResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitAndResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitAndResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntLeftShiftResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntLeftShiftResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntLeftShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntRightShiftResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntRightShiftResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntRightShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntNotResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntNotResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntNotResult(inputId);\
}\
\
[[nodiscard]] bool emitInt32NegationResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32NegationResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32NegationResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleNegationResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleNegationResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleNegationResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntNegationResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntNegationResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntNegationResult(inputId);\
}\
\
[[nodiscard]] bool emitInt32IncResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32IncResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32IncResult(inputId);\
}\
\
[[nodiscard]] bool emitInt32DecResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32DecResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32DecResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleIncResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleIncResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleIncResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleDecResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleDecResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleDecResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntIncResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntIncResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntIncResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntDecResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntDecResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntDecResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadInt32TruthyResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadInt32TruthyResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadInt32TruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadDoubleTruthyResult(NumberOperandId inputId);\
[[nodiscard]] bool emitLoadDoubleTruthyResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitLoadDoubleTruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadStringTruthyResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringTruthyResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringTruthyResult(strId);\
}\
\
[[nodiscard]] bool emitLoadObjectTruthyResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadObjectTruthyResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadObjectTruthyResult(objId);\
}\
\
[[nodiscard]] bool emitLoadBigIntTruthyResult(BigIntOperandId bigIntId);\
[[nodiscard]] bool emitLoadBigIntTruthyResult(CacheIRReader& reader) {\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitLoadBigIntTruthyResult(bigIntId);\
}\
\
[[nodiscard]] bool emitLoadValueTruthyResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadValueTruthyResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadValueTruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadOperandResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadOperandResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadOperandResult(inputId);\
}\
\
[[nodiscard]] bool emitNewPlainObjectResult(uint32_t numFixedSlots, uint32_t numDynamicSlots, gc::AllocKind allocKind, uint32_t shapeOffset, uint32_t siteOffset);\
[[nodiscard]] bool emitNewPlainObjectResult(CacheIRReader& reader) {\
  uint32_t numFixedSlots = reader.uint32Immediate();\
  uint32_t numDynamicSlots = reader.uint32Immediate();\
  gc::AllocKind allocKind = reader.allocKind();\
  uint32_t shapeOffset = reader.stubOffset();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewPlainObjectResult(numFixedSlots, numDynamicSlots, allocKind, shapeOffset, siteOffset);\
}\
\
[[nodiscard]] bool emitNewArrayObjectResult(uint32_t arrayLength, uint32_t shapeOffset, uint32_t siteOffset);\
[[nodiscard]] bool emitNewArrayObjectResult(CacheIRReader& reader) {\
  uint32_t arrayLength = reader.uint32Immediate();\
  uint32_t shapeOffset = reader.stubOffset();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewArrayObjectResult(arrayLength, shapeOffset, siteOffset);\
}\
\
[[nodiscard]] bool emitCallStringConcatResult(StringOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCallStringConcatResult(CacheIRReader& reader) {\
  StringOperandId lhsId = reader.stringOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCallStringConcatResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareStringResult(JSOp op, StringOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCompareStringResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  StringOperandId lhsId = reader.stringOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCompareStringResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareObjectResult(JSOp op, ObjOperandId lhsId, ObjOperandId rhsId);\
[[nodiscard]] bool emitCompareObjectResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  ObjOperandId lhsId = reader.objOperandId();\
  ObjOperandId rhsId = reader.objOperandId();\
  return emitCompareObjectResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareSymbolResult(JSOp op, SymbolOperandId lhsId, SymbolOperandId rhsId);\
[[nodiscard]] bool emitCompareSymbolResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  SymbolOperandId lhsId = reader.symbolOperandId();\
  SymbolOperandId rhsId = reader.symbolOperandId();\
  return emitCompareSymbolResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareInt32Result(JSOp op, Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitCompareInt32Result(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitCompareInt32Result(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareDoubleResult(JSOp op, NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareDoubleResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareDoubleResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntResult(JSOp op, BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitCompareBigIntResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntInt32Result(JSOp op, BigIntOperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntInt32Result(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitCompareBigIntInt32Result(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntNumberResult(JSOp op, BigIntOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntNumberResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareBigIntNumberResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntStringResult(JSOp op, BigIntOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntStringResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCompareBigIntStringResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareNullUndefinedResult(JSOp op, bool isUndefined, ValOperandId inputId);\
[[nodiscard]] bool emitCompareNullUndefinedResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  bool isUndefined = reader.readBool();\
  ValOperandId inputId = reader.valOperandId();\
  return emitCompareNullUndefinedResult(op, isUndefined, inputId);\
}\
\
[[nodiscard]] bool emitCompareDoubleSameValueResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareDoubleSameValueResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareDoubleSameValueResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitSameValueResult(ValOperandId lhsId, ValOperandId rhsId);\
[[nodiscard]] bool emitSameValueResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitSameValueResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitIndirectTruncateInt32Result(Int32OperandId valId);\
[[nodiscard]] bool emitIndirectTruncateInt32Result(CacheIRReader& reader) {\
  Int32OperandId valId = reader.int32OperandId();\
  return emitIndirectTruncateInt32Result(valId);\
}\
\
[[nodiscard]] bool emitBigIntAsIntNResult(Int32OperandId bitsId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitBigIntAsIntNResult(CacheIRReader& reader) {\
  Int32OperandId bitsId = reader.int32OperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitBigIntAsIntNResult(bitsId, bigIntId);\
}\
\
[[nodiscard]] bool emitBigIntAsUintNResult(Int32OperandId bitsId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitBigIntAsUintNResult(CacheIRReader& reader) {\
  Int32OperandId bitsId = reader.int32OperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitBigIntAsUintNResult(bitsId, bigIntId);\
}\
\
[[nodiscard]] bool emitBailout();\
[[nodiscard]] bool emitBailout(CacheIRReader& reader) {\
  return emitBailout();\
}\
\
[[nodiscard]] bool emitAssertRecoveredOnBailoutResult(ValOperandId valId, bool mustBeRecovered);\
[[nodiscard]] bool emitAssertRecoveredOnBailoutResult(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  bool mustBeRecovered = reader.readBool();\
  return emitAssertRecoveredOnBailoutResult(valId, mustBeRecovered);\
}\


#define CACHE_IR_TRANSPILER_OPS(_)\
_(ReturnFromIC)\
_(GuardToObject)\
_(GuardIsNullOrUndefined)\
_(GuardIsNull)\
_(GuardIsUndefined)\
_(GuardToBoolean)\
_(GuardToString)\
_(GuardToSymbol)\
_(GuardToBigInt)\
_(GuardIsNumber)\
_(GuardToInt32)\
_(GuardBooleanToInt32)\
_(GuardToInt32Index)\
_(Int32ToIntPtr)\
_(GuardNumberToIntPtrIndex)\
_(GuardToInt32ModUint32)\
_(GuardToUint8Clamped)\
_(GuardNonDoubleType)\
_(GuardShape)\
_(GuardProto)\
_(GuardNullProto)\
_(GuardClass)\
_(GuardAnyClass)\
_(HasClassResult)\
_(CallRegExpMatcherResult)\
_(CallRegExpSearcherResult)\
_(CallRegExpTesterResult)\
_(RegExpFlagResult)\
_(CallSubstringKernelResult)\
_(StringReplaceStringResult)\
_(StringSplitStringResult)\
_(RegExpPrototypeOptimizableResult)\
_(RegExpInstanceOptimizableResult)\
_(GetFirstDollarIndexResult)\
_(GuardIsExtensible)\
_(GuardIsNativeObject)\
_(GuardIsProxy)\
_(GuardIsNotProxy)\
_(GuardIsNotArrayBufferMaybeShared)\
_(GuardIsTypedArray)\
_(GuardIsNotDOMProxy)\
_(GuardSpecificObject)\
_(GuardSpecificFunction)\
_(GuardFunctionScript)\
_(GuardSpecificAtom)\
_(GuardSpecificSymbol)\
_(GuardNoDenseElements)\
_(GuardStringToIndex)\
_(GuardStringToInt32)\
_(GuardStringToNumber)\
_(BooleanToNumber)\
_(GuardHasGetterSetter)\
_(GuardInt32IsNonNegative)\
_(GuardIndexIsValidUpdateOrAdd)\
_(GuardIndexGreaterThanDenseInitLength)\
_(GuardTagNotEqual)\
_(GuardDynamicSlotIsSpecificObject)\
_(GuardFixedSlotValue)\
_(GuardDynamicSlotValue)\
_(GuardNoAllocationMetadataBuilder)\
_(GuardFunctionHasJitEntry)\
_(GuardFunctionHasNoJitEntry)\
_(GuardFunctionIsNonBuiltinCtor)\
_(GuardFunctionIsConstructor)\
_(GuardNotClassConstructor)\
_(GuardArrayIsPacked)\
_(GuardArgumentsObjectFlags)\
_(LoadObject)\
_(LoadProto)\
_(LoadEnclosingEnvironment)\
_(LoadWrapperTarget)\
_(LoadValueTag)\
_(LoadArgumentFixedSlot)\
_(LoadArgumentDynamicSlot)\
_(TruncateDoubleToUInt32)\
_(MegamorphicLoadSlotResult)\
_(MegamorphicLoadSlotByValueResult)\
_(MegamorphicStoreSlot)\
_(MegamorphicSetElement)\
_(MegamorphicHasPropResult)\
_(LoadDOMExpandoValue)\
_(LoadDOMExpandoValueGuardGeneration)\
_(LoadDOMExpandoValueIgnoreGeneration)\
_(GuardDOMExpandoMissingOrGuardShape)\
_(StoreFixedSlot)\
_(StoreDynamicSlot)\
_(AddAndStoreFixedSlot)\
_(AddAndStoreDynamicSlot)\
_(AllocateAndStoreDynamicSlot)\
_(StoreDenseElement)\
_(StoreDenseElementHole)\
_(ArrayPush)\
_(ArrayJoinResult)\
_(PackedArrayPopResult)\
_(PackedArrayShiftResult)\
_(PackedArraySliceResult)\
_(IsArrayResult)\
_(StoreFixedSlotUndefinedResult)\
_(IsObjectResult)\
_(IsPackedArrayResult)\
_(IsCallableResult)\
_(IsConstructorResult)\
_(IsCrossRealmArrayConstructorResult)\
_(IsTypedArrayResult)\
_(IsTypedArrayConstructorResult)\
_(ArrayBufferViewByteOffsetInt32Result)\
_(ArrayBufferViewByteOffsetDoubleResult)\
_(TypedArrayByteLengthInt32Result)\
_(TypedArrayByteLengthDoubleResult)\
_(TypedArrayElementSizeResult)\
_(GuardHasAttachedArrayBuffer)\
_(FinishBoundFunctionInitResult)\
_(NewArrayIteratorResult)\
_(NewStringIteratorResult)\
_(NewRegExpStringIteratorResult)\
_(ObjectCreateResult)\
_(NewArrayFromLengthResult)\
_(NewTypedArrayFromLengthResult)\
_(NewTypedArrayFromArrayBufferResult)\
_(NewTypedArrayFromArrayResult)\
_(NewStringObjectResult)\
_(StringFromCharCodeResult)\
_(StringFromCodePointResult)\
_(StringToLowerCaseResult)\
_(StringToUpperCaseResult)\
_(MathAbsInt32Result)\
_(MathAbsNumberResult)\
_(MathClz32Result)\
_(MathSignInt32Result)\
_(MathSignNumberResult)\
_(MathSignNumberToInt32Result)\
_(MathImulResult)\
_(MathSqrtNumberResult)\
_(MathFRoundNumberResult)\
_(MathRandomResult)\
_(MathHypot2NumberResult)\
_(MathHypot3NumberResult)\
_(MathHypot4NumberResult)\
_(MathAtan2NumberResult)\
_(MathFloorNumberResult)\
_(MathCeilNumberResult)\
_(MathTruncNumberResult)\
_(MathFloorToInt32Result)\
_(MathCeilToInt32Result)\
_(MathTruncToInt32Result)\
_(MathRoundToInt32Result)\
_(Int32MinMax)\
_(NumberMinMax)\
_(Int32MinMaxArrayResult)\
_(NumberMinMaxArrayResult)\
_(MathFunctionNumberResult)\
_(ObjectToStringResult)\
_(ReflectGetPrototypeOfResult)\
_(StoreTypedArrayElement)\
_(AtomicsCompareExchangeResult)\
_(AtomicsExchangeResult)\
_(AtomicsAddResult)\
_(AtomicsSubResult)\
_(AtomicsAndResult)\
_(AtomicsOrResult)\
_(AtomicsXorResult)\
_(AtomicsLoadResult)\
_(AtomicsStoreResult)\
_(AtomicsIsLockFreeResult)\
_(CallNativeSetter)\
_(CallScriptedSetter)\
_(CallInlinedSetter)\
_(CallDOMSetter)\
_(CallSetArrayLength)\
_(ProxySet)\
_(ProxySetByValue)\
_(CallAddOrUpdateSparseElementHelper)\
_(CallInt32ToString)\
_(CallNumberToString)\
_(BooleanToString)\
_(CallScriptedFunction)\
_(CallWasmFunction)\
_(GuardWasmArg)\
_(CallNativeFunction)\
_(CallDOMFunction)\
_(CallInlinedFunction)\
_(MetaTwoByte)\
_(LoadFixedSlotResult)\
_(LoadFixedSlotTypedResult)\
_(LoadDynamicSlotResult)\
_(LoadDenseElementResult)\
_(LoadDenseElementHoleResult)\
_(CallGetSparseElementResult)\
_(LoadDenseElementExistsResult)\
_(LoadTypedArrayElementExistsResult)\
_(LoadDenseElementHoleExistsResult)\
_(LoadTypedArrayElementResult)\
_(LoadDataViewValueResult)\
_(StoreDataViewValueResult)\
_(LoadInt32ArrayLengthResult)\
_(LoadInt32ArrayLength)\
_(LoadArgumentsObjectArgResult)\
_(LoadArgumentsObjectLengthResult)\
_(LoadFunctionLengthResult)\
_(LoadFunctionNameResult)\
_(LoadArrayBufferByteLengthInt32Result)\
_(LoadArrayBufferByteLengthDoubleResult)\
_(LoadArrayBufferViewLengthInt32Result)\
_(LoadArrayBufferViewLengthDoubleResult)\
_(LoadStringCharResult)\
_(LoadStringCharCodeResult)\
_(LoadStringLengthResult)\
_(FrameIsConstructingResult)\
_(LoadEnvironmentFixedSlotResult)\
_(LoadEnvironmentDynamicSlotResult)\
_(LoadObjectResult)\
_(LoadStringResult)\
_(LoadSymbolResult)\
_(LoadInt32Result)\
_(LoadDoubleResult)\
_(LoadBigIntResult)\
_(CallScriptedGetterResult)\
_(CallInlinedGetterResult)\
_(CallNativeGetterResult)\
_(CallDOMGetterResult)\
_(ProxyGetResult)\
_(ProxyGetByValueResult)\
_(ProxyHasPropResult)\
_(CallObjectHasSparseElementResult)\
_(CallNativeGetElementResult)\
_(GetNextMapSetEntryForIteratorResult)\
_(LoadUndefinedResult)\
_(LoadBooleanResult)\
_(LoadInt32Constant)\
_(LoadBooleanConstant)\
_(LoadUndefined)\
_(LoadConstantString)\
_(LoadConstantStringResult)\
_(LoadInstanceOfObjectResult)\
_(LoadTypeOfObjectResult)\
_(DoubleAddResult)\
_(DoubleSubResult)\
_(DoubleMulResult)\
_(DoubleDivResult)\
_(DoubleModResult)\
_(DoublePowResult)\
_(Int32AddResult)\
_(Int32SubResult)\
_(Int32MulResult)\
_(Int32DivResult)\
_(Int32ModResult)\
_(Int32PowResult)\
_(BigIntAddResult)\
_(BigIntSubResult)\
_(BigIntMulResult)\
_(BigIntDivResult)\
_(BigIntModResult)\
_(BigIntPowResult)\
_(Int32BitOrResult)\
_(Int32BitXorResult)\
_(Int32BitAndResult)\
_(Int32LeftShiftResult)\
_(Int32RightShiftResult)\
_(Int32URightShiftResult)\
_(Int32NotResult)\
_(BigIntBitOrResult)\
_(BigIntBitXorResult)\
_(BigIntBitAndResult)\
_(BigIntLeftShiftResult)\
_(BigIntRightShiftResult)\
_(BigIntNotResult)\
_(Int32NegationResult)\
_(DoubleNegationResult)\
_(BigIntNegationResult)\
_(Int32IncResult)\
_(Int32DecResult)\
_(DoubleIncResult)\
_(DoubleDecResult)\
_(BigIntIncResult)\
_(BigIntDecResult)\
_(LoadInt32TruthyResult)\
_(LoadDoubleTruthyResult)\
_(LoadStringTruthyResult)\
_(LoadObjectTruthyResult)\
_(LoadBigIntTruthyResult)\
_(LoadValueTruthyResult)\
_(LoadOperandResult)\
_(NewPlainObjectResult)\
_(NewArrayObjectResult)\
_(CallStringConcatResult)\
_(CompareStringResult)\
_(CompareObjectResult)\
_(CompareSymbolResult)\
_(CompareInt32Result)\
_(CompareDoubleResult)\
_(CompareBigIntResult)\
_(CompareBigIntInt32Result)\
_(CompareBigIntNumberResult)\
_(CompareBigIntStringResult)\
_(CompareNullUndefinedResult)\
_(CompareDoubleSameValueResult)\
_(SameValueResult)\
_(IndirectTruncateInt32Result)\
_(BigIntAsIntNResult)\
_(BigIntAsUintNResult)\
_(Bailout)\
_(AssertRecoveredOnBailoutResult)

#define CACHE_IR_SPEWER_GENERATED \
void spewReturnFromIC(CacheIRReader& reader) {\
  spewOp(CacheOp::ReturnFromIC);\
  spewOpEnd();\
}\
\
void spewGuardToObject(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToObject);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNullOrUndefined(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNullOrUndefined);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNull(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNull);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsUndefined(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsUndefined);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToBoolean(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToBoolean);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToString(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToString);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToSymbol(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToSymbol);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToBigInt(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToBigInt);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNumber(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNumber);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToInt32(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToInt32);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardBooleanToInt32(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardBooleanToInt32);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardToInt32Index(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToInt32Index);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32ToIntPtr(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32ToIntPtr);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewGuardNumberToIntPtrIndex(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNumberToIntPtrIndex);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewArgSeparator();\
  spewBoolImm("supportOOB", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToInt32ModUint32(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToInt32ModUint32);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardToUint8Clamped(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToUint8Clamped);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardNonDoubleType(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNonDoubleType);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewValueTypeImm("type", reader.valueType());\
  spewOpEnd();\
}\
\
void spewGuardShape(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardShape);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardProto(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardProto);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("protoOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardNullProto(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNullProto);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardClass(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardClass);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewGuardClassKindImm("kind", reader.guardClassKind());\
  spewOpEnd();\
}\
\
void spewGuardAnyClass(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardAnyClass);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("claspOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewHasClassResult(CacheIRReader& reader) {\
  spewOp(CacheOp::HasClassResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("claspOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallRegExpMatcherResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallRegExpMatcherResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("lastIndexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCallRegExpSearcherResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallRegExpSearcherResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("lastIndexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCallRegExpTesterResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallRegExpTesterResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("lastIndexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewRegExpFlagResult(CacheIRReader& reader) {\
  spewOp(CacheOp::RegExpFlagResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewInt32Imm("flagsMask", reader.int32Immediate());\
  spewOpEnd();\
}\
\
void spewCallSubstringKernelResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallSubstringKernelResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("beginId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("lengthId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewStringReplaceStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringReplaceStringResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("patternId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("replacementId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringSplitStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringSplitStringResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("separatorId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewRegExpPrototypeOptimizableResult(CacheIRReader& reader) {\
  spewOp(CacheOp::RegExpPrototypeOptimizableResult);\
  spewOperandId("protoId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewRegExpInstanceOptimizableResult(CacheIRReader& reader) {\
  spewOp(CacheOp::RegExpInstanceOptimizableResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("protoId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGetFirstDollarIndexResult(CacheIRReader& reader) {\
  spewOp(CacheOp::GetFirstDollarIndexResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewGuardCompartment(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardCompartment);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("globalOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("compartmentOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardIsExtensible(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsExtensible);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNativeObject(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNativeObject);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsProxy(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsProxy);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNotProxy(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNotProxy);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNotArrayBufferMaybeShared(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNotArrayBufferMaybeShared);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsTypedArray(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsTypedArray);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardHasProxyHandler(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardHasProxyHandler);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("handlerOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardIsNotDOMProxy(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNotDOMProxy);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardSpecificObject(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificObject);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardSpecificFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificFunction);\
  spewOperandId("funId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardFunctionScript(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionScript);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardSpecificAtom(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificAtom);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardSpecificSymbol(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificSymbol);\
  spewOperandId("symId", reader.symbolOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardNoDenseElements(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNoDenseElements);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardStringToIndex(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardStringToIndex);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardStringToInt32(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardStringToInt32);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardStringToNumber(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardStringToNumber);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewBooleanToNumber(CacheIRReader& reader) {\
  spewOp(CacheOp::BooleanToNumber);\
  spewOperandId("booleanId", reader.booleanOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewGuardAndGetIterator(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardAndGetIterator);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("iterOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("enumeratorsAddrOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardHasGetterSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardHasGetterSetter);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("idOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("getterSetterOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardInt32IsNonNegative(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardInt32IsNonNegative);\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardIndexIsValidUpdateOrAdd(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIndexIsValidUpdateOrAdd);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardIndexGreaterThanDenseInitLength(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIndexGreaterThanDenseInitLength);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardTagNotEqual(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardTagNotEqual);\
  spewOperandId("lhsId", reader.valueTagOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valueTagOperandId());\
  spewOpEnd();\
}\
\
void spewGuardXrayExpandoShapeAndDefaultProto(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardXrayExpandoShapeAndDefaultProto);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("shapeWrapperOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardXrayNoExpando(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardXrayNoExpando);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardDynamicSlotIsSpecificObject(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardDynamicSlotIsSpecificObject);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("expectedId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("slotOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardFixedSlotValue(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFixedSlotValue);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("valOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardDynamicSlotValue(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardDynamicSlotValue);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("valOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardNoAllocationMetadataBuilder(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNoAllocationMetadataBuilder);\
  spewField("builderAddrOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardFunctionHasJitEntry(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionHasJitEntry);\
  spewOperandId("funId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("constructing", reader.readBool());\
  spewOpEnd();\
}\
\
void spewGuardFunctionHasNoJitEntry(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionHasNoJitEntry);\
  spewOperandId("funId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardFunctionIsNonBuiltinCtor(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionIsNonBuiltinCtor);\
  spewOperandId("funId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardFunctionIsConstructor(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionIsConstructor);\
  spewOperandId("funId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardNotClassConstructor(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNotClassConstructor);\
  spewOperandId("funId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardArrayIsPacked(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardArrayIsPacked);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardArgumentsObjectFlags(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardArgumentsObjectFlags);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewByteImm("flags", reader.readByte());\
  spewOpEnd();\
}\
\
void spewLoadObject(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadObject);\
  spewOperandId("resultId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("objOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadProto(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadProto);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadEnclosingEnvironment(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadEnclosingEnvironment);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadWrapperTarget(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadWrapperTarget);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadValueTag(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadValueTag);\
  spewOperandId("valId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.valueTagOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArgumentFixedSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentFixedSlot);\
  spewOperandId("resultId", reader.valOperandId());\
  spewArgSeparator();\
  spewByteImm("slotIndex", reader.readByte());\
  spewOpEnd();\
}\
\
void spewLoadArgumentDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentDynamicSlot);\
  spewOperandId("resultId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewByteImm("slotIndex", reader.readByte());\
  spewOpEnd();\
}\
\
void spewTruncateDoubleToUInt32(CacheIRReader& reader) {\
  spewOp(CacheOp::TruncateDoubleToUInt32);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMegamorphicLoadSlotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicLoadSlotResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("nameOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewMegamorphicLoadSlotByValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicLoadSlotByValueResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMegamorphicStoreSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicStoreSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("nameOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMegamorphicSetElement(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicSetElement);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewOpEnd();\
}\
\
void spewMegamorphicHasPropResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicHasPropResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("hasOwn", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadDOMExpandoValue(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDOMExpandoValue);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadDOMExpandoValueGuardGeneration(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDOMExpandoValueGuardGeneration);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("expandoAndGenerationOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("generationOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadDOMExpandoValueIgnoreGeneration(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDOMExpandoValueIgnoreGeneration);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardDOMExpandoMissingOrGuardShape(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardDOMExpandoMissingOrGuardShape);\
  spewOperandId("expandoId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewStoreFixedSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreFixedSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewStoreDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreDynamicSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewAddAndStoreFixedSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::AddAndStoreFixedSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("newShapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewAddAndStoreDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::AddAndStoreDynamicSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("newShapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewAllocateAndStoreDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::AllocateAndStoreDynamicSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("newShapeOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("numNewSlotsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewStoreDenseElement(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreDenseElement);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewStoreDenseElementHole(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreDenseElementHole);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("handleAdd", reader.readBool());\
  spewOpEnd();\
}\
\
void spewArrayPush(CacheIRReader& reader) {\
  spewOp(CacheOp::ArrayPush);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewArrayJoinResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ArrayJoinResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("sepId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewPackedArrayPopResult(CacheIRReader& reader) {\
  spewOp(CacheOp::PackedArrayPopResult);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewPackedArrayShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::PackedArrayShiftResult);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewPackedArraySliceResult(CacheIRReader& reader) {\
  spewOp(CacheOp::PackedArraySliceResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("arrayId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("beginId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("endId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewIsArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsArrayResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewStoreFixedSlotUndefinedResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreFixedSlotUndefinedResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewIsObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsObjectResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewIsPackedArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsPackedArrayResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewIsCallableResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsCallableResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewIsConstructorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsConstructorResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewIsCrossRealmArrayConstructorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsCrossRealmArrayConstructorResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewIsTypedArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsTypedArrayResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("isPossiblyWrapped", reader.readBool());\
  spewOpEnd();\
}\
\
void spewIsTypedArrayConstructorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsTypedArrayConstructorResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewArrayBufferViewByteOffsetInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::ArrayBufferViewByteOffsetInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewArrayBufferViewByteOffsetDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ArrayBufferViewByteOffsetDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewTypedArrayByteLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::TypedArrayByteLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewTypedArrayByteLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::TypedArrayByteLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewTypedArrayElementSizeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::TypedArrayElementSizeResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardHasAttachedArrayBuffer(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardHasAttachedArrayBuffer);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewFinishBoundFunctionInitResult(CacheIRReader& reader) {\
  spewOp(CacheOp::FinishBoundFunctionInitResult);\
  spewOperandId("boundId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("targetId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argCountId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewNewArrayIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewArrayIteratorResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewStringIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewStringIteratorResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewRegExpStringIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewRegExpStringIteratorResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewObjectCreateResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ObjectCreateResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewArrayFromLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewArrayFromLengthResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("lengthId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewNewTypedArrayFromLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewTypedArrayFromLengthResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("lengthId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewNewTypedArrayFromArrayBufferResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewTypedArrayFromArrayBufferResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("bufferId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("byteOffsetId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("lengthId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewNewTypedArrayFromArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewTypedArrayFromArrayResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("arrayId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewNewStringObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewStringObjectResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringFromCharCodeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringFromCharCodeResult);\
  spewOperandId("codeId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewStringFromCodePointResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringFromCodePointResult);\
  spewOperandId("codeId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewStringToLowerCaseResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringToLowerCaseResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringToUpperCaseResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringToUpperCaseResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewMathAbsInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathAbsInt32Result);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMathAbsNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathAbsNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathClz32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathClz32Result);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMathSignInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathSignInt32Result);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMathSignNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathSignNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathSignNumberToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathSignNumberToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathImulResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathImulResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMathSqrtNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathSqrtNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathFRoundNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathFRoundNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathRandomResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathRandomResult);\
  spewField("rngOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewMathHypot2NumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathHypot2NumberResult);\
  spewOperandId("firstId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathHypot3NumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathHypot3NumberResult);\
  spewOperandId("firstId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("thirdId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathHypot4NumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathHypot4NumberResult);\
  spewOperandId("firstId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("thirdId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("fourthId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathAtan2NumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathAtan2NumberResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathFloorNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathFloorNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathCeilNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathCeilNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathTruncNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathTruncNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathFloorToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathFloorToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathCeilToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathCeilToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathTruncToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathTruncToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathRoundToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathRoundToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewInt32MinMax(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32MinMax);\
  spewBoolImm("isMax", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("firstId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewNumberMinMax(CacheIRReader& reader) {\
  spewOp(CacheOp::NumberMinMax);\
  spewBoolImm("isMax", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("firstId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewInt32MinMaxArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32MinMaxArrayResult);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("isMax", reader.readBool());\
  spewOpEnd();\
}\
\
void spewNumberMinMaxArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NumberMinMaxArrayResult);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("isMax", reader.readBool());\
  spewOpEnd();\
}\
\
void spewMathFunctionNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathFunctionNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewArgSeparator();\
  spewUnaryMathFunctionImm("fun", reader.unaryMathFunction());\
  spewOpEnd();\
}\
\
void spewObjectToStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ObjectToStringResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewReflectGetPrototypeOfResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ReflectGetPrototypeOfResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewStoreTypedArrayElement(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreTypedArrayElement);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("rhsId", reader.rawOperandId());\
  spewArgSeparator();\
  spewBoolImm("handleOOB", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAtomicsCompareExchangeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsCompareExchangeResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("expectedId", reader.rawOperandId());\
  spewArgSeparator();\
  spewRawOperandId("replacementId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewOpEnd();\
}\
\
void spewAtomicsExchangeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsExchangeResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewOpEnd();\
}\
\
void spewAtomicsAddResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsAddResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAtomicsSubResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsSubResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAtomicsAndResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsAndResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAtomicsOrResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsOrResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAtomicsXorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsXorResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAtomicsLoadResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsLoadResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewOpEnd();\
}\
\
void spewAtomicsStoreResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsStoreResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewOpEnd();\
}\
\
void spewAtomicsIsLockFreeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsIsLockFreeResult);\
  spewOperandId("valueId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCallNativeSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNativeSetter);\
  spewOperandId("receiverId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("setterOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallScriptedSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::CallScriptedSetter);\
  spewOperandId("receiverId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("setterOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallInlinedSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::CallInlinedSetter);\
  spewOperandId("receiverId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("setterOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("icScriptOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallDOMSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::CallDOMSetter);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("jitInfoOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewCallSetArrayLength(CacheIRReader& reader) {\
  spewOp(CacheOp::CallSetArrayLength);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewProxySet(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxySet);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("idOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewOpEnd();\
}\
\
void spewProxySetByValue(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxySetByValue);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewOpEnd();\
}\
\
void spewCallAddOrUpdateSparseElementHelper(CacheIRReader& reader) {\
  spewOp(CacheOp::CallAddOrUpdateSparseElementHelper);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewOpEnd();\
}\
\
void spewCallInt32ToString(CacheIRReader& reader) {\
  spewOp(CacheOp::CallInt32ToString);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewCallNumberToString(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNumberToString);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewBooleanToString(CacheIRReader& reader) {\
  spewOp(CacheOp::BooleanToString);\
  spewOperandId("inputId", reader.booleanOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewCallScriptedFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallScriptedFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewOpEnd();\
}\
\
void spewCallWasmFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallWasmFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewField("funcExportOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("instanceOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardWasmArg(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardWasmArg);\
  spewOperandId("argId", reader.valOperandId());\
  spewArgSeparator();\
  spewWasmValTypeImm("type", reader.wasmValType());\
  spewOpEnd();\
}\
\
void spewCallNativeFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNativeFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewBoolImm("ignoresReturnValue", reader.readBool());\
  spewOpEnd();\
}\
\
void spewCallDOMFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallDOMFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("thisObjId", reader.objOperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewOpEnd();\
}\
\
void spewCallClassHook(CacheIRReader& reader) {\
  spewOp(CacheOp::CallClassHook);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewField("targetOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallInlinedFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallInlinedFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewField("icScriptOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewOpEnd();\
}\
\
void spewMetaTwoByte(CacheIRReader& reader) {\
  spewOp(CacheOp::MetaTwoByte);\
  spewField("functionObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadFixedSlotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadFixedSlotResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadFixedSlotTypedResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadFixedSlotTypedResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewValueTypeImm("type", reader.valueType());\
  spewOpEnd();\
}\
\
void spewLoadDynamicSlotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDynamicSlotResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadDenseElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDenseElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadDenseElementHoleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDenseElementHoleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCallGetSparseElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallGetSparseElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadDenseElementExistsResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDenseElementExistsResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadTypedArrayElementExistsResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadTypedArrayElementExistsResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewLoadDenseElementHoleExistsResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDenseElementHoleExistsResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadTypedArrayElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadTypedArrayElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("handleOOB", reader.readBool());\
  spewArgSeparator();\
  spewBoolImm("forceDoubleForUint32", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadDataViewValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDataViewValueResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("offsetId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("littleEndianId", reader.booleanOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forceDoubleForUint32", reader.readBool());\
  spewOpEnd();\
}\
\
void spewStoreDataViewValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreDataViewValueResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("offsetId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewOperandId("littleEndianId", reader.booleanOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewOpEnd();\
}\
\
void spewLoadInt32ArrayLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32ArrayLengthResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadInt32ArrayLength(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32ArrayLength);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadArgumentsObjectArgResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentsObjectArgResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadArgumentsObjectLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentsObjectLengthResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadFunctionLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadFunctionLengthResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadFunctionNameResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadFunctionNameResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArrayBufferByteLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArrayBufferByteLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArrayBufferByteLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArrayBufferByteLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArrayBufferViewLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArrayBufferViewLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArrayBufferViewLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArrayBufferViewLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadStringCharResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringCharResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadStringCharCodeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringCharCodeResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadStringLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringLengthResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewFrameIsConstructingResult(CacheIRReader& reader) {\
  spewOp(CacheOp::FrameIsConstructingResult);\
  spewOpEnd();\
}\
\
void spewLoadEnvironmentFixedSlotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadEnvironmentFixedSlotResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadEnvironmentDynamicSlotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadEnvironmentDynamicSlotResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadObjectResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewLoadSymbolResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadSymbolResult);\
  spewOperandId("symId", reader.symbolOperandId());\
  spewOpEnd();\
}\
\
void spewLoadInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32Result);\
  spewOperandId("valId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDoubleResult);\
  spewOperandId("valId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewLoadBigIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBigIntResult);\
  spewOperandId("valId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewCallScriptedGetterResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallScriptedGetterResult);\
  spewOperandId("receiverId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("getterOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallInlinedGetterResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallInlinedGetterResult);\
  spewOperandId("receiverId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("getterOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("icScriptOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallNativeGetterResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNativeGetterResult);\
  spewOperandId("receiverId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("getterOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallDOMGetterResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallDOMGetterResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("jitInfoOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewProxyGetResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxyGetResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("idOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewProxyGetByValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxyGetByValueResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewProxyHasPropResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxyHasPropResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("hasOwn", reader.readBool());\
  spewOpEnd();\
}\
\
void spewCallObjectHasSparseElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallObjectHasSparseElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCallNativeGetElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNativeGetElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGetNextMapSetEntryForIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::GetNextMapSetEntryForIteratorResult);\
  spewOperandId("iterId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultArrId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("isMap", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadUndefinedResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadUndefinedResult);\
  spewOpEnd();\
}\
\
void spewLoadBooleanResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBooleanResult);\
  spewBoolImm("val", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadInt32Constant(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32Constant);\
  spewField("valOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadBooleanConstant(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBooleanConstant);\
  spewBoolImm("val", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.booleanOperandId());\
  spewOpEnd();\
}\
\
void spewLoadUndefined(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadUndefined);\
  spewOperandId("resultId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadConstantString(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadConstantString);\
  spewField("strOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewLoadConstantStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadConstantStringResult);\
  spewField("strOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadInstanceOfObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInstanceOfObjectResult);\
  spewOperandId("lhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("protoId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadTypeOfObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadTypeOfObjectResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleAddResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleAddResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleSubResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleSubResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleMulResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleMulResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleDivResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleDivResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleModResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleModResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoublePowResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoublePowResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewInt32AddResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32AddResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32SubResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32SubResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32MulResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32MulResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32DivResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32DivResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32ModResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32ModResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32PowResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32PowResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewBigIntAddResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntAddResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntSubResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntSubResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntMulResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntMulResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntDivResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntDivResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntModResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntModResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPowResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPowResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewInt32BitOrResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32BitOrResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32BitXorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32BitXorResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32BitAndResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32BitAndResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32LeftShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32LeftShiftResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32RightShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32RightShiftResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32URightShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32URightShiftResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewBoolImm("forceDouble", reader.readBool());\
  spewOpEnd();\
}\
\
void spewInt32NotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32NotResult);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewBigIntBitOrResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntBitOrResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntBitXorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntBitXorResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntBitAndResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntBitAndResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntLeftShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntLeftShiftResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntRightShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntRightShiftResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntNotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntNotResult);\
  spewOperandId("inputId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewInt32NegationResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32NegationResult);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewDoubleNegationResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleNegationResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntNegationResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntNegationResult);\
  spewOperandId("inputId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewInt32IncResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32IncResult);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32DecResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32DecResult);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewDoubleIncResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleIncResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleDecResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleDecResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntIncResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntIncResult);\
  spewOperandId("inputId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntDecResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntDecResult);\
  spewOperandId("inputId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewLoadInt32TruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32TruthyResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadDoubleTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDoubleTruthyResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewLoadStringTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringTruthyResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewLoadObjectTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadObjectTruthyResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadBigIntTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBigIntTruthyResult);\
  spewOperandId("bigIntId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewLoadValueTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadValueTruthyResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadValueResult);\
  spewField("valOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadOperandResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadOperandResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewNewPlainObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewPlainObjectResult);\
  spewUInt32Imm("numFixedSlots", reader.uint32Immediate());\
  spewArgSeparator();\
  spewUInt32Imm("numDynamicSlots", reader.uint32Immediate());\
  spewArgSeparator();\
  spewAllocKindImm("allocKind", reader.allocKind());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("siteOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewArrayObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewArrayObjectResult);\
  spewUInt32Imm("arrayLength", reader.uint32Immediate());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("siteOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallStringConcatResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallStringConcatResult);\
  spewOperandId("lhsId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewCallStringObjectConcatResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallStringObjectConcatResult);\
  spewOperandId("lhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewCallIsSuspendedGeneratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallIsSuspendedGeneratorResult);\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewCompareStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareStringResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewCompareObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareObjectResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewCompareSymbolResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareSymbolResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.symbolOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.symbolOperandId());\
  spewOpEnd();\
}\
\
void spewCompareInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareInt32Result);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCompareDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareDoubleResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewCompareBigIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareBigIntResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewCompareBigIntInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareBigIntInt32Result);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCompareBigIntNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareBigIntNumberResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewCompareBigIntStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareBigIntStringResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewCompareNullUndefinedResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareNullUndefinedResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewBoolImm("isUndefined", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewCompareDoubleSameValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareDoubleSameValueResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewSameValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SameValueResult);\
  spewOperandId("lhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewIndirectTruncateInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::IndirectTruncateInt32Result);\
  spewOperandId("valId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewBigIntAsIntNResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntAsIntNResult);\
  spewOperandId("bitsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("bigIntId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntAsUintNResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntAsUintNResult);\
  spewOperandId("bitsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("bigIntId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewCallPrintString(CacheIRReader& reader) {\
  spewOp(CacheOp::CallPrintString);\
  spewStaticStringImm("str", reinterpret_cast<char*>(reader.pointer()));\
  spewOpEnd();\
}\
\
void spewBreakpoint(CacheIRReader& reader) {\
  spewOp(CacheOp::Breakpoint);\
  spewOpEnd();\
}\
\
void spewWrapResult(CacheIRReader& reader) {\
  spewOp(CacheOp::WrapResult);\
  spewOpEnd();\
}\
\
void spewBailout(CacheIRReader& reader) {\
  spewOp(CacheOp::Bailout);\
  spewOpEnd();\
}\
\
void spewAssertRecoveredOnBailoutResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AssertRecoveredOnBailoutResult);\
  spewOperandId("valId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("mustBeRecovered", reader.readBool());\
  spewOpEnd();\
}\


#define CACHE_IR_CLONE_GENERATED \
void cloneReturnFromIC(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ReturnFromIC);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToObject);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNullOrUndefined(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNullOrUndefined);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNull(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNull);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsUndefined(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsUndefined);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToBoolean(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToBoolean);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToString);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToSymbol(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToSymbol);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToBigInt(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToBigInt);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNumber(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNumber);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToInt32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToInt32);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardBooleanToInt32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardBooleanToInt32);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToInt32Index(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToInt32Index);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32ToIntPtr(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32ToIntPtr);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNumberToIntPtrIndex(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNumberToIntPtrIndex);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  bool supportOOB = reader.readBool();\
  writer.writeBoolImm(supportOOB);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToInt32ModUint32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToInt32ModUint32);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToUint8Clamped(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToUint8Clamped);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNonDoubleType(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNonDoubleType);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  ValueType type = reader.valueType();\
  writer.writeValueTypeImm(type);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardShape(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardShape);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardProto(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardProto);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t protoOffset = reader.stubOffset();\
  JSObject* proto = getObjectField(protoOffset);\
  writer.writeObjectField(proto);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNullProto(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNullProto);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardClass(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardClass);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  GuardClassKind kind = reader.guardClassKind();\
  writer.writeGuardClassKindImm(kind);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardAnyClass(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardAnyClass);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t claspOffset = reader.stubOffset();\
  const void* clasp = getRawPointerField(claspOffset);\
  writer.writeRawPointerField(clasp);\
  writer.assertLengthMatches();\
}}\
\
void cloneHasClassResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::HasClassResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t claspOffset = reader.stubOffset();\
  const void* clasp = getRawPointerField(claspOffset);\
  writer.writeRawPointerField(clasp);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallRegExpMatcherResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallRegExpMatcherResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  StringOperandId inputId = reader.stringOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  writer.writeOperandId(lastIndexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallRegExpSearcherResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallRegExpSearcherResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  StringOperandId inputId = reader.stringOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  writer.writeOperandId(lastIndexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallRegExpTesterResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallRegExpTesterResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  StringOperandId inputId = reader.stringOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  writer.writeOperandId(lastIndexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneRegExpFlagResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::RegExpFlagResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  int32_t flagsMask = reader.int32Immediate();\
  writer.writeInt32Imm(flagsMask);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallSubstringKernelResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallSubstringKernelResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId beginId = reader.int32OperandId();\
  writer.writeOperandId(beginId);\
  Int32OperandId lengthId = reader.int32OperandId();\
  writer.writeOperandId(lengthId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringReplaceStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringReplaceStringResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  StringOperandId patternId = reader.stringOperandId();\
  writer.writeOperandId(patternId);\
  StringOperandId replacementId = reader.stringOperandId();\
  writer.writeOperandId(replacementId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringSplitStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringSplitStringResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  StringOperandId separatorId = reader.stringOperandId();\
  writer.writeOperandId(separatorId);\
  writer.assertLengthMatches();\
}}\
\
void cloneRegExpPrototypeOptimizableResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::RegExpPrototypeOptimizableResult);\
  ObjOperandId protoId = reader.objOperandId();\
  writer.writeOperandId(protoId);\
  writer.assertLengthMatches();\
}}\
\
void cloneRegExpInstanceOptimizableResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::RegExpInstanceOptimizableResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  ObjOperandId protoId = reader.objOperandId();\
  writer.writeOperandId(protoId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGetFirstDollarIndexResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GetFirstDollarIndexResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardCompartment(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardCompartment);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t globalOffset = reader.stubOffset();\
  JSObject* global = getObjectField(globalOffset);\
  writer.writeObjectField(global);\
  uint32_t compartmentOffset = reader.stubOffset();\
  const void* compartment = getRawPointerField(compartmentOffset);\
  writer.writeRawPointerField(compartment);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsExtensible(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsExtensible);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNativeObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNativeObject);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsProxy(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsProxy);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNotProxy(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNotProxy);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNotArrayBufferMaybeShared(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNotArrayBufferMaybeShared);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsTypedArray(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsTypedArray);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardHasProxyHandler(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardHasProxyHandler);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t handlerOffset = reader.stubOffset();\
  const void* handler = getRawPointerField(handlerOffset);\
  writer.writeRawPointerField(handler);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNotDOMProxy(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNotDOMProxy);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificObject);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t expectedOffset = reader.stubOffset();\
  JSObject* expected = getObjectField(expectedOffset);\
  writer.writeObjectField(expected);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificFunction);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  uint32_t expectedOffset = reader.stubOffset();\
  JSObject* expected = getObjectField(expectedOffset);\
  writer.writeObjectField(expected);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionScript(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionScript);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t expectedOffset = reader.stubOffset();\
  BaseScript* expected = getBaseScriptField(expectedOffset);\
  writer.writeBaseScriptField(expected);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificAtom(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificAtom);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  uint32_t expectedOffset = reader.stubOffset();\
  JSAtom* expected = getAtomField(expectedOffset);\
  writer.writeStringField(expected);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificSymbol(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificSymbol);\
  SymbolOperandId symId = reader.symbolOperandId();\
  writer.writeOperandId(symId);\
  uint32_t expectedOffset = reader.stubOffset();\
  JS::Symbol* expected = getSymbolField(expectedOffset);\
  writer.writeSymbolField(expected);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNoDenseElements(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNoDenseElements);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardStringToIndex(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardStringToIndex);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardStringToInt32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardStringToInt32);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardStringToNumber(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardStringToNumber);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  NumberOperandId resultId = reader.numberOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBooleanToNumber(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BooleanToNumber);\
  BooleanOperandId booleanId = reader.booleanOperandId();\
  writer.writeOperandId(booleanId);\
  NumberOperandId resultId = reader.numberOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardAndGetIterator(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardAndGetIterator);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t iterOffset = reader.stubOffset();\
  JSObject* iter = getObjectField(iterOffset);\
  writer.writeObjectField(iter);\
  uint32_t enumeratorsAddrOffset = reader.stubOffset();\
  const void* enumeratorsAddr = getRawPointerField(enumeratorsAddrOffset);\
  writer.writeRawPointerField(enumeratorsAddr);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardHasGetterSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardHasGetterSetter);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t idOffset = reader.stubOffset();\
  jsid id = getIdField(idOffset);\
  writer.writeIdField(id);\
  uint32_t getterSetterOffset = reader.stubOffset();\
  GetterSetter* getterSetter = getGetterSetterField(getterSetterOffset);\
  writer.writeGetterSetterField(getterSetter);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardInt32IsNonNegative(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardInt32IsNonNegative);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIndexIsValidUpdateOrAdd(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIndexIsValidUpdateOrAdd);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIndexGreaterThanDenseInitLength(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIndexGreaterThanDenseInitLength);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardTagNotEqual(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardTagNotEqual);\
  ValueTagOperandId lhsId = reader.valueTagOperandId();\
  writer.writeOperandId(lhsId);\
  ValueTagOperandId rhsId = reader.valueTagOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardXrayExpandoShapeAndDefaultProto(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardXrayExpandoShapeAndDefaultProto);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t shapeWrapperOffset = reader.stubOffset();\
  JSObject* shapeWrapper = getObjectField(shapeWrapperOffset);\
  writer.writeObjectField(shapeWrapper);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardXrayNoExpando(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardXrayNoExpando);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardDynamicSlotIsSpecificObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardDynamicSlotIsSpecificObject);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ObjOperandId expectedId = reader.objOperandId();\
  writer.writeOperandId(expectedId);\
  uint32_t slotOffset = reader.stubOffset();\
  uint32_t slot = getRawInt32Field(slotOffset);\
  writer.writeRawInt32Field(slot);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFixedSlotValue(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFixedSlotValue);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  uint32_t valOffset = reader.stubOffset();\
  const Value val = getValueField(valOffset);\
  writer.writeValueField(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardDynamicSlotValue(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardDynamicSlotValue);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  uint32_t valOffset = reader.stubOffset();\
  const Value val = getValueField(valOffset);\
  writer.writeValueField(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNoAllocationMetadataBuilder(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNoAllocationMetadataBuilder);\
  uint32_t builderAddrOffset = reader.stubOffset();\
  const void* builderAddr = getRawPointerField(builderAddrOffset);\
  writer.writeRawPointerField(builderAddr);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionHasJitEntry(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionHasJitEntry);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  bool constructing = reader.readBool();\
  writer.writeBoolImm(constructing);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionHasNoJitEntry(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionHasNoJitEntry);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionIsNonBuiltinCtor(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionIsNonBuiltinCtor);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionIsConstructor(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionIsConstructor);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNotClassConstructor(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNotClassConstructor);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardArrayIsPacked(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardArrayIsPacked);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardArgumentsObjectFlags(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardArgumentsObjectFlags);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint8_t flags = reader.readByte();\
  writer.writeByteImm(flags);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadObject);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  uint32_t objOffset = reader.stubOffset();\
  JSObject* obj = getObjectField(objOffset);\
  writer.writeObjectField(obj);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadProto(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadProto);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadEnclosingEnvironment(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadEnclosingEnvironment);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadWrapperTarget(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadWrapperTarget);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadValueTag(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadValueTag);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  ValueTagOperandId resultId = reader.valueTagOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentFixedSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentFixedSlot);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  uint8_t slotIndex = reader.readByte();\
  writer.writeByteImm(slotIndex);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentDynamicSlot);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  uint8_t slotIndex = reader.readByte();\
  writer.writeByteImm(slotIndex);\
  writer.assertLengthMatches();\
}}\
\
void cloneTruncateDoubleToUInt32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TruncateDoubleToUInt32);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicLoadSlotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicLoadSlotResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t nameOffset = reader.stubOffset();\
  PropertyName* name = getPropertyNameField(nameOffset);\
  writer.writeStringField(name);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicLoadSlotByValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicLoadSlotByValueResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicStoreSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicStoreSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t nameOffset = reader.stubOffset();\
  PropertyName* name = getPropertyNameField(nameOffset);\
  writer.writeStringField(name);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicSetElement(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicSetElement);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicHasPropResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicHasPropResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  bool hasOwn = reader.readBool();\
  writer.writeBoolImm(hasOwn);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDOMExpandoValue(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDOMExpandoValue);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDOMExpandoValueGuardGeneration(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDOMExpandoValueGuardGeneration);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t expandoAndGenerationOffset = reader.stubOffset();\
  const void* expandoAndGeneration = getRawPointerField(expandoAndGenerationOffset);\
  writer.writeRawPointerField(expandoAndGeneration);\
  uint32_t generationOffset = reader.stubOffset();\
  uint64_t generation = getRawInt64Field(generationOffset);\
  writer.writeRawInt64Field(generation);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDOMExpandoValueIgnoreGeneration(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDOMExpandoValueIgnoreGeneration);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardDOMExpandoMissingOrGuardShape(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardDOMExpandoMissingOrGuardShape);\
  ValOperandId expandoId = reader.valOperandId();\
  writer.writeOperandId(expandoId);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreFixedSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreFixedSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreDynamicSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneAddAndStoreFixedSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AddAndStoreFixedSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t newShapeOffset = reader.stubOffset();\
  Shape* newShape = getShapeField(newShapeOffset);\
  writer.writeShapeField(newShape);\
  writer.assertLengthMatches();\
}}\
\
void cloneAddAndStoreDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AddAndStoreDynamicSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t newShapeOffset = reader.stubOffset();\
  Shape* newShape = getShapeField(newShapeOffset);\
  writer.writeShapeField(newShape);\
  writer.assertLengthMatches();\
}}\
\
void cloneAllocateAndStoreDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AllocateAndStoreDynamicSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t newShapeOffset = reader.stubOffset();\
  Shape* newShape = getShapeField(newShapeOffset);\
  writer.writeShapeField(newShape);\
  uint32_t numNewSlotsOffset = reader.stubOffset();\
  uint32_t numNewSlots = getRawInt32Field(numNewSlotsOffset);\
  writer.writeRawInt32Field(numNewSlots);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreDenseElement(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreDenseElement);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreDenseElementHole(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreDenseElementHole);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool handleAdd = reader.readBool();\
  writer.writeBoolImm(handleAdd);\
  writer.assertLengthMatches();\
}}\
\
void cloneArrayPush(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArrayPush);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneArrayJoinResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArrayJoinResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  StringOperandId sepId = reader.stringOperandId();\
  writer.writeOperandId(sepId);\
  writer.assertLengthMatches();\
}}\
\
void clonePackedArrayPopResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::PackedArrayPopResult);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  writer.assertLengthMatches();\
}}\
\
void clonePackedArrayShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::PackedArrayShiftResult);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  writer.assertLengthMatches();\
}}\
\
void clonePackedArraySliceResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::PackedArraySliceResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  Int32OperandId beginId = reader.int32OperandId();\
  writer.writeOperandId(beginId);\
  Int32OperandId endId = reader.int32OperandId();\
  writer.writeOperandId(endId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsArrayResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreFixedSlotUndefinedResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreFixedSlotUndefinedResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsObjectResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsPackedArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsPackedArrayResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsCallableResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsCallableResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsConstructorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsConstructorResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsCrossRealmArrayConstructorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsCrossRealmArrayConstructorResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsTypedArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsTypedArrayResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  bool isPossiblyWrapped = reader.readBool();\
  writer.writeBoolImm(isPossiblyWrapped);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsTypedArrayConstructorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsTypedArrayConstructorResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneArrayBufferViewByteOffsetInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArrayBufferViewByteOffsetInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneArrayBufferViewByteOffsetDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArrayBufferViewByteOffsetDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneTypedArrayByteLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TypedArrayByteLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneTypedArrayByteLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TypedArrayByteLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneTypedArrayElementSizeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TypedArrayElementSizeResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardHasAttachedArrayBuffer(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardHasAttachedArrayBuffer);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneFinishBoundFunctionInitResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::FinishBoundFunctionInitResult);\
  ObjOperandId boundId = reader.objOperandId();\
  writer.writeOperandId(boundId);\
  ObjOperandId targetId = reader.objOperandId();\
  writer.writeOperandId(targetId);\
  Int32OperandId argCountId = reader.int32OperandId();\
  writer.writeOperandId(argCountId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewArrayIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewArrayIteratorResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewStringIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewStringIteratorResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewRegExpStringIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewRegExpStringIteratorResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneObjectCreateResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ObjectCreateResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewArrayFromLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewArrayFromLengthResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  Int32OperandId lengthId = reader.int32OperandId();\
  writer.writeOperandId(lengthId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewTypedArrayFromLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewTypedArrayFromLengthResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  Int32OperandId lengthId = reader.int32OperandId();\
  writer.writeOperandId(lengthId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewTypedArrayFromArrayBufferResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewTypedArrayFromArrayBufferResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ObjOperandId bufferId = reader.objOperandId();\
  writer.writeOperandId(bufferId);\
  ValOperandId byteOffsetId = reader.valOperandId();\
  writer.writeOperandId(byteOffsetId);\
  ValOperandId lengthId = reader.valOperandId();\
  writer.writeOperandId(lengthId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewTypedArrayFromArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewTypedArrayFromArrayResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewStringObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewStringObjectResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringFromCharCodeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringFromCharCodeResult);\
  Int32OperandId codeId = reader.int32OperandId();\
  writer.writeOperandId(codeId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringFromCodePointResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringFromCodePointResult);\
  Int32OperandId codeId = reader.int32OperandId();\
  writer.writeOperandId(codeId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringToLowerCaseResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringToLowerCaseResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringToUpperCaseResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringToUpperCaseResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathAbsInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathAbsInt32Result);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathAbsNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathAbsNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathClz32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathClz32Result);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathSignInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathSignInt32Result);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathSignNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathSignNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathSignNumberToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathSignNumberToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathImulResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathImulResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathSqrtNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathSqrtNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathFRoundNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathFRoundNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathRandomResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathRandomResult);\
  uint32_t rngOffset = reader.stubOffset();\
  const void* rng = getRawPointerField(rngOffset);\
  writer.writeRawPointerField(rng);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathHypot2NumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathHypot2NumberResult);\
  NumberOperandId firstId = reader.numberOperandId();\
  writer.writeOperandId(firstId);\
  NumberOperandId secondId = reader.numberOperandId();\
  writer.writeOperandId(secondId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathHypot3NumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathHypot3NumberResult);\
  NumberOperandId firstId = reader.numberOperandId();\
  writer.writeOperandId(firstId);\
  NumberOperandId secondId = reader.numberOperandId();\
  writer.writeOperandId(secondId);\
  NumberOperandId thirdId = reader.numberOperandId();\
  writer.writeOperandId(thirdId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathHypot4NumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathHypot4NumberResult);\
  NumberOperandId firstId = reader.numberOperandId();\
  writer.writeOperandId(firstId);\
  NumberOperandId secondId = reader.numberOperandId();\
  writer.writeOperandId(secondId);\
  NumberOperandId thirdId = reader.numberOperandId();\
  writer.writeOperandId(thirdId);\
  NumberOperandId fourthId = reader.numberOperandId();\
  writer.writeOperandId(fourthId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathAtan2NumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathAtan2NumberResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathFloorNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathFloorNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathCeilNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathCeilNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathTruncNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathTruncNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathFloorToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathFloorToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathCeilToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathCeilToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathTruncToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathTruncToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathRoundToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathRoundToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32MinMax(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32MinMax);\
  bool isMax = reader.readBool();\
  writer.writeBoolImm(isMax);\
  Int32OperandId firstId = reader.int32OperandId();\
  writer.writeOperandId(firstId);\
  Int32OperandId secondId = reader.int32OperandId();\
  writer.writeOperandId(secondId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNumberMinMax(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NumberMinMax);\
  bool isMax = reader.readBool();\
  writer.writeBoolImm(isMax);\
  NumberOperandId firstId = reader.numberOperandId();\
  writer.writeOperandId(firstId);\
  NumberOperandId secondId = reader.numberOperandId();\
  writer.writeOperandId(secondId);\
  NumberOperandId resultId = reader.numberOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32MinMaxArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32MinMaxArrayResult);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  bool isMax = reader.readBool();\
  writer.writeBoolImm(isMax);\
  writer.assertLengthMatches();\
}}\
\
void cloneNumberMinMaxArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NumberMinMaxArrayResult);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  bool isMax = reader.readBool();\
  writer.writeBoolImm(isMax);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathFunctionNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathFunctionNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  UnaryMathFunction fun = reader.unaryMathFunction();\
  writer.writeUnaryMathFunctionImm(fun);\
  writer.assertLengthMatches();\
}}\
\
void cloneObjectToStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ObjectToStringResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneReflectGetPrototypeOfResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ReflectGetPrototypeOfResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreTypedArrayElement(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreTypedArrayElement);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool handleOOB = reader.readBool();\
  writer.writeBoolImm(handleOOB);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsCompareExchangeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsCompareExchangeResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId expectedId = reader.valOperandId();\
  writer.writeOperandId(expectedId);\
  ValOperandId replacementId = reader.valOperandId();\
  writer.writeOperandId(replacementId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsExchangeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsExchangeResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsAddResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsAddResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsSubResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsSubResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsAndResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsAndResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsOrResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsOrResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsXorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsXorResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsLoadResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsLoadResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsStoreResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsStoreResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsIsLockFreeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsIsLockFreeResult);\
  Int32OperandId valueId = reader.int32OperandId();\
  writer.writeOperandId(valueId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNativeSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNativeSetter);\
  ObjOperandId receiverId = reader.objOperandId();\
  writer.writeOperandId(receiverId);\
  uint32_t setterOffset = reader.stubOffset();\
  JSObject* setter = getObjectField(setterOffset);\
  writer.writeObjectField(setter);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallScriptedSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallScriptedSetter);\
  ObjOperandId receiverId = reader.objOperandId();\
  writer.writeOperandId(receiverId);\
  uint32_t setterOffset = reader.stubOffset();\
  JSObject* setter = getObjectField(setterOffset);\
  writer.writeObjectField(setter);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallInlinedSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallInlinedSetter);\
  ObjOperandId receiverId = reader.objOperandId();\
  writer.writeOperandId(receiverId);\
  uint32_t setterOffset = reader.stubOffset();\
  JSObject* setter = getObjectField(setterOffset);\
  writer.writeObjectField(setter);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t icScriptOffset = reader.stubOffset();\
  const void* icScript = getRawPointerField(icScriptOffset);\
  writer.writeRawPointerField(icScript);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallDOMSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallDOMSetter);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t jitInfoOffset = reader.stubOffset();\
  const void* jitInfo = getRawPointerField(jitInfoOffset);\
  writer.writeRawPointerField(jitInfo);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallSetArrayLength(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallSetArrayLength);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxySet(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxySet);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t idOffset = reader.stubOffset();\
  jsid id = getIdField(idOffset);\
  writer.writeIdField(id);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxySetByValue(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxySetByValue);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallAddOrUpdateSparseElementHelper(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallAddOrUpdateSparseElementHelper);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId idId = reader.int32OperandId();\
  writer.writeOperandId(idId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallInt32ToString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallInt32ToString);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNumberToString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNumberToString);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBooleanToString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BooleanToString);\
  BooleanOperandId inputId = reader.booleanOperandId();\
  writer.writeOperandId(inputId);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallScriptedFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallScriptedFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallWasmFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallWasmFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t funcExportOffset = reader.stubOffset();\
  const void* funcExport = getRawPointerField(funcExportOffset);\
  writer.writeRawPointerField(funcExport);\
  uint32_t instanceOffset = reader.stubOffset();\
  JSObject* instance = getObjectField(instanceOffset);\
  writer.writeObjectField(instance);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardWasmArg(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardWasmArg);\
  ValOperandId argId = reader.valOperandId();\
  writer.writeOperandId(argId);\
  wasm::ValType::Kind type = reader.wasmValType();\
  writer.writeWasmValTypeImm(type);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNativeFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNativeFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  bool ignoresReturnValue = reader.readBool();\
  writer.writeBoolImm(ignoresReturnValue);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallDOMFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallDOMFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  ObjOperandId thisObjId = reader.objOperandId();\
  writer.writeOperandId(thisObjId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallClassHook(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallClassHook);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t targetOffset = reader.stubOffset();\
  const void* target = getRawPointerField(targetOffset);\
  writer.writeRawPointerField(target);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallInlinedFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallInlinedFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  uint32_t icScriptOffset = reader.stubOffset();\
  const void* icScript = getRawPointerField(icScriptOffset);\
  writer.writeRawPointerField(icScript);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  writer.assertLengthMatches();\
}}\
\
void cloneMetaTwoByte(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MetaTwoByte);\
  uint32_t functionObjectOffset = reader.stubOffset();\
  JSObject* functionObject = getObjectField(functionObjectOffset);\
  writer.writeObjectField(functionObject);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadFixedSlotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadFixedSlotResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadFixedSlotTypedResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadFixedSlotTypedResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValueType type = reader.valueType();\
  writer.writeValueTypeImm(type);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDynamicSlotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDynamicSlotResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDenseElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDenseElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDenseElementHoleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDenseElementHoleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallGetSparseElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallGetSparseElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDenseElementExistsResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDenseElementExistsResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadTypedArrayElementExistsResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadTypedArrayElementExistsResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDenseElementHoleExistsResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDenseElementHoleExistsResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadTypedArrayElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadTypedArrayElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool handleOOB = reader.readBool();\
  writer.writeBoolImm(handleOOB);\
  bool forceDoubleForUint32 = reader.readBool();\
  writer.writeBoolImm(forceDoubleForUint32);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDataViewValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDataViewValueResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  writer.writeOperandId(offsetId);\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  writer.writeOperandId(littleEndianId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forceDoubleForUint32 = reader.readBool();\
  writer.writeBoolImm(forceDoubleForUint32);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreDataViewValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreDataViewValueResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  writer.writeOperandId(offsetId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  writer.writeOperandId(littleEndianId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32ArrayLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32ArrayLengthResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32ArrayLength(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32ArrayLength);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentsObjectArgResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentsObjectArgResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentsObjectLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentsObjectLengthResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadFunctionLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadFunctionLengthResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadFunctionNameResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadFunctionNameResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArrayBufferByteLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArrayBufferByteLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArrayBufferByteLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArrayBufferByteLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArrayBufferViewLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArrayBufferViewLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArrayBufferViewLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArrayBufferViewLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringCharResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringCharResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringCharCodeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringCharCodeResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringLengthResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneFrameIsConstructingResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::FrameIsConstructingResult);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadEnvironmentFixedSlotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadEnvironmentFixedSlotResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadEnvironmentDynamicSlotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadEnvironmentDynamicSlotResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadObjectResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadSymbolResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadSymbolResult);\
  SymbolOperandId symId = reader.symbolOperandId();\
  writer.writeOperandId(symId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32Result);\
  Int32OperandId valId = reader.int32OperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDoubleResult);\
  NumberOperandId valId = reader.numberOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBigIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBigIntResult);\
  BigIntOperandId valId = reader.bigIntOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallScriptedGetterResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallScriptedGetterResult);\
  ValOperandId receiverId = reader.valOperandId();\
  writer.writeOperandId(receiverId);\
  uint32_t getterOffset = reader.stubOffset();\
  JSObject* getter = getObjectField(getterOffset);\
  writer.writeObjectField(getter);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallInlinedGetterResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallInlinedGetterResult);\
  ValOperandId receiverId = reader.valOperandId();\
  writer.writeOperandId(receiverId);\
  uint32_t getterOffset = reader.stubOffset();\
  JSObject* getter = getObjectField(getterOffset);\
  writer.writeObjectField(getter);\
  uint32_t icScriptOffset = reader.stubOffset();\
  const void* icScript = getRawPointerField(icScriptOffset);\
  writer.writeRawPointerField(icScript);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNativeGetterResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNativeGetterResult);\
  ValOperandId receiverId = reader.valOperandId();\
  writer.writeOperandId(receiverId);\
  uint32_t getterOffset = reader.stubOffset();\
  JSObject* getter = getObjectField(getterOffset);\
  writer.writeObjectField(getter);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallDOMGetterResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallDOMGetterResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t jitInfoOffset = reader.stubOffset();\
  const void* jitInfo = getRawPointerField(jitInfoOffset);\
  writer.writeRawPointerField(jitInfo);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxyGetResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxyGetResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t idOffset = reader.stubOffset();\
  jsid id = getIdField(idOffset);\
  writer.writeIdField(id);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxyGetByValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxyGetByValueResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxyHasPropResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxyHasPropResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  bool hasOwn = reader.readBool();\
  writer.writeBoolImm(hasOwn);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallObjectHasSparseElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallObjectHasSparseElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNativeGetElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNativeGetElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGetNextMapSetEntryForIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GetNextMapSetEntryForIteratorResult);\
  ObjOperandId iterId = reader.objOperandId();\
  writer.writeOperandId(iterId);\
  ObjOperandId resultArrId = reader.objOperandId();\
  writer.writeOperandId(resultArrId);\
  bool isMap = reader.readBool();\
  writer.writeBoolImm(isMap);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadUndefinedResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadUndefinedResult);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBooleanResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBooleanResult);\
  bool val = reader.readBool();\
  writer.writeBoolImm(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32Constant(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32Constant);\
  uint32_t valOffset = reader.stubOffset();\
  uint32_t val = getRawInt32Field(valOffset);\
  writer.writeRawInt32Field(val);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBooleanConstant(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBooleanConstant);\
  bool val = reader.readBool();\
  writer.writeBoolImm(val);\
  BooleanOperandId resultId = reader.booleanOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadUndefined(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadUndefined);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadConstantString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadConstantString);\
  uint32_t strOffset = reader.stubOffset();\
  JSString* str = getStringField(strOffset);\
  writer.writeStringField(str);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadConstantStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadConstantStringResult);\
  uint32_t strOffset = reader.stubOffset();\
  JSString* str = getStringField(strOffset);\
  writer.writeStringField(str);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInstanceOfObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInstanceOfObjectResult);\
  ValOperandId lhsId = reader.valOperandId();\
  writer.writeOperandId(lhsId);\
  ObjOperandId protoId = reader.objOperandId();\
  writer.writeOperandId(protoId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadTypeOfObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadTypeOfObjectResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleAddResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleAddResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleSubResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleSubResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleMulResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleMulResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleDivResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleDivResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleModResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleModResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoublePowResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoublePowResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32AddResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32AddResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32SubResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32SubResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32MulResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32MulResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32DivResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32DivResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32ModResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32ModResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32PowResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32PowResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntAddResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntAddResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntSubResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntSubResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntMulResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntMulResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntDivResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntDivResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntModResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntModResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPowResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPowResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32BitOrResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32BitOrResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32BitXorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32BitXorResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32BitAndResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32BitAndResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32LeftShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32LeftShiftResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32RightShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32RightShiftResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32URightShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32URightShiftResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  bool forceDouble = reader.readBool();\
  writer.writeBoolImm(forceDouble);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32NotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32NotResult);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntBitOrResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntBitOrResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntBitXorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntBitXorResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntBitAndResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntBitAndResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntLeftShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntLeftShiftResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntRightShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntRightShiftResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntNotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntNotResult);\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32NegationResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32NegationResult);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleNegationResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleNegationResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntNegationResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntNegationResult);\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32IncResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32IncResult);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32DecResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32DecResult);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleIncResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleIncResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleDecResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleDecResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntIncResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntIncResult);\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntDecResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntDecResult);\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32TruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32TruthyResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDoubleTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDoubleTruthyResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringTruthyResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadObjectTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadObjectTruthyResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBigIntTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBigIntTruthyResult);\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  writer.writeOperandId(bigIntId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadValueTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadValueTruthyResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadValueResult);\
  uint32_t valOffset = reader.stubOffset();\
  const Value val = getValueField(valOffset);\
  writer.writeValueField(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadOperandResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadOperandResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewPlainObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewPlainObjectResult);\
  uint32_t numFixedSlots = reader.uint32Immediate();\
  writer.writeUInt32Imm(numFixedSlots);\
  uint32_t numDynamicSlots = reader.uint32Immediate();\
  writer.writeUInt32Imm(numDynamicSlots);\
  gc::AllocKind allocKind = reader.allocKind();\
  writer.writeAllocKindImm(allocKind);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  uint32_t siteOffset = reader.stubOffset();\
  gc::AllocSite* site = getAllocSiteField(siteOffset);\
  writer.writeAllocSiteField(site);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewArrayObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewArrayObjectResult);\
  uint32_t arrayLength = reader.uint32Immediate();\
  writer.writeUInt32Imm(arrayLength);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  uint32_t siteOffset = reader.stubOffset();\
  gc::AllocSite* site = getAllocSiteField(siteOffset);\
  writer.writeAllocSiteField(site);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallStringConcatResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallStringConcatResult);\
  StringOperandId lhsId = reader.stringOperandId();\
  writer.writeOperandId(lhsId);\
  StringOperandId rhsId = reader.stringOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallStringObjectConcatResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallStringObjectConcatResult);\
  ValOperandId lhsId = reader.valOperandId();\
  writer.writeOperandId(lhsId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallIsSuspendedGeneratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallIsSuspendedGeneratorResult);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareStringResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  StringOperandId lhsId = reader.stringOperandId();\
  writer.writeOperandId(lhsId);\
  StringOperandId rhsId = reader.stringOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareObjectResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  ObjOperandId lhsId = reader.objOperandId();\
  writer.writeOperandId(lhsId);\
  ObjOperandId rhsId = reader.objOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareSymbolResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareSymbolResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  SymbolOperandId lhsId = reader.symbolOperandId();\
  writer.writeOperandId(lhsId);\
  SymbolOperandId rhsId = reader.symbolOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareInt32Result);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareDoubleResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareBigIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareBigIntResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareBigIntInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareBigIntInt32Result);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareBigIntNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareBigIntNumberResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareBigIntStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareBigIntStringResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  StringOperandId rhsId = reader.stringOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareNullUndefinedResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareNullUndefinedResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  bool isUndefined = reader.readBool();\
  writer.writeBoolImm(isUndefined);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareDoubleSameValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareDoubleSameValueResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSameValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SameValueResult);\
  ValOperandId lhsId = reader.valOperandId();\
  writer.writeOperandId(lhsId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIndirectTruncateInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IndirectTruncateInt32Result);\
  Int32OperandId valId = reader.int32OperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntAsIntNResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntAsIntNResult);\
  Int32OperandId bitsId = reader.int32OperandId();\
  writer.writeOperandId(bitsId);\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  writer.writeOperandId(bigIntId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntAsUintNResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntAsUintNResult);\
  Int32OperandId bitsId = reader.int32OperandId();\
  writer.writeOperandId(bitsId);\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  writer.writeOperandId(bigIntId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallPrintString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallPrintString);\
  const char* str = reinterpret_cast<char*>(reader.pointer());\
  writer.writeStaticStringImm(str);\
  writer.assertLengthMatches();\
}}\
\
void cloneBreakpoint(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Breakpoint);\
  writer.assertLengthMatches();\
}}\
\
void cloneWrapResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::WrapResult);\
  writer.assertLengthMatches();\
}}\
\
void cloneBailout(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Bailout);\
  writer.assertLengthMatches();\
}}\
\
void cloneAssertRecoveredOnBailoutResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AssertRecoveredOnBailoutResult);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  bool mustBeRecovered = reader.readBool();\
  writer.writeBoolImm(mustBeRecovered);\
  writer.assertLengthMatches();\
}}\




#endif // jit_CacheIROpsGenerated_h
