/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated by hand from a subset of NIST ike sample CAVs test */

#ifndef ike_sha512_vectors_h__
#define ike_sha512_vectors_h__

#include "testvectors_base/test-structs.h"

const IkeTestVector kIkeSha512ProofVectors[] = {
    // these vectors are from this NIST samples
    {1, IkeTestType::ikeGxy,
     "b15a9cfce8c8d7eab879d6243029d40188d3b740875a6ac62f56cac4377e2edd", "", "",
     "f05aa036dfce45a558d40418dea98096e519bc7841e3db3dd93658d118c3e83b502f398ec"
     "b1361ec77d38a8855efff407f6f772e5d65b58eb1134096e8478d2b",
     "acadc6314a69cfcd", "4e4ad17718fea7ce", "", 0, 0, true},
    {2, IkeTestType::ikeV1,
     "f05aa036dfce45a558d40418dea98096e519bc7841e3db3dd93658d118c3e83b502f398ec"
     "b1361ec77d38a8855efff407f6f772e5d65b58eb1134096e8478d2b",
     "b15a9cfce8c8d7eab879d6243029d40188d3b740875a6ac62f56cac4377e2edd", "",
     "3c4be16a631aa49018fa6740745a61ab1f1a2455a96e91f159a134ccfe30303d687216961"
     "95e95bfd530510ef2f9532491878710944db7854f00ad13c68fca01",
     "1ff4d76565b3151a", "1f11b8eb20d57a16", "", 0, 0, true},
    {3, IkeTestType::ikeV1,
     "f05aa036dfce45a558d40418dea98096e519bc7841e3db3dd93658d118c3e83b502f398ec"
     "b1361ec77d38a8855efff407f6f772e5d65b58eb1134096e8478d2b",
     "b15a9cfce8c8d7eab879d6243029d40188d3b740875a6ac62f56cac4377e2edd",
     "3c4be16a631aa49018fa6740745a61ab1f1a2455a96e91f159a134ccfe30303d687216961"
     "95e95bfd530510ef2f9532491878710944db7854f00ad13c68fca01",
     "15ecf5c80b675585e10c4388f6f9c37e8b63269a0a99851f08ba617e28c561f43eaf41122"
     "23ff97525bf0b3897f514fce7a3acee10a61ae088c01efc5f643587",
     "1ff4d76565b3151a", "1f11b8eb20d57a16", "", 1, 0, true},
    {4, IkeTestType::ikeV1,
     "f05aa036dfce45a558d40418dea98096e519bc7841e3db3dd93658d118c3e83b502f398ec"
     "b1361ec77d38a8855efff407f6f772e5d65b58eb1134096e8478d2b",
     "b15a9cfce8c8d7eab879d6243029d40188d3b740875a6ac62f56cac4377e2edd",
     "15ecf5c80b675585e10c4388f6f9c37e8b63269a0a99851f08ba617e28c561f43eaf41122"
     "23ff97525bf0b3897f514fce7a3acee10a61ae088c01efc5f643587",
     "60f6b6c10c2b6bedc085ad6546d993c9ce1f86918d1c935c89d6631170a5dab0e37298f21"
     "ca3b7901a53bde55a15fad39f782039ce26fc8c2ba8cbd9d4287669",
     "1ff4d76565b3151a", "1f11b8eb20d57a16", "", 2, 0, true},
    {5, IkeTestType::ikeV1Psk, "4c", "", "",
     "5bcb5499ae4c1437ce6c195392bf26bf7980a59bcb787a0b58671771a3d4b06dc1eb78092"
     "41b7e5931740b05bf8a9873bb493c5f067e28e4f58ab65c3dbe44cd",
     "482a05eca86fba51", "84ee19d02272de2e", "", 0, 0, true},
    {6, IkeTestType::ikeGxy,
     "276255c3eaace5c6db32b609aa86c0ef07bba4bf2dc4c262995efd95ca607c3f", "", "",
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "97c41a9b0a03e74c", "a659fd06e1746600", "", 0, 0, true},
    {7, IkeTestType::ikeV2Rekey,
     "22259105314717dc73c210919ee9cb3ded774dc087e866aa3960404c0ed7b8e78e79b9938"
     "88388e2e5cb238d4bfcb4cdee9da074a26e329d6c2f2f660cc9c711",
     "bb4015f7727b35532021336a9e4a6370ac8729b01fbb8f15d52236820fac4709", "",
     "ecdaf3ccb990abc898a453b03fd56f9975275f150e1e571b0560b3cb2ee67289e82b899cd"
     "c2129fd821fe8aebea796f190765c25798f5883f923526551f16a4b",
     "97c41a9b0a03e74c", "a659fd06e1746600", "", 0, 0, true},
    {8, IkeTestType::ikePlus,
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "",
     "22259105314717dc73c210919ee9cb3ded774dc087e866aa3960404c0ed7b8e78e79b9938"
     "88388e2e5cb238d4bfcb4cdee9da074a26e329d6c2f2f660cc9c711c941a2fb3d85a2e5d0"
     "1e579c8f2c9d00fa6fabe76a137b00c7ff1b291899906588c26f073d819063238c4c844f0"
     "f8d221b65b76dbc9ed6f6368e5dba86b3e81b60eb44a1",
     "", "",
     // seed_data is Ni || Nr || SPIi || SPIr
     // NOTE: there is no comma so the strings are concatenated together.
     "97c41a9b0a03e74c"   // Ni
     "a659fd06e1746600"   // Nr
     "ff43c5c689b95481"   // SPIi
     "e2ba607f30079bb7",  // SPIr
     0, 132, true},
    {9, IkeTestType::ikePlus,
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "",
     "22259105314717dc73c210919ee9cb3ded774dc087e866aa3960404c0ed7b8e78e79b9938"
     "88388e2e5cb238d4bfcb4cdee9da074a26e329d6c2f2f660cc9c711",
     "", "",
     // seed_data is Ni || Nr || SPIi || SPIr
     // NOTE: there is no comma so the strings are concatenated together.
     "97c41a9b0a03e74c"   // Ni
     "a659fd06e1746600"   // Nr
     "ff43c5c689b95481"   // SPIi
     "e2ba607f30079bb7",  // SPIr
     0, 64, true},
    {10, IkeTestType::ikePlus,
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "", "22259105314717dc73c210919ee9cb", "", "",
     // seed_data is Ni || Nr || SPIi || SPIr
     // NOTE: there is no comma so the strings are concatenated together.
     "97c41a9b0a03e74c"   // Ni
     "a659fd06e1746600"   // Nr
     "ff43c5c689b95481"   // SPIi
     "e2ba607f30079bb7",  // SPIr
     0, 15, true},
    // These vectors are self-generated
    {11, IkeTestType::ikeV1AppB,
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "",
     "05e3de273d8a611667894a8aed01bb41984f18dc539028fa0f5252e6f05e15891faa75dfd"
     "c1f76b745d34a4820b0068efa93c176f8cd00a7ed5745d6cffe78a76603cdcf2ebb482b12"
     "c8fddbaf942827891b7c423b6a3675ec62e2dcf92e96eb743ae58cfd7bf188a142626ea5c"
     "15325c1862fffc3889fc38e379f68552556c2232de5fb",
     "", "", "", 0, 132, true},
    {12, IkeTestType::ikeV1AppB,
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "",
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "", "", 0, 64, true},
    {13, IkeTestType::ikeV1AppB,
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "", "d6e74966b75fd2afab48be319d63d9", "", "", "", 0, 15, true},
    {14, IkeTestType::ikeV1AppBQuick,
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "",
     "05e3de273d8a611667894a8aed01bb41984f18dc539028fa0f5252e6f05e15891faa75dfd"
     "c1f76b745d34a4820b0068efa93c176f8cd00a7ed5745d6cffe78a71de07d41ab9eb3fef7"
     "64886c6edd39b32bc05943b089adda8ceed3de5160c936600e4b171a96172569fc4410f0d"
     "d913bfa9719cb368ffedd78d78a404749ca03c16e72c8",
     "", "", "0", 0, 132, true},
    {15, IkeTestType::ikeV1AppBQuick,
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "",
     "05e3de273d8a611667894a8aed01bb41984f18dc539028fa0f5252e6f05e15891faa75dfd"
     "c1f76b745d34a4820b0068efa93c176f8cd00a7ed5745d6cffe78a7",
     "", "", "0", 0, 64, true},
    {16, IkeTestType::ikeV1AppBQuick,
     "d6e74966b75fd2afab48be319d63d97c8a5d2ffe2e320763a462c664b36c3a944067d867c"
     "3a55fd8a7e5cca64b22e24415987e15549f09a81b455adaa5303df8",
     "", "", "05e3de273d8a611667894a8aed01bb", "", "", "0", 0, 15, true},
};

#endif  // ike_sha512_vectors_h__
