const neg = @import("negXi2.zig");
const testing = @import("std").testing;

fn test__negti2(a: i128, expected: i128) !void {
    const result = neg.__negti2(a);
    try testing.expectEqual(expected, result);
}

test "negti2" {
    // TODO ensuring that math.minInt(i128); returns error

    try test__negti2(-3, 3);
    try test__negti2(-2, 2);
    try test__negti2(-1, 1);
    try test__negti2(0, 0); // special case for 2s complement
    try test__negti2(1, -1);
    try test__negti2(2, -2);
    try test__negti2(3, -3);

    // max_usable == MAX(i32) == -MIN(i32)
    // == 170141183460469231731687303715884105727
    // == 7fffffffffffffffffffffffffffffff
    // divTrunc: max_usable / i, i=1,2,3,5,100
    // 7fffffffffffffffffffffffffffffff / i
    try test__negti2(-56713727820156410577229101238628035242, 56713727820156410577229101238628035242);
    try test__negti2(56713727820156410577229101238628035242, -56713727820156410577229101238628035242);
    try test__negti2(-34028236692093846346337460743176821145, 34028236692093846346337460743176821145);
    try test__negti2(34028236692093846346337460743176821145, -34028236692093846346337460743176821145);
    try test__negti2(-17014118346046923173168730371588410572, 17014118346046923173168730371588410572);
    try test__negti2(17014118346046923173168730371588410572, -17014118346046923173168730371588410572);
    // shifting: max_usable >> i, i=0..bitsize-4
    // 7fffffffffffffffffffffffffffffff >> i
    // 7fffffffffffffffffffffffffffffff >> i + 1
    // 7fffffffffffffffffffffffffffffff >> i + 3
    // 7fffffffffffffffffffffffffffffff >> i + 7
    try test__negti2(-170141183460469231731687303715884105727, 170141183460469231731687303715884105727);
    try test__negti2(170141183460469231731687303715884105727, -170141183460469231731687303715884105727);
    try test__negti2(-170141183460469231731687303715884105726, 170141183460469231731687303715884105726);
    try test__negti2(170141183460469231731687303715884105726, -170141183460469231731687303715884105726);
    try test__negti2(-170141183460469231731687303715884105724, 170141183460469231731687303715884105724);
    try test__negti2(170141183460469231731687303715884105724, -170141183460469231731687303715884105724);
    try test__negti2(-170141183460469231731687303715884105720, 170141183460469231731687303715884105720);
    try test__negti2(170141183460469231731687303715884105720, -170141183460469231731687303715884105720);
    try test__negti2(-85070591730234615865843651857942052863, 85070591730234615865843651857942052863);
    try test__negti2(85070591730234615865843651857942052863, -85070591730234615865843651857942052863);
    try test__negti2(-85070591730234615865843651857942052862, 85070591730234615865843651857942052862);
    try test__negti2(85070591730234615865843651857942052862, -85070591730234615865843651857942052862);
    try test__negti2(-85070591730234615865843651857942052860, 85070591730234615865843651857942052860);
    try test__negti2(85070591730234615865843651857942052860, -85070591730234615865843651857942052860);
    try test__negti2(-85070591730234615865843651857942052856, 85070591730234615865843651857942052856);
    try test__negti2(85070591730234615865843651857942052856, -85070591730234615865843651857942052856);
    try test__negti2(-42535295865117307932921825928971026431, 42535295865117307932921825928971026431);
    try test__negti2(42535295865117307932921825928971026431, -42535295865117307932921825928971026431);
    try test__negti2(-42535295865117307932921825928971026430, 42535295865117307932921825928971026430);
    try test__negti2(42535295865117307932921825928971026430, -42535295865117307932921825928971026430);
    try test__negti2(-42535295865117307932921825928971026428, 42535295865117307932921825928971026428);
    try test__negti2(42535295865117307932921825928971026428, -42535295865117307932921825928971026428);
    try test__negti2(-42535295865117307932921825928971026424, 42535295865117307932921825928971026424);
    try test__negti2(42535295865117307932921825928971026424, -42535295865117307932921825928971026424);
    try test__negti2(-21267647932558653966460912964485513215, 21267647932558653966460912964485513215);
    try test__negti2(21267647932558653966460912964485513215, -21267647932558653966460912964485513215);
    try test__negti2(-21267647932558653966460912964485513214, 21267647932558653966460912964485513214);
    try test__negti2(21267647932558653966460912964485513214, -21267647932558653966460912964485513214);
    try test__negti2(-21267647932558653966460912964485513212, 21267647932558653966460912964485513212);
    try test__negti2(21267647932558653966460912964485513212, -21267647932558653966460912964485513212);
    try test__negti2(-21267647932558653966460912964485513208, 21267647932558653966460912964485513208);
    try test__negti2(21267647932558653966460912964485513208, -21267647932558653966460912964485513208);
    try test__negti2(-10633823966279326983230456482242756607, 10633823966279326983230456482242756607);
    try test__negti2(10633823966279326983230456482242756607, -10633823966279326983230456482242756607);
    try test__negti2(-10633823966279326983230456482242756606, 10633823966279326983230456482242756606);
    try test__negti2(10633823966279326983230456482242756606, -10633823966279326983230456482242756606);
    try test__negti2(-10633823966279326983230456482242756604, 10633823966279326983230456482242756604);
    try test__negti2(10633823966279326983230456482242756604, -10633823966279326983230456482242756604);
    try test__negti2(-10633823966279326983230456482242756600, 10633823966279326983230456482242756600);
    try test__negti2(10633823966279326983230456482242756600, -10633823966279326983230456482242756600);
    try test__negti2(-5316911983139663491615228241121378303, 5316911983139663491615228241121378303);
    try test__negti2(5316911983139663491615228241121378303, -5316911983139663491615228241121378303);
    try test__negti2(-5316911983139663491615228241121378302, 5316911983139663491615228241121378302);
    try test__negti2(5316911983139663491615228241121378302, -5316911983139663491615228241121378302);
    try test__negti2(-5316911983139663491615228241121378300, 5316911983139663491615228241121378300);
    try test__negti2(5316911983139663491615228241121378300, -5316911983139663491615228241121378300);
    try test__negti2(-5316911983139663491615228241121378296, 5316911983139663491615228241121378296);
    try test__negti2(5316911983139663491615228241121378296, -5316911983139663491615228241121378296);
    try test__negti2(-2658455991569831745807614120560689151, 2658455991569831745807614120560689151);
    try test__negti2(2658455991569831745807614120560689151, -2658455991569831745807614120560689151);
    try test__negti2(-2658455991569831745807614120560689150, 2658455991569831745807614120560689150);
    try test__negti2(2658455991569831745807614120560689150, -2658455991569831745807614120560689150);
    try test__negti2(-2658455991569831745807614120560689148, 2658455991569831745807614120560689148);
    try test__negti2(2658455991569831745807614120560689148, -2658455991569831745807614120560689148);
    try test__negti2(-2658455991569831745807614120560689144, 2658455991569831745807614120560689144);
    try test__negti2(2658455991569831745807614120560689144, -2658455991569831745807614120560689144);
    try test__negti2(-1329227995784915872903807060280344575, 1329227995784915872903807060280344575);
    try test__negti2(1329227995784915872903807060280344575, -1329227995784915872903807060280344575);
    try test__negti2(-1329227995784915872903807060280344574, 1329227995784915872903807060280344574);
    try test__negti2(1329227995784915872903807060280344574, -1329227995784915872903807060280344574);
    try test__negti2(-1329227995784915872903807060280344572, 1329227995784915872903807060280344572);
    try test__negti2(1329227995784915872903807060280344572, -1329227995784915872903807060280344572);
    try test__negti2(-1329227995784915872903807060280344568, 1329227995784915872903807060280344568);
    try test__negti2(1329227995784915872903807060280344568, -1329227995784915872903807060280344568);
    try test__negti2(-664613997892457936451903530140172287, 664613997892457936451903530140172287);
    try test__negti2(664613997892457936451903530140172287, -664613997892457936451903530140172287);
    try test__negti2(-664613997892457936451903530140172286, 664613997892457936451903530140172286);
    try test__negti2(664613997892457936451903530140172286, -664613997892457936451903530140172286);
    try test__negti2(-664613997892457936451903530140172284, 664613997892457936451903530140172284);
    try test__negti2(664613997892457936451903530140172284, -664613997892457936451903530140172284);
    try test__negti2(-664613997892457936451903530140172280, 664613997892457936451903530140172280);
    try test__negti2(664613997892457936451903530140172280, -664613997892457936451903530140172280);
    try test__negti2(-332306998946228968225951765070086143, 332306998946228968225951765070086143);
    try test__negti2(332306998946228968225951765070086143, -332306998946228968225951765070086143);
    try test__negti2(-332306998946228968225951765070086142, 332306998946228968225951765070086142);
    try test__negti2(332306998946228968225951765070086142, -332306998946228968225951765070086142);
    try test__negti2(-332306998946228968225951765070086140, 332306998946228968225951765070086140);
    try test__negti2(332306998946228968225951765070086140, -332306998946228968225951765070086140);
    try test__negti2(-332306998946228968225951765070086136, 332306998946228968225951765070086136);
    try test__negti2(332306998946228968225951765070086136, -332306998946228968225951765070086136);
    try test__negti2(-166153499473114484112975882535043071, 166153499473114484112975882535043071);
    try test__negti2(166153499473114484112975882535043071, -166153499473114484112975882535043071);
    try test__negti2(-166153499473114484112975882535043070, 166153499473114484112975882535043070);
    try test__negti2(166153499473114484112975882535043070, -166153499473114484112975882535043070);
    try test__negti2(-166153499473114484112975882535043068, 166153499473114484112975882535043068);
    try test__negti2(166153499473114484112975882535043068, -166153499473114484112975882535043068);
    try test__negti2(-166153499473114484112975882535043064, 166153499473114484112975882535043064);
    try test__negti2(166153499473114484112975882535043064, -166153499473114484112975882535043064);
    try test__negti2(-83076749736557242056487941267521535, 83076749736557242056487941267521535);
    try test__negti2(83076749736557242056487941267521535, -83076749736557242056487941267521535);
    try test__negti2(-83076749736557242056487941267521534, 83076749736557242056487941267521534);
    try test__negti2(83076749736557242056487941267521534, -83076749736557242056487941267521534);
    try test__negti2(-83076749736557242056487941267521532, 83076749736557242056487941267521532);
    try test__negti2(83076749736557242056487941267521532, -83076749736557242056487941267521532);
    try test__negti2(-83076749736557242056487941267521528, 83076749736557242056487941267521528);
    try test__negti2(83076749736557242056487941267521528, -83076749736557242056487941267521528);
    try test__negti2(-41538374868278621028243970633760767, 41538374868278621028243970633760767);
    try test__negti2(41538374868278621028243970633760767, -41538374868278621028243970633760767);
    try test__negti2(-41538374868278621028243970633760766, 41538374868278621028243970633760766);
    try test__negti2(41538374868278621028243970633760766, -41538374868278621028243970633760766);
    try test__negti2(-41538374868278621028243970633760764, 41538374868278621028243970633760764);
    try test__negti2(41538374868278621028243970633760764, -41538374868278621028243970633760764);
    try test__negti2(-41538374868278621028243970633760760, 41538374868278621028243970633760760);
    try test__negti2(41538374868278621028243970633760760, -41538374868278621028243970633760760);
    try test__negti2(-20769187434139310514121985316880383, 20769187434139310514121985316880383);
    try test__negti2(20769187434139310514121985316880383, -20769187434139310514121985316880383);
    try test__negti2(-20769187434139310514121985316880382, 20769187434139310514121985316880382);
    try test__negti2(20769187434139310514121985316880382, -20769187434139310514121985316880382);
    try test__negti2(-20769187434139310514121985316880380, 20769187434139310514121985316880380);
    try test__negti2(20769187434139310514121985316880380, -20769187434139310514121985316880380);
    try test__negti2(-20769187434139310514121985316880376, 20769187434139310514121985316880376);
    try test__negti2(20769187434139310514121985316880376, -20769187434139310514121985316880376);
    try test__negti2(-10384593717069655257060992658440191, 10384593717069655257060992658440191);
    try test__negti2(10384593717069655257060992658440191, -10384593717069655257060992658440191);
    try test__negti2(-10384593717069655257060992658440190, 10384593717069655257060992658440190);
    try test__negti2(10384593717069655257060992658440190, -10384593717069655257060992658440190);
    try test__negti2(-10384593717069655257060992658440188, 10384593717069655257060992658440188);
    try test__negti2(10384593717069655257060992658440188, -10384593717069655257060992658440188);
    try test__negti2(-10384593717069655257060992658440184, 10384593717069655257060992658440184);
    try test__negti2(10384593717069655257060992658440184, -10384593717069655257060992658440184);
    try test__negti2(-5192296858534827628530496329220095, 5192296858534827628530496329220095);
    try test__negti2(5192296858534827628530496329220095, -5192296858534827628530496329220095);
    try test__negti2(-5192296858534827628530496329220094, 5192296858534827628530496329220094);
    try test__negti2(5192296858534827628530496329220094, -5192296858534827628530496329220094);
    try test__negti2(-5192296858534827628530496329220092, 5192296858534827628530496329220092);
    try test__negti2(5192296858534827628530496329220092, -5192296858534827628530496329220092);
    try test__negti2(-5192296858534827628530496329220088, 5192296858534827628530496329220088);
    try test__negti2(5192296858534827628530496329220088, -5192296858534827628530496329220088);
    try test__negti2(-2596148429267413814265248164610047, 2596148429267413814265248164610047);
    try test__negti2(2596148429267413814265248164610047, -2596148429267413814265248164610047);
    try test__negti2(-2596148429267413814265248164610046, 2596148429267413814265248164610046);
    try test__negti2(2596148429267413814265248164610046, -2596148429267413814265248164610046);
    try test__negti2(-2596148429267413814265248164610044, 2596148429267413814265248164610044);
    try test__negti2(2596148429267413814265248164610044, -2596148429267413814265248164610044);
    try test__negti2(-2596148429267413814265248164610040, 2596148429267413814265248164610040);
    try test__negti2(2596148429267413814265248164610040, -2596148429267413814265248164610040);
    try test__negti2(-1298074214633706907132624082305023, 1298074214633706907132624082305023);
    try test__negti2(1298074214633706907132624082305023, -1298074214633706907132624082305023);
    try test__negti2(-1298074214633706907132624082305022, 1298074214633706907132624082305022);
    try test__negti2(1298074214633706907132624082305022, -1298074214633706907132624082305022);
    try test__negti2(-1298074214633706907132624082305020, 1298074214633706907132624082305020);
    try test__negti2(1298074214633706907132624082305020, -1298074214633706907132624082305020);
    try test__negti2(-1298074214633706907132624082305016, 1298074214633706907132624082305016);
    try test__negti2(1298074214633706907132624082305016, -1298074214633706907132624082305016);
    try test__negti2(-649037107316853453566312041152511, 649037107316853453566312041152511);
    try test__negti2(649037107316853453566312041152511, -649037107316853453566312041152511);
    try test__negti2(-649037107316853453566312041152510, 649037107316853453566312041152510);
    try test__negti2(649037107316853453566312041152510, -649037107316853453566312041152510);
    try test__negti2(-649037107316853453566312041152508, 649037107316853453566312041152508);
    try test__negti2(649037107316853453566312041152508, -649037107316853453566312041152508);
    try test__negti2(-649037107316853453566312041152504, 649037107316853453566312041152504);
    try test__negti2(649037107316853453566312041152504, -649037107316853453566312041152504);
    try test__negti2(-324518553658426726783156020576255, 324518553658426726783156020576255);
    try test__negti2(324518553658426726783156020576255, -324518553658426726783156020576255);
    try test__negti2(-324518553658426726783156020576254, 324518553658426726783156020576254);
    try test__negti2(324518553658426726783156020576254, -324518553658426726783156020576254);
    try test__negti2(-324518553658426726783156020576252, 324518553658426726783156020576252);
    try test__negti2(324518553658426726783156020576252, -324518553658426726783156020576252);
    try test__negti2(-324518553658426726783156020576248, 324518553658426726783156020576248);
    try test__negti2(324518553658426726783156020576248, -324518553658426726783156020576248);
    try test__negti2(-162259276829213363391578010288127, 162259276829213363391578010288127);
    try test__negti2(162259276829213363391578010288127, -162259276829213363391578010288127);
    try test__negti2(-162259276829213363391578010288126, 162259276829213363391578010288126);
    try test__negti2(162259276829213363391578010288126, -162259276829213363391578010288126);
    try test__negti2(-162259276829213363391578010288124, 162259276829213363391578010288124);
    try test__negti2(162259276829213363391578010288124, -162259276829213363391578010288124);
    try test__negti2(-162259276829213363391578010288120, 162259276829213363391578010288120);
    try test__negti2(162259276829213363391578010288120, -162259276829213363391578010288120);
    try test__negti2(-81129638414606681695789005144063, 81129638414606681695789005144063);
    try test__negti2(81129638414606681695789005144063, -81129638414606681695789005144063);
    try test__negti2(-81129638414606681695789005144062, 81129638414606681695789005144062);
    try test__negti2(81129638414606681695789005144062, -81129638414606681695789005144062);
    try test__negti2(-81129638414606681695789005144060, 81129638414606681695789005144060);
    try test__negti2(81129638414606681695789005144060, -81129638414606681695789005144060);
    try test__negti2(-81129638414606681695789005144056, 81129638414606681695789005144056);
    try test__negti2(81129638414606681695789005144056, -81129638414606681695789005144056);
    try test__negti2(-40564819207303340847894502572031, 40564819207303340847894502572031);
    try test__negti2(40564819207303340847894502572031, -40564819207303340847894502572031);
    try test__negti2(-40564819207303340847894502572030, 40564819207303340847894502572030);
    try test__negti2(40564819207303340847894502572030, -40564819207303340847894502572030);
    try test__negti2(-40564819207303340847894502572028, 40564819207303340847894502572028);
    try test__negti2(40564819207303340847894502572028, -40564819207303340847894502572028);
    try test__negti2(-40564819207303340847894502572024, 40564819207303340847894502572024);
    try test__negti2(40564819207303340847894502572024, -40564819207303340847894502572024);
    try test__negti2(-20282409603651670423947251286015, 20282409603651670423947251286015);
    try test__negti2(20282409603651670423947251286015, -20282409603651670423947251286015);
    try test__negti2(-20282409603651670423947251286014, 20282409603651670423947251286014);
    try test__negti2(20282409603651670423947251286014, -20282409603651670423947251286014);
    try test__negti2(-20282409603651670423947251286012, 20282409603651670423947251286012);
    try test__negti2(20282409603651670423947251286012, -20282409603651670423947251286012);
    try test__negti2(-20282409603651670423947251286008, 20282409603651670423947251286008);
    try test__negti2(20282409603651670423947251286008, -20282409603651670423947251286008);
    try test__negti2(-10141204801825835211973625643007, 10141204801825835211973625643007);
    try test__negti2(10141204801825835211973625643007, -10141204801825835211973625643007);
    try test__negti2(-10141204801825835211973625643006, 10141204801825835211973625643006);
    try test__negti2(10141204801825835211973625643006, -10141204801825835211973625643006);
    try test__negti2(-10141204801825835211973625643004, 10141204801825835211973625643004);
    try test__negti2(10141204801825835211973625643004, -10141204801825835211973625643004);
    try test__negti2(-10141204801825835211973625643000, 10141204801825835211973625643000);
    try test__negti2(10141204801825835211973625643000, -10141204801825835211973625643000);
    try test__negti2(-5070602400912917605986812821503, 5070602400912917605986812821503);
    try test__negti2(5070602400912917605986812821503, -5070602400912917605986812821503);
    try test__negti2(-5070602400912917605986812821502, 5070602400912917605986812821502);
    try test__negti2(5070602400912917605986812821502, -5070602400912917605986812821502);
    try test__negti2(-5070602400912917605986812821500, 5070602400912917605986812821500);
    try test__negti2(5070602400912917605986812821500, -5070602400912917605986812821500);
    try test__negti2(-5070602400912917605986812821496, 5070602400912917605986812821496);
    try test__negti2(5070602400912917605986812821496, -5070602400912917605986812821496);
    try test__negti2(-2535301200456458802993406410751, 2535301200456458802993406410751);
    try test__negti2(2535301200456458802993406410751, -2535301200456458802993406410751);
    try test__negti2(-2535301200456458802993406410750, 2535301200456458802993406410750);
    try test__negti2(2535301200456458802993406410750, -2535301200456458802993406410750);
    try test__negti2(-2535301200456458802993406410748, 2535301200456458802993406410748);
    try test__negti2(2535301200456458802993406410748, -2535301200456458802993406410748);
    try test__negti2(-2535301200456458802993406410744, 2535301200456458802993406410744);
    try test__negti2(2535301200456458802993406410744, -2535301200456458802993406410744);
    try test__negti2(-1267650600228229401496703205375, 1267650600228229401496703205375);
    try test__negti2(1267650600228229401496703205375, -1267650600228229401496703205375);
    try test__negti2(-1267650600228229401496703205374, 1267650600228229401496703205374);
    try test__negti2(1267650600228229401496703205374, -1267650600228229401496703205374);
    try test__negti2(-1267650600228229401496703205372, 1267650600228229401496703205372);
    try test__negti2(1267650600228229401496703205372, -1267650600228229401496703205372);
    try test__negti2(-1267650600228229401496703205368, 1267650600228229401496703205368);
    try test__negti2(1267650600228229401496703205368, -1267650600228229401496703205368);
    try test__negti2(-633825300114114700748351602687, 633825300114114700748351602687);
    try test__negti2(633825300114114700748351602687, -633825300114114700748351602687);
    try test__negti2(-633825300114114700748351602686, 633825300114114700748351602686);
    try test__negti2(633825300114114700748351602686, -633825300114114700748351602686);
    try test__negti2(-633825300114114700748351602684, 633825300114114700748351602684);
    try test__negti2(633825300114114700748351602684, -633825300114114700748351602684);
    try test__negti2(-633825300114114700748351602680, 633825300114114700748351602680);
    try test__negti2(633825300114114700748351602680, -633825300114114700748351602680);
    try test__negti2(-316912650057057350374175801343, 316912650057057350374175801343);
    try test__negti2(316912650057057350374175801343, -316912650057057350374175801343);
    try test__negti2(-316912650057057350374175801342, 316912650057057350374175801342);
    try test__negti2(316912650057057350374175801342, -316912650057057350374175801342);
    try test__negti2(-316912650057057350374175801340, 316912650057057350374175801340);
    try test__negti2(316912650057057350374175801340, -316912650057057350374175801340);
    try test__negti2(-316912650057057350374175801336, 316912650057057350374175801336);
    try test__negti2(316912650057057350374175801336, -316912650057057350374175801336);
    try test__negti2(-158456325028528675187087900671, 158456325028528675187087900671);
    try test__negti2(158456325028528675187087900671, -158456325028528675187087900671);
    try test__negti2(-158456325028528675187087900670, 158456325028528675187087900670);
    try test__negti2(158456325028528675187087900670, -158456325028528675187087900670);
    try test__negti2(-158456325028528675187087900668, 158456325028528675187087900668);
    try test__negti2(158456325028528675187087900668, -158456325028528675187087900668);
    try test__negti2(-158456325028528675187087900664, 158456325028528675187087900664);
    try test__negti2(158456325028528675187087900664, -158456325028528675187087900664);
    try test__negti2(-79228162514264337593543950335, 79228162514264337593543950335);
    try test__negti2(79228162514264337593543950335, -79228162514264337593543950335);
    try test__negti2(-79228162514264337593543950334, 79228162514264337593543950334);
    try test__negti2(79228162514264337593543950334, -79228162514264337593543950334);
    try test__negti2(-79228162514264337593543950332, 79228162514264337593543950332);
    try test__negti2(79228162514264337593543950332, -79228162514264337593543950332);
    try test__negti2(-79228162514264337593543950328, 79228162514264337593543950328);
    try test__negti2(79228162514264337593543950328, -79228162514264337593543950328);
    try test__negti2(-39614081257132168796771975167, 39614081257132168796771975167);
    try test__negti2(39614081257132168796771975167, -39614081257132168796771975167);
    try test__negti2(-39614081257132168796771975166, 39614081257132168796771975166);
    try test__negti2(39614081257132168796771975166, -39614081257132168796771975166);
    try test__negti2(-39614081257132168796771975164, 39614081257132168796771975164);
    try test__negti2(39614081257132168796771975164, -39614081257132168796771975164);
    try test__negti2(-39614081257132168796771975160, 39614081257132168796771975160);
    try test__negti2(39614081257132168796771975160, -39614081257132168796771975160);
    try test__negti2(-19807040628566084398385987583, 19807040628566084398385987583);
    try test__negti2(19807040628566084398385987583, -19807040628566084398385987583);
    try test__negti2(-19807040628566084398385987582, 19807040628566084398385987582);
    try test__negti2(19807040628566084398385987582, -19807040628566084398385987582);
    try test__negti2(-19807040628566084398385987580, 19807040628566084398385987580);
    try test__negti2(19807040628566084398385987580, -19807040628566084398385987580);
    try test__negti2(-19807040628566084398385987576, 19807040628566084398385987576);
    try test__negti2(19807040628566084398385987576, -19807040628566084398385987576);
    try test__negti2(-9903520314283042199192993791, 9903520314283042199192993791);
    try test__negti2(9903520314283042199192993791, -9903520314283042199192993791);
    try test__negti2(-9903520314283042199192993790, 9903520314283042199192993790);
    try test__negti2(9903520314283042199192993790, -9903520314283042199192993790);
    try test__negti2(-9903520314283042199192993788, 9903520314283042199192993788);
    try test__negti2(9903520314283042199192993788, -9903520314283042199192993788);
    try test__negti2(-9903520314283042199192993784, 9903520314283042199192993784);
    try test__negti2(9903520314283042199192993784, -9903520314283042199192993784);
    try test__negti2(-4951760157141521099596496895, 4951760157141521099596496895);
    try test__negti2(4951760157141521099596496895, -4951760157141521099596496895);
    try test__negti2(-4951760157141521099596496894, 4951760157141521099596496894);
    try test__negti2(4951760157141521099596496894, -4951760157141521099596496894);
    try test__negti2(-4951760157141521099596496892, 4951760157141521099596496892);
    try test__negti2(4951760157141521099596496892, -4951760157141521099596496892);
    try test__negti2(-4951760157141521099596496888, 4951760157141521099596496888);
    try test__negti2(4951760157141521099596496888, -4951760157141521099596496888);
    try test__negti2(-2475880078570760549798248447, 2475880078570760549798248447);
    try test__negti2(2475880078570760549798248447, -2475880078570760549798248447);
    try test__negti2(-2475880078570760549798248446, 2475880078570760549798248446);
    try test__negti2(2475880078570760549798248446, -2475880078570760549798248446);
    try test__negti2(-2475880078570760549798248444, 2475880078570760549798248444);
    try test__negti2(2475880078570760549798248444, -2475880078570760549798248444);
    try test__negti2(-2475880078570760549798248440, 2475880078570760549798248440);
    try test__negti2(2475880078570760549798248440, -2475880078570760549798248440);
    try test__negti2(-1237940039285380274899124223, 1237940039285380274899124223);
    try test__negti2(1237940039285380274899124223, -1237940039285380274899124223);
    try test__negti2(-1237940039285380274899124222, 1237940039285380274899124222);
    try test__negti2(1237940039285380274899124222, -1237940039285380274899124222);
    try test__negti2(-1237940039285380274899124220, 1237940039285380274899124220);
    try test__negti2(1237940039285380274899124220, -1237940039285380274899124220);
    try test__negti2(-1237940039285380274899124216, 1237940039285380274899124216);
    try test__negti2(1237940039285380274899124216, -1237940039285380274899124216);
    try test__negti2(-618970019642690137449562111, 618970019642690137449562111);
    try test__negti2(618970019642690137449562111, -618970019642690137449562111);
    try test__negti2(-618970019642690137449562110, 618970019642690137449562110);
    try test__negti2(618970019642690137449562110, -618970019642690137449562110);
    try test__negti2(-618970019642690137449562108, 618970019642690137449562108);
    try test__negti2(618970019642690137449562108, -618970019642690137449562108);
    try test__negti2(-618970019642690137449562104, 618970019642690137449562104);
    try test__negti2(618970019642690137449562104, -618970019642690137449562104);
    try test__negti2(-309485009821345068724781055, 309485009821345068724781055);
    try test__negti2(309485009821345068724781055, -309485009821345068724781055);
    try test__negti2(-309485009821345068724781054, 309485009821345068724781054);
    try test__negti2(309485009821345068724781054, -309485009821345068724781054);
    try test__negti2(-309485009821345068724781052, 309485009821345068724781052);
    try test__negti2(309485009821345068724781052, -309485009821345068724781052);
    try test__negti2(-309485009821345068724781048, 309485009821345068724781048);
    try test__negti2(309485009821345068724781048, -309485009821345068724781048);
    try test__negti2(-154742504910672534362390527, 154742504910672534362390527);
    try test__negti2(154742504910672534362390527, -154742504910672534362390527);
    try test__negti2(-154742504910672534362390526, 154742504910672534362390526);
    try test__negti2(154742504910672534362390526, -154742504910672534362390526);
    try test__negti2(-154742504910672534362390524, 154742504910672534362390524);
    try test__negti2(154742504910672534362390524, -154742504910672534362390524);
    try test__negti2(-154742504910672534362390520, 154742504910672534362390520);
    try test__negti2(154742504910672534362390520, -154742504910672534362390520);
    try test__negti2(-77371252455336267181195263, 77371252455336267181195263);
    try test__negti2(77371252455336267181195263, -77371252455336267181195263);
    try test__negti2(-77371252455336267181195262, 77371252455336267181195262);
    try test__negti2(77371252455336267181195262, -77371252455336267181195262);
    try test__negti2(-77371252455336267181195260, 77371252455336267181195260);
    try test__negti2(77371252455336267181195260, -77371252455336267181195260);
    try test__negti2(-77371252455336267181195256, 77371252455336267181195256);
    try test__negti2(77371252455336267181195256, -77371252455336267181195256);
    try test__negti2(-38685626227668133590597631, 38685626227668133590597631);
    try test__negti2(38685626227668133590597631, -38685626227668133590597631);
    try test__negti2(-38685626227668133590597630, 38685626227668133590597630);
    try test__negti2(38685626227668133590597630, -38685626227668133590597630);
    try test__negti2(-38685626227668133590597628, 38685626227668133590597628);
    try test__negti2(38685626227668133590597628, -38685626227668133590597628);
    try test__negti2(-38685626227668133590597624, 38685626227668133590597624);
    try test__negti2(38685626227668133590597624, -38685626227668133590597624);
    try test__negti2(-19342813113834066795298815, 19342813113834066795298815);
    try test__negti2(19342813113834066795298815, -19342813113834066795298815);
    try test__negti2(-19342813113834066795298814, 19342813113834066795298814);
    try test__negti2(19342813113834066795298814, -19342813113834066795298814);
    try test__negti2(-19342813113834066795298812, 19342813113834066795298812);
    try test__negti2(19342813113834066795298812, -19342813113834066795298812);
    try test__negti2(-19342813113834066795298808, 19342813113834066795298808);
    try test__negti2(19342813113834066795298808, -19342813113834066795298808);
    try test__negti2(-9671406556917033397649407, 9671406556917033397649407);
    try test__negti2(9671406556917033397649407, -9671406556917033397649407);
    try test__negti2(-9671406556917033397649406, 9671406556917033397649406);
    try test__negti2(9671406556917033397649406, -9671406556917033397649406);
    try test__negti2(-9671406556917033397649404, 9671406556917033397649404);
    try test__negti2(9671406556917033397649404, -9671406556917033397649404);
    try test__negti2(-9671406556917033397649400, 9671406556917033397649400);
    try test__negti2(9671406556917033397649400, -9671406556917033397649400);
    try test__negti2(-4835703278458516698824703, 4835703278458516698824703);
    try test__negti2(4835703278458516698824703, -4835703278458516698824703);
    try test__negti2(-4835703278458516698824702, 4835703278458516698824702);
    try test__negti2(4835703278458516698824702, -4835703278458516698824702);
    try test__negti2(-4835703278458516698824700, 4835703278458516698824700);
    try test__negti2(4835703278458516698824700, -4835703278458516698824700);
    try test__negti2(-4835703278458516698824696, 4835703278458516698824696);
    try test__negti2(4835703278458516698824696, -4835703278458516698824696);
    try test__negti2(-2417851639229258349412351, 2417851639229258349412351);
    try test__negti2(2417851639229258349412351, -2417851639229258349412351);
    try test__negti2(-2417851639229258349412350, 2417851639229258349412350);
    try test__negti2(2417851639229258349412350, -2417851639229258349412350);
    try test__negti2(-2417851639229258349412348, 2417851639229258349412348);
    try test__negti2(2417851639229258349412348, -2417851639229258349412348);
    try test__negti2(-2417851639229258349412344, 2417851639229258349412344);
    try test__negti2(2417851639229258349412344, -2417851639229258349412344);
    try test__negti2(-1208925819614629174706175, 1208925819614629174706175);
    try test__negti2(1208925819614629174706175, -1208925819614629174706175);
    try test__negti2(-1208925819614629174706174, 1208925819614629174706174);
    try test__negti2(1208925819614629174706174, -1208925819614629174706174);
    try test__negti2(-1208925819614629174706172, 1208925819614629174706172);
    try test__negti2(1208925819614629174706172, -1208925819614629174706172);
    try test__negti2(-1208925819614629174706168, 1208925819614629174706168);
    try test__negti2(1208925819614629174706168, -1208925819614629174706168);
    try test__negti2(-604462909807314587353087, 604462909807314587353087);
    try test__negti2(604462909807314587353087, -604462909807314587353087);
    try test__negti2(-604462909807314587353086, 604462909807314587353086);
    try test__negti2(604462909807314587353086, -604462909807314587353086);
    try test__negti2(-604462909807314587353084, 604462909807314587353084);
    try test__negti2(604462909807314587353084, -604462909807314587353084);
    try test__negti2(-604462909807314587353080, 604462909807314587353080);
    try test__negti2(604462909807314587353080, -604462909807314587353080);
    try test__negti2(-302231454903657293676543, 302231454903657293676543);
    try test__negti2(302231454903657293676543, -302231454903657293676543);
    try test__negti2(-302231454903657293676542, 302231454903657293676542);
    try test__negti2(302231454903657293676542, -302231454903657293676542);
    try test__negti2(-302231454903657293676540, 302231454903657293676540);
    try test__negti2(302231454903657293676540, -302231454903657293676540);
    try test__negti2(-302231454903657293676536, 302231454903657293676536);
    try test__negti2(302231454903657293676536, -302231454903657293676536);
    try test__negti2(-151115727451828646838271, 151115727451828646838271);
    try test__negti2(151115727451828646838271, -151115727451828646838271);
    try test__negti2(-151115727451828646838270, 151115727451828646838270);
    try test__negti2(151115727451828646838270, -151115727451828646838270);
    try test__negti2(-151115727451828646838268, 151115727451828646838268);
    try test__negti2(151115727451828646838268, -151115727451828646838268);
    try test__negti2(-151115727451828646838264, 151115727451828646838264);
    try test__negti2(151115727451828646838264, -151115727451828646838264);
    try test__negti2(-75557863725914323419135, 75557863725914323419135);
    try test__negti2(75557863725914323419135, -75557863725914323419135);
    try test__negti2(-75557863725914323419134, 75557863725914323419134);
    try test__negti2(75557863725914323419134, -75557863725914323419134);
    try test__negti2(-75557863725914323419132, 75557863725914323419132);
    try test__negti2(75557863725914323419132, -75557863725914323419132);
    try test__negti2(-75557863725914323419128, 75557863725914323419128);
    try test__negti2(75557863725914323419128, -75557863725914323419128);
    try test__negti2(-37778931862957161709567, 37778931862957161709567);
    try test__negti2(37778931862957161709567, -37778931862957161709567);
    try test__negti2(-37778931862957161709566, 37778931862957161709566);
    try test__negti2(37778931862957161709566, -37778931862957161709566);
    try test__negti2(-37778931862957161709564, 37778931862957161709564);
    try test__negti2(37778931862957161709564, -37778931862957161709564);
    try test__negti2(-37778931862957161709560, 37778931862957161709560);
    try test__negti2(37778931862957161709560, -37778931862957161709560);
    try test__negti2(-18889465931478580854783, 18889465931478580854783);
    try test__negti2(18889465931478580854783, -18889465931478580854783);
    try test__negti2(-18889465931478580854782, 18889465931478580854782);
    try test__negti2(18889465931478580854782, -18889465931478580854782);
    try test__negti2(-18889465931478580854780, 18889465931478580854780);
    try test__negti2(18889465931478580854780, -18889465931478580854780);
    try test__negti2(-18889465931478580854776, 18889465931478580854776);
    try test__negti2(18889465931478580854776, -18889465931478580854776);
    try test__negti2(-9444732965739290427391, 9444732965739290427391);
    try test__negti2(9444732965739290427391, -9444732965739290427391);
    try test__negti2(-9444732965739290427390, 9444732965739290427390);
    try test__negti2(9444732965739290427390, -9444732965739290427390);
    try test__negti2(-9444732965739290427388, 9444732965739290427388);
    try test__negti2(9444732965739290427388, -9444732965739290427388);
    try test__negti2(-9444732965739290427384, 9444732965739290427384);
    try test__negti2(9444732965739290427384, -9444732965739290427384);
    try test__negti2(-4722366482869645213695, 4722366482869645213695);
    try test__negti2(4722366482869645213695, -4722366482869645213695);
    try test__negti2(-4722366482869645213694, 4722366482869645213694);
    try test__negti2(4722366482869645213694, -4722366482869645213694);
    try test__negti2(-4722366482869645213692, 4722366482869645213692);
    try test__negti2(4722366482869645213692, -4722366482869645213692);
    try test__negti2(-4722366482869645213688, 4722366482869645213688);
    try test__negti2(4722366482869645213688, -4722366482869645213688);
    try test__negti2(-2361183241434822606847, 2361183241434822606847);
    try test__negti2(2361183241434822606847, -2361183241434822606847);
    try test__negti2(-2361183241434822606846, 2361183241434822606846);
    try test__negti2(2361183241434822606846, -2361183241434822606846);
    try test__negti2(-2361183241434822606844, 2361183241434822606844);
    try test__negti2(2361183241434822606844, -2361183241434822606844);
    try test__negti2(-2361183241434822606840, 2361183241434822606840);
    try test__negti2(2361183241434822606840, -2361183241434822606840);
    try test__negti2(-1180591620717411303423, 1180591620717411303423);
    try test__negti2(1180591620717411303423, -1180591620717411303423);
    try test__negti2(-1180591620717411303422, 1180591620717411303422);
    try test__negti2(1180591620717411303422, -1180591620717411303422);
    try test__negti2(-1180591620717411303420, 1180591620717411303420);
    try test__negti2(1180591620717411303420, -1180591620717411303420);
    try test__negti2(-1180591620717411303416, 1180591620717411303416);
    try test__negti2(1180591620717411303416, -1180591620717411303416);
    try test__negti2(-590295810358705651711, 590295810358705651711);
    try test__negti2(590295810358705651711, -590295810358705651711);
    try test__negti2(-590295810358705651710, 590295810358705651710);
    try test__negti2(590295810358705651710, -590295810358705651710);
    try test__negti2(-590295810358705651708, 590295810358705651708);
    try test__negti2(590295810358705651708, -590295810358705651708);
    try test__negti2(-590295810358705651704, 590295810358705651704);
    try test__negti2(590295810358705651704, -590295810358705651704);
    try test__negti2(-295147905179352825855, 295147905179352825855);
    try test__negti2(295147905179352825855, -295147905179352825855);
    try test__negti2(-295147905179352825854, 295147905179352825854);
    try test__negti2(295147905179352825854, -295147905179352825854);
    try test__negti2(-295147905179352825852, 295147905179352825852);
    try test__negti2(295147905179352825852, -295147905179352825852);
    try test__negti2(-295147905179352825848, 295147905179352825848);
    try test__negti2(295147905179352825848, -295147905179352825848);
    try test__negti2(-147573952589676412927, 147573952589676412927);
    try test__negti2(147573952589676412927, -147573952589676412927);
    try test__negti2(-147573952589676412926, 147573952589676412926);
    try test__negti2(147573952589676412926, -147573952589676412926);
    try test__negti2(-147573952589676412924, 147573952589676412924);
    try test__negti2(147573952589676412924, -147573952589676412924);
    try test__negti2(-147573952589676412920, 147573952589676412920);
    try test__negti2(147573952589676412920, -147573952589676412920);
    try test__negti2(-73786976294838206463, 73786976294838206463);
    try test__negti2(73786976294838206463, -73786976294838206463);
    try test__negti2(-73786976294838206462, 73786976294838206462);
    try test__negti2(73786976294838206462, -73786976294838206462);
    try test__negti2(-73786976294838206460, 73786976294838206460);
    try test__negti2(73786976294838206460, -73786976294838206460);
    try test__negti2(-73786976294838206456, 73786976294838206456);
    try test__negti2(73786976294838206456, -73786976294838206456);
    try test__negti2(-36893488147419103231, 36893488147419103231);
    try test__negti2(36893488147419103231, -36893488147419103231);
    try test__negti2(-36893488147419103230, 36893488147419103230);
    try test__negti2(36893488147419103230, -36893488147419103230);
    try test__negti2(-36893488147419103228, 36893488147419103228);
    try test__negti2(36893488147419103228, -36893488147419103228);
    try test__negti2(-36893488147419103224, 36893488147419103224);
    try test__negti2(36893488147419103224, -36893488147419103224);
    try test__negti2(-18446744073709551615, 18446744073709551615);
    try test__negti2(18446744073709551615, -18446744073709551615);
    try test__negti2(-18446744073709551614, 18446744073709551614);
    try test__negti2(18446744073709551614, -18446744073709551614);
    try test__negti2(-18446744073709551612, 18446744073709551612);
    try test__negti2(18446744073709551612, -18446744073709551612);
    try test__negti2(-18446744073709551608, 18446744073709551608);
    try test__negti2(18446744073709551608, -18446744073709551608);
    try test__negti2(-9223372036854775807, 9223372036854775807);
    try test__negti2(9223372036854775807, -9223372036854775807);
    try test__negti2(-9223372036854775806, 9223372036854775806);
    try test__negti2(9223372036854775806, -9223372036854775806);
    try test__negti2(-9223372036854775804, 9223372036854775804);
    try test__negti2(9223372036854775804, -9223372036854775804);
    try test__negti2(-9223372036854775800, 9223372036854775800);
    try test__negti2(9223372036854775800, -9223372036854775800);
    try test__negti2(-4611686018427387903, 4611686018427387903);
    try test__negti2(4611686018427387903, -4611686018427387903);
    try test__negti2(-4611686018427387902, 4611686018427387902);
    try test__negti2(4611686018427387902, -4611686018427387902);
    try test__negti2(-4611686018427387900, 4611686018427387900);
    try test__negti2(4611686018427387900, -4611686018427387900);
    try test__negti2(-4611686018427387896, 4611686018427387896);
    try test__negti2(4611686018427387896, -4611686018427387896);
    try test__negti2(-2305843009213693951, 2305843009213693951);
    try test__negti2(2305843009213693951, -2305843009213693951);
    try test__negti2(-2305843009213693950, 2305843009213693950);
    try test__negti2(2305843009213693950, -2305843009213693950);
    try test__negti2(-2305843009213693948, 2305843009213693948);
    try test__negti2(2305843009213693948, -2305843009213693948);
    try test__negti2(-2305843009213693944, 2305843009213693944);
    try test__negti2(2305843009213693944, -2305843009213693944);
    try test__negti2(-1152921504606846975, 1152921504606846975);
    try test__negti2(1152921504606846975, -1152921504606846975);
    try test__negti2(-1152921504606846974, 1152921504606846974);
    try test__negti2(1152921504606846974, -1152921504606846974);
    try test__negti2(-1152921504606846972, 1152921504606846972);
    try test__negti2(1152921504606846972, -1152921504606846972);
    try test__negti2(-1152921504606846968, 1152921504606846968);
    try test__negti2(1152921504606846968, -1152921504606846968);
    try test__negti2(-576460752303423487, 576460752303423487);
    try test__negti2(576460752303423487, -576460752303423487);
    try test__negti2(-576460752303423486, 576460752303423486);
    try test__negti2(576460752303423486, -576460752303423486);
    try test__negti2(-576460752303423484, 576460752303423484);
    try test__negti2(576460752303423484, -576460752303423484);
    try test__negti2(-576460752303423480, 576460752303423480);
    try test__negti2(576460752303423480, -576460752303423480);
    try test__negti2(-288230376151711743, 288230376151711743);
    try test__negti2(288230376151711743, -288230376151711743);
    try test__negti2(-288230376151711742, 288230376151711742);
    try test__negti2(288230376151711742, -288230376151711742);
    try test__negti2(-288230376151711740, 288230376151711740);
    try test__negti2(288230376151711740, -288230376151711740);
    try test__negti2(-288230376151711736, 288230376151711736);
    try test__negti2(288230376151711736, -288230376151711736);
    try test__negti2(-144115188075855871, 144115188075855871);
    try test__negti2(144115188075855871, -144115188075855871);
    try test__negti2(-144115188075855870, 144115188075855870);
    try test__negti2(144115188075855870, -144115188075855870);
    try test__negti2(-144115188075855868, 144115188075855868);
    try test__negti2(144115188075855868, -144115188075855868);
    try test__negti2(-144115188075855864, 144115188075855864);
    try test__negti2(144115188075855864, -144115188075855864);
    try test__negti2(-72057594037927935, 72057594037927935);
    try test__negti2(72057594037927935, -72057594037927935);
    try test__negti2(-72057594037927934, 72057594037927934);
    try test__negti2(72057594037927934, -72057594037927934);
    try test__negti2(-72057594037927932, 72057594037927932);
    try test__negti2(72057594037927932, -72057594037927932);
    try test__negti2(-72057594037927928, 72057594037927928);
    try test__negti2(72057594037927928, -72057594037927928);
    try test__negti2(-36028797018963967, 36028797018963967);
    try test__negti2(36028797018963967, -36028797018963967);
    try test__negti2(-36028797018963966, 36028797018963966);
    try test__negti2(36028797018963966, -36028797018963966);
    try test__negti2(-36028797018963964, 36028797018963964);
    try test__negti2(36028797018963964, -36028797018963964);
    try test__negti2(-36028797018963960, 36028797018963960);
    try test__negti2(36028797018963960, -36028797018963960);
    try test__negti2(-18014398509481983, 18014398509481983);
    try test__negti2(18014398509481983, -18014398509481983);
    try test__negti2(-18014398509481982, 18014398509481982);
    try test__negti2(18014398509481982, -18014398509481982);
    try test__negti2(-18014398509481980, 18014398509481980);
    try test__negti2(18014398509481980, -18014398509481980);
    try test__negti2(-18014398509481976, 18014398509481976);
    try test__negti2(18014398509481976, -18014398509481976);
    try test__negti2(-9007199254740991, 9007199254740991);
    try test__negti2(9007199254740991, -9007199254740991);
    try test__negti2(-9007199254740990, 9007199254740990);
    try test__negti2(9007199254740990, -9007199254740990);
    try test__negti2(-9007199254740988, 9007199254740988);
    try test__negti2(9007199254740988, -9007199254740988);
    try test__negti2(-9007199254740984, 9007199254740984);
    try test__negti2(9007199254740984, -9007199254740984);
    try test__negti2(-4503599627370495, 4503599627370495);
    try test__negti2(4503599627370495, -4503599627370495);
    try test__negti2(-4503599627370494, 4503599627370494);
    try test__negti2(4503599627370494, -4503599627370494);
    try test__negti2(-4503599627370492, 4503599627370492);
    try test__negti2(4503599627370492, -4503599627370492);
    try test__negti2(-4503599627370488, 4503599627370488);
    try test__negti2(4503599627370488, -4503599627370488);
    try test__negti2(-2251799813685247, 2251799813685247);
    try test__negti2(2251799813685247, -2251799813685247);
    try test__negti2(-2251799813685246, 2251799813685246);
    try test__negti2(2251799813685246, -2251799813685246);
    try test__negti2(-2251799813685244, 2251799813685244);
    try test__negti2(2251799813685244, -2251799813685244);
    try test__negti2(-2251799813685240, 2251799813685240);
    try test__negti2(2251799813685240, -2251799813685240);
    try test__negti2(-1125899906842623, 1125899906842623);
    try test__negti2(1125899906842623, -1125899906842623);
    try test__negti2(-1125899906842622, 1125899906842622);
    try test__negti2(1125899906842622, -1125899906842622);
    try test__negti2(-1125899906842620, 1125899906842620);
    try test__negti2(1125899906842620, -1125899906842620);
    try test__negti2(-1125899906842616, 1125899906842616);
    try test__negti2(1125899906842616, -1125899906842616);
    try test__negti2(-562949953421311, 562949953421311);
    try test__negti2(562949953421311, -562949953421311);
    try test__negti2(-562949953421310, 562949953421310);
    try test__negti2(562949953421310, -562949953421310);
    try test__negti2(-562949953421308, 562949953421308);
    try test__negti2(562949953421308, -562949953421308);
    try test__negti2(-562949953421304, 562949953421304);
    try test__negti2(562949953421304, -562949953421304);
    try test__negti2(-281474976710655, 281474976710655);
    try test__negti2(281474976710655, -281474976710655);
    try test__negti2(-281474976710654, 281474976710654);
    try test__negti2(281474976710654, -281474976710654);
    try test__negti2(-281474976710652, 281474976710652);
    try test__negti2(281474976710652, -281474976710652);
    try test__negti2(-281474976710648, 281474976710648);
    try test__negti2(281474976710648, -281474976710648);
    try test__negti2(-140737488355327, 140737488355327);
    try test__negti2(140737488355327, -140737488355327);
    try test__negti2(-140737488355326, 140737488355326);
    try test__negti2(140737488355326, -140737488355326);
    try test__negti2(-140737488355324, 140737488355324);
    try test__negti2(140737488355324, -140737488355324);
    try test__negti2(-140737488355320, 140737488355320);
    try test__negti2(140737488355320, -140737488355320);
    try test__negti2(-70368744177663, 70368744177663);
    try test__negti2(70368744177663, -70368744177663);
    try test__negti2(-70368744177662, 70368744177662);
    try test__negti2(70368744177662, -70368744177662);
    try test__negti2(-70368744177660, 70368744177660);
    try test__negti2(70368744177660, -70368744177660);
    try test__negti2(-70368744177656, 70368744177656);
    try test__negti2(70368744177656, -70368744177656);
    try test__negti2(-35184372088831, 35184372088831);
    try test__negti2(35184372088831, -35184372088831);
    try test__negti2(-35184372088830, 35184372088830);
    try test__negti2(35184372088830, -35184372088830);
    try test__negti2(-35184372088828, 35184372088828);
    try test__negti2(35184372088828, -35184372088828);
    try test__negti2(-35184372088824, 35184372088824);
    try test__negti2(35184372088824, -35184372088824);
    try test__negti2(-17592186044415, 17592186044415);
    try test__negti2(17592186044415, -17592186044415);
    try test__negti2(-17592186044414, 17592186044414);
    try test__negti2(17592186044414, -17592186044414);
    try test__negti2(-17592186044412, 17592186044412);
    try test__negti2(17592186044412, -17592186044412);
    try test__negti2(-17592186044408, 17592186044408);
    try test__negti2(17592186044408, -17592186044408);
    try test__negti2(-8796093022207, 8796093022207);
    try test__negti2(8796093022207, -8796093022207);
    try test__negti2(-8796093022206, 8796093022206);
    try test__negti2(8796093022206, -8796093022206);
    try test__negti2(-8796093022204, 8796093022204);
    try test__negti2(8796093022204, -8796093022204);
    try test__negti2(-8796093022200, 8796093022200);
    try test__negti2(8796093022200, -8796093022200);
    try test__negti2(-4398046511103, 4398046511103);
    try test__negti2(4398046511103, -4398046511103);
    try test__negti2(-4398046511102, 4398046511102);
    try test__negti2(4398046511102, -4398046511102);
    try test__negti2(-4398046511100, 4398046511100);
    try test__negti2(4398046511100, -4398046511100);
    try test__negti2(-4398046511096, 4398046511096);
    try test__negti2(4398046511096, -4398046511096);
    try test__negti2(-2199023255551, 2199023255551);
    try test__negti2(2199023255551, -2199023255551);
    try test__negti2(-2199023255550, 2199023255550);
    try test__negti2(2199023255550, -2199023255550);
    try test__negti2(-2199023255548, 2199023255548);
    try test__negti2(2199023255548, -2199023255548);
    try test__negti2(-2199023255544, 2199023255544);
    try test__negti2(2199023255544, -2199023255544);
    try test__negti2(-1099511627775, 1099511627775);
    try test__negti2(1099511627775, -1099511627775);
    try test__negti2(-1099511627774, 1099511627774);
    try test__negti2(1099511627774, -1099511627774);
    try test__negti2(-1099511627772, 1099511627772);
    try test__negti2(1099511627772, -1099511627772);
    try test__negti2(-1099511627768, 1099511627768);
    try test__negti2(1099511627768, -1099511627768);
    try test__negti2(-549755813887, 549755813887);
    try test__negti2(549755813887, -549755813887);
    try test__negti2(-549755813886, 549755813886);
    try test__negti2(549755813886, -549755813886);
    try test__negti2(-549755813884, 549755813884);
    try test__negti2(549755813884, -549755813884);
    try test__negti2(-549755813880, 549755813880);
    try test__negti2(549755813880, -549755813880);
    try test__negti2(-274877906943, 274877906943);
    try test__negti2(274877906943, -274877906943);
    try test__negti2(-274877906942, 274877906942);
    try test__negti2(274877906942, -274877906942);
    try test__negti2(-274877906940, 274877906940);
    try test__negti2(274877906940, -274877906940);
    try test__negti2(-274877906936, 274877906936);
    try test__negti2(274877906936, -274877906936);
    try test__negti2(-137438953471, 137438953471);
    try test__negti2(137438953471, -137438953471);
    try test__negti2(-137438953470, 137438953470);
    try test__negti2(137438953470, -137438953470);
    try test__negti2(-137438953468, 137438953468);
    try test__negti2(137438953468, -137438953468);
    try test__negti2(-137438953464, 137438953464);
    try test__negti2(137438953464, -137438953464);
    try test__negti2(-68719476735, 68719476735);
    try test__negti2(68719476735, -68719476735);
    try test__negti2(-68719476734, 68719476734);
    try test__negti2(68719476734, -68719476734);
    try test__negti2(-68719476732, 68719476732);
    try test__negti2(68719476732, -68719476732);
    try test__negti2(-68719476728, 68719476728);
    try test__negti2(68719476728, -68719476728);
    try test__negti2(-34359738367, 34359738367);
    try test__negti2(34359738367, -34359738367);
    try test__negti2(-34359738366, 34359738366);
    try test__negti2(34359738366, -34359738366);
    try test__negti2(-34359738364, 34359738364);
    try test__negti2(34359738364, -34359738364);
    try test__negti2(-34359738360, 34359738360);
    try test__negti2(34359738360, -34359738360);
    try test__negti2(-17179869183, 17179869183);
    try test__negti2(17179869183, -17179869183);
    try test__negti2(-17179869182, 17179869182);
    try test__negti2(17179869182, -17179869182);
    try test__negti2(-17179869180, 17179869180);
    try test__negti2(17179869180, -17179869180);
    try test__negti2(-17179869176, 17179869176);
    try test__negti2(17179869176, -17179869176);
    try test__negti2(-8589934591, 8589934591);
    try test__negti2(8589934591, -8589934591);
    try test__negti2(-8589934590, 8589934590);
    try test__negti2(8589934590, -8589934590);
    try test__negti2(-8589934588, 8589934588);
    try test__negti2(8589934588, -8589934588);
    try test__negti2(-8589934584, 8589934584);
    try test__negti2(8589934584, -8589934584);
    try test__negti2(-4294967295, 4294967295);
    try test__negti2(4294967295, -4294967295);
    try test__negti2(-4294967294, 4294967294);
    try test__negti2(4294967294, -4294967294);
    try test__negti2(-4294967292, 4294967292);
    try test__negti2(4294967292, -4294967292);
    try test__negti2(-4294967288, 4294967288);
    try test__negti2(4294967288, -4294967288);
    try test__negti2(-2147483647, 2147483647);
    try test__negti2(2147483647, -2147483647);
    try test__negti2(-2147483646, 2147483646);
    try test__negti2(2147483646, -2147483646);
    try test__negti2(-2147483644, 2147483644);
    try test__negti2(2147483644, -2147483644);
    try test__negti2(-2147483640, 2147483640);
    try test__negti2(2147483640, -2147483640);
    try test__negti2(-1073741823, 1073741823);
    try test__negti2(1073741823, -1073741823);
    try test__negti2(-1073741822, 1073741822);
    try test__negti2(1073741822, -1073741822);
    try test__negti2(-1073741820, 1073741820);
    try test__negti2(1073741820, -1073741820);
    try test__negti2(-1073741816, 1073741816);
    try test__negti2(1073741816, -1073741816);
    try test__negti2(-536870911, 536870911);
    try test__negti2(536870911, -536870911);
    try test__negti2(-536870910, 536870910);
    try test__negti2(536870910, -536870910);
    try test__negti2(-536870908, 536870908);
    try test__negti2(536870908, -536870908);
    try test__negti2(-536870904, 536870904);
    try test__negti2(536870904, -536870904);
    try test__negti2(-268435455, 268435455);
    try test__negti2(268435455, -268435455);
    try test__negti2(-268435454, 268435454);
    try test__negti2(268435454, -268435454);
    try test__negti2(-268435452, 268435452);
    try test__negti2(268435452, -268435452);
    try test__negti2(-268435448, 268435448);
    try test__negti2(268435448, -268435448);
    try test__negti2(-134217727, 134217727);
    try test__negti2(134217727, -134217727);
    try test__negti2(-134217726, 134217726);
    try test__negti2(134217726, -134217726);
    try test__negti2(-134217724, 134217724);
    try test__negti2(134217724, -134217724);
    try test__negti2(-134217720, 134217720);
    try test__negti2(134217720, -134217720);
    try test__negti2(-67108863, 67108863);
    try test__negti2(67108863, -67108863);
    try test__negti2(-67108862, 67108862);
    try test__negti2(67108862, -67108862);
    try test__negti2(-67108860, 67108860);
    try test__negti2(67108860, -67108860);
    try test__negti2(-67108856, 67108856);
    try test__negti2(67108856, -67108856);
    try test__negti2(-33554431, 33554431);
    try test__negti2(33554431, -33554431);
    try test__negti2(-33554430, 33554430);
    try test__negti2(33554430, -33554430);
    try test__negti2(-33554428, 33554428);
    try test__negti2(33554428, -33554428);
    try test__negti2(-33554424, 33554424);
    try test__negti2(33554424, -33554424);
    try test__negti2(-16777215, 16777215);
    try test__negti2(16777215, -16777215);
    try test__negti2(-16777214, 16777214);
    try test__negti2(16777214, -16777214);
    try test__negti2(-16777212, 16777212);
    try test__negti2(16777212, -16777212);
    try test__negti2(-16777208, 16777208);
    try test__negti2(16777208, -16777208);
    try test__negti2(-8388607, 8388607);
    try test__negti2(8388607, -8388607);
    try test__negti2(-8388606, 8388606);
    try test__negti2(8388606, -8388606);
    try test__negti2(-8388604, 8388604);
    try test__negti2(8388604, -8388604);
    try test__negti2(-8388600, 8388600);
    try test__negti2(8388600, -8388600);
    try test__negti2(-4194303, 4194303);
    try test__negti2(4194303, -4194303);
    try test__negti2(-4194302, 4194302);
    try test__negti2(4194302, -4194302);
    try test__negti2(-4194300, 4194300);
    try test__negti2(4194300, -4194300);
    try test__negti2(-4194296, 4194296);
    try test__negti2(4194296, -4194296);
    try test__negti2(-2097151, 2097151);
    try test__negti2(2097151, -2097151);
    try test__negti2(-2097150, 2097150);
    try test__negti2(2097150, -2097150);
    try test__negti2(-2097148, 2097148);
    try test__negti2(2097148, -2097148);
    try test__negti2(-2097144, 2097144);
    try test__negti2(2097144, -2097144);
    try test__negti2(-1048575, 1048575);
    try test__negti2(1048575, -1048575);
    try test__negti2(-1048574, 1048574);
    try test__negti2(1048574, -1048574);
    try test__negti2(-1048572, 1048572);
    try test__negti2(1048572, -1048572);
    try test__negti2(-1048568, 1048568);
    try test__negti2(1048568, -1048568);
    try test__negti2(-524287, 524287);
    try test__negti2(524287, -524287);
    try test__negti2(-524286, 524286);
    try test__negti2(524286, -524286);
    try test__negti2(-524284, 524284);
    try test__negti2(524284, -524284);
    try test__negti2(-524280, 524280);
    try test__negti2(524280, -524280);
    try test__negti2(-262143, 262143);
    try test__negti2(262143, -262143);
    try test__negti2(-262142, 262142);
    try test__negti2(262142, -262142);
    try test__negti2(-262140, 262140);
    try test__negti2(262140, -262140);
    try test__negti2(-262136, 262136);
    try test__negti2(262136, -262136);
    try test__negti2(-131071, 131071);
    try test__negti2(131071, -131071);
    try test__negti2(-131070, 131070);
    try test__negti2(131070, -131070);
    try test__negti2(-131068, 131068);
    try test__negti2(131068, -131068);
    try test__negti2(-131064, 131064);
    try test__negti2(131064, -131064);
    try test__negti2(-65535, 65535);
    try test__negti2(65535, -65535);
    try test__negti2(-65534, 65534);
    try test__negti2(65534, -65534);
    try test__negti2(-65532, 65532);
    try test__negti2(65532, -65532);
    try test__negti2(-65528, 65528);
    try test__negti2(65528, -65528);
    try test__negti2(-32767, 32767);
    try test__negti2(32767, -32767);
    try test__negti2(-32766, 32766);
    try test__negti2(32766, -32766);
    try test__negti2(-32764, 32764);
    try test__negti2(32764, -32764);
    try test__negti2(-32760, 32760);
    try test__negti2(32760, -32760);
    try test__negti2(-16383, 16383);
    try test__negti2(16383, -16383);
    try test__negti2(-16382, 16382);
    try test__negti2(16382, -16382);
    try test__negti2(-16380, 16380);
    try test__negti2(16380, -16380);
    try test__negti2(-16376, 16376);
    try test__negti2(16376, -16376);
    try test__negti2(-8191, 8191);
    try test__negti2(8191, -8191);
    try test__negti2(-8190, 8190);
    try test__negti2(8190, -8190);
    try test__negti2(-8188, 8188);
    try test__negti2(8188, -8188);
    try test__negti2(-8184, 8184);
    try test__negti2(8184, -8184);
    try test__negti2(-4095, 4095);
    try test__negti2(4095, -4095);
    try test__negti2(-4094, 4094);
    try test__negti2(4094, -4094);
    try test__negti2(-4092, 4092);
    try test__negti2(4092, -4092);
    try test__negti2(-4088, 4088);
    try test__negti2(4088, -4088);
    try test__negti2(-2047, 2047);
    try test__negti2(2047, -2047);
    try test__negti2(-2046, 2046);
    try test__negti2(2046, -2046);
    try test__negti2(-2044, 2044);
    try test__negti2(2044, -2044);
    try test__negti2(-2040, 2040);
    try test__negti2(2040, -2040);
    try test__negti2(-1023, 1023);
    try test__negti2(1023, -1023);
    try test__negti2(-1022, 1022);
    try test__negti2(1022, -1022);
    try test__negti2(-1020, 1020);
    try test__negti2(1020, -1020);
    try test__negti2(-1016, 1016);
    try test__negti2(1016, -1016);
    try test__negti2(-511, 511);
    try test__negti2(511, -511);
    try test__negti2(-510, 510);
    try test__negti2(510, -510);
    try test__negti2(-508, 508);
    try test__negti2(508, -508);
    try test__negti2(-504, 504);
    try test__negti2(504, -504);
    try test__negti2(-255, 255);
    try test__negti2(255, -255);
    try test__negti2(-254, 254);
    try test__negti2(254, -254);
    try test__negti2(-252, 252);
    try test__negti2(252, -252);
    try test__negti2(-248, 248);
    try test__negti2(248, -248);
    try test__negti2(-127, 127);
    try test__negti2(127, -127);
    try test__negti2(-126, 126);
    try test__negti2(126, -126);
    try test__negti2(-124, 124);
    try test__negti2(124, -124);
    try test__negti2(-120, 120);
    try test__negti2(120, -120);
    try test__negti2(-63, 63);
    try test__negti2(63, -63);
    try test__negti2(-62, 62);
    try test__negti2(62, -62);
    try test__negti2(-60, 60);
    try test__negti2(60, -60);
    try test__negti2(-56, 56);
    try test__negti2(56, -56);
    try test__negti2(-31, 31);
    try test__negti2(31, -31);
    try test__negti2(-30, 30);
    try test__negti2(30, -30);
    try test__negti2(-28, 28);
    try test__negti2(28, -28);
    try test__negti2(-24, 24);
    try test__negti2(24, -24);
    try test__negti2(-15, 15);
    try test__negti2(15, -15);
    try test__negti2(-14, 14);
    try test__negti2(14, -14);
    try test__negti2(-12, 12);
    try test__negti2(12, -12);
    try test__negti2(-8, 8);
    try test__negti2(8, -8);
}
