/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package com.facebook.thrift.annotation.rust_deprecated;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import java.util.Collections;
import java.util.BitSet;
import java.util.Arrays;
import com.facebook.thrift.*;
import com.facebook.thrift.annotations.*;
import com.facebook.thrift.async.*;
import com.facebook.thrift.meta_data.*;
import com.facebook.thrift.server.*;
import com.facebook.thrift.transport.*;
import com.facebook.thrift.protocol.*;

/**
 * There is a default Rust type associated with each Thrift type. For example,
 * the default Rust type to represent Thrift `map<>`s is
 * `std::collections::BTreeMap<>`.
 * 
 * The `rust.Type` annotation provides an ability to "override" (substitute) a
 * non-default Rust type in certain circumstances (full details below). We might
 * say for example, `@rust.Type{name="HashMap"}` to override an instance of a
 * specific Thrift `map<>`.
 * 
 * The `rust.Type` annotation can be applied to any type but has no effect when
 * applied to `string`, `list<>`, `struct` or `enum` types.
 * 
 * The `name` argument of a `rust.Type` annotation may specify a "standard" or
 * "nonstandard" type: a name containing a '`::`' is classified as a nonstandard
 * type whereas, a name without a '`::`' is classified as standard.
 * 
 * Standard types that may appear in `@rust.Type` annotations are exactly types
 * that are (re-)exported from the `fbthrift::builtin_types` module. For such
 * types, the `fbthift` package provides stock `fbthrift::Serialize<>` and
 * `fbthrift::Deserialize<>` instances for them. At the current time the full
 * set of such types is `std::collections::*`, `bytes::Bytes` and
 * `ordered_float::OrderedFloat`.
 * 
 * This is an example of an application of a `@rust.Type` annotation with a
 * standard type:
 * 
 * ```
 * @rust.Type{name = "OrderdedFloat<f64>"}
 * typedef double Double
 * 
 * struct T {
 *   1: Double data; // `data: fbthrift::builtin_types::OrderedFloat<f64>`
 * }
 * ```
 * 
 * This is an example of application of a `@rust.Type` annotation with a
 * nonstandard type:
 * 
 * ```
 * @rust.Type{name = "smallvec::SmallVec<[u8; 32]>"}
 * typedef binary binary_t
 * 
 * struct T {
 *   1: binary_t data; // `data: smallvec::SmallVec<[u8; 32]>`
 * }
 * ```
 * 
 * Nonstandard types, when they appear in `@rust.Type` annotations applied to
 * Thrift `map<>`, `set<>` or `binary` types will result in the generation of
 * `fbthrift::Serialize<>` and `fbthrift::Deserialize<>` instances for those
 * types. The serialization code makes assumptions about valid expressions and
 * the existence of trait implementations for such types that are documented
 * below.
 * 
 * A nonstandard type say can also be applied to `i64`. In this case, the
 * resulting generated serialization code assumes the existence of
 * `fbthrift::Serialize<>` and `fbthrift::Deserialize<>` for that nonstandard
 * type.
 * 
 * A nonstandard type applied to Thrift `void`, `bool`, `float`, `byte`, `i16`,
 * `i32`, `double`, and `float` types will not result in the generation of any
 * serialization code for the nonstandard type (rendering nonstandard types
 * applied to these types effectively unsupported at this time).
 * 
 * "Codegen" errors or bugs resulting from the use of standard types in valid
 * positions in `@rust.Type` annotations should be considered the responsibility
 * of the the Rust Thrift maintainers to address. Less "formal" support should
 * be expected from the Rust Thrift maintainers when nonstandard types are
 * involved.
 * 
 * ## `binary`
 * 
 * The default Rust type for a Thrift `binary` is
 * `std::vec::Vec<std::primitive::u8>`. An example override:
 * 
 * ```
 * @rust.Type{name = "smallvec::SmallVec<[u8; 32]>"}
 * typedef binary binary_t
 * 
 * struct T {
 *   1: binary_t data;
 * }
 * ```
 * 
 * If nonstandard `B` models Thrift `binary`, `b : B`, `other: &[u8]` and `vec :
 * std::vec::Vec<u8>` then the following expressions are required to be valid
 * and the following trait instances must exist:
 * 
 * | expression                                            |
 * | :---------------------------------------------------- |
 * | `let _: &[u8]  = b.as_slice()`                        |
 * | `let _: B = <B>::with_capacity(l)`                    |
 * | `b.extend_from_slice(other)`                          |
 * 
 * | type           | traits                               |
 * | :------------- | :----------------------------------  |
 * | `B`            | `Debug`, `Default`,                  |
 * |                | `From<std::vec::Vec<u8>>`            |
 * 
 * ## `set`
 * 
 * The default Rust type for a thrift `set` is `std::collections::BTreeSet<>`.
 * An example override:
 * 
 * ```
 * @rust.Type{name = "sorted_vector_map::SortedVectorSet"}
 * typedef set<string> set_t
 * 
 * struct T {
 *   1: set_t data; // `data: sorted_vector_map::SortedVectorSet<String>`
 * }
 * ```
 * 
 * If nonstandard `S` models thrift `set`, `K` is the Rust element type, `k :
 * K`, `l : usize`, `s : S<K>` and `'a` a lifetime, required valid expressions
 * and trait implementations are as follows:
 * 
 * | expression                                            |
 * | :---------------------------------------------------- |
 * | `for _ in &s { ... }`                                 |
 * | `let _: usize = s.len()`                              |
 * | `let mut _: T<K> = <S<K>>::with_capacity(l);`         |
 * | `s.insert(k)`                                         |
 * 
 * | type           | traits                               |
 * | :------------- | :----------------------------------  |
 * | `S<K>`         | `Debug`, `Default`                   |
 * | `&'a S<K>`     | `IntoIterator<Item = &'a K>`         |
 * 
 * ## `map`
 * 
 * The default rust type for a thrift `map` is `std::collections::BTreeMap<>`.
 * An example override:
 * 
 * ```
 * @rust.Type{name = "sorted_vector_map::SortedVectorMap"}
 * typedef map<string, i64> map_t
 * 
 * struct T {
 *   1: map_t data; // `data: sorted_vector_map::SortedVectorMap<String, i64>`
 * }
 * ```
 * 
 * If nonstandard `T` models thrift `map`, `K` and `V` are the Rust map key and
 * value types respectively, `k : K`, `v : V`, `l : usize`, `m : T<K, V>` and
 * `'a` a lifetime, required valid expressions and trait implementations are:
 * 
 * | expression                                            |
 * | :---------------------------------------------------- |
 * | `for (key, val) in &m { ... }`                        |
 * | `let _: usize = m.len()`                              |
 * | `let mut _: T<K, V> = <T<K, V>>::with_capacity(l);`   |
 * | `m.insert(k, v)`                                      |
 * 
 * | type           | traits
 * | :------------- | :----------------------------------
 * | `T<K, V>`      | `Debug`, `Default`
 * | `&'a T<K, V>`  | `IntoIterator<Item = (&'a K, &'a V)>`
 */
@SuppressWarnings({ "unused", "serial" })
public class Type implements TBase, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("Type");
  private static final TField NAME_FIELD_DESC = new TField("name", TType.STRING, (short)1);

  public final String name;
  public static final int NAME = 1;

  public Type(
      String name) {
    this.name = name;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public Type(Type other) {
    if (other.isSetName()) {
      this.name = TBaseHelper.deepCopy(other.name);
    } else {
      this.name = null;
    }
  }

  public Type deepCopy() {
    return new Type(this);
  }

  public String getName() {
    return this.name;
  }

  // Returns true if field name is set (has been assigned a value) and false otherwise
  public boolean isSetName() {
    return this.name != null;
  }

  @Override
  public boolean equals(Object _that) {
    if (_that == null)
      return false;
    if (this == _that)
      return true;
    if (!(_that instanceof Type))
      return false;
    Type that = (Type)_that;

    if (!TBaseHelper.equalsNobinary(this.isSetName(), that.isSetName(), this.name, that.name)) { return false; }

    return true;
  }

  @Override
  public int hashCode() {
    return Arrays.deepHashCode(new Object[] {name});
  }

  // This is required to satisfy the TBase interface, but can't be implemented on immutable struture.
  public void read(TProtocol iprot) throws TException {
    throw new TException("unimplemented in android immutable structure");
  }

  public static Type deserialize(TProtocol iprot) throws TException {
    String tmp_name = null;
    TField __field;
    iprot.readStructBegin();
    while (true)
    {
      __field = iprot.readFieldBegin();
      if (__field.type == TType.STOP) {
        break;
      }
      switch (__field.id)
      {
        case NAME:
          if (__field.type == TType.STRING) {
            tmp_name = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, __field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, __field.type);
          break;
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    Type _that;
    _that = new Type(
      tmp_name
    );
    _that.validate();
    return _that;
  }

  public void write(TProtocol oprot) throws TException {
    validate();

    oprot.writeStructBegin(STRUCT_DESC);
    if (this.name != null) {
      oprot.writeFieldBegin(NAME_FIELD_DESC);
      oprot.writeString(this.name);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    return toString(1, true);
  }

  @Override
  public String toString(int indent, boolean prettyPrint) {
    return TBaseHelper.toStringHelper(this, indent, prettyPrint);
  }

  public void validate() throws TException {
    // check for required fields
  }

}

