/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OneOrMorePattern
extends Pattern {
    private final Pattern p;

    OneOrMorePattern(Pattern pattern) {
        super(pattern.isNullable(), pattern.getContentType(), OneOrMorePattern.combineHashCode(19, pattern.hashCode()));
        this.p = pattern;
    }

    @Override
    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p.expand(schemaPatternBuilder);
        if (pattern != this.p) {
            return schemaPatternBuilder.makeOneOrMore(pattern);
        }
        return this;
    }

    @Override
    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_one_or_more");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_one_or_more");
            }
        }
        this.p.checkRestrictions(n == 1 ? 2 : n, duplicateAttributeDetector, alphabet);
        if (n != 6 && !OneOrMorePattern.contentTypeGroupable(this.p.getContentType(), this.p.getContentType())) {
            throw new RestrictionViolationException("one_or_more_string");
        }
    }

    @Override
    boolean samePattern(Pattern pattern) {
        return pattern instanceof OneOrMorePattern && this.p == ((OneOrMorePattern)pattern).p;
    }

    @Override
    <T> T apply(PatternFunction<T> patternFunction) {
        return patternFunction.caseOneOrMore(this);
    }

    Pattern getOperand() {
        return this.p;
    }
}

