/* umockdev.c generated by valac 0.42.3, the Vala compiler
 * generated from umockdev.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * SECTION:umockdev
 * @title: umockdev
 * @short_description: Build a test bed for testing software that handles Linux
 * hardware devices.
 *
 * Please see README.rst about an overview of the parts of umockdev, and how
 * they fit together.
 */
/**
 * SECTION:functions
 * @title: global functions
 * @short_description: Global functions
 *
 * These work independently from #Testbed objects.
 */
/**
 * SECTION:umockdeverror
 * @title: umockdev errors
 * @short_description: #GError types for parsing umockdev files
 * hardware devices.
 *
 * See #GError for more information on error domains.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "uevent_sender.h"
#include <unistd.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <gio/gio.h>
#include <stdarg.h>
#include <sys/socket.h>
#include <linux/input.h>
#include <time.h>
#include <pty.h>
#include <termios.h>
#include <stdio.h>
#include <sys/select.h>
#include <sys/time.h>
#include <gio/gunixsocketaddress.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gobject/gvaluecollector.h>


#define UMOCKDEV_TYPE_TESTBED (umockdev_testbed_get_type ())
#define UMOCKDEV_TESTBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_TESTBED, UMockdevTestbed))
#define UMOCKDEV_TESTBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedClass))
#define UMOCKDEV_IS_TESTBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_TESTBED))
#define UMOCKDEV_IS_TESTBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_TESTBED))
#define UMOCKDEV_TESTBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedClass))

typedef struct _UMockdevTestbed UMockdevTestbed;
typedef struct _UMockdevTestbedClass UMockdevTestbedClass;
typedef struct _UMockdevTestbedPrivate UMockdevTestbedPrivate;

#define UMOCKDEV_TYPE_SCRIPT_RUNNER (umockdev_script_runner_get_type ())
#define UMOCKDEV_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner))
#define UMOCKDEV_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))
#define UMOCKDEV_IS_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_IS_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_SCRIPT_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))

typedef struct _UMockdevScriptRunner UMockdevScriptRunner;
typedef struct _UMockdevScriptRunnerClass UMockdevScriptRunnerClass;

#define UMOCKDEV_TYPE_SOCKET_SERVER (umockdev_socket_server_get_type ())
#define UMOCKDEV_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer))
#define UMOCKDEV_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))
#define UMOCKDEV_IS_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_IS_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_SOCKET_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))

typedef struct _UMockdevSocketServer UMockdevSocketServer;
typedef struct _UMockdevSocketServerClass UMockdevSocketServerClass;
enum  {
	UMOCKDEV_TESTBED_0_PROPERTY,
	UMOCKDEV_TESTBED_NUM_PROPERTIES
};
static GParamSpec* umockdev_testbed_properties[UMOCKDEV_TESTBED_NUM_PROPERTIES];
#define _umockdev_socket_server_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_socket_server_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _uevent_sender_close0(var) ((var == NULL) ? NULL : (var = (uevent_sender_close (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _umockdev_script_runner_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _UMockdevScriptRunnerPrivate UMockdevScriptRunnerPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _UMockdevParamSpecScriptRunner UMockdevParamSpecScriptRunner;
typedef struct _UMockdevSocketServerPrivate UMockdevSocketServerPrivate;
typedef struct _UMockdevParamSpecSocketServer UMockdevParamSpecSocketServer;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UMockdevTestbed {
	GObject parent_instance;
	UMockdevTestbedPrivate * priv;
};

struct _UMockdevTestbedClass {
	GObjectClass parent_class;
};

struct _UMockdevTestbedPrivate {
	gchar* root_dir;
	gchar* sys_dir;
	GRegex* re_record_val;
	GRegex* re_record_keyval;
	GRegex* re_record_optval;
	uevent_sender* ev_sender;
	GHashTable* dev_fd;
	GHashTable* dev_script_runner;
	UMockdevSocketServer* socket_server;
};

typedef enum  {
	UMOCKDEV_ERROR_PARSE,
	UMOCKDEV_ERROR_VALUE
} UMockdevError;
#define UMOCKDEV_ERROR umockdev_error_quark ()
struct _UMockdevScriptRunner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevScriptRunnerPrivate * priv;
};

struct _UMockdevScriptRunnerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevScriptRunner *self);
};

struct _UMockdevScriptRunnerPrivate {
	gchar* _device;
	gchar* script_file;
	GThread* thread;
	FILE* script;
	gint fd;
	gboolean running;
	guint fuzz;
};

struct _UMockdevParamSpecScriptRunner {
	GParamSpec parent_instance;
};

struct _UMockdevSocketServer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevSocketServerPrivate * priv;
};

struct _UMockdevSocketServerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevSocketServer *self);
};

struct _UMockdevSocketServerPrivate {
	GSocket** listen_sockets;
	gint listen_sockets_length1;
	gint _listen_sockets_size_;
	GHashTable* socket_scriptfile;
	GHashTable* script_runners;
	GThread* thread;
	gboolean running;
	gint ctrl_r;
	gint ctrl_w;
};

struct _UMockdevParamSpecSocketServer {
	GParamSpec parent_instance;
};

/**
 * UMockdevError:
 * @UMOCKDEV_ERROR_PARSE:
 * There is a malformed or missing line in the device description.
 * @UMOCKDEV_ERROR_VALUE:
 * A value in the device description has an invalid value, for example a device
 * path does not start with "/devices/".
 *
 * Error codes for parsing umockdev files.
 */

extern gboolean umockdev___in_mock_env_initialized;
gboolean umockdev___in_mock_env_initialized = FALSE;
extern gboolean umockdev___in_mock_env_result;
gboolean umockdev___in_mock_env_result = FALSE;
static gint UMockdevTestbed_private_offset;
static gpointer umockdev_testbed_parent_class = NULL;
static gint UMockdevScriptRunner_private_offset;
static gpointer umockdev_script_runner_parent_class = NULL;
static gint UMockdevSocketServer_private_offset;
static gpointer umockdev_socket_server_parent_class = NULL;

GType umockdev_testbed_get_type (void) G_GNUC_CONST;
gpointer umockdev_script_runner_ref (gpointer instance);
void umockdev_script_runner_unref (gpointer instance);
GParamSpec* umockdev_param_spec_script_runner (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void umockdev_value_set_script_runner (GValue* value,
                                       gpointer v_object);
void umockdev_value_take_script_runner (GValue* value,
                                        gpointer v_object);
gpointer umockdev_value_get_script_runner (const GValue* value);
GType umockdev_script_runner_get_type (void) G_GNUC_CONST;
gpointer umockdev_socket_server_ref (gpointer instance);
void umockdev_socket_server_unref (gpointer instance);
GParamSpec* umockdev_param_spec_socket_server (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void umockdev_value_set_socket_server (GValue* value,
                                       gpointer v_object);
void umockdev_value_take_socket_server (GValue* value,
                                        gpointer v_object);
gpointer umockdev_value_get_socket_server (const GValue* value);
GType umockdev_socket_server_get_type (void) G_GNUC_CONST;
void umockdev_script_runner_stop (UMockdevScriptRunner* self);
void umockdev_socket_server_stop (UMockdevSocketServer* self);
void umockdev_remove_dir (const gchar* path,
                          gboolean remove_toplevel);
UMockdevTestbed* umockdev_testbed_new (void);
UMockdevTestbed* umockdev_testbed_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _umockdev_script_runner_unref0_ (gpointer var);
gchar* umockdev_testbed_get_root_dir (UMockdevTestbed* self);
gchar* umockdev_testbed_get_sys_dir (UMockdevTestbed* self);
void umockdev_testbed_set_attribute (UMockdevTestbed* self,
                                     const gchar* devpath,
                                     const gchar* name,
                                     const gchar* value);
void umockdev_testbed_set_attribute_binary (UMockdevTestbed* self,
                                            const gchar* devpath,
                                            const gchar* name,
                                            guint8* value,
                                            int value_length1);
void umockdev_testbed_set_attribute_int (UMockdevTestbed* self,
                                         const gchar* devpath,
                                         const gchar* name,
                                         gint value);
void umockdev_testbed_set_attribute_hex (UMockdevTestbed* self,
                                         const gchar* devpath,
                                         const gchar* name,
                                         guint value);
void umockdev_testbed_set_attribute_link (UMockdevTestbed* self,
                                          const gchar* devpath,
                                          const gchar* name,
                                          const gchar* value);
gchar* umockdev_testbed_get_property (UMockdevTestbed* self,
                                      const gchar* devpath,
                                      const gchar* name);
void umockdev_testbed_set_property (UMockdevTestbed* self,
                                    const gchar* devpath,
                                    const gchar* name,
                                    const gchar* value);
void umockdev_testbed_set_property_int (UMockdevTestbed* self,
                                        const gchar* devpath,
                                        const gchar* name,
                                        gint value);
void umockdev_testbed_set_property_hex (UMockdevTestbed* self,
                                        const gchar* devpath,
                                        const gchar* name,
                                        guint value);
gchar* umockdev_testbed_add_devicev (UMockdevTestbed* self,
                                     const gchar* subsystem,
                                     const gchar* name,
                                     const gchar* parent,
                                     gchar** attributes,
                                     gchar** properties);
gchar* umockdev_make_dotdots (const gchar* path);
gboolean umockdev_in_mock_environment (void);
void umockdev_testbed_uevent (UMockdevTestbed* self,
                              const gchar* devpath,
                              const gchar* action);
gchar* umockdev_testbed_add_device (UMockdevTestbed* self,
                                    const gchar* subsystem,
                                    const gchar* name,
                                    const gchar* parent,
                                    ...);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void umockdev_testbed_remove_device (UMockdevTestbed* self,
                                     const gchar* syspath);
gchar* umockdev_find_devnode (const gchar* devpath);
GQuark umockdev_error_quark (void);
gboolean umockdev_testbed_add_from_string (UMockdevTestbed* self,
                                           const gchar* data,
                                           GError** error);
static gchar* umockdev_testbed_add_dev_from_string (UMockdevTestbed* self,
                                             const gchar* data,
                                             GError** error);
gboolean umockdev_testbed_add_from_file (UMockdevTestbed* self,
                                         const gchar* path,
                                         GError** error);
gboolean umockdev_testbed_load_ioctl (UMockdevTestbed* self,
                                      const gchar* dev,
                                      const gchar* recordfile,
                                      GError** error);
static guint8* _vala_array_dup1 (guint8* self,
                          int length);
gboolean umockdev_testbed_load_script (UMockdevTestbed* self,
                                       const gchar* dev,
                                       const gchar* recordfile,
                                       GError** error);
gint umockdev_testbed_get_dev_fd (UMockdevTestbed* self,
                                  const gchar* devnode);
UMockdevScriptRunner* umockdev_script_runner_new (const gchar* device,
                                                  const gchar* script_file,
                                                  gint fd,
                                                  GError** error);
UMockdevScriptRunner* umockdev_script_runner_construct (GType object_type,
                                                        const gchar* device,
                                                        const gchar* script_file,
                                                        gint fd,
                                                        GError** error);
gboolean umockdev_testbed_load_socket_script (UMockdevTestbed* self,
                                              const gchar* path,
                                              gint type,
                                              const gchar* recordfile,
                                              GError** error);
UMockdevSocketServer* umockdev_socket_server_new (void);
UMockdevSocketServer* umockdev_socket_server_construct (GType object_type);
void umockdev_socket_server_add (UMockdevSocketServer* self,
                                 const gchar* sock_path,
                                 gint fd,
                                 const gchar* record_file);
gboolean umockdev_testbed_load_evemu_events (UMockdevTestbed* self,
                                             const gchar* dev,
                                             const gchar* eventsfile,
                                             GError** error);
gchar* umockdev_script_runner_encode (guint8* data,
                                      int data_length1);
static gchar* umockdev_testbed_record_parse_line (UMockdevTestbed* self,
                                           const gchar* data,
                                           gchar* type,
                                           gchar* * key,
                                           gchar* * val);
static void _vala_array_add3 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
guint8* umockdev_decode_hex (const gchar* data,
                             int* result_length1,
                             GError** error);
static void umockdev_testbed_create_node_for_device (UMockdevTestbed* self,
                                              const gchar* subsystem,
                                              const gchar* node_path,
                                              guint8* node_contents,
                                              int node_contents_length1,
                                              const gchar* majmin,
                                              GError** error);
void umockdev_testbed_disable (UMockdevTestbed* self);
void umockdev_testbed_enable (UMockdevTestbed* self);
void umockdev_testbed_clear (UMockdevTestbed* self);
static void umockdev_testbed_finalize (GObject * obj);
guint8 umockdev_hexdigit (gchar c);
static void umockdev_script_runner_set_device (UMockdevScriptRunner* self,
                                        const gchar* value);
static void* umockdev_script_runner_run (UMockdevScriptRunner* self);
static gpointer _umockdev_script_runner_run_gthread_func (gpointer self);
const gchar* umockdev_script_runner_get_device (UMockdevScriptRunner* self);
static guint8* umockdev_script_runner_next_line (UMockdevScriptRunner* self,
                                          gchar* op,
                                          guint32* delta,
                                          int* result_length1);
static void umockdev_script_runner_op_write (UMockdevScriptRunner* self,
                                      guint8* data,
                                      int data_length1,
                                      guint32 delta);
static guint8* umockdev_script_runner_decode (const gchar* quoted,
                                       int* result_length1);
static guint umockdev_script_runner_hamming (guint8* d1,
                                      int d1_length1,
                                      guint8* d2,
                                      int d2_length1);
static void _vala_array_add11 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add12 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add13 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add14 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add15 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add16 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add17 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add18 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void umockdev_script_runner_finalize (UMockdevScriptRunner * obj);
static void* umockdev_socket_server_run (UMockdevSocketServer* self);
static gpointer _umockdev_socket_server_run_gthread_func (gpointer self);
static void _vala_array_add19 (GSocket** * array,
                        int* length,
                        int* size,
                        GSocket* value);
static void umockdev_socket_server_finalize (UMockdevSocketServer * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static inline gpointer
umockdev_testbed_get_instance_private (UMockdevTestbed* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevTestbed_private_offset);
}


/**
     * umockdev_testbed_new:
     *
     * Create a new #UMockdevTestbed object. This is initially empty, call
     * methods like #umockdev_testbed_add_device or
     * #umockdev_testbed_add_from_string to fill it.
     *
     * Returns: The newly created #UMockdevTestbed object.
     */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}


static void
_umockdev_script_runner_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL));
}


UMockdevTestbed*
umockdev_testbed_construct (GType object_type)
{
	UMockdevTestbed * self = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (UMockdevTestbed*) g_object_new (object_type, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_dir_make_tmp ("umockdev.XXXXXX", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (self->priv->root_dir);
		self->priv->root_dir = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		g_error ("umockdev.vala:70: Cannot create temporary directory: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = self->priv->root_dir;
	_tmp5_ = g_build_filename (_tmp4_, "sys", NULL);
	_g_free0 (self->priv->sys_dir);
	self->priv->sys_dir = _tmp5_;
	_tmp6_ = self->priv->sys_dir;
	g_mkdir (_tmp6_, 0755);
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->dev_fd);
	self->priv->dev_fd = _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	self->priv->dev_script_runner = _tmp12_;
	_tmp13_ = self->priv->root_dir;
	g_setenv ("UMOCKDEV_DIR", _tmp13_, TRUE);
	_tmp14_ = self->priv->root_dir;
	g_debug ("umockdev.vala:79: Created udev test bed %s", _tmp14_);
	return self;
}


UMockdevTestbed*
umockdev_testbed_new (void)
{
	return umockdev_testbed_construct (UMOCKDEV_TYPE_TESTBED);
}


/**
     * umockdev_testbed_get_root_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the root directory for the testbed. This is mostly useful for
     * setting up the "dev/" or "proc/" testbed directories in this root
     * directory. For getting the mocked "sys/" dir, use
     * #umockdev_testbed_get_sys_dir.
     *
     * Returns: The testbed's root directory.
     */
gchar*
umockdev_testbed_get_root_dir (UMockdevTestbed* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
     * umockdev_testbed_get_sys_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the sysfs directory for the testbed.
     *
     * Returns: The testbed's sysfs directory.
     */
gchar*
umockdev_testbed_get_sys_dir (UMockdevTestbed* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sys_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
     * umockdev_testbed_set_attribute:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute string value
     *
     * Set a text sysfs attribute for a device.
     */
static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void
umockdev_testbed_set_attribute (UMockdevTestbed* self,
                                const gchar* devpath,
                                const gchar* name,
                                const gchar* value)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = string_get_data (value, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	umockdev_testbed_set_attribute_binary (self, devpath, name, _tmp1_, _tmp1__length1);
}


/**
     * umockdev_testbed_set_attribute_binary:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name (may contain leading directories like
     *        "queue/rotational")
     * @value: Attribute binary value
     * @value_length1: Length of @value in bytes.
     *
     * Set a binary sysfs attribute for a device.
     */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


void
umockdev_testbed_set_attribute_binary (UMockdevTestbed* self,
                                       const gchar* devpath,
                                       const gchar* name,
                                       guint8* value,
                                       int value_length1)
{
	gchar* attr_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, name, NULL);
	attr_path = _tmp1_;
	if (string_contains (name, "/")) {
		gchar* d = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = attr_path;
		_tmp3_ = g_path_get_dirname (_tmp2_);
		d = _tmp3_;
		_tmp4_ = d;
		if (g_mkdir_with_parents (_tmp4_, 0755) != 0) {
			const gchar* _tmp5_;
			gint _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = d;
			_tmp6_ = errno;
			_tmp7_ = g_strerror (_tmp6_);
			g_error ("umockdev.vala:165: cannot create attribute subdir '%s': %s", _tmp5_, _tmp7_);
		}
		_g_free0 (d);
	}
	{
		const gchar* _tmp8_;
		_tmp8_ = attr_path;
		g_file_set_contents (_tmp8_, (const char*) value, (size_t) value_length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_free0 (attr_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e->message;
		g_error ("umockdev.vala:171: Cannot write attribute file: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (attr_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (attr_path);
}


/**
     * umockdev_testbed_set_attribute_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name (may contain leading directories like
     *        "queue/rotational")
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device.
     */
void
umockdev_testbed_set_attribute_int (UMockdevTestbed* self,
                                    const gchar* devpath,
                                    const gchar* name,
                                    gint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%i", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_attribute (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
     * umockdev_testbed_set_attribute_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device. Set an integer udev
     * property for a device. @value is interpreted as a hexadecimal number.
     * For example, for value==31 this sets the attribute contents to "1f".
     */
void
umockdev_testbed_set_attribute_hex (UMockdevTestbed* self,
                                    const gchar* devpath,
                                    const gchar* name,
                                    guint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%x", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_attribute (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
     * umockdev_testbed_set_attribute_link:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute link target value
     *
     * Set a symlink sysfs attribute for a device; this is primarily important
     * for setting "driver" links.
     */
void
umockdev_testbed_set_attribute_link (UMockdevTestbed* self,
                                     const gchar* devpath,
                                     const gchar* name,
                                     const gchar* value)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* dir = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, name, NULL);
	path = _tmp1_;
	_tmp2_ = g_path_get_dirname (path);
	dir = _tmp2_;
	if (g_mkdir_with_parents (dir, 0755) != 0) {
		gint _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = errno;
		_tmp4_ = g_strerror (_tmp3_);
		g_error ("umockdev.vala:221: cannot create attribute dir '%s': %s", dir, _tmp4_);
	}
	if (symlink (value, path) < 0) {
		gint _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = errno;
		_tmp6_ = g_strerror (_tmp5_);
		g_error ("umockdev.vala:223: Cannot create symlink %s: %s", path, _tmp6_);
	}
	_g_free0 (dir);
	_g_free0 (path);
}


/**
     * umockdev_testbed_get_property:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     *
     * Get a string udev property for a device. Note that this is mostly for
     * testing umockdev itself; for real application testing, use
     * libudev/gudev.
     *
     * Returns: property value, or %NULL if it does not exist
     */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


gchar*
umockdev_testbed_get_property (UMockdevTestbed* self,
                               const gchar* devpath,
                               const gchar* name)
{
	gchar* result = NULL;
	gchar* uevent_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* ret = NULL;
	GFile* f = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	gchar* prefix = NULL;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (devpath != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, "uevent", NULL);
	uevent_path = _tmp1_;
	ret = NULL;
	_tmp2_ = uevent_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	f = _tmp3_;
	_tmp4_ = g_strconcat (name, "=", NULL);
	prefix = _tmp4_;
	{
		GFileInputStream* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileInputStream* _tmp7_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp8_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp22_;
		_tmp6_ = f;
		_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp5_);
		inp = _tmp8_;
		while (TRUE) {
			gchar* _tmp9_ = NULL;
			GDataInputStream* _tmp10_;
			gsize _tmp11_ = 0UL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp10_ = inp;
			_tmp12_ = g_data_input_stream_read_line (_tmp10_, &_tmp11_, NULL, &_inner_error_);
			len = _tmp11_;
			_tmp9_ = _tmp12_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp5_);
				goto __catch2_g_error;
			}
			_tmp13_ = _tmp9_;
			_tmp9_ = NULL;
			_g_free0 (line);
			line = _tmp13_;
			_tmp14_ = line;
			if (!(_tmp14_ != NULL)) {
				_g_free0 (_tmp9_);
				break;
			}
			_tmp15_ = line;
			_tmp16_ = prefix;
			if (g_str_has_prefix (_tmp15_, _tmp16_)) {
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gchar* _tmp21_;
				_tmp17_ = line;
				_tmp18_ = prefix;
				_tmp19_ = strlen (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = string_substring (_tmp17_, (glong) _tmp20_, (glong) -1);
				_g_free0 (ret);
				ret = _tmp21_;
				_g_free0 (_tmp9_);
				break;
			}
			_g_free0 (_tmp9_);
		}
		_tmp22_ = inp;
		g_input_stream_close ((GInputStream*) _tmp22_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp5_);
			goto __catch2_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp5_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e->message;
		g_error ("umockdev.vala:258: Cannot read uevent file: %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (prefix);
		_g_object_unref0 (f);
		_g_free0 (ret);
		_g_free0 (uevent_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = ret;
	_g_free0 (prefix);
	_g_object_unref0 (f);
	_g_free0 (uevent_path);
	return result;
}


/**
     * umockdev_testbed_set_property:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property string value
     *
     * Set a string udev property for a device.
     */
void
umockdev_testbed_set_property (UMockdevTestbed* self,
                               const gchar* devpath,
                               const gchar* name,
                               const gchar* value)
{
	gchar* uevent_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* props = NULL;
	gchar* _tmp2_;
	gchar* real_value = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* f = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	gboolean existing = FALSE;
	gchar* prefix = NULL;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, "uevent", NULL);
	uevent_path = _tmp1_;
	_tmp2_ = g_strdup ("");
	props = _tmp2_;
	if (g_strcmp0 (name, "DEVNAME") == 0) {
		_tmp3_ = g_str_has_prefix (value, "/dev/");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = string_substring (value, (glong) 5, (glong) -1);
		_g_free0 (real_value);
		real_value = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (value);
		_g_free0 (real_value);
		real_value = _tmp5_;
	}
	_tmp6_ = uevent_path;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	f = _tmp7_;
	existing = FALSE;
	_tmp8_ = g_strconcat (name, "=", NULL);
	prefix = _tmp8_;
	{
		GFileInputStream* _tmp9_ = NULL;
		GFile* _tmp10_;
		GFileInputStream* _tmp11_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp12_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp34_;
		gboolean _tmp35_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		guint8* _tmp46_;
		gint _tmp46__length1;
		guint8* _tmp47_;
		gint _tmp47__length1;
		_tmp10_ = f;
		_tmp11_ = g_file_read (_tmp10_, NULL, &_inner_error_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp12_ = g_data_input_stream_new ((GInputStream*) _tmp9_);
		inp = _tmp12_;
		while (TRUE) {
			gchar* _tmp13_ = NULL;
			GDataInputStream* _tmp14_;
			gsize _tmp15_ = 0UL;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp14_ = inp;
			_tmp16_ = g_data_input_stream_read_line (_tmp14_, &_tmp15_, NULL, &_inner_error_);
			len = _tmp15_;
			_tmp13_ = _tmp16_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp9_);
				goto __catch3_g_error;
			}
			_tmp17_ = _tmp13_;
			_tmp13_ = NULL;
			_g_free0 (line);
			line = _tmp17_;
			_tmp18_ = line;
			if (!(_tmp18_ != NULL)) {
				_g_free0 (_tmp13_);
				break;
			}
			_tmp19_ = line;
			_tmp20_ = prefix;
			if (g_str_has_prefix (_tmp19_, _tmp20_)) {
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				existing = TRUE;
				_tmp21_ = props;
				_tmp22_ = prefix;
				_tmp23_ = real_value;
				_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat (_tmp21_, _tmp27_, NULL);
				_g_free0 (props);
				props = _tmp28_;
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
			} else {
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp29_ = props;
				_tmp30_ = line;
				_tmp31_ = g_strconcat (_tmp30_, "\n", NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
				_g_free0 (props);
				props = _tmp33_;
				_g_free0 (_tmp32_);
			}
			_g_free0 (_tmp13_);
		}
		_tmp34_ = inp;
		g_input_stream_close ((GInputStream*) _tmp34_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp9_);
			goto __catch3_g_error;
		}
		_tmp35_ = existing;
		if (!_tmp35_) {
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp36_ = props;
			_tmp37_ = prefix;
			_tmp38_ = real_value;
			_tmp39_ = g_strconcat (_tmp37_, _tmp38_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp40_, "\n", NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp36_, _tmp42_, NULL);
			_g_free0 (props);
			props = _tmp43_;
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
		}
		_tmp44_ = uevent_path;
		_tmp45_ = props;
		_tmp46_ = string_get_data (_tmp45_, &_tmp46__length1);
		_tmp47_ = _tmp46_;
		_tmp47__length1 = _tmp46__length1;
		g_file_set_contents (_tmp44_, (const char*) _tmp47_, (size_t) _tmp47__length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp9_);
			goto __catch3_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp9_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp48_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp48_ = e->message;
		g_error ("umockdev.vala:311: Cannot update uevent file: %s", _tmp48_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (prefix);
		_g_object_unref0 (f);
		_g_free0 (real_value);
		_g_free0 (props);
		_g_free0 (uevent_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (prefix);
	_g_object_unref0 (f);
	_g_free0 (real_value);
	_g_free0 (props);
	_g_free0 (uevent_path);
}


/**
     * umockdev_testbed_set_property_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device.
     */
void
umockdev_testbed_set_property_int (UMockdevTestbed* self,
                                   const gchar* devpath,
                                   const gchar* name,
                                   gint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%i", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_property (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
     * umockdev_testbed_set_property_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device. @value is interpreted as a
     * hexadecimal number. For example, for value==31 this sets the property's
     * value to "1f".
     */
void
umockdev_testbed_set_property_hex (UMockdevTestbed* self,
                                   const gchar* devpath,
                                   const gchar* name,
                                   guint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%x", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_property (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}


/**
     * umockdev_testbed_add_devicev:
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @attributes: (array zero-terminated=1):
     *              A list of device sysfs attributes, alternating names and
     *              values, terminated with %NULL:
     *              { "key1", "value1", "key2", "value2", ..., NULL }
     * @properties: (array zero-terminated=1):
     *              A list of device udev properties; same format as @attributes
     *
     * This method is mostly meant for language bindings (where it is named
     * umockdev_testbed_add_device()). For C programs it is usually more convenient to
     * use umockdev_testbed_add_device().
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     *
     * Rename to: umockdev_testbed_add_device
     */
static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar*
umockdev_testbed_add_devicev (UMockdevTestbed* self,
                              const gchar* subsystem,
                              const gchar* name,
                              const gchar* parent,
                              gchar** attributes,
                              gchar** properties)
{
	gchar* result = NULL;
	gchar* dev_path = NULL;
	gchar* dev_node = NULL;
	gchar* dev_dir = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gchar* dev_path_no_sys = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gchar* props = NULL;
	gchar* _tmp75_;
	const gchar* _tmp107_;
	const gchar* _tmp108_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	dev_node = NULL;
	if (parent != NULL) {
		gchar* _tmp0_;
		if (!g_str_has_prefix (parent, "/sys/")) {
			g_critical ("umockdev.vala:386: add_devicev(): parent device %s does not start with" \
" /sys/", parent);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		if (!g_file_test (parent, G_FILE_TEST_IS_DIR)) {
			g_critical ("umockdev.vala:390: add_devicev(): parent device %s does not exist", parent);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		_tmp0_ = g_build_filename (parent, name, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_build_filename ("/sys/devices", name, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp1_;
	}
	_tmp2_ = self->priv->root_dir;
	_tmp3_ = dev_path;
	_tmp4_ = g_build_filename (_tmp2_, _tmp3_, NULL);
	dev_dir = _tmp4_;
	_tmp6_ = dev_dir;
	if (g_file_test (_tmp6_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = dev_dir;
		_tmp8_ = g_build_filename (_tmp7_, "uevent", NULL);
		_tmp9_ = _tmp8_;
		_tmp5_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
		_g_free0 (_tmp9_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp10_;
		_tmp10_ = dev_dir;
		g_error ("umockdev.vala:401: device %s already exists", _tmp10_);
	}
	_tmp11_ = dev_path;
	_tmp12_ = dev_path;
	_tmp13_ = string_substring (_tmp11_, (glong) string_index_of (_tmp12_, "/devices/", 0), (glong) -1);
	dev_path_no_sys = _tmp13_;
	_tmp14_ = dev_dir;
	if (g_mkdir_with_parents (_tmp14_, 0755) != 0) {
		const gchar* _tmp15_;
		gint _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = dev_dir;
		_tmp16_ = errno;
		_tmp17_ = g_strerror (_tmp16_);
		g_error ("umockdev.vala:407: cannot create dev dir '%s': %s", _tmp15_, _tmp17_);
	}
	if (g_strcmp0 (subsystem, "usb") != 0) {
		_tmp19_ = g_strcmp0 (subsystem, "pci") != 0;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		_tmp18_ = g_strcmp0 (subsystem, "thunderbolt") != 0;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gchar* class_dir = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp20_ = self->priv->sys_dir;
		_tmp21_ = g_build_filename (_tmp20_, "class", subsystem, NULL);
		class_dir = _tmp21_;
		_tmp22_ = class_dir;
		if (g_mkdir_with_parents (_tmp22_, 0755) != 0) {
			const gchar* _tmp23_;
			gint _tmp24_;
			const gchar* _tmp25_;
			_tmp23_ = class_dir;
			_tmp24_ = errno;
			_tmp25_ = g_strerror (_tmp24_);
			g_error ("umockdev.vala:412: cannot create class dir '%s': %s", _tmp23_, _tmp25_);
		}
		_tmp26_ = dev_path;
		_tmp27_ = umockdev_make_dotdots (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_build_filename (_tmp28_, "class", subsystem, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = dev_dir;
		_tmp32_ = g_build_filename (_tmp31_, "subsystem", NULL);
		_tmp33_ = _tmp32_;
		_vala_assert (symlink (_tmp30_, _tmp33_) == 0, "FileUtils.symlink(Path.build_filename(make_dotdots(dev_path), \"class\", subsystem),                                      Path.build_filename(dev_dir, \"subsystem\")) == 0");
		_g_free0 (_tmp33_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_tmp34_ = dev_path_no_sys;
		_tmp35_ = g_build_filename ("..", "..", _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = class_dir;
		_tmp38_ = g_path_get_basename (name);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_build_filename (_tmp37_, _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		_vala_assert (symlink (_tmp36_, _tmp41_) == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", dev_path_no_sys),                                      Path.build_filename(class_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp36_);
		_g_free0 (class_dir);
	} else {
		gchar* bus_dir = NULL;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		const gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp42_ = self->priv->sys_dir;
		_tmp43_ = g_build_filename (_tmp42_, "bus", subsystem, "devices", NULL);
		bus_dir = _tmp43_;
		_tmp44_ = bus_dir;
		_vala_assert (g_mkdir_with_parents (_tmp44_, 0755) == 0, "DirUtils.create_with_parents(bus_dir, 0755) == 0");
		_tmp45_ = dev_path_no_sys;
		_tmp46_ = g_build_filename ("..", "..", "..", _tmp45_, NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = bus_dir;
		_tmp49_ = g_path_get_basename (name);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_build_filename (_tmp48_, _tmp50_, NULL);
		_tmp52_ = _tmp51_;
		_vala_assert (symlink (_tmp47_, _tmp52_) == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", \"..\", dev_path_no_sys),                                      Path.build_filename(bus_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp47_);
		_tmp53_ = dev_path;
		_tmp54_ = umockdev_make_dotdots (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_build_filename (_tmp55_, "bus", subsystem, NULL);
		_tmp57_ = _tmp56_;
		_tmp58_ = dev_dir;
		_tmp59_ = g_build_filename (_tmp58_, "subsystem", NULL);
		_tmp60_ = _tmp59_;
		_vala_assert (symlink (_tmp57_, _tmp60_) == 0, "FileUtils.symlink(Path.build_filename(make_dotdots(dev_path), \"bus\", subsystem),                                      Path.build_filename(dev_dir, \"subsystem\")) == 0");
		_g_free0 (_tmp60_);
		_g_free0 (_tmp57_);
		_g_free0 (_tmp55_);
		_g_free0 (bus_dir);
	}
	if (g_strcmp0 (subsystem, "block") == 0) {
		gchar* block_dir = NULL;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		_tmp61_ = self->priv->sys_dir;
		_tmp62_ = g_build_filename (_tmp61_, "block", NULL);
		block_dir = _tmp62_;
		_tmp63_ = block_dir;
		if (g_mkdir_with_parents (_tmp63_, 0755) != 0) {
			const gchar* _tmp64_;
			gint _tmp65_;
			const gchar* _tmp66_;
			_tmp64_ = block_dir;
			_tmp65_ = errno;
			_tmp66_ = g_strerror (_tmp65_);
			g_error ("umockdev.vala:439: cannot create block dir '%s': %s", _tmp64_, _tmp66_);
		}
		_tmp67_ = dev_path_no_sys;
		_tmp68_ = g_build_filename ("..", _tmp67_, NULL);
		_tmp69_ = _tmp68_;
		_tmp70_ = block_dir;
		_tmp71_ = g_path_get_basename (name);
		_tmp72_ = _tmp71_;
		_tmp73_ = g_build_filename (_tmp70_, _tmp72_, NULL);
		_tmp74_ = _tmp73_;
		_vala_assert (symlink (_tmp69_, _tmp74_) == 0, "FileUtils.symlink(Path.build_filename(\"..\", dev_path_no_sys),                                      Path.build_filename(block_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp74_);
		_g_free0 (_tmp72_);
		_g_free0 (_tmp69_);
		_g_free0 (block_dir);
	}
	_tmp75_ = g_strdup ("");
	props = _tmp75_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp76_ = FALSE;
			_tmp76_ = TRUE;
			while (TRUE) {
				gint _tmp78_;
				gboolean _tmp79_ = FALSE;
				gint _tmp80_;
				const gchar* _tmp81_;
				if (!_tmp76_) {
					gint _tmp77_;
					_tmp77_ = i;
					i = _tmp77_ + 2;
				}
				_tmp76_ = FALSE;
				_tmp78_ = i;
				if (!(_tmp78_ < (_vala_array_length (properties) - 1))) {
					break;
				}
				_tmp80_ = i;
				_tmp81_ = properties[_tmp80_];
				if (g_strcmp0 (_tmp81_, "DEVNAME") == 0) {
					gint _tmp82_;
					const gchar* _tmp83_;
					_tmp82_ = i;
					_tmp83_ = properties[_tmp82_ + 1];
					_tmp79_ = g_str_has_prefix (_tmp83_, "/dev/");
				} else {
					_tmp79_ = FALSE;
				}
				if (_tmp79_) {
					gint _tmp84_;
					const gchar* _tmp85_;
					gchar* _tmp86_;
					const gchar* _tmp87_;
					const gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					_tmp84_ = i;
					_tmp85_ = properties[_tmp84_ + 1];
					_tmp86_ = string_substring (_tmp85_, (glong) 5, (glong) -1);
					_g_free0 (dev_node);
					dev_node = _tmp86_;
					_tmp87_ = props;
					_tmp88_ = dev_node;
					_tmp89_ = g_strconcat ("DEVNAME=", _tmp88_, NULL);
					_tmp90_ = _tmp89_;
					_tmp91_ = g_strconcat (_tmp90_, "\n", NULL);
					_tmp92_ = _tmp91_;
					_tmp93_ = g_strconcat (_tmp87_, _tmp92_, NULL);
					_g_free0 (props);
					props = _tmp93_;
					_g_free0 (_tmp92_);
					_g_free0 (_tmp90_);
				} else {
					const gchar* _tmp94_;
					gint _tmp95_;
					const gchar* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					gint _tmp99_;
					const gchar* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					gchar* _tmp105_;
					_tmp94_ = props;
					_tmp95_ = i;
					_tmp96_ = properties[_tmp95_];
					_tmp97_ = g_strconcat (_tmp96_, "=", NULL);
					_tmp98_ = _tmp97_;
					_tmp99_ = i;
					_tmp100_ = properties[_tmp99_ + 1];
					_tmp101_ = g_strconcat (_tmp98_, _tmp100_, NULL);
					_tmp102_ = _tmp101_;
					_tmp103_ = g_strconcat (_tmp102_, "\n", NULL);
					_tmp104_ = _tmp103_;
					_tmp105_ = g_strconcat (_tmp94_, _tmp104_, NULL);
					_g_free0 (props);
					props = _tmp105_;
					_g_free0 (_tmp104_);
					_g_free0 (_tmp102_);
					_g_free0 (_tmp98_);
				}
			}
		}
	}
	if ((_vala_array_length (properties) % 2) != 0) {
		const gchar* _tmp106_;
		_tmp106_ = properties[_vala_array_length (properties) - 1];
		g_warning ("umockdev.vala:455: add_devicev: Ignoring property key '%s' without val" \
"ue", _tmp106_);
	}
	_tmp107_ = dev_path;
	_tmp108_ = props;
	umockdev_testbed_set_attribute (self, _tmp107_, "uevent", _tmp108_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp109_ = FALSE;
			_tmp109_ = TRUE;
			while (TRUE) {
				gint _tmp111_;
				const gchar* _tmp112_;
				gint _tmp113_;
				const gchar* _tmp114_;
				gint _tmp115_;
				const gchar* _tmp116_;
				gboolean _tmp117_ = FALSE;
				gint _tmp118_;
				const gchar* _tmp119_;
				if (!_tmp109_) {
					gint _tmp110_;
					_tmp110_ = i;
					i = _tmp110_ + 2;
				}
				_tmp109_ = FALSE;
				_tmp111_ = i;
				if (!(_tmp111_ < (_vala_array_length (attributes) - 1))) {
					break;
				}
				_tmp112_ = dev_path;
				_tmp113_ = i;
				_tmp114_ = attributes[_tmp113_];
				_tmp115_ = i;
				_tmp116_ = attributes[_tmp115_ + 1];
				umockdev_testbed_set_attribute (self, _tmp112_, _tmp114_, _tmp116_);
				_tmp118_ = i;
				_tmp119_ = attributes[_tmp118_];
				if (g_strcmp0 (_tmp119_, "dev") == 0) {
					const gchar* _tmp120_;
					_tmp120_ = dev_node;
					_tmp117_ = _tmp120_ != NULL;
				} else {
					_tmp117_ = FALSE;
				}
				if (_tmp117_) {
					gchar* infodir = NULL;
					const gchar* _tmp121_;
					gchar* _tmp122_;
					const gchar* _tmp123_;
					gint _tmp124_;
					const gchar* _tmp125_;
					const gchar* _tmp126_;
					const gchar* _tmp127_;
					gchar* _tmp128_;
					gchar* _tmp129_;
					gchar* _tmp130_;
					gchar* _tmp131_;
					const gchar* _tmp132_ = NULL;
					const gchar* _tmp133_;
					gchar* sysdev_dir = NULL;
					const gchar* _tmp134_;
					gchar* _tmp135_;
					const gchar* _tmp136_;
					gchar* dest = NULL;
					const gchar* _tmp140_;
					gint _tmp141_;
					const gchar* _tmp142_;
					gchar* _tmp143_;
					const gchar* _tmp144_;
					_tmp121_ = self->priv->root_dir;
					_tmp122_ = g_build_filename (_tmp121_, "dev", ".node", NULL);
					infodir = _tmp122_;
					_tmp123_ = infodir;
					g_mkdir_with_parents (_tmp123_, 0755);
					_tmp124_ = i;
					_tmp125_ = attributes[_tmp124_ + 1];
					_tmp126_ = infodir;
					_tmp127_ = dev_node;
					_tmp128_ = string_replace (_tmp127_, "/", "_");
					_tmp129_ = _tmp128_;
					_tmp130_ = g_build_filename (_tmp126_, _tmp129_, NULL);
					_tmp131_ = _tmp130_;
					_vala_assert (symlink (_tmp125_, _tmp131_) == 0, "FileUtils.symlink(attributes[i+1],                                          Path.build_filename(infodir, dev_node.replace(\"/\", \"_\"))) == 0");
					_g_free0 (_tmp131_);
					_g_free0 (_tmp129_);
					_tmp133_ = dev_path;
					if (string_contains (_tmp133_, "/block/")) {
						_tmp132_ = "block";
					} else {
						_tmp132_ = "char";
					}
					_tmp134_ = self->priv->sys_dir;
					_tmp135_ = g_build_filename (_tmp134_, "dev", _tmp132_, NULL);
					sysdev_dir = _tmp135_;
					_tmp136_ = sysdev_dir;
					if (g_mkdir_with_parents (_tmp136_, 0755) != 0) {
						const gchar* _tmp137_;
						gint _tmp138_;
						const gchar* _tmp139_;
						_tmp137_ = sysdev_dir;
						_tmp138_ = errno;
						_tmp139_ = g_strerror (_tmp138_);
						g_error ("umockdev.vala:472: cannot create dir '%s': %s", _tmp137_, _tmp139_);
					}
					_tmp140_ = sysdev_dir;
					_tmp141_ = i;
					_tmp142_ = attributes[_tmp141_ + 1];
					_tmp143_ = g_build_filename (_tmp140_, _tmp142_, NULL);
					dest = _tmp143_;
					_tmp144_ = dest;
					if (!g_file_test (_tmp144_, G_FILE_TEST_EXISTS)) {
						const gchar* _tmp145_;
						gchar* _tmp146_;
						gchar* _tmp147_;
						gchar* _tmp148_;
						gchar* _tmp149_;
						const gchar* _tmp150_;
						gboolean _tmp151_;
						_tmp145_ = dev_path;
						_tmp146_ = string_substring (_tmp145_, (glong) 5, (glong) -1);
						_tmp147_ = _tmp146_;
						_tmp148_ = g_strconcat ("../../", _tmp147_, NULL);
						_tmp149_ = _tmp148_;
						_tmp150_ = dest;
						_tmp151_ = symlink (_tmp149_, _tmp150_) < 0;
						_g_free0 (_tmp149_);
						_g_free0 (_tmp147_);
						if (_tmp151_) {
							const gchar* _tmp152_;
							const gchar* _tmp153_;
							gchar* _tmp154_;
							gchar* _tmp155_;
							gint _tmp156_;
							const gchar* _tmp157_;
							_tmp152_ = dest;
							_tmp153_ = dev_path;
							_tmp154_ = string_substring (_tmp153_, (glong) 5, (glong) -1);
							_tmp155_ = _tmp154_;
							_tmp156_ = errno;
							_tmp157_ = g_strerror (_tmp156_);
							g_error ("umockdev.vala:476: add_device %s: failed to symlink %s to %s: %s\n", name, _tmp152_, _tmp155_, _tmp157_);
							_g_free0 (_tmp155_);
						}
					}
					_g_free0 (dest);
					_g_free0 (sysdev_dir);
					_g_free0 (infodir);
				}
			}
		}
	}
	if ((_vala_array_length (attributes) % 2) != 0) {
		const gchar* _tmp158_;
		_tmp158_ = attributes[_vala_array_length (attributes) - 1];
		g_warning ("umockdev.vala:482: add_devicev: Ignoring attribute key '%s' without va" \
"lue", _tmp158_);
	}
	if (umockdev_in_mock_environment ()) {
		const gchar* _tmp159_;
		_tmp159_ = dev_path;
		umockdev_testbed_uevent (self, _tmp159_, "add");
	}
	result = dev_path;
	_g_free0 (props);
	_g_free0 (dev_path_no_sys);
	_g_free0 (dev_dir);
	_g_free0 (dev_node);
	return result;
}


/**
     * umockdev_testbed_add_device: (skip)
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @...: Arbitrarily many pairs of sysfs attributes (alternating names and
     *       values), terminated by %NULL, followed by arbitrarily many pairs of udev
     *       properties, terminated by another %NULL.
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * Example:
     *   |[
     *   umockdev_testbed_add_device (testbed, "usb", "dev1", NULL,
     *                              "idVendor", "0815", "idProduct", "AFFE", NULL,
     *                              "ID_MODEL", "KoolGadget", NULL);
     *   ]|
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     */
static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar*
umockdev_testbed_add_device (UMockdevTestbed* self,
                             const gchar* subsystem,
                             const gchar* name,
                             const gchar* parent,
                             ...)
{
	gchar* result = NULL;
	gchar** attributes = NULL;
	gchar** _tmp0_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** properties = NULL;
	gchar** _tmp1_;
	gint properties_length1;
	gint _properties_size_;
	gint arg_set = 0;
	va_list l = {0};
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	attributes = _tmp0_;
	attributes_length1 = 0;
	_attributes_size_ = attributes_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	properties = _tmp1_;
	properties_length1 = 0;
	_properties_size_ = properties_length1;
	arg_set = 0;
	va_start (l, parent);
	while (TRUE) {
		gchar* arg = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp7_;
		_tmp2_ = va_arg (l, gchar*);
		_tmp3_ = g_strdup (_tmp2_);
		arg = _tmp3_;
		_tmp4_ = arg;
		if (_tmp4_ == NULL) {
			gint _tmp5_;
			gint _tmp6_;
			_tmp5_ = arg_set;
			arg_set = _tmp5_ + 1;
			_tmp6_ = arg_set;
			if (_tmp6_ > 1) {
				_g_free0 (arg);
				break;
			} else {
				_g_free0 (arg);
				continue;
			}
		}
		_tmp7_ = arg_set;
		if (_tmp7_ == 0) {
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = attributes;
			_tmp8__length1 = attributes_length1;
			_tmp9_ = arg;
			_tmp10_ = g_strdup (_tmp9_);
			_vala_array_add1 (&attributes, &attributes_length1, &_attributes_size_, _tmp10_);
		} else {
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = properties;
			_tmp11__length1 = properties_length1;
			_tmp12_ = arg;
			_tmp13_ = g_strdup (_tmp12_);
			_vala_array_add2 (&properties, &properties_length1, &_properties_size_, _tmp13_);
		}
		_g_free0 (arg);
	}
	_tmp14_ = attributes;
	_tmp14__length1 = attributes_length1;
	_tmp15_ = properties;
	_tmp15__length1 = properties_length1;
	_tmp16_ = umockdev_testbed_add_devicev (self, subsystem, name, parent, _tmp14_, _tmp15_);
	result = _tmp16_;
	va_end (l);
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_free), NULL);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
     * umockdev_testbed_remove_device:
     * @self: A #UMockdevTestbed.
     * @syspath: Sysfs path of device
     *
     * Remove a device from the testbed. This removes the sysfs directory, the
     * /sys/class/ link, the device node, and all other information related to
     * it. Note that this will also remove all child devices (i. e.
     * subdirectories of @syspath).
     */
void
umockdev_testbed_remove_device (UMockdevTestbed* self,
                                const gchar* syspath)
{
	gchar* real_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* devname = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* subsystem = NULL;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	const gchar* _tmp51_;
	const gchar* _tmp67_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (syspath != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, syspath, NULL);
	real_path = _tmp1_;
	_tmp2_ = g_path_get_basename (syspath);
	devname = _tmp2_;
	_tmp3_ = real_path;
	if (!g_file_test (_tmp3_, G_FILE_TEST_IS_DIR)) {
		g_critical ("umockdev.vala:562: umockdev_testbed_remove_device(): device %s does no" \
"t exist", syspath);
		_g_free0 (devname);
		_g_free0 (real_path);
		return;
	}
	{
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = real_path;
		_tmp6_ = g_build_filename (_tmp5_, "subsystem", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_read_link (_tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_tmp4_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = g_path_get_basename (_tmp4_);
		_g_free0 (subsystem);
		subsystem = _tmp10_;
		_g_free0 (_tmp4_);
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("umockdev.vala:572: umockdev_testbed_remove_device(): cannot determine " \
"subsystem of %s: %s", syspath, _tmp12_);
		_g_error_free0 (e);
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		return;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* dev_maj_min = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* dev_node = NULL;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp13_ = real_path;
		_tmp14_ = g_build_filename (_tmp13_, "dev", NULL);
		_tmp15_ = _tmp14_;
		g_file_get_contents (_tmp15_, &_tmp16_, NULL, &_inner_error_);
		_g_free0 (dev_maj_min);
		dev_maj_min = _tmp16_;
		_g_free0 (_tmp15_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (dev_maj_min);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch6_g_file_error;
			}
			_g_free0 (dev_maj_min);
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (string_contains (syspath, "/block/")) {
			_tmp17_ = "block";
		} else {
			_tmp17_ = "char";
		}
		_tmp18_ = self->priv->sys_dir;
		_tmp19_ = dev_maj_min;
		_tmp20_ = g_build_filename (_tmp18_, "dev", _tmp17_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		g_unlink (_tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = real_path;
		_tmp23_ = umockdev_find_devnode (_tmp22_);
		dev_node = _tmp23_;
		_tmp24_ = dev_node;
		if (_tmp24_ != NULL) {
			gchar* real_node = NULL;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp25_ = self->priv->root_dir;
			_tmp26_ = dev_node;
			_tmp27_ = g_build_filename (_tmp25_, _tmp26_, NULL);
			real_node = _tmp27_;
			_tmp28_ = real_node;
			g_unlink (_tmp28_);
			_tmp29_ = real_node;
			_tmp30_ = g_path_get_dirname (_tmp29_);
			_tmp31_ = _tmp30_;
			g_rmdir (_tmp31_);
			_g_free0 (_tmp31_);
			_tmp32_ = self->priv->root_dir;
			_tmp33_ = dev_node;
			_tmp34_ = string_substring (_tmp33_, (glong) 5, (glong) -1);
			_tmp35_ = _tmp34_;
			_tmp36_ = string_replace (_tmp35_, "/", "_");
			_tmp37_ = _tmp36_;
			_tmp38_ = g_build_filename (_tmp32_, "dev", ".node", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			g_unlink (_tmp39_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_g_free0 (real_node);
		}
		_g_free0 (dev_node);
		_g_free0 (dev_maj_min);
	}
	goto __finally6;
	__catch6_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp40_ = self->priv->sys_dir;
	_tmp41_ = subsystem;
	_tmp42_ = devname;
	_tmp43_ = g_build_filename (_tmp40_, "class", _tmp41_, _tmp42_, NULL);
	_tmp44_ = _tmp43_;
	g_unlink (_tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = self->priv->sys_dir;
	_tmp46_ = subsystem;
	_tmp47_ = g_build_filename (_tmp45_, "class", _tmp46_, NULL);
	_tmp48_ = _tmp47_;
	g_rmdir (_tmp48_);
	_g_free0 (_tmp48_);
	_tmp51_ = subsystem;
	if (g_strcmp0 (_tmp51_, "usb") == 0) {
		_tmp50_ = TRUE;
	} else {
		const gchar* _tmp52_;
		_tmp52_ = subsystem;
		_tmp50_ = g_strcmp0 (_tmp52_, "pci") == 0;
	}
	if (_tmp50_) {
		_tmp49_ = TRUE;
	} else {
		const gchar* _tmp53_;
		_tmp53_ = subsystem;
		_tmp49_ = g_strcmp0 (_tmp53_, "thunderbolt") == 0;
	}
	if (_tmp49_) {
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp54_ = self->priv->sys_dir;
		_tmp55_ = subsystem;
		_tmp56_ = devname;
		_tmp57_ = g_build_filename (_tmp54_, "bus", _tmp55_, "devices", _tmp56_, NULL);
		_tmp58_ = _tmp57_;
		g_unlink (_tmp58_);
		_g_free0 (_tmp58_);
		_tmp59_ = self->priv->sys_dir;
		_tmp60_ = subsystem;
		_tmp61_ = g_build_filename (_tmp59_, "bus", _tmp60_, "devices", NULL);
		_tmp62_ = _tmp61_;
		g_rmdir (_tmp62_);
		_g_free0 (_tmp62_);
		_tmp63_ = self->priv->sys_dir;
		_tmp64_ = subsystem;
		_tmp65_ = g_build_filename (_tmp63_, "bus", _tmp64_, NULL);
		_tmp66_ = _tmp65_;
		g_rmdir (_tmp66_);
		_g_free0 (_tmp66_);
	}
	_tmp67_ = real_path;
	umockdev_remove_dir (_tmp67_, TRUE);
	_g_free0 (subsystem);
	_g_free0 (devname);
	_g_free0 (real_path);
}


/**
     * umockdev_testbed_add_from_string:
     * @self: A #UMockdevTestbed.
     * @data: Description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This reads
     * the format generated by the umockdev-record tool.
     *
     * Each paragraph defines one device. A line starts with a type tag (like 'E'),
     * followed by a colon, followed by either a value or a "key=value" assignment,
     * depending on the type tag. A device description must start with a 'P:' line.
     * Available type tags are:
     * <itemizedlist>
     *   <listitem><type>P:</type> <emphasis>path</emphasis>: device path in sysfs, starting with
     *             <filename>/devices/</filename>; must occur exactly once at the
     *             start of device definition</listitem>
     *   <listitem><type>E:</type> <emphasis>key=value</emphasis>: udev property
     *             </listitem>
     *   <listitem><type>A:</type> <emphasis>key=value</emphasis>: ASCII sysfs
     *             attribute, with backslash-style escaping of \ (\\) and newlines
     *             (\n)</listitem>
     *   <listitem><type>H:</type> <emphasis>key=value</emphasis>: binary sysfs
     *             attribute, with the value being written as continuous hex string
     *             (e. g. 0081FE0A..)</listitem>
     *   <listitem><type>N:</type> <emphasis>devname</emphasis>[=<emphasis>contents</emphasis>]:
     *             device node name (without the <filename>/dev/</filename>
     *             prefix); if <emphasis>contents</emphasis> is given (encoded in a
     *             continuous hex string), it creates a
     *             <filename>/dev/devname</filename> in the mock environment with
     *             the given contents, otherwise the created dev file will be a
     *             pty; see #umockdev_testbed_get_dev_fd for details.</listitem>
     *   <listitem><type>S:</type> <emphasis>linkname</emphasis>: device node
     *             symlink (without the <filename>/dev/</filename> prefix); ignored right
     *             now.</listitem>
     * </itemizedlist>
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


gboolean
umockdev_testbed_add_from_string (UMockdevTestbed* self,
                                  const gchar* data,
                                  GError** error)
{
	gboolean result = FALSE;
	gchar* cur_data = NULL;
	gchar* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	{
		GRegex* _tmp0_;
		GRegex* _tmp5_;
		GRegex* _tmp10_;
		_tmp0_ = self->priv->re_record_val;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp4_;
			_tmp2_ = g_regex_new ("^([PS]): (.*)(?>\n|$)", 0, 0, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp3_ = FALSE;
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp3_;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (self->priv->re_record_val);
			self->priv->re_record_val = _tmp4_;
			_g_regex_unref0 (_tmp1_);
		}
		_tmp5_ = self->priv->re_record_keyval;
		if (_tmp5_ == NULL) {
			GRegex* _tmp6_ = NULL;
			GRegex* _tmp7_;
			GRegex* _tmp9_;
			_tmp7_ = g_regex_new ("^([EAHL]): ([^=\n]+)=(.*)(?>\n|$)", 0, 0, &_inner_error_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp8_ = FALSE;
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp8_;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_regex_unref0 (self->priv->re_record_keyval);
			self->priv->re_record_keyval = _tmp9_;
			_g_regex_unref0 (_tmp6_);
		}
		_tmp10_ = self->priv->re_record_optval;
		if (_tmp10_ == NULL) {
			GRegex* _tmp11_ = NULL;
			GRegex* _tmp12_;
			GRegex* _tmp14_;
			_tmp12_ = g_regex_new ("^([N]): ([^=\n]+)(?>=([0-9A-F]+))?(?>\n|$)", 0, 0, &_inner_error_);
			_tmp11_ = _tmp12_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp13_ = FALSE;
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp13_;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_regex_unref0 (self->priv->re_record_optval);
			self->priv->re_record_optval = _tmp14_;
			_g_regex_unref0 (_tmp11_);
		}
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e->message;
		g_error ("umockdev.vala:657: Internal error, cannot create regex: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			gboolean _tmp16_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp16_;
		} else {
			gboolean _tmp17_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp17_;
		}
	}
	_tmp18_ = g_strdup (data);
	cur_data = _tmp18_;
	while (TRUE) {
		const gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp25_;
		_tmp19_ = cur_data;
		if (!(string_get (_tmp19_, (glong) 0) != '\0')) {
			break;
		}
		_tmp21_ = cur_data;
		_tmp22_ = umockdev_testbed_add_dev_from_string (self, _tmp21_, &_inner_error_);
		_tmp20_ = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				gboolean _tmp23_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_free0 (cur_data);
				return _tmp23_;
			} else {
				gboolean _tmp24_ = FALSE;
				_g_free0 (cur_data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp24_;
			}
		}
		_tmp25_ = _tmp20_;
		_tmp20_ = NULL;
		_g_free0 (cur_data);
		cur_data = _tmp25_;
		_g_free0 (_tmp20_);
	}
	result = TRUE;
	_g_free0 (cur_data);
	return result;
}


/**
     * umockdev_testbed_add_from_file:
     * @self: A #UMockdevTestbed.
     * @path: Path to file with description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This
     * reads a file with the format generated by the umockdev-record tool, and
     * is mostly a convenience wrapper around
     * @umockdev_testbed_add_from_string.
     *
     * Returns: %TRUE on success, %FALSE if the @path cannot be read or thhe
     *          data is invalid and an error occurred.
     */
gboolean
umockdev_testbed_add_from_file (UMockdevTestbed* self,
                                const gchar* path,
                                GError** error)
{
	gboolean result = FALSE;
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_file_get_contents (path, &_tmp0_, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == UMOCKDEV_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (contents);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp2_;
		}
	}
	_tmp4_ = contents;
	_tmp3_ = umockdev_testbed_add_from_string (self, _tmp4_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == UMOCKDEV_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			gboolean _tmp5_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (contents);
			return _tmp5_;
		} else {
			gboolean _tmp6_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp6_;
		}
	}
	result = _tmp3_;
	_g_free0 (contents);
	return result;
}


/**
     * umockdev_testbed_uevent:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @action: "add", "remove", or "change"
     *
     * Generate an uevent for a device.
     */
void
umockdev_testbed_uevent (UMockdevTestbed* self,
                         const gchar* devpath,
                         const gchar* action)
{
	uevent_sender* _tmp0_;
	uevent_sender* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->ev_sender;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		uevent_sender* _tmp2_;
		uevent_sender* _tmp3_;
		g_debug ("umockdev.vala:700: umockdev_testbed_uevent: lazily initializing uevent" \
"_sender");
		_tmp1_ = self->priv->root_dir;
		_tmp2_ = uevent_sender_open (_tmp1_);
		_uevent_sender_close0 (self->priv->ev_sender);
		self->priv->ev_sender = _tmp2_;
		_tmp3_ = self->priv->ev_sender;
		_vala_assert (_tmp3_ != NULL, "this.ev_sender != null");
	}
	g_debug ("umockdev.vala:704: umockdev_testbed_uevent: sending uevent %s for devi" \
"ce %s", action, devpath);
	_tmp4_ = self->priv->ev_sender;
	uevent_sender_send (_tmp4_, devpath, action);
}


/**
     * umockdev_testbed_load_ioctl:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the ioctl record.
     *       %NULL is valid; in this case the ioctl record is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the ioctl record file.
     * @error: return location for a GError, or %NULL
     *
     * Load an ioctl record file for a particular device into the testbed.
     * ioctl records can be created with umockdev-record --ioctl.
     * They can optionally be xz compressed to save space (but then are
     * required to have an .xz file name suffix).
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static guint8*
_vala_array_dup1 (guint8* self,
                  int length)
{
	return g_memdup (self, length * sizeof (guint8));
}


gboolean
umockdev_testbed_load_ioctl (UMockdevTestbed* self,
                             const gchar* dev,
                             const gchar* recordfile,
                             GError** error)
{
	gboolean result = FALSE;
	GDataInputStream* recording = NULL;
	gchar* owned_dev = NULL;
	gchar* _tmp0_;
	const gchar* _tmp26_;
	gchar* dest = NULL;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* contents = NULL;
	GDataInputStream* _tmp55_;
	gchar* _tmp56_;
	const gchar* _tmp58_;
	gboolean _tmp60_ = FALSE;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = g_strdup (dev);
	owned_dev = _tmp0_;
	if (g_str_has_suffix (recordfile, ".xz")) {
		{
			gchar* contents = NULL;
			gint exit = 0;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar** _tmp4_;
			gchar** _tmp5_;
			gint _tmp5__length1;
			gchar* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp9_;
			const gchar* _tmp10_;
			guint8* _tmp11_;
			gint _tmp11__length1;
			guint8* _tmp12_;
			gint _tmp12__length1;
			guint8* _tmp13_;
			gint _tmp13__length1;
			GMemoryInputStream* _tmp14_;
			GMemoryInputStream* _tmp15_;
			GDataInputStream* _tmp16_;
			_tmp1_ = g_strdup ("xz");
			_tmp2_ = g_strdup ("-cd");
			_tmp3_ = g_strdup (recordfile);
			_tmp4_ = g_new0 (gchar*, 3 + 1);
			_tmp4_[0] = _tmp1_;
			_tmp4_[1] = _tmp2_;
			_tmp4_[2] = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp5__length1 = 3;
			g_spawn_sync (NULL, _tmp5_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp6_, NULL, &_tmp7_, &_inner_error_);
			_g_free0 (contents);
			contents = _tmp6_;
			exit = _tmp7_;
			_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp8_ = FALSE;
				_g_free0 (contents);
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch8_g_spawn_error;
				}
				_g_free0 (contents);
				_g_free0 (owned_dev);
				_g_object_unref0 (recording);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp8_;
			}
			_tmp9_ = exit;
			_vala_assert (_tmp9_ == 0, "exit == 0");
			_tmp10_ = contents;
			_tmp11_ = string_get_data (_tmp10_, &_tmp11__length1);
			_tmp12_ = _tmp11_;
			_tmp12__length1 = _tmp11__length1;
			_tmp13_ = (_tmp12_ != NULL) ? _vala_array_dup1 (_tmp12_, _tmp12__length1) : ((gpointer) _tmp12_);
			_tmp13__length1 = _tmp12__length1;
			_tmp14_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp13_, _tmp13__length1, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_data_input_stream_new ((GInputStream*) _tmp15_);
			_g_object_unref0 (recording);
			recording = _tmp16_;
			_g_object_unref0 (_tmp15_);
			_g_free0 (contents);
		}
		goto __finally8;
		__catch8_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp17_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = e->message;
			g_error ("umockdev.vala:745: Cannot call xz to decompress %s: %s", recordfile, _tmp17_);
			_g_error_free0 (e);
		}
		__finally8:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp18_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp18_;
		}
	} else {
		GFileInputStream* _tmp19_ = NULL;
		GFile* _tmp20_;
		GFile* _tmp21_;
		GFileInputStream* _tmp22_;
		GFileInputStream* _tmp23_;
		GDataInputStream* _tmp25_;
		_tmp20_ = g_file_new_for_path (recordfile);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_file_read (_tmp21_, NULL, &_inner_error_);
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp21_);
		_tmp19_ = _tmp23_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp24_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp24_;
		}
		_tmp25_ = g_data_input_stream_new ((GInputStream*) _tmp19_);
		_g_object_unref0 (recording);
		recording = _tmp25_;
		_g_object_unref0 (_tmp19_);
	}
	_tmp26_ = owned_dev;
	if (_tmp26_ == NULL) {
		gchar* line = NULL;
		GDataInputStream* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp38_;
		GMatchInfo* header_matcher = NULL;
		GRegex* _tmp39_ = NULL;
		GRegex* _tmp40_;
		const gchar* _tmp42_;
		GMatchInfo* _tmp43_ = NULL;
		gboolean _tmp44_;
		GMatchInfo* _tmp45_;
		gchar* _tmp46_;
		GDataInputStream* _tmp47_;
		_tmp27_ = recording;
		_tmp28_ = g_data_input_stream_read_line (_tmp27_, NULL, NULL, &_inner_error_);
		line = _tmp28_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp29_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp29_;
		}
		while (TRUE) {
			gboolean _tmp30_ = FALSE;
			const gchar* _tmp31_;
			gchar* _tmp33_ = NULL;
			GDataInputStream* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp37_;
			_tmp31_ = line;
			if (_tmp31_ != NULL) {
				const gchar* _tmp32_;
				_tmp32_ = line;
				_tmp30_ = g_str_has_prefix (_tmp32_, "#");
			} else {
				_tmp30_ = FALSE;
			}
			if (!_tmp30_) {
				break;
			}
			_tmp34_ = recording;
			_tmp35_ = g_data_input_stream_read_line (_tmp34_, NULL, NULL, &_inner_error_);
			_tmp33_ = _tmp35_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp36_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_free0 (line);
				_g_free0 (owned_dev);
				_g_object_unref0 (recording);
				return _tmp36_;
			}
			_tmp37_ = _tmp33_;
			_tmp33_ = NULL;
			_g_free0 (line);
			line = _tmp37_;
			_g_free0 (_tmp33_);
		}
		_tmp38_ = line;
		if (_tmp38_ == NULL) {
			g_error ("umockdev.vala:760: ioctl recording file %s has no non-comment content", recordfile);
		}
		_tmp40_ = g_regex_new ("^@DEV (.*)(\n|$)", 0, 0, &_inner_error_);
		_tmp39_ = _tmp40_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp41_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp41_;
		}
		_tmp42_ = line;
		_tmp44_ = g_regex_match (_tmp39_, _tmp42_, 0, &_tmp43_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp43_;
		if (!_tmp44_) {
			g_error ("umockdev.vala:764: null passed for device node, but recording %s has n" \
"o @DEV header", recordfile);
		}
		_tmp45_ = header_matcher;
		_tmp46_ = g_match_info_fetch (_tmp45_, 1);
		_g_free0 (owned_dev);
		owned_dev = _tmp46_;
		_tmp47_ = recording;
		g_seekable_seek ((GSeekable*) _tmp47_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp48_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (_tmp39_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp48_;
		}
		_g_regex_unref0 (_tmp39_);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
	}
	_tmp49_ = self->priv->root_dir;
	_tmp50_ = owned_dev;
	_tmp51_ = g_build_filename (_tmp49_, "ioctl", _tmp50_, NULL);
	dest = _tmp51_;
	_tmp52_ = dest;
	_tmp53_ = g_path_get_dirname (_tmp52_);
	_tmp54_ = _tmp53_;
	_vala_assert (g_mkdir_with_parents (_tmp54_, 0755) == 0, "DirUtils.create_with_parents(Path.get_dirname(dest), 0755) == 0");
	_g_free0 (_tmp54_);
	_tmp55_ = recording;
	_tmp56_ = g_data_input_stream_read_upto (_tmp55_, "", (gssize) 0, NULL, NULL, &_inner_error_);
	contents = _tmp56_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp57_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (dest);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		return _tmp57_;
	}
	_tmp58_ = contents;
	if (_tmp58_ == NULL) {
		gchar* _tmp59_;
		_tmp59_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp59_;
	}
	_tmp61_ = dest;
	_tmp62_ = contents;
	_tmp60_ = g_file_set_contents (_tmp61_, _tmp62_, (gssize) -1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp63_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_free0 (dest);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		return _tmp63_;
	}
	result = _tmp60_;
	_g_free0 (contents);
	_g_free0 (dest);
	_g_free0 (owned_dev);
	_g_object_unref0 (recording);
	return result;
}


/**
     * umockdev_testbed_load_script:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the script record.
     *       %NULL is valid; in this case the script is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Load a script record file for a particular device into the testbed.
     * script records can be created with umockdev-record --script.
     *
     * Returns: %TRUE on success, %FALSE if @recordfile is invalid and an error
     *          occurred.
     */
gboolean
umockdev_testbed_load_script (UMockdevTestbed* self,
                              const gchar* dev,
                              const gchar* recordfile,
                              GError** error)
{
	gboolean result = FALSE;
	gchar* owned_dev = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp29_;
	const gchar* _tmp30_;
	gint fd = 0;
	const gchar* _tmp31_;
	gint _tmp32_;
	UMockdevScriptRunner* _tmp39_ = NULL;
	const gchar* _tmp40_;
	gint _tmp41_;
	UMockdevScriptRunner* _tmp42_;
	GHashTable* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	UMockdevScriptRunner* _tmp47_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = g_strdup (dev);
	owned_dev = _tmp0_;
	_tmp1_ = owned_dev;
	if (_tmp1_ == NULL) {
		GFileInputStream* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFileInputStream* _tmp5_;
		GFileInputStream* _tmp6_;
		GDataInputStream* recording = NULL;
		GDataInputStream* _tmp8_;
		gchar* line = NULL;
		GDataInputStream* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp20_;
		GMatchInfo* header_matcher = NULL;
		GRegex* _tmp21_ = NULL;
		GRegex* _tmp22_;
		const gchar* _tmp24_;
		GMatchInfo* _tmp25_ = NULL;
		gboolean _tmp26_;
		GMatchInfo* _tmp27_;
		gchar* _tmp28_;
		_tmp3_ = g_file_new_for_path (recordfile);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_tmp2_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			return _tmp7_;
		}
		_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
		recording = _tmp8_;
		_tmp9_ = recording;
		_tmp10_ = g_data_input_stream_read_line (_tmp9_, NULL, NULL, &_inner_error_);
		line = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp11_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (recording);
			_g_object_unref0 (_tmp2_);
			_g_free0 (owned_dev);
			return _tmp11_;
		}
		while (TRUE) {
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp13_;
			gchar* _tmp15_ = NULL;
			GDataInputStream* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp19_;
			_tmp13_ = line;
			if (_tmp13_ != NULL) {
				const gchar* _tmp14_;
				_tmp14_ = line;
				_tmp12_ = g_str_has_prefix (_tmp14_, "#");
			} else {
				_tmp12_ = FALSE;
			}
			if (!_tmp12_) {
				break;
			}
			_tmp16_ = recording;
			_tmp17_ = g_data_input_stream_read_line (_tmp16_, NULL, NULL, &_inner_error_);
			_tmp15_ = _tmp17_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp18_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_free0 (line);
				_g_object_unref0 (recording);
				_g_object_unref0 (_tmp2_);
				_g_free0 (owned_dev);
				return _tmp18_;
			}
			_tmp19_ = _tmp15_;
			_tmp15_ = NULL;
			_g_free0 (line);
			line = _tmp19_;
			_g_free0 (_tmp15_);
		}
		_tmp20_ = line;
		if (_tmp20_ == NULL) {
			g_error ("umockdev.vala:806: script recording %s has no non-comment content", recordfile);
		}
		_tmp22_ = g_regex_new ("^d 0 (.*)(\n|$)", 0, 0, &_inner_error_);
		_tmp21_ = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp23_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_object_unref0 (recording);
			_g_object_unref0 (_tmp2_);
			_g_free0 (owned_dev);
			return _tmp23_;
		}
		_tmp24_ = line;
		_tmp26_ = g_regex_match (_tmp21_, _tmp24_, 0, &_tmp25_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp25_;
		if (!_tmp26_) {
			g_error ("umockdev.vala:810: null passed for device node, but recording %s has n" \
"o d 0 header", recordfile);
		}
		_tmp27_ = header_matcher;
		_tmp28_ = g_match_info_fetch (_tmp27_, 1);
		_g_free0 (owned_dev);
		owned_dev = _tmp28_;
		_g_regex_unref0 (_tmp21_);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
		_g_object_unref0 (recording);
		_g_object_unref0 (_tmp2_);
	}
	_tmp29_ = self->priv->dev_script_runner;
	_tmp30_ = owned_dev;
	_vala_assert (!g_hash_table_contains (_tmp29_, _tmp30_), "!this.dev_script_runner.contains (owned_dev)");
	_tmp31_ = owned_dev;
	fd = umockdev_testbed_get_dev_fd (self, _tmp31_);
	_tmp32_ = fd;
	if (_tmp32_ < 0) {
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		gboolean _tmp38_ = FALSE;
		_tmp33_ = owned_dev;
		_tmp34_ = g_strconcat (_tmp33_, " is not a device suitable for scripts", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_inner_error_ = _tmp37_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (owned_dev);
		return _tmp38_;
	}
	_tmp40_ = owned_dev;
	_tmp41_ = fd;
	_tmp42_ = umockdev_script_runner_new (_tmp40_, recordfile, _tmp41_, &_inner_error_);
	_tmp39_ = _tmp42_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp43_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (owned_dev);
		return _tmp43_;
	}
	_tmp44_ = self->priv->dev_script_runner;
	_tmp45_ = owned_dev;
	_tmp46_ = g_strdup (_tmp45_);
	_tmp47_ = _tmp39_;
	_tmp39_ = NULL;
	g_hash_table_insert (_tmp44_, _tmp46_, _tmp47_);
	result = TRUE;
	_umockdev_script_runner_unref0 (_tmp39_);
	_g_free0 (owned_dev);
	return result;
}


/**
     * umockdev_testbed_load_socket_script:
     * @self: A #UMockdevTestbed.
     * @path: Unix socket path
     * @type: Unix socket type (#SOCK_STREAM, #SOCK_DGRAM)
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Add an Unix socket to the testbed that is backed by a recorded script.
     * Clients can connect to the socket using @path (i. e. without the testbed
     * prefix).
     *
     * Returns: %TRUE on success, %FALSE if the @path or @type are
     *          invalid and an error occurred.
     */
gboolean
umockdev_testbed_load_socket_script (UMockdevTestbed* self,
                                     const gchar* path,
                                     gint type,
                                     const gchar* recordfile,
                                     GError** error)
{
	gboolean result = FALSE;
	gint fd = 0;
	gint _tmp0_;
	gchar* real_path = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	UMockdevSocketServer* _tmp23_;
	UMockdevSocketServer* _tmp25_;
	const gchar* _tmp26_;
	gint _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	fd = socket (AF_UNIX, type, 0);
	_tmp0_ = fd;
	if (_tmp0_ < 0) {
		gint _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp1_ = errno;
		_tmp2_ = g_strerror (_tmp1_);
		_tmp3_ = g_strdup_printf ("Cannot create socket type %i: %s", type, _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == G_FILE_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	_tmp9_ = self->priv->root_dir;
	_tmp10_ = g_build_filename (_tmp9_, path, NULL);
	real_path = _tmp10_;
	_tmp11_ = real_path;
	_tmp12_ = g_path_get_dirname (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_mkdir_with_parents (_tmp13_, 0755) != 0;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		gint _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GError* _tmp19_;
		GError* _tmp20_;
		_tmp15_ = errno;
		_tmp16_ = g_strerror (_tmp15_);
		_tmp17_ = g_strdup_printf ("Cannot create socket path: %s", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		_inner_error_ = _tmp20_;
		if (_inner_error_->domain == G_FILE_ERROR) {
			gboolean _tmp21_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (real_path);
			return _tmp21_;
		} else {
			gboolean _tmp22_ = FALSE;
			_g_free0 (real_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp22_;
		}
	}
	_tmp23_ = self->priv->socket_server;
	if (_tmp23_ == NULL) {
		UMockdevSocketServer* _tmp24_;
		_tmp24_ = umockdev_socket_server_new ();
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = _tmp24_;
	}
	_tmp25_ = self->priv->socket_server;
	_tmp26_ = real_path;
	_tmp27_ = fd;
	umockdev_socket_server_add (_tmp25_, _tmp26_, _tmp27_, recordfile);
	result = TRUE;
	_g_free0 (real_path);
	return result;
}


/**
     * umockdev_testbed_load_evemu_events:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the evemu events.
     *       %NULL is valid; in this case the events are associated with
     *       the device node it was recorded from.
     * @eventsfile: Path of the evemu events file.
     * @error: return location for a GError, or %NULL
     *
     * Load an evemu event file for a particular device into the testbed. These
     * have a very simple line-based format with 4 fields that represent the
     * data in a struct input_event:
     *
     *  E: sec.usec evtype(hex) evcode(hex) evvalue
     *
     * The timestamps in those are absolute, and are usually as they were at
     * record time. When loading them into umockdev they are interpreted
     * relatively: the first event happens immediately, and the time to the
     * next event is the difference between the corresponding timestamps in the
     * .event file.
     *
     * Returns: %TRUE on success, %FALSE if @eventsfile is invalid and an error
     *          occurred.
     */
static guint64
uint64_parse (const gchar* str)
{
	guint64 result = 0ULL;
	guint64 _tmp0_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = g_ascii_strtoull (str, NULL, (guint) 0);
	result = _tmp0_;
	return result;
}


gboolean
umockdev_testbed_load_evemu_events (UMockdevTestbed* self,
                                    const gchar* dev,
                                    const gchar* eventsfile,
                                    GError** error)
{
	gboolean result = FALSE;
	GFile* f_ev = NULL;
	GFile* _tmp0_;
	GFileInputStream* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* s_ev = NULL;
	GDataInputStream* _tmp5_;
	gchar* line = NULL;
	gchar* recorded_dev = NULL;
	gsize len = 0UL;
	GMatchInfo* match = NULL;
	struct input_event ev = {0};
	struct input_event _tmp6_ = {0};
	GRegex* default_dev_re = NULL;
	GRegex* _tmp7_;
	GRegex* event_re = NULL;
	GRegex* _tmp9_;
	gchar* script_file = NULL;
	gint script_fd = 0;
	gchar* _tmp11_ = NULL;
	gint _tmp12_;
	gint delay = 0;
	gboolean first = FALSE;
	gint _tmp86_;
	gchar* owned_dev = NULL;
	gchar* _tmp87_;
	const gchar* _tmp88_;
	gboolean ret = FALSE;
	const gchar* _tmp92_;
	const gchar* _tmp93_;
	const gchar* _tmp95_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (eventsfile != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (eventsfile);
	f_ev = _tmp0_;
	_tmp2_ = f_ev;
	_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (f_ev);
		return _tmp4_;
	}
	_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp1_);
	s_ev = _tmp5_;
	recorded_dev = NULL;
	ev = _tmp6_;
	_tmp7_ = g_regex_new ("^# device (.*)$", 0, 0, &_inner_error_);
	default_dev_re = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (f_ev);
		return _tmp8_;
	}
	_tmp9_ = g_regex_new ("^E: ([0-9]+)\\.([0-9]+) +([0-9a-fA-F]+) +([0-9a-fA-F]+) +(-?[0-9]+) *#" \
"?", 0, 0, &_inner_error_);
	event_re = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (f_ev);
		return _tmp10_;
	}
	_tmp12_ = g_file_open_tmp ("evemu.XXXXXX.script", &_tmp11_, &_inner_error_);
	_g_free0 (script_file);
	script_file = _tmp11_;
	script_fd = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (script_file);
		_g_regex_unref0 (event_re);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (f_ev);
		return _tmp13_;
	}
	delay = 0;
	first = TRUE;
	while (TRUE) {
		gchar* _tmp14_ = NULL;
		GDataInputStream* _tmp15_;
		gsize _tmp16_ = 0UL;
		gchar* _tmp17_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		GRegex* _tmp21_;
		const gchar* _tmp22_;
		GMatchInfo* _tmp23_ = NULL;
		gboolean _tmp24_;
		GRegex* _tmp27_;
		const gchar* _tmp28_;
		GMatchInfo* _tmp29_ = NULL;
		gboolean _tmp30_;
		time_t ev_sec = 0;
		GMatchInfo* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		time_t _tmp36_;
		time_t ev_usec = 0;
		GMatchInfo* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		time_t _tmp40_;
		gboolean _tmp41_;
		time_t _tmp51_;
		time_t _tmp52_;
		GMatchInfo* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gulong _tmp56_;
		GMatchInfo* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gulong _tmp60_;
		GMatchInfo* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		guint8* ev_data = NULL;
		guint8* _tmp64_;
		gint ev_data_length1;
		gint _ev_data_size_;
		guint8* _tmp65_;
		gint _tmp65__length1;
		guint8* _tmp66_;
		gint _tmp66__length1;
		gchar* script_line = NULL;
		gint _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		guint8* _tmp74_;
		gint _tmp74__length1;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gint _tmp81_;
		const gchar* _tmp82_;
		const gchar* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		_tmp15_ = s_ev;
		_tmp17_ = g_data_input_stream_read_line (_tmp15_, &_tmp16_, NULL, &_inner_error_);
		len = _tmp16_;
		_tmp14_ = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp18_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (script_file);
			_g_regex_unref0 (event_re);
			_g_regex_unref0 (default_dev_re);
			_g_match_info_unref0 (match);
			_g_free0 (recorded_dev);
			_g_free0 (line);
			_g_object_unref0 (s_ev);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (f_ev);
			return _tmp18_;
		}
		_tmp19_ = _tmp14_;
		_tmp14_ = NULL;
		_g_free0 (line);
		line = _tmp19_;
		_tmp20_ = line;
		if (!(_tmp20_ != NULL)) {
			_g_free0 (_tmp14_);
			break;
		}
		_tmp21_ = default_dev_re;
		_tmp22_ = line;
		_tmp24_ = g_regex_match (_tmp21_, _tmp22_, 0, &_tmp23_);
		_g_match_info_unref0 (match);
		match = _tmp23_;
		if (_tmp24_) {
			GMatchInfo* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = match;
			_tmp26_ = g_match_info_fetch (_tmp25_, 1);
			_g_free0 (recorded_dev);
			recorded_dev = _tmp26_;
			_g_free0 (_tmp14_);
			continue;
		}
		_tmp27_ = event_re;
		_tmp28_ = line;
		_tmp30_ = g_regex_match (_tmp27_, _tmp28_, 0, &_tmp29_);
		_g_match_info_unref0 (match);
		match = _tmp29_;
		if (!_tmp30_) {
			const gchar* _tmp31_;
			_tmp31_ = line;
			if (!g_str_has_prefix (_tmp31_, "#")) {
				const gchar* _tmp32_;
				_tmp32_ = line;
				g_warning ("umockdev.vala:909: Ignoring invalid line in %s: %s", eventsfile, _tmp32_);
			}
			_g_free0 (_tmp14_);
			continue;
		}
		_tmp33_ = match;
		_tmp34_ = g_match_info_fetch (_tmp33_, 1);
		_tmp35_ = _tmp34_;
		_tmp36_ = (time_t) uint64_parse (_tmp35_);
		_g_free0 (_tmp35_);
		ev_sec = _tmp36_;
		_tmp37_ = match;
		_tmp38_ = g_match_info_fetch (_tmp37_, 2);
		_tmp39_ = _tmp38_;
		_tmp40_ = (time_t) uint64_parse (_tmp39_);
		_g_free0 (_tmp39_);
		ev_usec = _tmp40_;
		_tmp41_ = first;
		if (_tmp41_) {
			delay = 0;
			first = FALSE;
		} else {
			time_t _tmp42_;
			struct input_event _tmp43_;
			struct timeval _tmp44_;
			time_t _tmp45_;
			time_t _tmp46_;
			struct input_event _tmp47_;
			struct timeval _tmp48_;
			glong _tmp49_;
			gint _tmp50_;
			_tmp42_ = ev_sec;
			_tmp43_ = ev;
			_tmp44_ = _tmp43_.time;
			_tmp45_ = _tmp44_.tv_sec;
			_tmp46_ = ev_usec;
			_tmp47_ = ev;
			_tmp48_ = _tmp47_.time;
			_tmp49_ = _tmp48_.tv_usec;
			delay = (((gint) (_tmp42_ - _tmp45_)) * 1000) + (((gint) (_tmp46_ - _tmp49_)) / 1000);
			_tmp50_ = delay;
			if (_tmp50_ < 0) {
				delay = 0;
			}
		}
		_tmp51_ = ev_sec;
		ev.time.tv_sec = _tmp51_;
		_tmp52_ = ev_usec;
		ev.time.tv_usec = (glong) _tmp52_;
		_tmp53_ = match;
		_tmp54_ = g_match_info_fetch (_tmp53_, 3);
		_tmp55_ = _tmp54_;
		_tmp56_ = strtoul (_tmp55_, NULL, 16);
		ev.type = (guint16) _tmp56_;
		_g_free0 (_tmp55_);
		_tmp57_ = match;
		_tmp58_ = g_match_info_fetch (_tmp57_, 4);
		_tmp59_ = _tmp58_;
		_tmp60_ = strtoul (_tmp59_, NULL, 16);
		ev.code = (guint16) _tmp60_;
		_g_free0 (_tmp59_);
		_tmp61_ = match;
		_tmp62_ = g_match_info_fetch (_tmp61_, 5);
		_tmp63_ = _tmp62_;
		ev.value = (gint32) atoi (_tmp63_);
		_g_free0 (_tmp63_);
		_tmp64_ = g_new0 (guint8, sizeof (struct input_event));
		ev_data = _tmp64_;
		ev_data_length1 = sizeof (struct input_event);
		_ev_data_size_ = ev_data_length1;
		_tmp65_ = ev_data;
		_tmp65__length1 = ev_data_length1;
		_tmp66_ = ev_data;
		_tmp66__length1 = ev_data_length1;
		memcpy (_tmp65_, &ev, (gsize) _tmp66__length1);
		_tmp67_ = delay;
		_tmp68_ = g_strdup_printf ("%i", _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_strconcat ("r ", _tmp69_, NULL);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strconcat (_tmp71_, " ", NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = ev_data;
		_tmp74__length1 = ev_data_length1;
		_tmp75_ = umockdev_script_runner_encode (_tmp74_, _tmp74__length1);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strconcat (_tmp73_, _tmp76_, NULL);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strconcat (_tmp78_, "\n", NULL);
		_tmp80_ = _tmp79_;
		_g_free0 (_tmp78_);
		_g_free0 (_tmp76_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp71_);
		_g_free0 (_tmp69_);
		script_line = _tmp80_;
		_tmp81_ = script_fd;
		_tmp82_ = script_line;
		_tmp83_ = script_line;
		_tmp84_ = strlen (_tmp83_);
		_tmp85_ = _tmp84_;
		write (_tmp81_, _tmp82_, (gsize) _tmp85_);
		_g_free0 (script_line);
		ev_data = (g_free (ev_data), NULL);
		_g_free0 (_tmp14_);
	}
	_tmp86_ = script_fd;
	close (_tmp86_);
	_tmp87_ = g_strdup (dev);
	owned_dev = _tmp87_;
	_tmp88_ = owned_dev;
	if (_tmp88_ == NULL) {
		const gchar* _tmp89_;
		const gchar* _tmp90_;
		gchar* _tmp91_;
		_tmp89_ = recorded_dev;
		if (_tmp89_ == NULL) {
			g_error ("umockdev.vala:939: null passed for device node, but recording %s has n" \
"o '# device' header", eventsfile);
		}
		_tmp90_ = recorded_dev;
		_tmp91_ = g_strdup (_tmp90_);
		_g_free0 (owned_dev);
		owned_dev = _tmp91_;
	}
	_tmp92_ = owned_dev;
	_tmp93_ = script_file;
	ret = umockdev_testbed_load_script (self, _tmp92_, _tmp93_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp94_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (owned_dev);
		_g_free0 (script_file);
		_g_regex_unref0 (event_re);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (f_ev);
		return _tmp94_;
	}
	_tmp95_ = script_file;
	g_unlink (_tmp95_);
	result = ret;
	_g_free0 (owned_dev);
	_g_free0 (script_file);
	_g_regex_unref0 (event_re);
	_g_regex_unref0 (default_dev_re);
	_g_match_info_unref0 (match);
	_g_free0 (recorded_dev);
	_g_free0 (line);
	_g_object_unref0 (s_ev);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (f_ev);
	return result;
}


static void
_vala_array_add3 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add4 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add5 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add7 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add8 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add9 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add10 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar*
umockdev_testbed_add_dev_from_string (UMockdevTestbed* self,
                                      const gchar* data,
                                      GError** error)
{
	gchar* result = NULL;
	gchar type = '\0';
	gchar* key = NULL;
	gchar* val = NULL;
	gchar* devpath = NULL;
	gchar* subsystem = NULL;
	gchar* majmin = NULL;
	gchar* cur_data = NULL;
	gchar* _tmp0_;
	gchar* devnode_path = NULL;
	guint8* devnode_contents = NULL;
	guint8* _tmp1_;
	gint devnode_contents_length1;
	gint _devnode_contents_size_;
	const gchar* _tmp2_;
	gchar _tmp3_ = '\0';
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	gchar** attrs = NULL;
	gchar** _tmp15_;
	gint attrs_length1;
	gint _attrs_size_;
	gchar** binattrs = NULL;
	gchar** _tmp16_;
	gint binattrs_length1;
	gint _binattrs_size_;
	gchar** linkattrs = NULL;
	gchar** _tmp17_;
	gint linkattrs_length1;
	gint _linkattrs_size_;
	gchar** props = NULL;
	gchar** _tmp18_;
	gint props_length1;
	gint _props_size_;
	const gchar* _tmp81_;
	const gchar* _tmp84_;
	const gchar* _tmp85_;
	gchar* syspath = NULL;
	const gchar* _tmp86_;
	const gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar** _tmp90_;
	gint _tmp90__length1;
	gchar** _tmp91_;
	gint _tmp91__length1;
	gchar* _tmp92_;
	gchar* _tmp93_;
	const gchar* _tmp119_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	devpath = NULL;
	subsystem = NULL;
	majmin = NULL;
	_tmp0_ = g_strdup (data);
	cur_data = _tmp0_;
	devnode_path = NULL;
	_tmp1_ = g_new0 (guint8, 0);
	devnode_contents = _tmp1_;
	devnode_contents_length1 = 0;
	_devnode_contents_size_ = devnode_contents_length1;
	_tmp2_ = cur_data;
	_tmp6_ = umockdev_testbed_record_parse_line (self, _tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	type = _tmp3_;
	_g_free0 (key);
	key = _tmp4_;
	_g_free0 (devpath);
	devpath = _tmp5_;
	_g_free0 (cur_data);
	cur_data = _tmp6_;
	_tmp8_ = cur_data;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		gchar _tmp9_;
		_tmp9_ = type;
		_tmp7_ = _tmp9_ != 'P';
	}
	if (_tmp7_) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "device descriptions must start with a \"P: /devices/path/...\" line");
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = devpath;
	if (!g_str_has_prefix (_tmp11_, "/devices/")) {
		const gchar* _tmp12_;
		GError* _tmp13_;
		_tmp12_ = devpath;
		_tmp13_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "invalid device path '%s': must start with /devices/", _tmp12_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = devpath;
	g_debug ("umockdev.vala:966: parsing device description for %s", _tmp14_);
	_tmp15_ = g_new0 (gchar*, 0 + 1);
	attrs = _tmp15_;
	attrs_length1 = 0;
	_attrs_size_ = attrs_length1;
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	binattrs = _tmp16_;
	binattrs_length1 = 0;
	_binattrs_size_ = binattrs_length1;
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	linkattrs = _tmp17_;
	linkattrs_length1 = 0;
	_linkattrs_size_ = linkattrs_length1;
	_tmp18_ = g_new0 (gchar*, 0 + 1);
	props = _tmp18_;
	props_length1 = 0;
	_props_size_ = props_length1;
	while (TRUE) {
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		const gchar* _tmp24_;
		gchar _tmp25_ = '\0';
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar _tmp32_;
		_tmp20_ = cur_data;
		_tmp21_ = strlen (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_ > 0) {
			const gchar* _tmp23_;
			_tmp23_ = cur_data;
			_tmp19_ = string_get (_tmp23_, (glong) 0) != '\n';
		} else {
			_tmp19_ = FALSE;
		}
		if (!_tmp19_) {
			break;
		}
		_tmp24_ = cur_data;
		_tmp28_ = umockdev_testbed_record_parse_line (self, _tmp24_, &_tmp25_, &_tmp26_, &_tmp27_);
		type = _tmp25_;
		_g_free0 (key);
		key = _tmp26_;
		_g_free0 (val);
		val = _tmp27_;
		_g_free0 (cur_data);
		cur_data = _tmp28_;
		_tmp29_ = cur_data;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			GError* _tmp31_;
			_tmp30_ = devpath;
			_tmp31_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed attribute or property line in description of device %s", _tmp30_);
			_inner_error_ = _tmp31_;
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp32_ = type;
		switch (_tmp32_) {
			case 'H':
			{
				gchar** _tmp33_;
				gint _tmp33__length1;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				gchar** _tmp36_;
				gint _tmp36__length1;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp33_ = binattrs;
				_tmp33__length1 = binattrs_length1;
				_tmp34_ = key;
				_tmp35_ = g_strdup (_tmp34_);
				_vala_array_add3 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp35_);
				_tmp36_ = binattrs;
				_tmp36__length1 = binattrs_length1;
				_tmp37_ = val;
				_tmp38_ = g_strdup (_tmp37_);
				_vala_array_add4 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp38_);
				break;
			}
			case 'A':
			{
				gchar** _tmp39_;
				gint _tmp39__length1;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				gchar** _tmp44_;
				gint _tmp44__length1;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				const gchar* _tmp47_;
				_tmp39_ = attrs;
				_tmp39__length1 = attrs_length1;
				_tmp40_ = key;
				_tmp41_ = g_strdup (_tmp40_);
				_vala_array_add5 (&attrs, &attrs_length1, &_attrs_size_, _tmp41_);
				_tmp42_ = val;
				_tmp43_ = g_strcompress (_tmp42_);
				_g_free0 (val);
				val = _tmp43_;
				_tmp44_ = attrs;
				_tmp44__length1 = attrs_length1;
				_tmp45_ = val;
				_tmp46_ = g_strdup (_tmp45_);
				_vala_array_add6 (&attrs, &attrs_length1, &_attrs_size_, _tmp46_);
				_tmp47_ = key;
				if (g_strcmp0 (_tmp47_, "dev") == 0) {
					const gchar* _tmp48_;
					gchar* _tmp49_;
					_tmp48_ = val;
					_tmp49_ = g_strdup (_tmp48_);
					_g_free0 (majmin);
					majmin = _tmp49_;
				}
				break;
			}
			case 'L':
			{
				gchar** _tmp50_;
				gint _tmp50__length1;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				gchar** _tmp53_;
				gint _tmp53__length1;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				_tmp50_ = linkattrs;
				_tmp50__length1 = linkattrs_length1;
				_tmp51_ = key;
				_tmp52_ = g_strdup (_tmp51_);
				_vala_array_add7 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp52_);
				_tmp53_ = linkattrs;
				_tmp53__length1 = linkattrs_length1;
				_tmp54_ = val;
				_tmp55_ = g_strdup (_tmp54_);
				_vala_array_add8 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp55_);
				break;
			}
			case 'E':
			{
				gchar** _tmp56_;
				gint _tmp56__length1;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				gchar** _tmp59_;
				gint _tmp59__length1;
				const gchar* _tmp60_;
				gchar* _tmp61_;
				const gchar* _tmp62_;
				_tmp56_ = props;
				_tmp56__length1 = props_length1;
				_tmp57_ = key;
				_tmp58_ = g_strdup (_tmp57_);
				_vala_array_add9 (&props, &props_length1, &_props_size_, _tmp58_);
				_tmp59_ = props;
				_tmp59__length1 = props_length1;
				_tmp60_ = val;
				_tmp61_ = g_strdup (_tmp60_);
				_vala_array_add10 (&props, &props_length1, &_props_size_, _tmp61_);
				_tmp62_ = key;
				if (g_strcmp0 (_tmp62_, "SUBSYSTEM") == 0) {
					const gchar* _tmp63_;
					const gchar* _tmp66_;
					gchar* _tmp67_;
					_tmp63_ = subsystem;
					if (_tmp63_ != NULL) {
						const gchar* _tmp64_;
						GError* _tmp65_;
						_tmp64_ = devpath;
						_tmp65_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "duplicate SUBSYSTEM property in description of device %s", _tmp64_);
						_inner_error_ = _tmp65_;
						if (_inner_error_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error_);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp66_ = val;
					_tmp67_ = g_strdup (_tmp66_);
					_g_free0 (subsystem);
					subsystem = _tmp67_;
				}
				break;
			}
			case 'P':
			{
				const gchar* _tmp68_;
				GError* _tmp69_;
				_tmp68_ = devpath;
				_tmp69_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "invalid P: line in description of device %s", _tmp68_);
				_inner_error_ = _tmp69_;
				if (_inner_error_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error_);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			case 'N':
			{
				const gchar* _tmp70_;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				const gchar* _tmp73_;
				_tmp70_ = self->priv->root_dir;
				_tmp71_ = key;
				_tmp72_ = g_build_filename (_tmp70_, "dev", _tmp71_, NULL);
				_g_free0 (devnode_path);
				devnode_path = _tmp72_;
				_tmp73_ = val;
				if (_tmp73_ != NULL) {
					guint8* _tmp74_ = NULL;
					const gchar* _tmp75_;
					gint _tmp76_ = 0;
					guint8* _tmp77_;
					gint _tmp74__length1;
					gint __tmp74__size_;
					guint8* _tmp78_;
					gint _tmp78__length1;
					_tmp75_ = val;
					_tmp77_ = umockdev_decode_hex (_tmp75_, &_tmp76_, &_inner_error_);
					_tmp74_ = _tmp77_;
					_tmp74__length1 = _tmp76_;
					__tmp74__size_ = _tmp74__length1;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error_);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp78_ = _tmp74_;
					_tmp78__length1 = _tmp74__length1;
					_tmp74_ = NULL;
					_tmp74__length1 = 0;
					devnode_contents = (g_free (devnode_contents), NULL);
					devnode_contents = _tmp78_;
					devnode_contents_length1 = _tmp78__length1;
					_devnode_contents_size_ = devnode_contents_length1;
					_tmp74_ = (g_free (_tmp74_), NULL);
				}
				break;
			}
			case 'S':
			{
				break;
			}
			default:
			{
				gchar _tmp79_;
				GError* _tmp80_;
				_tmp79_ = type;
				_tmp80_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "Unknown line type '%c'\n", (gint) _tmp79_);
				_inner_error_ = _tmp80_;
				if (_inner_error_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error_);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	_tmp81_ = subsystem;
	if (_tmp81_ == NULL) {
		const gchar* _tmp82_;
		GError* _tmp83_;
		_tmp82_ = devpath;
		_tmp83_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "missing SUBSYSTEM property in description of device %s", _tmp82_);
		_inner_error_ = _tmp83_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp84_ = devpath;
	_tmp85_ = subsystem;
	g_debug ("umockdev.vala:1032: creating device %s (subsystem %s)", _tmp84_, _tmp85_);
	_tmp86_ = subsystem;
	_tmp87_ = devpath;
	_tmp88_ = string_substring (_tmp87_, (glong) 9, (glong) -1);
	_tmp89_ = _tmp88_;
	_tmp90_ = attrs;
	_tmp90__length1 = attrs_length1;
	_tmp91_ = props;
	_tmp91__length1 = props_length1;
	_tmp92_ = umockdev_testbed_add_devicev (self, _tmp86_, _tmp89_, NULL, _tmp90_, _tmp91_);
	_tmp93_ = _tmp92_;
	_g_free0 (_tmp89_);
	syspath = _tmp93_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp94_ = FALSE;
			_tmp94_ = TRUE;
			while (TRUE) {
				gint _tmp96_;
				gchar** _tmp97_;
				gint _tmp97__length1;
				guint8* _tmp98_ = NULL;
				gchar** _tmp99_;
				gint _tmp99__length1;
				gint _tmp100_;
				const gchar* _tmp101_;
				gint _tmp102_ = 0;
				guint8* _tmp103_;
				gint _tmp98__length1;
				gint __tmp98__size_;
				const gchar* _tmp104_;
				gchar** _tmp105_;
				gint _tmp105__length1;
				gint _tmp106_;
				const gchar* _tmp107_;
				if (!_tmp94_) {
					gint _tmp95_;
					_tmp95_ = i;
					i = _tmp95_ + 2;
				}
				_tmp94_ = FALSE;
				_tmp96_ = i;
				_tmp97_ = binattrs;
				_tmp97__length1 = binattrs_length1;
				if (!(_tmp96_ < _tmp97__length1)) {
					break;
				}
				_tmp99_ = binattrs;
				_tmp99__length1 = binattrs_length1;
				_tmp100_ = i;
				_tmp101_ = _tmp99_[_tmp100_ + 1];
				_tmp103_ = umockdev_decode_hex (_tmp101_, &_tmp102_, &_inner_error_);
				_tmp98_ = _tmp103_;
				_tmp98__length1 = _tmp102_;
				__tmp98__size_ = _tmp98__length1;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == UMOCKDEV_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (syspath);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						return NULL;
					} else {
						_g_free0 (syspath);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp104_ = syspath;
				_tmp105_ = binattrs;
				_tmp105__length1 = binattrs_length1;
				_tmp106_ = i;
				_tmp107_ = _tmp105_[_tmp106_];
				umockdev_testbed_set_attribute_binary (self, _tmp104_, _tmp107_, _tmp98_, _tmp98__length1);
				_tmp98_ = (g_free (_tmp98_), NULL);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp108_ = FALSE;
			_tmp108_ = TRUE;
			while (TRUE) {
				gint _tmp110_;
				gchar** _tmp111_;
				gint _tmp111__length1;
				const gchar* _tmp112_;
				gchar** _tmp113_;
				gint _tmp113__length1;
				gint _tmp114_;
				const gchar* _tmp115_;
				gchar** _tmp116_;
				gint _tmp116__length1;
				gint _tmp117_;
				const gchar* _tmp118_;
				if (!_tmp108_) {
					gint _tmp109_;
					_tmp109_ = i;
					i = _tmp109_ + 2;
				}
				_tmp108_ = FALSE;
				_tmp110_ = i;
				_tmp111_ = linkattrs;
				_tmp111__length1 = linkattrs_length1;
				if (!(_tmp110_ < _tmp111__length1)) {
					break;
				}
				_tmp112_ = syspath;
				_tmp113_ = linkattrs;
				_tmp113__length1 = linkattrs_length1;
				_tmp114_ = i;
				_tmp115_ = _tmp113_[_tmp114_];
				_tmp116_ = linkattrs;
				_tmp116__length1 = linkattrs_length1;
				_tmp117_ = i;
				_tmp118_ = _tmp116_[_tmp117_ + 1];
				umockdev_testbed_set_attribute_link (self, _tmp112_, _tmp115_, _tmp118_);
			}
		}
	}
	_tmp119_ = devnode_path;
	if (_tmp119_ != NULL) {
		const gchar* _tmp120_;
		const gchar* _tmp121_;
		guint8* _tmp122_;
		gint _tmp122__length1;
		const gchar* _tmp123_;
		_tmp120_ = subsystem;
		_tmp121_ = devnode_path;
		_tmp122_ = devnode_contents;
		_tmp122__length1 = devnode_contents_length1;
		_tmp123_ = majmin;
		umockdev_testbed_create_node_for_device (self, _tmp120_, _tmp121_, _tmp122_, _tmp122__length1, _tmp123_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (syspath);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				_g_free0 (syspath);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp124_ = FALSE;
		const gchar* _tmp125_;
		const gchar* _tmp127_;
		const gchar* _tmp128_;
		gchar* _tmp129_;
		_tmp125_ = cur_data;
		if (string_get (_tmp125_, (glong) 0) != '\0') {
			const gchar* _tmp126_;
			_tmp126_ = cur_data;
			_tmp124_ = string_get (_tmp126_, (glong) 0) == '\n';
		} else {
			_tmp124_ = FALSE;
		}
		if (!_tmp124_) {
			break;
		}
		_tmp127_ = cur_data;
		_tmp128_ = g_utf8_next_char (_tmp127_);
		_tmp129_ = g_strdup (_tmp128_);
		_g_free0 (cur_data);
		cur_data = _tmp129_;
	}
	result = cur_data;
	_g_free0 (syspath);
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
	linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
	binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
	attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
	devnode_contents = (g_free (devnode_contents), NULL);
	_g_free0 (devnode_path);
	_g_free0 (majmin);
	_g_free0 (subsystem);
	_g_free0 (devpath);
	_g_free0 (val);
	_g_free0 (key);
	return result;
}


static void
umockdev_testbed_create_node_for_device (UMockdevTestbed* self,
                                         const gchar* subsystem,
                                         const gchar* node_path,
                                         guint8* node_contents,
                                         int node_contents_length1,
                                         const gchar* majmin,
                                         GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint ptym = 0;
	gint ptys = 0;
	gchar* ptyname_array = NULL;
	gchar* _tmp5_;
	gint ptyname_array_length1;
	gint _ptyname_array_size_;
	gchar* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_;
	gchar* ptyname = NULL;
	gchar* _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	struct termios ios = {0};
	gint _tmp16_;
	struct termios _tmp17_ = {0};
	gint _tmp18_;
	tcflag_t _tmp19_;
	tcflag_t _tmp20_;
	tcflag_t _tmp21_;
	gint _tmp22_;
	struct termios _tmp23_;
	const gchar* _tmp24_;
	gchar* devname = NULL;
	const gchar* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gchar* _tmp39_;
	GHashTable* _tmp40_;
	const gchar* _tmp41_;
	GHashTable* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gint _tmp45_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subsystem != NULL);
	g_return_if_fail (node_path != NULL);
	_tmp0_ = g_path_get_dirname (node_path);
	_tmp1_ = _tmp0_;
	_vala_assert (g_mkdir_with_parents (_tmp1_, 0755) == 0, "DirUtils.create_with_parents(Path.get_dirname(node_path), 0755) == 0");
	_g_free0 (_tmp1_);
	if (node_contents_length1 > 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 (subsystem, "block") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (subsystem, "usb") == 0;
	}
	if (_tmp2_) {
		{
			g_debug ("umockdev.vala:1065: create_node_for_device: creating file device %s", node_path);
			g_file_set_contents (node_path, (const char*) node_contents, (size_t) node_contents_length1, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch9_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (g_strcmp0 (subsystem, "block") == 0) {
				g_chmod (node_path, 01644);
			}
		}
		goto __finally9;
		__catch9_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = e->message;
			g_error ("umockdev.vala:1072: Cannot create dev node file: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally9:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		return;
	}
	_tmp5_ = g_new0 (gchar, 8192);
	ptyname_array = _tmp5_;
	ptyname_array_length1 = 8192;
	_ptyname_array_size_ = ptyname_array_length1;
	_tmp6_ = ptyname_array;
	_tmp6__length1 = ptyname_array_length1;
	_tmp9_ = openpty (&_tmp7_, &_tmp8_, _tmp6_, NULL, NULL);
	ptym = _tmp7_;
	ptys = _tmp8_;
	if (_tmp9_ < 0) {
		gint _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = errno;
		_tmp11_ = g_strerror (_tmp10_);
		g_error ("umockdev.vala:1082: umockdev Testbed.create_node_for_device: openpty()" \
" failed: %s", _tmp11_);
	}
	_tmp12_ = ptyname_array;
	_tmp12__length1 = ptyname_array_length1;
	_tmp13_ = g_strdup ((const gchar*) _tmp12_);
	ptyname = _tmp13_;
	_tmp14_ = ptyname;
	g_debug ("umockdev.vala:1084: create_node_for_device: creating pty device %s: go" \
"t pty %s", node_path, _tmp14_);
	_tmp15_ = ptys;
	close (_tmp15_);
	_tmp16_ = ptym;
	_tmp18_ = tcgetattr (_tmp16_, &_tmp17_);
	ios = _tmp17_;
	_vala_assert (_tmp18_ == 0, "Posix.tcgetattr (ptym, out ios) == 0");
	_tmp19_ = ios.c_iflag;
	ios.c_iflag = _tmp19_ & (~((IGNCR | INLCR) | ICRNL));
	_tmp20_ = ios.c_oflag;
	ios.c_oflag = _tmp20_ & (~(ONLCR | OCRNL));
	_tmp21_ = ios.c_lflag;
	ios.c_lflag = _tmp21_ & (~(ICANON | ECHO));
	cfmakeraw (&ios);
	_tmp22_ = ptym;
	_tmp23_ = ios;
	_vala_assert (tcsetattr (_tmp22_, TCSANOW, &_tmp23_) == 0, "Posix.tcsetattr (ptym, Posix.TCSANOW, ios) == 0");
	_tmp24_ = ptyname;
	_vala_assert (symlink (_tmp24_, node_path) == 0, "FileUtils.symlink (ptyname, node_path) == 0");
	if (majmin != NULL) {
		gchar* mapdir = NULL;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* dest = NULL;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp25_ = self->priv->root_dir;
		_tmp26_ = g_build_filename (_tmp25_, "dev", ".ptymap", NULL);
		mapdir = _tmp26_;
		_tmp27_ = mapdir;
		g_mkdir_with_parents (_tmp27_, 0755);
		_tmp28_ = mapdir;
		_tmp29_ = ptyname;
		_tmp30_ = string_replace (_tmp29_, "/", "_");
		_tmp31_ = _tmp30_;
		_tmp32_ = g_build_filename (_tmp28_, _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		dest = _tmp33_;
		_tmp34_ = dest;
		g_debug ("umockdev.vala:1105: create_node_for_device: creating ptymap symlink %s", _tmp34_);
		_tmp35_ = dest;
		_vala_assert (symlink (majmin, _tmp35_) == 0, "FileUtils.symlink(majmin, dest) == 0");
		_g_free0 (dest);
		_g_free0 (mapdir);
	}
	_tmp36_ = self->priv->root_dir;
	_tmp37_ = strlen (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = string_substring (node_path, (glong) _tmp38_, (glong) -1);
	devname = _tmp39_;
	_tmp40_ = self->priv->dev_fd;
	_tmp41_ = devname;
	_vala_assert (!g_hash_table_contains (_tmp40_, _tmp41_), "!this.dev_fd.contains (devname)");
	_tmp42_ = self->priv->dev_fd;
	_tmp43_ = devname;
	_tmp44_ = g_strdup (_tmp43_);
	_tmp45_ = ptym;
	g_hash_table_insert (_tmp42_, _tmp44_, (gpointer) ((gintptr) _tmp45_));
	_g_free0 (devname);
	_g_free0 (ptyname);
	ptyname_array = (g_free (ptyname_array), NULL);
}


/**
     * umockdev_testbed_record_parse_line:
     * @data: String to parse
     * @type: Pointer to a gchar which will get the line type (one of P, N,
     *        S, E, or H)
     * @key:  Pointer to a string which will get the key name; this will be
     *        set to %NULL for line types which do not have a key (P, N, S). You
     *        need to free this with g_free().
     * @value: Pointer to a string which will get the value. You need to
     *         free this with g_free().
     *
     * Parse one line from a device record file.
     *
     * Returns: Pointer to the next line start in @data, or %NULL if the first line
     * is not valid.
     */
static gchar*
umockdev_testbed_record_parse_line (UMockdevTestbed* self,
                                    const gchar* data,
                                    gchar* type,
                                    gchar* * key,
                                    gchar* * val)
{
	gchar _vala_type = '\0';
	gchar* _vala_key = NULL;
	gchar* _vala_val = NULL;
	gchar* result = NULL;
	GMatchInfo* match = NULL;
	GRegex* _tmp0_;
	GMatchInfo* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* type_str = NULL;
	GMatchInfo* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint end_pos = 0;
	GMatchInfo* _tmp24_;
	gint _tmp25_ = 0;
	gboolean _tmp26_;
	gint _tmp27_;
	gchar* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = self->priv->re_record_val;
	_tmp2_ = g_regex_match (_tmp0_, data, 0, &_tmp1_);
	_g_match_info_unref0 (match);
	match = _tmp1_;
	if (_tmp2_) {
		GMatchInfo* _tmp3_;
		gchar* _tmp4_;
		_g_free0 (_vala_key);
		_vala_key = NULL;
		_tmp3_ = match;
		_tmp4_ = g_match_info_fetch (_tmp3_, 2);
		_g_free0 (_vala_val);
		_vala_val = _tmp4_;
	} else {
		GRegex* _tmp5_;
		GMatchInfo* _tmp6_ = NULL;
		gboolean _tmp7_;
		_tmp5_ = self->priv->re_record_keyval;
		_tmp7_ = g_regex_match (_tmp5_, data, 0, &_tmp6_);
		_g_match_info_unref0 (match);
		match = _tmp6_;
		if (_tmp7_) {
			GMatchInfo* _tmp8_;
			gchar* _tmp9_;
			GMatchInfo* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp8_ = match;
			_tmp9_ = g_match_info_fetch (_tmp8_, 2);
			_g_free0 (_vala_key);
			_vala_key = _tmp9_;
			_tmp10_ = match;
			_tmp11_ = g_match_info_fetch (_tmp10_, 3);
			_g_free0 (_vala_val);
			_vala_val = _tmp11_;
			_tmp12_ = _vala_val;
			_vala_assert (_tmp12_ != NULL, "val != null");
		} else {
			GRegex* _tmp13_;
			GMatchInfo* _tmp14_ = NULL;
			gboolean _tmp15_;
			_tmp13_ = self->priv->re_record_optval;
			_tmp15_ = g_regex_match (_tmp13_, data, 0, &_tmp14_);
			_g_match_info_unref0 (match);
			match = _tmp14_;
			if (_tmp15_) {
				GMatchInfo* _tmp16_;
				gchar* _tmp17_;
				GMatchInfo* _tmp18_;
				gchar* _tmp19_;
				_tmp16_ = match;
				_tmp17_ = g_match_info_fetch (_tmp16_, 2);
				_g_free0 (_vala_key);
				_vala_key = _tmp17_;
				_tmp18_ = match;
				_tmp19_ = g_match_info_fetch (_tmp18_, 3);
				_g_free0 (_vala_val);
				_vala_val = _tmp19_;
			} else {
				g_debug ("umockdev.vala:1147: record_parse_line: >%s< does not match anything, f" \
"ailing", data);
				_vala_type = '\0';
				_g_free0 (_vala_key);
				_vala_key = NULL;
				_g_free0 (_vala_val);
				_vala_val = NULL;
				result = NULL;
				_g_match_info_unref0 (match);
				if (type) {
					*type = _vala_type;
				}
				if (key) {
					*key = _vala_key;
				} else {
					_g_free0 (_vala_key);
				}
				if (val) {
					*val = _vala_val;
				} else {
					_g_free0 (_vala_val);
				}
				return result;
			}
		}
	}
	_tmp20_ = match;
	_tmp21_ = g_match_info_fetch (_tmp20_, 1);
	type_str = _tmp21_;
	_tmp22_ = type_str;
	_vala_assert (_tmp22_ != NULL, "type_str != null");
	_tmp23_ = type_str;
	_vala_type = string_get (_tmp23_, (glong) 0);
	_tmp24_ = match;
	_tmp26_ = g_match_info_fetch_pos (_tmp24_, 0, NULL, &_tmp25_);
	end_pos = _tmp25_;
	_vala_assert (_tmp26_, "match.fetch_pos(0, null, out end_pos)");
	_tmp27_ = end_pos;
	_tmp28_ = string_substring (data, (glong) _tmp27_, (glong) -1);
	result = _tmp28_;
	_g_free0 (type_str);
	_g_match_info_unref0 (match);
	if (type) {
		*type = _vala_type;
	}
	if (key) {
		*key = _vala_key;
	} else {
		_g_free0 (_vala_key);
	}
	if (val) {
		*val = _vala_val;
	} else {
		_g_free0 (_vala_val);
	}
	return result;
}


/**
     * umockdev_testbed_disable:
     * @self: A #UMockdevTestbed.
     *
     * Disable the testbed.  This can be used for temporarily switching back to
     * the real /sys and /dev without having to destroy or change $UMOCKDEV_DIR
     * and the #UMockdevTestbed instance. Use @umockdev_testbed_enable() to
     * re-enable the testbed.
     */
void
umockdev_testbed_disable (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_fopen (_tmp2_, "w");
	_tmp4_ = _tmp3_;
	_fclose0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
     * umockdev_testbed_enable:
     * @self: A #UMockdevTestbed.
     *
     * Re-enable the testbed after @@umockdev_testbed_disable().
     */
void
umockdev_testbed_enable (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	g_remove (_tmp2_);
	_g_free0 (_tmp2_);
}


/**
     * umockdev_testbed_clear:
     * @self: A #UMockdevTestbed.
     *
     * Remove all added devices from testbed directory.  After that, the
     * umockdev root directory will be in the same state as directly after the
     * constructor.
     */
void
umockdev_testbed_clear (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	umockdev_remove_dir (_tmp0_, FALSE);
	_tmp1_ = self->priv->sys_dir;
	g_mkdir (_tmp1_, 0755);
}


/**
     * umockdev_testbed_get_dev_fd:
     * @self: A #UMockdevTestbed.
     * @devnode: Device node name ("/dev/...")
     *
     * Simulated devices without a pre-defined contents are backed by a
     * stream-like device node (PTY). Return the file descriptor
     * for accessing their "master" side, i. e. the end that gets
     * controlled by test suites. The tested program opens the "slave" side,
     * which is just openening the device specified by @devnode, e. g.
     * /dev/ttyUSB2. Once that happened, your test can directly communicate
     * with the tested program over that descriptor.
     *
     * Returns: File descriptor for communicating with clients that connect to
     *           @devnode, or -1 if @devnode does not exist or is not a
     *           simulated stream device. This must not be closed!
     */
gint
umockdev_testbed_get_dev_fd (UMockdevTestbed* self,
                             const gchar* devnode)
{
	gint result = 0;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (devnode != NULL, 0);
	_tmp0_ = self->priv->dev_fd;
	if (g_hash_table_contains (_tmp0_, devnode)) {
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = self->priv->dev_fd;
		_tmp2_ = g_hash_table_lookup (_tmp1_, devnode);
		result = (gint) ((gintptr) _tmp2_);
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void
umockdev_testbed_class_init (UMockdevTestbedClass * klass)
{
	umockdev_testbed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevTestbed_private_offset);
	G_OBJECT_CLASS (klass)->finalize = umockdev_testbed_finalize;
}


static void
umockdev_testbed_instance_init (UMockdevTestbed * self)
{
	self->priv = umockdev_testbed_get_instance_private (self);
	self->priv->ev_sender = NULL;
	self->priv->socket_server = NULL;
}


static void
umockdev_testbed_finalize (GObject * obj)
{
	UMockdevTestbed * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GList* _tmp5_;
	UMockdevSocketServer* _tmp8_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_TESTBED, UMockdevTestbed);
	_tmp0_ = self->priv->dev_script_runner;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp1_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp2_;
				_tmp2_ = r;
				umockdev_script_runner_stop (_tmp2_);
			}
		}
		(r_collection == NULL) ? NULL : (r_collection = (g_list_free (r_collection), NULL));
	}
	_tmp3_ = self->priv->dev_script_runner;
	g_hash_table_remove_all (_tmp3_);
	_tmp4_ = self->priv->dev_fd;
	_tmp5_ = g_hash_table_get_values (_tmp4_);
	{
		GList* fd_collection = NULL;
		GList* fd_it = NULL;
		fd_collection = _tmp5_;
		for (fd_it = fd_collection; fd_it != NULL; fd_it = fd_it->next) {
			gint fd = 0;
			fd = (gint) ((gintptr) fd_it->data);
			{
				gint _tmp6_;
				gint _tmp7_;
				_tmp6_ = fd;
				g_debug ("umockdev.vala:90: closing master pty fd %i for emulated device", _tmp6_);
				_tmp7_ = fd;
				close (_tmp7_);
			}
		}
		(fd_collection == NULL) ? NULL : (fd_collection = (g_list_free (fd_collection), NULL));
	}
	_tmp8_ = self->priv->socket_server;
	if (_tmp8_ != NULL) {
		UMockdevSocketServer* _tmp9_;
		g_debug ("umockdev.vala:95: shutting down socket server thread");
		_tmp9_ = self->priv->socket_server;
		umockdev_socket_server_stop (_tmp9_);
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = NULL;
	}
	_tmp10_ = self->priv->root_dir;
	g_debug ("umockdev.vala:100: Removing test bed %s", _tmp10_);
	_tmp11_ = self->priv->root_dir;
	umockdev_remove_dir (_tmp11_, TRUE);
	g_unsetenv ("UMOCKDEV_DIR");
	_g_free0 (self->priv->root_dir);
	_g_free0 (self->priv->sys_dir);
	_g_regex_unref0 (self->priv->re_record_val);
	_g_regex_unref0 (self->priv->re_record_keyval);
	_g_regex_unref0 (self->priv->re_record_optval);
	_uevent_sender_close0 (self->priv->ev_sender);
	_g_hash_table_unref0 (self->priv->dev_fd);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	_umockdev_socket_server_unref0 (self->priv->socket_server);
	G_OBJECT_CLASS (umockdev_testbed_parent_class)->finalize (obj);
}


/**
 * UMockdevTestbed:
 *
 * The #UMockdevTestbed class builds a temporary sandbox for mock devices.
 * You can add a number of devices including arbitrary sysfs attributes and
 * udev properties, and then run your software in that test bed that is
 * independent of the actual hardware it is running on.  With this you can
 * simulate particular hardware in virtual environments up to some degree,
 * without needing any particular privileges or disturbing the whole system.
 *
 * You can either add devices by specifying individual device paths,
 * properties, and attributes, or use the umockdev-record tool to create a human
 * readable/editable record of a real device (and all its parents) and load
 * that into the testbed with umockdev_testbed_add_from_string().
 *
 * Instantiating a #UMockdevTestbed object creates a temporary directory with
 * an empty sysfs tree and sets the $UMOCKDEV_DIR environment variable so that
 * programs subsequently started under umockdev-wrapper will use the test bed
 * instead of the system's real sysfs.
 */
GType
umockdev_testbed_get_type (void)
{
	static volatile gsize umockdev_testbed_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_testbed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevTestbedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_testbed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevTestbed), 0, (GInstanceInitFunc) umockdev_testbed_instance_init, NULL };
		GType umockdev_testbed_type_id;
		umockdev_testbed_type_id = g_type_register_static (G_TYPE_OBJECT, "UMockdevTestbed", &g_define_type_info, 0);
		UMockdevTestbed_private_offset = g_type_add_instance_private (umockdev_testbed_type_id, sizeof (UMockdevTestbedPrivate));
		g_once_init_leave (&umockdev_testbed_type_id__volatile, umockdev_testbed_type_id);
	}
	return umockdev_testbed_type_id__volatile;
}


void
umockdev_remove_dir (const gchar* path,
                     gboolean remove_toplevel)
{
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	if (g_file_test (path, G_FILE_TEST_IS_DIR)) {
		_tmp0_ = !g_file_test (path, G_FILE_TEST_IS_SYMLINK);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GDir* d = NULL;
		gchar* name = NULL;
		{
			GDir* _tmp1_ = NULL;
			GDir* _tmp2_;
			GDir* _tmp3_;
			_tmp2_ = g_dir_open (path, (guint) 0, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch10_g_file_error;
				}
				_g_dir_close0 (d);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_dir_close0 (d);
			d = _tmp3_;
			_g_dir_close0 (_tmp1_);
		}
		goto __finally10;
		__catch10_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("umockdev.vala:1252: cannot open: %s: %s", path, _tmp5_);
			_g_error_free0 (e);
			_g_dir_close0 (d);
			return;
		}
		__finally10:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_dir_close0 (d);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			GDir* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp6_ = d;
			_tmp7_ = g_dir_read_name (_tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (name);
			name = _tmp8_;
			_tmp9_ = name;
			if (!(_tmp9_ != NULL)) {
				break;
			}
			_tmp10_ = name;
			_tmp11_ = g_build_filename (path, _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			umockdev_remove_dir (_tmp12_, TRUE);
			_g_free0 (_tmp12_);
		}
		_g_free0 (name);
		_g_dir_close0 (d);
	}
	if (remove_toplevel) {
		if (g_remove (path) < 0) {
			gint _tmp13_;
			const gchar* _tmp14_;
			_tmp13_ = errno;
			_tmp14_ = g_strerror (_tmp13_);
			g_warning ("umockdev.vala:1263: cannot remove %s: %s", path, _tmp14_);
		}
	}
}


static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar*
umockdev_make_dotdots (const gchar* path)
{
	gchar* result = NULL;
	gint offset = 0;
	guint count = 0U;
	gchar* dots = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (path != NULL, NULL);
	offset = 0;
	count = (guint) 0;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		guint _tmp2_;
		gint _tmp3_;
		_tmp0_ = offset;
		offset = string_index_of_char (path, (gunichar) '/', _tmp0_);
		_tmp1_ = offset;
		if (!(_tmp1_ >= 0)) {
			break;
		}
		_tmp2_ = count;
		count = _tmp2_ + 1;
		_tmp3_ = offset;
		offset = _tmp3_ + 1;
	}
	_tmp4_ = g_strdup ("");
	dots = _tmp4_;
	while (TRUE) {
		guint _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		guint _tmp8_;
		_tmp5_ = count;
		if (!(_tmp5_ > ((guint) 1))) {
			break;
		}
		_tmp6_ = dots;
		_tmp7_ = g_strconcat (_tmp6_, "../", NULL);
		_g_free0 (dots);
		dots = _tmp7_;
		_tmp8_ = count;
		count = _tmp8_ - 1;
	}
	result = dots;
	return result;
}


guint8
umockdev_hexdigit (gchar c)
{
	guint8 result = 0U;
	gint _tmp0_ = 0;
	if (c >= 'a') {
		_tmp0_ = (c - 'a') + 10;
	} else {
		gint _tmp1_ = 0;
		if (c >= 'A') {
			_tmp1_ = (c - 'A') + 10;
		} else {
			_tmp1_ = (gint) (c - '0');
		}
		_tmp0_ = _tmp1_;
	}
	result = (guint8) _tmp0_;
	return result;
}


guint8*
umockdev_decode_hex (const gchar* data,
                     int* result_length1,
                     GError** error)
{
	guint8* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint len = 0;
	gint _tmp3_;
	gint _tmp4_;
	guint8* bin = NULL;
	gint _tmp5_;
	guint8* _tmp6_;
	gint bin_length1;
	gint _bin_size_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = strlen (data);
	_tmp1_ = _tmp0_;
	if ((_tmp1_ % 2) != 0) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed hexadecimal value: %s", data);
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = strlen (data);
	_tmp4_ = _tmp3_;
	len = _tmp4_;
	_tmp5_ = len;
	_tmp6_ = g_new0 (guint8, _tmp5_ / 2);
	bin = _tmp6_;
	bin_length1 = _tmp5_ / 2;
	_bin_size_ = bin_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				guint _tmp9_;
				guint8* _tmp10_;
				gint _tmp10__length1;
				guint8* _tmp11_;
				gint _tmp11__length1;
				guint _tmp12_;
				guint _tmp13_;
				guint _tmp14_;
				guint8 _tmp15_;
				if (!_tmp7_) {
					guint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = bin;
				_tmp10__length1 = bin_length1;
				if (!(_tmp9_ < ((guint) _tmp10__length1))) {
					break;
				}
				_tmp11_ = bin;
				_tmp11__length1 = bin_length1;
				_tmp12_ = i;
				_tmp13_ = i;
				_tmp14_ = i;
				_tmp11_[_tmp12_] = (guint8) ((umockdev_hexdigit (string_get (data, (glong) (_tmp13_ * 2))) << 4) | umockdev_hexdigit (string_get (data, (glong) ((_tmp14_ * 2) + 1))));
				_tmp15_ = _tmp11_[_tmp12_];
			}
		}
	}
	_tmp16_ = bin;
	_tmp16__length1 = bin_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


gchar*
umockdev_find_devnode (const gchar* devpath)
{
	gchar* result = NULL;
	gchar* devname = NULL;
	GFile* f = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (devpath != NULL, NULL);
	devname = NULL;
	_tmp0_ = g_build_filename (devpath, "uevent", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	f = _tmp3_;
	{
		GFileInputStream* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileInputStream* _tmp6_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp7_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp20_;
		_tmp5_ = f;
		_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp7_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
		inp = _tmp7_;
		while (TRUE) {
			gchar* _tmp8_ = NULL;
			GDataInputStream* _tmp9_;
			gsize _tmp10_ = 0UL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp9_ = inp;
			_tmp11_ = g_data_input_stream_read_line (_tmp9_, &_tmp10_, NULL, &_inner_error_);
			len = _tmp10_;
			_tmp8_ = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp4_);
				goto __catch11_g_error;
			}
			_tmp12_ = _tmp8_;
			_tmp8_ = NULL;
			_g_free0 (line);
			line = _tmp12_;
			_tmp13_ = line;
			if (!(_tmp13_ != NULL)) {
				_g_free0 (_tmp8_);
				break;
			}
			_tmp14_ = line;
			if (g_str_has_prefix (_tmp14_, "DEVNAME=")) {
				const gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = line;
				_tmp16_ = string_substring (_tmp15_, (glong) 8, (glong) -1);
				_g_free0 (devname);
				devname = _tmp16_;
				_tmp17_ = devname;
				if (!g_str_has_prefix (_tmp17_, "/dev/")) {
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp18_ = devname;
					_tmp19_ = g_strconcat ("/dev/", _tmp18_, NULL);
					_g_free0 (devname);
					devname = _tmp19_;
				}
				_g_free0 (_tmp8_);
				break;
			}
			_g_free0 (_tmp8_);
		}
		_tmp20_ = inp;
		g_input_stream_close ((GInputStream*) _tmp20_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp4_);
			goto __catch11_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("umockdev.vala:1331: Cannot read uevent file: %s\n", _tmp22_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (f);
		_g_free0 (devname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = devname;
	_g_object_unref0 (f);
	return result;
}


static inline gpointer
umockdev_script_runner_get_instance_private (UMockdevScriptRunner* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevScriptRunner_private_offset);
}


static gpointer
_umockdev_script_runner_run_gthread_func (gpointer self)
{
	gpointer result;
	result = umockdev_script_runner_run ((UMockdevScriptRunner*) self);
	umockdev_script_runner_unref (self);
	return result;
}


UMockdevScriptRunner*
umockdev_script_runner_construct (GType object_type,
                                  const gchar* device,
                                  const gchar* script_file,
                                  gint fd,
                                  GError** error)
{
	UMockdevScriptRunner* self = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	gchar* _tmp6_;
	GThread* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (script_file != NULL, NULL);
	self = (UMockdevScriptRunner*) g_type_create_instance (object_type);
	_tmp0_ = g_fopen (script_file, "r");
	_fclose0 (self->priv->script);
	self->priv->script = _tmp0_;
	_tmp1_ = self->priv->script;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = g_strconcat ("Cannot open script record file ", script_file, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_umockdev_script_runner_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	umockdev_script_runner_set_device (self, device);
	_tmp6_ = g_strdup (script_file);
	_g_free0 (self->priv->script_file);
	self->priv->script_file = _tmp6_;
	self->priv->fd = fd;
	self->priv->running = TRUE;
	_tmp7_ = g_thread_new (device, _umockdev_script_runner_run_gthread_func, umockdev_script_runner_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp7_;
	return self;
}


UMockdevScriptRunner*
umockdev_script_runner_new (const gchar* device,
                            const gchar* script_file,
                            gint fd,
                            GError** error)
{
	return umockdev_script_runner_construct (UMOCKDEV_TYPE_SCRIPT_RUNNER, device, script_file, fd, error);
}


static gpointer
_g_thread_ref0 (gpointer self)
{
	return self ? g_thread_ref (self) : NULL;
}


void
umockdev_script_runner_stop (UMockdevScriptRunner* self)
{
	gboolean _tmp0_;
	const gchar* _tmp1_;
	GThread* _tmp2_;
	GThread* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->running;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_device;
	g_debug ("umockdev.vala:1362: Stopping script runner for %s: joining thread", _tmp1_);
	self->priv->running = FALSE;
	_tmp2_ = self->priv->thread;
	_tmp3_ = _g_thread_ref0 (_tmp2_);
	g_thread_join (_tmp3_);
}


static void*
umockdev_script_runner_run (UMockdevScriptRunner* self)
{
	void* result = NULL;
	gchar op = '\0';
	guint32 delta = 0U;
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_;
	const gchar* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	g_debug ("umockdev.vala:1373: ScriptRunner[%s]: start", _tmp0_);
	while (TRUE) {
		gboolean _tmp1_;
		gchar _tmp2_ = '\0';
		guint32 _tmp3_ = 0U;
		gint _tmp4_ = 0;
		guint8* _tmp5_;
		gchar _tmp6_;
		_tmp1_ = self->priv->running;
		if (!_tmp1_) {
			break;
		}
		_tmp5_ = umockdev_script_runner_next_line (self, &_tmp2_, &_tmp3_, &_tmp4_);
		op = _tmp2_;
		delta = _tmp3_;
		data = (g_free (data), NULL);
		data = _tmp5_;
		data_length1 = _tmp4_;
		_data_size_ = data_length1;
		_tmp6_ = op;
		switch (_tmp6_) {
			case 'r':
			{
				const gchar* _tmp7_;
				guint32 _tmp8_;
				guint32 _tmp9_;
				const gchar* _tmp10_;
				guint8* _tmp11_;
				gint _tmp11__length1;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gssize l = 0L;
				gint _tmp14_;
				guint8* _tmp15_;
				gint _tmp15__length1;
				guint8* _tmp16_;
				gint _tmp16__length1;
				gssize _tmp17_;
				gssize _tmp21_;
				guint8* _tmp22_;
				gint _tmp22__length1;
				_tmp7_ = self->priv->_device;
				_tmp8_ = delta;
				g_debug ("ScriptRunner[%s]: read op; sleeping %" G_GUINT32_FORMAT " ms", _tmp7_, _tmp8_);
				_tmp9_ = delta;
				g_usleep ((gulong) (_tmp9_ * 1000));
				_tmp10_ = self->priv->_device;
				_tmp11_ = data;
				_tmp11__length1 = data_length1;
				_tmp12_ = umockdev_script_runner_encode (_tmp11_, _tmp11__length1);
				_tmp13_ = _tmp12_;
				g_debug ("umockdev.vala:1383: ScriptRunner[%s]: read op after sleep; writing dat" \
"a '%s'", _tmp10_, _tmp13_);
				_g_free0 (_tmp13_);
				_tmp14_ = self->priv->fd;
				_tmp15_ = data;
				_tmp15__length1 = data_length1;
				_tmp16_ = data;
				_tmp16__length1 = data_length1;
				l = write (_tmp14_, _tmp15_, (gsize) _tmp16__length1);
				_tmp17_ = l;
				if (_tmp17_ < ((gssize) 0)) {
					const gchar* _tmp18_;
					gint _tmp19_;
					const gchar* _tmp20_;
					_tmp18_ = self->priv->_device;
					_tmp19_ = errno;
					_tmp20_ = g_strerror (_tmp19_);
					g_error ("umockdev.vala:1386: ScriptRunner[%s]: write failed: %s", _tmp18_, _tmp20_);
				}
				_tmp21_ = l;
				_tmp22_ = data;
				_tmp22__length1 = data_length1;
				_vala_assert (_tmp21_ == ((gssize) _tmp22__length1), "l == data.length");
				break;
			}
			case 'w':
			{
				const gchar* _tmp23_;
				guint8* _tmp24_;
				gint _tmp24__length1;
				gchar* _tmp25_;
				gchar* _tmp26_;
				guint8* _tmp27_;
				gint _tmp27__length1;
				guint32 _tmp28_;
				_tmp23_ = self->priv->_device;
				_tmp24_ = data;
				_tmp24__length1 = data_length1;
				_tmp25_ = umockdev_script_runner_encode (_tmp24_, _tmp24__length1);
				_tmp26_ = _tmp25_;
				g_debug ("umockdev.vala:1391: ScriptRunner[%s]: write op, data '%s'", _tmp23_, _tmp26_);
				_g_free0 (_tmp26_);
				_tmp27_ = data;
				_tmp27__length1 = data_length1;
				_tmp28_ = delta;
				umockdev_script_runner_op_write (self, _tmp27_, _tmp27__length1, _tmp28_);
				break;
			}
			case 'Q':
			{
				self->priv->running = FALSE;
				break;
			}
			case 'f':
			{
				guint32 _tmp29_;
				guint32 _tmp32_;
				const gchar* _tmp33_;
				guint _tmp34_;
				_tmp29_ = delta;
				if (_tmp29_ > ((guint32) 100)) {
					const gchar* _tmp30_;
					guint32 _tmp31_;
					_tmp30_ = self->priv->_device;
					_tmp31_ = delta;
					g_error ("umockdev.vala:1401: ScriptRunner[%s]: fuzz value %u is invalid (must b" \
"e between 0 and 100)", _tmp30_, (guint) _tmp31_);
				}
				_tmp32_ = delta;
				self->priv->fuzz = (guint) _tmp32_;
				_tmp33_ = self->priv->_device;
				_tmp34_ = self->priv->fuzz;
				g_debug ("umockdev.vala:1404: ScriptRunner[%s]: setting fuzz level to %u%%", _tmp33_, _tmp34_);
				break;
			}
			case 'd':
			{
				break;
			}
			default:
			{
				const gchar* _tmp35_;
				gchar _tmp36_;
				_tmp35_ = self->priv->_device;
				_tmp36_ = op;
				g_debug ("umockdev.vala:1412: ScriptRunner[%s]: got unknown line op %c, ignoring", _tmp35_, (gint) _tmp36_);
				break;
			}
		}
	}
	_tmp37_ = self->priv->_device;
	g_debug ("umockdev.vala:1417: ScriptRunner[%s]: not running any more, ending thr" \
"ead", _tmp37_);
	result = NULL;
	data = (g_free (data), NULL);
	return result;
}


static gchar*
g_file_stream_read_line (FILE* self)
{
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_;
		GString* _tmp1_;
		gint _tmp3_;
		GString* _tmp4_;
		gint _tmp5_;
		c = fgetc (self);
		_tmp0_ = c;
		if (!(_tmp0_ != EOF)) {
			break;
		}
		_tmp1_ = ret;
		if (_tmp1_ == NULL) {
			GString* _tmp2_;
			_tmp2_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp2_;
		}
		_tmp3_ = c;
		if (_tmp3_ == ((gint) '\n')) {
			break;
		}
		_tmp4_ = ret;
		_tmp5_ = c;
		g_string_append_c ((GString*) _tmp4_, (gchar) _tmp5_);
	}
	_tmp6_ = ret;
	if (_tmp6_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = ret;
		_tmp8_ = ((GString*) _tmp7_)->str;
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static guint8*
umockdev_script_runner_next_line (UMockdevScriptRunner* self,
                                  gchar* op,
                                  guint32* delta,
                                  int* result_length1)
{
	gchar _vala_op = '\0';
	guint32 _vala_delta = 0U;
	guint8* result = NULL;
	gint c = 0;
	glong cur_pos = 0L;
	FILE* _tmp13_;
	FILE* _tmp14_;
	FILE* _tmp17_;
	FILE* _tmp18_;
	gchar* line = NULL;
	FILE* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gint _tmp25_ = 0;
	guint8* _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			FILE* _tmp1_;
			gint _tmp2_;
			if (!_tmp0_) {
			}
			_tmp0_ = FALSE;
			_tmp1_ = self->priv->script;
			c = fgetc (_tmp1_);
			_tmp2_ = c;
			if (_tmp2_ == EOF) {
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				guint8* _tmp5_;
				guint8* _tmp6_;
				gint _tmp6__length1;
				_tmp3_ = self->priv->_device;
				_tmp4_ = self->priv->script_file;
				g_debug ("umockdev.vala:1428: ScriptRunner[%s]: end of script %s, closing", _tmp3_, _tmp4_);
				_vala_op = 'Q';
				_vala_delta = (guint32) 0;
				_tmp5_ = g_new0 (guint8, 0);
				_tmp6_ = _tmp5_;
				_tmp6__length1 = 0;
				if (result_length1) {
					*result_length1 = _tmp6__length1;
				}
				result = _tmp6_;
				if (op) {
					*op = _vala_op;
				}
				if (delta) {
					*delta = _vala_delta;
				}
				return result;
			} else {
				gint _tmp7_;
				_tmp7_ = c;
				if (_tmp7_ == ((gint) '#')) {
					FILE* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp8_ = self->priv->script;
					_tmp9_ = g_file_stream_read_line (_tmp8_);
					_tmp10_ = _tmp9_;
					_vala_assert (_tmp10_ != NULL, "this.script.read_line () != null");
					_g_free0 (_tmp10_);
				} else {
					gint _tmp11_;
					_tmp11_ = c;
					if (_tmp11_ != ((gint) '\n')) {
						gint _tmp12_;
						_tmp12_ = c;
						_vala_op = (gchar) _tmp12_;
						break;
					}
				}
			}
		}
	}
	_tmp13_ = self->priv->script;
	cur_pos = ftell (_tmp13_);
	_tmp14_ = self->priv->script;
	if (fgetc (_tmp14_) != ((gint) ' ')) {
		const gchar* _tmp15_;
		glong _tmp16_;
		_tmp15_ = self->priv->script_file;
		_tmp16_ = cur_pos;
		g_error ("umockdev.vala:1442: Missing space after operation code in %s at positi" \
"on %li", _tmp15_, _tmp16_);
	}
	_tmp17_ = self->priv->script;
	cur_pos = ftell (_tmp17_);
	_tmp18_ = self->priv->script;
	if (fscanf (_tmp18_, "%" G_GUINT32_FORMAT " ", &_vala_delta) != 1) {
		const gchar* _tmp19_;
		glong _tmp20_;
		_tmp19_ = self->priv->script_file;
		_tmp20_ = cur_pos;
		g_error ("umockdev.vala:1447: Cannot parse time in %s at position %li", _tmp19_, _tmp20_);
	}
	_tmp21_ = self->priv->script;
	_tmp22_ = g_file_stream_read_line (_tmp21_);
	line = _tmp22_;
	_tmp23_ = line;
	_vala_assert (_tmp23_ != NULL, "line != null");
	_tmp24_ = line;
	_tmp26_ = umockdev_script_runner_decode (_tmp24_, &_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp27__length1 = _tmp25_;
	if (result_length1) {
		*result_length1 = _tmp27__length1;
	}
	result = _tmp27_;
	_g_free0 (line);
	if (op) {
		*op = _vala_op;
	}
	if (delta) {
		*delta = _vala_delta;
	}
	return result;
}


static void
umockdev_script_runner_op_write (UMockdevScriptRunner* self,
                                 guint8* data,
                                 int data_length1,
                                 guint32 delta)
{
	fd_set fds = {0};
	struct timeval timeout = {0};
	struct timeval _tmp0_ = {0};
	gsize offset = 0UL;
	guint8* buf = NULL;
	guint8* _tmp1_;
	gint buf_length1;
	gint _buf_size_;
	g_return_if_fail (self != NULL);
	_tmp0_.tv_sec = (time_t) 0;
	_tmp0_.tv_usec = (glong) 200000;
	timeout = _tmp0_;
	offset = (gsize) 0;
	_tmp1_ = g_new0 (guint8, data_length1);
	buf = _tmp1_;
	buf_length1 = data_length1;
	_buf_size_ = buf_length1;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		fd_set _tmp5_ = {0};
		gint _tmp6_;
		gint res = 0;
		gint _tmp7_;
		struct timeval _tmp8_;
		gint _tmp9_;
		gint _tmp14_;
		gssize len = 0L;
		gint _tmp19_;
		guint8* _tmp20_;
		gint _tmp20__length1;
		gsize _tmp21_;
		gssize _tmp22_;
		guint _tmp28_;
		gsize _tmp62_;
		gssize _tmp63_;
		const gchar* _tmp64_;
		gssize _tmp65_;
		gsize _tmp66_;
		_tmp3_ = self->priv->running;
		if (_tmp3_) {
			gsize _tmp4_;
			_tmp4_ = offset;
			_tmp2_ = _tmp4_ < ((gsize) data_length1);
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		FD_ZERO (&_tmp5_);
		fds = _tmp5_;
		_tmp6_ = self->priv->fd;
		FD_SET (_tmp6_, &fds);
		_tmp7_ = self->priv->fd;
		_tmp8_ = timeout;
		res = select (_tmp7_ + 1, &fds, NULL, NULL, &_tmp8_);
		_tmp9_ = res;
		if (_tmp9_ < 0) {
			gint _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_;
			const gchar* _tmp13_;
			_tmp10_ = errno;
			if (_tmp10_ == EINTR) {
				continue;
			}
			_tmp11_ = self->priv->_device;
			_tmp12_ = errno;
			_tmp13_ = g_strerror (_tmp12_);
			g_error ("umockdev.vala:1472: ScriptRunner op_write[%s]: select() failed: %s", _tmp11_, _tmp13_);
		}
		_tmp14_ = res;
		if (_tmp14_ == 0) {
			const gchar* _tmp15_;
			gsize _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp15_ = self->priv->_device;
			_tmp16_ = offset;
			_tmp17_ = umockdev_script_runner_encode (data + ((gint) _tmp16_), data_length1 - ((gint) _tmp16_));
			_tmp18_ = _tmp17_;
			g_debug ("umockdev.vala:1477: ScriptRunner[%s]: timed out on read operation on e" \
"xpected block '%s', trying again", _tmp15_, _tmp18_);
			_g_free0 (_tmp18_);
			continue;
		}
		_tmp19_ = self->priv->fd;
		_tmp20_ = buf;
		_tmp20__length1 = buf_length1;
		_tmp21_ = offset;
		len = read (_tmp19_, _tmp20_, data_length1 - _tmp21_);
		_tmp22_ = len;
		if (_tmp22_ <= ((gssize) 0)) {
			const gchar* _tmp23_;
			gsize _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			FILE* _tmp27_;
			_tmp23_ = self->priv->_device;
			_tmp24_ = offset;
			_tmp25_ = umockdev_script_runner_encode (data + ((gint) _tmp24_), data_length1 - ((gint) _tmp24_));
			_tmp26_ = _tmp25_;
			g_debug ("umockdev.vala:1485: ScriptRunner[%s]: got failure or EOF on read opera" \
"tion on expected block '%s', resetting", _tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			_tmp27_ = self->priv->script;
			fseek (_tmp27_, (glong) 0, SEEK_SET);
			buf = (g_free (buf), NULL);
			return;
		}
		_tmp28_ = self->priv->fuzz;
		if (_tmp28_ == ((guint) 0)) {
			guint8* _tmp29_;
			gint _tmp29__length1;
			gsize _tmp30_;
			gssize _tmp31_;
			_tmp29_ = buf;
			_tmp29__length1 = buf_length1;
			_tmp30_ = offset;
			_tmp31_ = len;
			if (memcmp (_tmp29_, data + ((gint) _tmp30_), (gsize) _tmp31_) != 0) {
				const gchar* _tmp32_;
				guint8* _tmp33_;
				gint _tmp33__length1;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gssize _tmp36_;
				gsize _tmp37_;
				gsize _tmp38_;
				gssize _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp32_ = self->priv->_device;
				_tmp33_ = buf;
				_tmp33__length1 = buf_length1;
				_tmp34_ = umockdev_script_runner_encode (_tmp33_, _tmp33__length1);
				_tmp35_ = _tmp34_;
				_tmp36_ = len;
				_tmp37_ = offset;
				_tmp38_ = offset;
				_tmp39_ = len;
				_tmp40_ = umockdev_script_runner_encode (data + ((gint) _tmp37_), ((gint) (_tmp38_ + _tmp39_)) - ((gint) _tmp37_));
				_tmp41_ = _tmp40_;
				g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s'", _tmp32_, _tmp35_, _tmp36_, _tmp41_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp35_);
			}
		} else {
			guint d = 0U;
			guint8* _tmp42_;
			gint _tmp42__length1;
			gsize _tmp43_;
			gsize _tmp44_;
			gssize _tmp45_;
			guint _tmp46_;
			guint _tmp47_;
			gssize _tmp48_;
			_tmp42_ = buf;
			_tmp42__length1 = buf_length1;
			_tmp43_ = offset;
			_tmp44_ = offset;
			_tmp45_ = len;
			d = umockdev_script_runner_hamming (_tmp42_, _tmp42__length1, data + ((gint) _tmp43_), ((gint) (_tmp44_ + _tmp45_)) - ((gint) _tmp43_));
			_tmp46_ = d;
			_tmp47_ = self->priv->fuzz;
			_tmp48_ = len;
			if (((gssize) (_tmp46_ * 100)) > (_tmp47_ * _tmp48_)) {
				const gchar* _tmp49_;
				guint8* _tmp50_;
				gint _tmp50__length1;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gssize _tmp53_;
				gsize _tmp54_;
				gsize _tmp55_;
				gssize _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				guint _tmp59_;
				gssize _tmp60_;
				guint _tmp61_;
				_tmp49_ = self->priv->_device;
				_tmp50_ = buf;
				_tmp50__length1 = buf_length1;
				_tmp51_ = umockdev_script_runner_encode (_tmp50_, _tmp50__length1);
				_tmp52_ = _tmp51_;
				_tmp53_ = len;
				_tmp54_ = offset;
				_tmp55_ = offset;
				_tmp56_ = len;
				_tmp57_ = umockdev_script_runner_encode (data + ((gint) _tmp54_), ((gint) (_tmp55_ + _tmp56_)) - ((gint) _tmp54_));
				_tmp58_ = _tmp57_;
				_tmp59_ = d;
				_tmp60_ = len;
				_tmp61_ = self->priv->fuzz;
				g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s', difference %u%% > fuzz level %u%%", _tmp49_, _tmp52_, _tmp53_, _tmp58_, ((guint) (((_tmp59_ * 1000) / _tmp60_) + 5)) / 10, _tmp61_);
				_g_free0 (_tmp58_);
				_g_free0 (_tmp52_);
			}
		}
		_tmp62_ = offset;
		_tmp63_ = len;
		offset = _tmp62_ + _tmp63_;
		_tmp64_ = self->priv->_device;
		_tmp65_ = len;
		_tmp66_ = offset;
		g_debug ("ScriptRunner[%s]: op_write, got %" G_GSSIZE_FORMAT " bytes; offset: %" G_GSIZE_FORMAT ", full block size %i", _tmp64_, _tmp65_, _tmp66_, data_length1);
	}
	buf = (g_free (buf), NULL);
}


static void
_vala_array_add11 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add12 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static guint8*
umockdev_script_runner_decode (const gchar* quoted,
                               int* result_length1)
{
	guint8* result = NULL;
	guint8* data = NULL;
	guint8* _tmp0_;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	g_return_val_if_fail (quoted != NULL, NULL);
	_tmp0_ = g_new0 (guint8, 0);
	data = _tmp0_;
	data_length1 = 0;
	_data_size_ = data_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				guint8* _tmp6_;
				gint _tmp6__length1;
				guint8* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				guint8 _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = strlen (quoted);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				_tmp6_ = string_get_data (quoted, &_tmp6__length1);
				_tmp7_ = _tmp6_;
				_tmp7__length1 = _tmp6__length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				if (_tmp9_ == ((guint8) '^')) {
					gint _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gchar _tmp13_ = '\0';
					guint8* _tmp14_;
					gint _tmp14__length1;
					guint8* _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					guint8 _tmp17_;
					guint8* _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					_tmp10_ = i;
					_tmp11_ = strlen (quoted);
					_tmp12_ = _tmp11_;
					_vala_assert ((_tmp10_ + 1) < _tmp12_, "i + 1 < quoted.length");
					_tmp14_ = string_get_data (quoted, &_tmp14__length1);
					_tmp15_ = _tmp14_;
					_tmp15__length1 = _tmp14__length1;
					_tmp16_ = i;
					_tmp17_ = _tmp15_[_tmp16_ + 1];
					if (_tmp17_ == ((guint8) '`')) {
						_tmp13_ = '^';
					} else {
						guint8* _tmp18_;
						gint _tmp18__length1;
						guint8* _tmp19_;
						gint _tmp19__length1;
						gint _tmp20_;
						guint8 _tmp21_;
						_tmp18_ = string_get_data (quoted, &_tmp18__length1);
						_tmp19_ = _tmp18_;
						_tmp19__length1 = _tmp18__length1;
						_tmp20_ = i;
						_tmp21_ = _tmp19_[_tmp20_ + 1];
						_tmp13_ = (gchar) (_tmp21_ - 64);
					}
					_tmp22_ = data;
					_tmp22__length1 = data_length1;
					_vala_array_add11 (&data, &data_length1, &_data_size_, (guint8) _tmp13_);
					_tmp23_ = i;
					i = _tmp23_ + 1;
				} else {
					guint8* _tmp24_;
					gint _tmp24__length1;
					guint8* _tmp25_;
					gint _tmp25__length1;
					guint8* _tmp26_;
					gint _tmp26__length1;
					gint _tmp27_;
					guint8 _tmp28_;
					_tmp24_ = data;
					_tmp24__length1 = data_length1;
					_tmp25_ = string_get_data (quoted, &_tmp25__length1);
					_tmp26_ = _tmp25_;
					_tmp26__length1 = _tmp25__length1;
					_tmp27_ = i;
					_tmp28_ = _tmp26_[_tmp27_];
					_vala_array_add12 (&data, &data_length1, &_data_size_, _tmp28_);
				}
			}
		}
	}
	_tmp29_ = data;
	_tmp29__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp29__length1;
	}
	result = _tmp29_;
	return result;
}


static void
_vala_array_add13 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add14 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add15 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add16 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add17 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add18 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


gchar*
umockdev_script_runner_encode (guint8* data,
                               int data_length1)
{
	gchar* result = NULL;
	guint8* quoted = NULL;
	guint8* _tmp0_;
	gint quoted_length1;
	gint _quoted_size_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	guint8* _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	_tmp0_ = g_new0 (guint8, 0);
	quoted = _tmp0_;
	quoted_length1 = 0;
	_quoted_size_ = quoted_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				guint8 _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < data_length1)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = data[_tmp4_];
				if (((gint) _tmp5_) < 32) {
					guint8* _tmp6_;
					gint _tmp6__length1;
					guint8* _tmp7_;
					gint _tmp7__length1;
					gint _tmp8_;
					guint8 _tmp9_;
					_tmp6_ = quoted;
					_tmp6__length1 = quoted_length1;
					_vala_array_add13 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
					_tmp7_ = quoted;
					_tmp7__length1 = quoted_length1;
					_tmp8_ = i;
					_tmp9_ = data[_tmp8_];
					_vala_array_add14 (&quoted, &quoted_length1, &_quoted_size_, (guint8) (_tmp9_ + 64));
				} else {
					gint _tmp10_;
					guint8 _tmp11_;
					_tmp10_ = i;
					_tmp11_ = data[_tmp10_];
					if (_tmp11_ == ((guint8) '^')) {
						guint8* _tmp12_;
						gint _tmp12__length1;
						guint8* _tmp13_;
						gint _tmp13__length1;
						_tmp12_ = quoted;
						_tmp12__length1 = quoted_length1;
						_vala_array_add15 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
						_tmp13_ = quoted;
						_tmp13__length1 = quoted_length1;
						_vala_array_add16 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '`');
					} else {
						guint8* _tmp14_;
						gint _tmp14__length1;
						gint _tmp15_;
						guint8 _tmp16_;
						_tmp14_ = quoted;
						_tmp14__length1 = quoted_length1;
						_tmp15_ = i;
						_tmp16_ = data[_tmp15_];
						_vala_array_add17 (&quoted, &quoted_length1, &_quoted_size_, _tmp16_);
					}
				}
			}
		}
	}
	_tmp17_ = quoted;
	_tmp17__length1 = quoted_length1;
	_vala_array_add18 (&quoted, &quoted_length1, &_quoted_size_, (guint8) 0);
	_tmp18_ = quoted;
	_tmp18__length1 = quoted_length1;
	_tmp19_ = g_strdup ((const gchar*) _tmp18_);
	result = _tmp19_;
	quoted = (g_free (quoted), NULL);
	return result;
}


static guint
umockdev_script_runner_hamming (guint8* d1,
                                int d1_length1,
                                guint8* d2,
                                int d2_length1)
{
	guint result = 0U;
	guint d = 0U;
	guint i = 0U;
	_vala_assert (d1_length1 == d2_length1, "d1.length == d2.length");
	d = (guint) 0;
	{
		gboolean _tmp0_ = FALSE;
		i = (guint) 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			guint _tmp2_;
			guint _tmp3_;
			guint _tmp4_;
			guint8 _tmp5_;
			guint _tmp6_;
			guint8 _tmp7_;
			if (!_tmp0_) {
				guint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			if (!(_tmp2_ < ((guint) d1_length1))) {
				break;
			}
			_tmp3_ = d;
			_tmp4_ = i;
			_tmp5_ = d1[_tmp4_];
			_tmp6_ = i;
			_tmp7_ = d2[_tmp6_];
			d = _tmp3_ + ((guint) (((gint) (_tmp5_ ^ _tmp7_)) > 0));
		}
	}
	result = d;
	return result;
}


const gchar*
umockdev_script_runner_get_device (UMockdevScriptRunner* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}


static void
umockdev_script_runner_set_device (UMockdevScriptRunner* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_device);
	self->priv->_device = _tmp0_;
}


static void
umockdev_value_script_runner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
umockdev_value_script_runner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		umockdev_script_runner_unref (value->data[0].v_pointer);
	}
}


static void
umockdev_value_script_runner_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_script_runner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
umockdev_value_script_runner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
umockdev_value_script_runner_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UMockdevScriptRunner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_script_runner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
umockdev_value_script_runner_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	UMockdevScriptRunner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_script_runner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
umockdev_param_spec_script_runner (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	UMockdevParamSpecScriptRunner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
umockdev_value_get_script_runner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	return value->data[0].v_pointer;
}


void
umockdev_value_set_script_runner (GValue* value,
                                  gpointer v_object)
{
	UMockdevScriptRunner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_script_runner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}


void
umockdev_value_take_script_runner (GValue* value,
                                   gpointer v_object)
{
	UMockdevScriptRunner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}


static void
umockdev_script_runner_class_init (UMockdevScriptRunnerClass * klass)
{
	umockdev_script_runner_parent_class = g_type_class_peek_parent (klass);
	((UMockdevScriptRunnerClass *) klass)->finalize = umockdev_script_runner_finalize;
	g_type_class_adjust_private_offset (klass, &UMockdevScriptRunner_private_offset);
}


static void
umockdev_script_runner_instance_init (UMockdevScriptRunner * self)
{
	self->priv = umockdev_script_runner_get_instance_private (self);
	self->priv->fuzz = (guint) 0;
	self->ref_count = 1;
}


static void
umockdev_script_runner_finalize (UMockdevScriptRunner * obj)
{
	UMockdevScriptRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner);
	g_signal_handlers_destroy (self);
	umockdev_script_runner_stop (self);
	_g_free0 (self->priv->_device);
	_g_free0 (self->priv->script_file);
	_g_thread_unref0 (self->priv->thread);
	_fclose0 (self->priv->script);
}


GType
umockdev_script_runner_get_type (void)
{
	static volatile gsize umockdev_script_runner_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_script_runner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { umockdev_value_script_runner_init, umockdev_value_script_runner_free_value, umockdev_value_script_runner_copy_value, umockdev_value_script_runner_peek_pointer, "p", umockdev_value_script_runner_collect_value, "p", umockdev_value_script_runner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevScriptRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_script_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevScriptRunner), 0, (GInstanceInitFunc) umockdev_script_runner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType umockdev_script_runner_type_id;
		umockdev_script_runner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevScriptRunner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		UMockdevScriptRunner_private_offset = g_type_add_instance_private (umockdev_script_runner_type_id, sizeof (UMockdevScriptRunnerPrivate));
		g_once_init_leave (&umockdev_script_runner_type_id__volatile, umockdev_script_runner_type_id);
	}
	return umockdev_script_runner_type_id__volatile;
}


gpointer
umockdev_script_runner_ref (gpointer instance)
{
	UMockdevScriptRunner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
umockdev_script_runner_unref (gpointer instance)
{
	UMockdevScriptRunner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SCRIPT_RUNNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static inline gpointer
umockdev_socket_server_get_instance_private (UMockdevSocketServer* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevSocketServer_private_offset);
}


static gpointer
_umockdev_socket_server_run_gthread_func (gpointer self)
{
	gpointer result;
	result = umockdev_socket_server_run ((UMockdevSocketServer*) self);
	umockdev_socket_server_unref (self);
	return result;
}


UMockdevSocketServer*
umockdev_socket_server_construct (GType object_type)
{
	UMockdevSocketServer* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GThread* _tmp6_;
	gint* fds = NULL;
	gint* _tmp7_;
	gint fds_length1;
	gint _fds_size_;
	gint _tmp8_;
	gint _tmp9_;
	self = (UMockdevSocketServer*) g_type_create_instance (object_type);
	self->priv->running = TRUE;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	self->priv->socket_scriptfile = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->script_runners);
	self->priv->script_runners = _tmp5_;
	_tmp6_ = g_thread_new ("SocketServer", _umockdev_socket_server_run_gthread_func, umockdev_socket_server_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp6_;
	_tmp7_ = g_new0 (gint, 2);
	fds = _tmp7_;
	fds_length1 = 2;
	_fds_size_ = fds_length1;
	_vala_assert (pipe (fds) == 0, "Posix.pipe (fds) == 0");
	_tmp8_ = fds[0];
	self->priv->ctrl_r = _tmp8_;
	_tmp9_ = fds[1];
	self->priv->ctrl_w = _tmp9_;
	fds = (g_free (fds), NULL);
	return self;
}


UMockdevSocketServer*
umockdev_socket_server_new (void)
{
	return umockdev_socket_server_construct (UMOCKDEV_TYPE_SOCKET_SERVER);
}


void
umockdev_socket_server_stop (UMockdevSocketServer* self)
{
	gboolean _tmp0_;
	gchar b = '\0';
	gint _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	GHashTable* _tmp5_;
	GThread* _tmp6_;
	GThread* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->running;
	if (!_tmp0_) {
		return;
	}
	self->priv->running = FALSE;
	g_debug ("umockdev.vala:1605: Stopping SocketServer: signalling thread");
	b = '1';
	_tmp1_ = self->priv->ctrl_w;
	_vala_assert (write (_tmp1_, &b, (gsize) 1) == ((gssize) 1), "Posix.write (this.ctrl_w, &b, 1) == 1");
	_tmp2_ = self->priv->script_runners;
	_tmp3_ = g_hash_table_get_values (_tmp2_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp3_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp4_;
				_tmp4_ = r;
				umockdev_script_runner_stop (_tmp4_);
			}
		}
		(r_collection == NULL) ? NULL : (r_collection = (g_list_free (r_collection), NULL));
	}
	_tmp5_ = self->priv->script_runners;
	g_hash_table_remove_all (_tmp5_);
	g_debug ("umockdev.vala:1614: Stopping SocketServer: joining thread");
	_tmp6_ = self->priv->thread;
	_tmp7_ = _g_thread_ref0 (_tmp6_);
	g_thread_join (_tmp7_);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_vala_array_add19 (GSocket** * array,
                   int* length,
                   int* size,
                   GSocket* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GSocket*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void
umockdev_socket_server_add (UMockdevSocketServer* self,
                            const gchar* sock_path,
                            gint fd,
                            const gchar* record_file)
{
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar b = '\0';
	gint _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sock_path != NULL);
	g_return_if_fail (record_file != NULL);
	{
		GSocket* s = NULL;
		GSocket* _tmp0_;
		GSocket* _tmp1_;
		gboolean _tmp2_ = FALSE;
		GSocket* _tmp3_;
		GUnixSocketAddress* _tmp4_;
		GUnixSocketAddress* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_ = FALSE;
		GSocket* _tmp8_;
		GSocket** _tmp9_;
		gint _tmp9__length1;
		GSocket* _tmp10_;
		GSocket* _tmp11_;
		_tmp0_ = g_socket_new_from_fd (fd, &_inner_error_);
		s = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		_tmp1_ = s;
		_vala_assert (_tmp1_ != NULL, "s != null");
		_tmp3_ = s;
		_tmp4_ = (GUnixSocketAddress*) g_unix_socket_address_new (sock_path);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_socket_bind (_tmp3_, (GSocketAddress*) _tmp5_, TRUE, &_inner_error_);
		_g_object_unref0 (_tmp5_);
		_tmp2_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (s);
			goto __catch12_g_error;
		}
		_vala_assert (_tmp2_, "s.bind (new UnixSocketAddress (sock_path), true)");
		_tmp8_ = s;
		_tmp7_ = g_socket_listen (_tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (s);
			goto __catch12_g_error;
		}
		_vala_assert (_tmp7_, "s.listen ()");
		_tmp9_ = self->priv->listen_sockets;
		_tmp9__length1 = self->priv->listen_sockets_length1;
		_tmp10_ = s;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_vala_array_add19 (&self->priv->listen_sockets, &self->priv->listen_sockets_length1, &self->priv->_listen_sockets_size_, _tmp11_);
		_g_object_unref0 (s);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e->message;
		g_error ("umockdev.vala:1627: load_socket_script(): cannot create Socket: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_debug ("umockdev.vala:1630: SocketServer.add: Created socket path %s, fd %i", sock_path, fd);
	_tmp13_ = self->priv->socket_scriptfile;
	_tmp14_ = g_strdup (sock_path);
	_tmp15_ = g_strdup (record_file);
	g_hash_table_insert (_tmp13_, _tmp14_, _tmp15_);
	b = '1';
	_tmp16_ = self->priv->ctrl_w;
	_vala_assert (write (_tmp16_, &b, (gsize) 1) == ((gssize) 1), "Posix.write (this.ctrl_w, &b, 1) == 1");
}


static void*
umockdev_socket_server_run (UMockdevSocketServer* self)
{
	void* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_debug ("umockdev.vala:1641: starting SocketServer thread");
	while (TRUE) {
		gboolean _tmp0_;
		fd_set fds = {0};
		fd_set _tmp1_ = {0};
		gint _tmp2_;
		gint max = 0;
		gint _tmp3_;
		GSocket** _tmp4_;
		gint _tmp4__length1;
		gint res = 0;
		gint _tmp15_;
		struct timeval _tmp16_ = {0};
		gint _tmp17_;
		gint _tmp21_;
		gint _tmp22_;
		fd_set _tmp23_;
		GSocket** _tmp25_;
		gint _tmp25__length1;
		_tmp0_ = self->priv->running;
		if (!_tmp0_) {
			break;
		}
		FD_ZERO (&_tmp1_);
		fds = _tmp1_;
		_tmp2_ = self->priv->ctrl_r;
		FD_SET (_tmp2_, &fds);
		_tmp3_ = self->priv->ctrl_r;
		max = _tmp3_;
		_tmp4_ = self->priv->listen_sockets;
		_tmp4__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp4_;
			s_collection_length1 = _tmp4__length1;
			for (s_it = 0; s_it < _tmp4__length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					GSocket* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					_tmp5_ = s;
					_tmp6_ = g_socket_get_fd (_tmp5_);
					_tmp7_ = _tmp6_;
					FD_SET (_tmp7_, &fds);
					_tmp8_ = s;
					_tmp9_ = g_socket_get_fd (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = max;
					if (_tmp10_ > _tmp11_) {
						GSocket* _tmp12_;
						gint _tmp13_;
						gint _tmp14_;
						_tmp12_ = s;
						_tmp13_ = g_socket_get_fd (_tmp12_);
						_tmp14_ = _tmp13_;
						max = _tmp14_;
					}
				}
			}
		}
		_tmp15_ = max;
		_tmp16_.tv_sec = (time_t) 0;
		_tmp16_.tv_usec = (glong) 500000;
		res = select (_tmp15_ + 1, &fds, NULL, NULL, &_tmp16_);
		_tmp17_ = res;
		if (_tmp17_ < 0) {
			gint _tmp18_;
			gint _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = errno;
			if (_tmp18_ == EINTR) {
				continue;
			}
			_tmp19_ = errno;
			_tmp20_ = g_strerror (_tmp19_);
			g_error ("umockdev.vala:1660: socket server thread: select() failed: %s", _tmp20_);
		}
		_tmp21_ = res;
		if (_tmp21_ == 0) {
			continue;
		}
		_tmp22_ = self->priv->ctrl_r;
		_tmp23_ = fds;
		if (FD_ISSET (_tmp22_, &_tmp23_) > 0) {
			gchar buf = '\0';
			gint _tmp24_;
			g_debug ("umockdev.vala:1667: socket server thread: woken up by control fd");
			_tmp24_ = self->priv->ctrl_r;
			_vala_assert (read (_tmp24_, &buf, (gsize) 1) == ((gssize) 1), "Posix.read (this.ctrl_r, &buf, 1) == 1");
			continue;
		}
		g_debug ("umockdev.vala:1673: socket server thread: select() got requests");
		_tmp25_ = self->priv->listen_sockets;
		_tmp25__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp25_;
			s_collection_length1 = _tmp25__length1;
			for (s_it = 0; s_it < _tmp25__length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					fd_set _tmp29_;
					_tmp26_ = s;
					_tmp27_ = g_socket_get_fd (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = fds;
					if (FD_ISSET (_tmp28_, &_tmp29_) > 0) {
						gint fd = 0;
						GSocket* _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						gchar* sock_path = NULL;
						_tmp30_ = s;
						_tmp31_ = g_socket_get_fd (_tmp30_);
						_tmp32_ = _tmp31_;
						fd = accept (_tmp32_, NULL, NULL);
						_tmp33_ = fd;
						if (_tmp33_ < 0) {
							gint _tmp34_;
							const gchar* _tmp35_;
							_tmp34_ = errno;
							_tmp35_ = g_strerror (_tmp34_);
							g_error ("umockdev.vala:1680: socket server thread: accept() failed: %s", _tmp35_);
						}
						sock_path = NULL;
						{
							GSocketAddress* _tmp36_ = NULL;
							GSocket* _tmp37_;
							GSocketAddress* _tmp38_;
							const gchar* _tmp39_;
							const gchar* _tmp40_;
							gchar* _tmp41_;
							gchar* script = NULL;
							GHashTable* _tmp42_;
							const gchar* _tmp43_;
							gconstpointer _tmp44_;
							gchar* _tmp45_;
							GSocket* _tmp46_;
							gint _tmp47_;
							gint _tmp48_;
							const gchar* _tmp49_;
							const gchar* _tmp50_;
							gchar* key = NULL;
							const gchar* _tmp51_;
							gint _tmp52_;
							gchar* _tmp53_;
							UMockdevScriptRunner* _tmp54_ = NULL;
							const gchar* _tmp55_;
							const gchar* _tmp56_;
							gint _tmp57_;
							UMockdevScriptRunner* _tmp58_;
							GHashTable* _tmp59_;
							const gchar* _tmp60_;
							gchar* _tmp61_;
							UMockdevScriptRunner* _tmp62_;
							_tmp37_ = s;
							_tmp38_ = g_socket_get_local_address (_tmp37_, &_inner_error_);
							_tmp36_ = _tmp38_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								goto __catch13_g_error;
							}
							_tmp39_ = g_unix_socket_address_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, G_TYPE_UNIX_SOCKET_ADDRESS, GUnixSocketAddress));
							_tmp40_ = _tmp39_;
							_tmp41_ = g_strdup (_tmp40_);
							_g_free0 (sock_path);
							sock_path = _tmp41_;
							_tmp42_ = self->priv->socket_scriptfile;
							_tmp43_ = sock_path;
							_tmp44_ = g_hash_table_lookup (_tmp42_, _tmp43_);
							_tmp45_ = g_strdup ((const gchar*) _tmp44_);
							script = _tmp45_;
							_tmp46_ = s;
							_tmp47_ = g_socket_get_fd (_tmp46_);
							_tmp48_ = _tmp47_;
							_tmp49_ = sock_path;
							_tmp50_ = script;
							g_debug ("umockdev.vala:1685: socket server thread: accepted request on server s" \
"ocket fd %i, path %s, script %s", _tmp48_, _tmp49_, _tmp50_);
							_tmp51_ = sock_path;
							_tmp52_ = fd;
							_tmp53_ = g_strdup_printf ("%s%i", _tmp51_, _tmp52_);
							key = _tmp53_;
							_tmp55_ = key;
							_tmp56_ = script;
							_tmp57_ = fd;
							_tmp58_ = umockdev_script_runner_new (_tmp55_, _tmp56_, _tmp57_, &_inner_error_);
							_tmp54_ = _tmp58_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								_g_free0 (key);
								_g_free0 (script);
								_g_object_unref0 (_tmp36_);
								goto __catch13_g_error;
							}
							_tmp59_ = self->priv->script_runners;
							_tmp60_ = key;
							_tmp61_ = g_strdup (_tmp60_);
							_tmp62_ = _tmp54_;
							_tmp54_ = NULL;
							g_hash_table_insert (_tmp59_, _tmp61_, _tmp62_);
							_umockdev_script_runner_unref0 (_tmp54_);
							_g_free0 (key);
							_g_free0 (script);
							_g_object_unref0 (_tmp36_);
						}
						goto __finally13;
						__catch13_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp63_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp63_ = e->message;
							g_error ("umockdev.vala:1690: socket server thread: cannot launch ScriptRunner: " \
"%s", _tmp63_);
							_g_error_free0 (e);
						}
						__finally13:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (sock_path);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_free0 (sock_path);
					}
				}
			}
		}
	}
	g_debug ("umockdev.vala:1696: socket server thread: end");
	result = NULL;
	return result;
}


static void
umockdev_value_socket_server_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
umockdev_value_socket_server_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		umockdev_socket_server_unref (value->data[0].v_pointer);
	}
}


static void
umockdev_value_socket_server_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_socket_server_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
umockdev_value_socket_server_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
umockdev_value_socket_server_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UMockdevSocketServer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_socket_server_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
umockdev_value_socket_server_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	UMockdevSocketServer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_socket_server_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
umockdev_param_spec_socket_server (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	UMockdevParamSpecSocketServer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
umockdev_value_get_socket_server (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	return value->data[0].v_pointer;
}


void
umockdev_value_set_socket_server (GValue* value,
                                  gpointer v_object)
{
	UMockdevSocketServer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_socket_server_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}


void
umockdev_value_take_socket_server (GValue* value,
                                   gpointer v_object)
{
	UMockdevSocketServer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}


static void
umockdev_socket_server_class_init (UMockdevSocketServerClass * klass)
{
	umockdev_socket_server_parent_class = g_type_class_peek_parent (klass);
	((UMockdevSocketServerClass *) klass)->finalize = umockdev_socket_server_finalize;
	g_type_class_adjust_private_offset (klass, &UMockdevSocketServer_private_offset);
}


static void
umockdev_socket_server_instance_init (UMockdevSocketServer * self)
{
	GSocket** _tmp0_;
	self->priv = umockdev_socket_server_get_instance_private (self);
	_tmp0_ = g_new0 (GSocket*, 0 + 1);
	self->priv->listen_sockets = _tmp0_;
	self->priv->listen_sockets_length1 = 0;
	self->priv->_listen_sockets_size_ = self->priv->listen_sockets_length1;
	self->ref_count = 1;
}


static void
umockdev_socket_server_finalize (UMockdevSocketServer * obj)
{
	UMockdevSocketServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer);
	g_signal_handlers_destroy (self);
	umockdev_socket_server_stop (self);
	self->priv->listen_sockets = (_vala_array_free (self->priv->listen_sockets, self->priv->listen_sockets_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	_g_hash_table_unref0 (self->priv->script_runners);
	_g_thread_unref0 (self->priv->thread);
}


GType
umockdev_socket_server_get_type (void)
{
	static volatile gsize umockdev_socket_server_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_socket_server_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { umockdev_value_socket_server_init, umockdev_value_socket_server_free_value, umockdev_value_socket_server_copy_value, umockdev_value_socket_server_peek_pointer, "p", umockdev_value_socket_server_collect_value, "p", umockdev_value_socket_server_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevSocketServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_socket_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevSocketServer), 0, (GInstanceInitFunc) umockdev_socket_server_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType umockdev_socket_server_type_id;
		umockdev_socket_server_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevSocketServer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		UMockdevSocketServer_private_offset = g_type_add_instance_private (umockdev_socket_server_type_id, sizeof (UMockdevSocketServerPrivate));
		g_once_init_leave (&umockdev_socket_server_type_id__volatile, umockdev_socket_server_type_id);
	}
	return umockdev_socket_server_type_id__volatile;
}


gpointer
umockdev_socket_server_ref (gpointer instance)
{
	UMockdevSocketServer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
umockdev_socket_server_unref (gpointer instance)
{
	UMockdevSocketServer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SOCKET_SERVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


/**
 * umockdev_in_mock_environment:
 *
 * Check whether the current process is running under umockdev-wrapper, i. e.
 * the umockdev preload library.
 *
 * Returns: %TRUE if running under preload with mocked devices, %FALSE if
 *          running against the real system.
 */
gboolean
umockdev_in_mock_environment (void)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp8_;
	_tmp0_ = umockdev___in_mock_env_initialized;
	if (!_tmp0_) {
		struct stat st = {0};
		struct stat _tmp1_ = {0};
		gint _tmp2_;
		_tmp2_ = stat ("/sys", &_tmp1_);
		st = _tmp1_;
		if (_tmp2_ >= 0) {
			gboolean _tmp3_ = FALSE;
			struct stat _tmp4_;
			ino_t _tmp5_;
			_tmp4_ = st;
			_tmp5_ = _tmp4_.st_ino;
			if (_tmp5_ > ((ino_t) 1)) {
				struct stat _tmp6_;
				gsize _tmp7_;
				_tmp6_ = st;
				_tmp7_ = _tmp6_.st_size;
				_tmp3_ = _tmp7_ > ((gsize) 0);
			} else {
				_tmp3_ = FALSE;
			}
			umockdev___in_mock_env_result = _tmp3_;
		}
		umockdev___in_mock_env_initialized = TRUE;
	}
	_tmp8_ = umockdev___in_mock_env_result;
	result = _tmp8_;
	return result;
}


GQuark
umockdev_error_quark (void)
{
	return g_quark_from_static_string ("umockdev_error-quark");
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



