# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServerUpdate(Model):
    """An update request for an Azure SQL Database server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param administrator_login: Administrator username for the server. Once
     created it cannot be changed.
    :type administrator_login: str
    :param administrator_login_password: The administrator login password
     (required for server creation).
    :type administrator_login_password: str
    :param version: The version of the server.
    :type version: str
    :ivar state: The state of the server.
    :vartype state: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the
     server.
    :vartype fully_qualified_domain_name: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
    }

    _attribute_map = {
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ServerUpdate, self).__init__(**kwargs)
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.version = kwargs.get('version', None)
        self.state = None
        self.fully_qualified_domain_name = None
        self.tags = kwargs.get('tags', None)
