# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource_py3 import ProxyResource


class InstanceFailoverGroup(ProxyResource):
    """An instance failover group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param read_write_endpoint: Required. Read-write endpoint of the failover
     group instance.
    :type read_write_endpoint:
     ~azure.mgmt.sql.models.InstanceFailoverGroupReadWriteEndpoint
    :param read_only_endpoint: Read-only endpoint of the failover group
     instance.
    :type read_only_endpoint:
     ~azure.mgmt.sql.models.InstanceFailoverGroupReadOnlyEndpoint
    :ivar replication_role: Local replication role of the failover group
     instance. Possible values include: 'Primary', 'Secondary'
    :vartype replication_role: str or
     ~azure.mgmt.sql.models.InstanceFailoverGroupReplicationRole
    :ivar replication_state: Replication state of the failover group instance.
    :vartype replication_state: str
    :param partner_regions: Required. Partner region information for the
     failover group.
    :type partner_regions: list[~azure.mgmt.sql.models.PartnerRegionInfo]
    :param managed_instance_pairs: Required. List of managed instance pairs in
     the failover group.
    :type managed_instance_pairs:
     list[~azure.mgmt.sql.models.ManagedInstancePairInfo]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'read_write_endpoint': {'required': True},
        'replication_role': {'readonly': True},
        'replication_state': {'readonly': True},
        'partner_regions': {'required': True},
        'managed_instance_pairs': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'read_write_endpoint': {'key': 'properties.readWriteEndpoint', 'type': 'InstanceFailoverGroupReadWriteEndpoint'},
        'read_only_endpoint': {'key': 'properties.readOnlyEndpoint', 'type': 'InstanceFailoverGroupReadOnlyEndpoint'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
        'partner_regions': {'key': 'properties.partnerRegions', 'type': '[PartnerRegionInfo]'},
        'managed_instance_pairs': {'key': 'properties.managedInstancePairs', 'type': '[ManagedInstancePairInfo]'},
    }

    def __init__(self, *, read_write_endpoint, partner_regions, managed_instance_pairs, read_only_endpoint=None, **kwargs) -> None:
        super(InstanceFailoverGroup, self).__init__(**kwargs)
        self.read_write_endpoint = read_write_endpoint
        self.read_only_endpoint = read_only_endpoint
        self.replication_role = None
        self.replication_state = None
        self.partner_regions = partner_regions
        self.managed_instance_pairs = managed_instance_pairs
