# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StorageProfile(Model):
    """Specifies the storage settings for the HANA instance disks.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar nfs_ip_address: IP Address to connect to storage.
    :vartype nfs_ip_address: str
    :param os_disks: Specifies information about the operating system disk
     used by the hana instance.
    :type os_disks: list[~azure.mgmt.hanaonazure.models.Disk]
    """

    _validation = {
        'nfs_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'nfs_ip_address': {'key': 'nfsIpAddress', 'type': 'str'},
        'os_disks': {'key': 'osDisks', 'type': '[Disk]'},
    }

    def __init__(self, *, os_disks=None, **kwargs) -> None:
        super(StorageProfile, self).__init__(**kwargs)
        self.nfs_ip_address = None
        self.os_disks = os_disks
