# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContainerState(Model):
    """The container instance state.

    :param state: The state of the container instance.
    :type state: str
    :param start_time: The date-time when the container instance state
     started.
    :type start_time: datetime
    :param exit_code: The container instance exit codes correspond to those
     from the `docker run` command.
    :type exit_code: int
    :param finish_time: The date-time when the container instance state
     finished.
    :type finish_time: datetime
    :param detail_status: The human-readable status of the container instance
     state.
    :type detail_status: str
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'detail_status': {'key': 'detailStatus', 'type': 'str'},
    }

    def __init__(self, *, state: str=None, start_time=None, exit_code: int=None, finish_time=None, detail_status: str=None, **kwargs) -> None:
        super(ContainerState, self).__init__(**kwargs)
        self.state = state
        self.start_time = start_time
        self.exit_code = exit_code
        self.finish_time = finish_time
        self.detail_status = detail_status
