# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AutoScaleSettings(Model):
    """AutoScale settings for the pool.

    :param formula: A formula for the desired number of compute nodes in the
     pool.
    :type formula: str
    :param evaluation_interval: The time interval at which to automatically
     adjust the pool size according to the autoscale formula. If omitted, the
     default value is 15 minutes (PT15M).
    :type evaluation_interval: timedelta
    """

    _validation = {
        'formula': {'required': True},
    }

    _attribute_map = {
        'formula': {'key': 'formula', 'type': 'str'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'duration'},
    }

    def __init__(self, formula, evaluation_interval=None):
        super(AutoScaleSettings, self).__init__()
        self.formula = formula
        self.evaluation_interval = evaluation_interval
