# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ComponentsResource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicationInsightsComponent(ComponentsResource):
    """An Application Insights component definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: The kind of application that this component refers to, used to customize UI. This
     value is a freeform string, values should typically be one of the following: web, ios, other,
     store, java, phone. Required.
    :vartype kind: str
    :ivar application_id: The unique ID of your application. This field mirrors the 'Name' field
     and cannot be changed.
    :vartype application_id: str
    :ivar app_id: Application Insights Unique ID for your Application.
    :vartype app_id: str
    :ivar application_type: Type of application being monitored. Known values are: "web" and
     "other".
    :vartype application_type: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ApplicationType
    :ivar flow_type: Used by the Application Insights system to determine what kind of flow this
     component was created by. This is to be set to 'Bluefield' when creating/updating a component
     via the REST API. "Bluefield"
    :vartype flow_type: str or ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.FlowType
    :ivar request_source: Describes what tool created this Application Insights component.
     Customers using this API should set this to the default 'rest'. "rest"
    :vartype request_source: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.RequestSource
    :ivar instrumentation_key: Application Insights Instrumentation key. A read-only value that
     applications can use to identify the destination for all telemetry sent to Azure Application
     Insights. This value will be supplied upon construction of each new Application Insights
     component.
    :vartype instrumentation_key: str
    :ivar creation_date: Creation Date for the Application Insights component, in ISO 8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar tenant_id: Azure Tenant Id.
    :vartype tenant_id: str
    :ivar hockey_app_id: The unique application ID created when a new application is added to
     HockeyApp, used for communications with HockeyApp.
    :vartype hockey_app_id: str
    :ivar hockey_app_token: Token used to authenticate communications with between Application
     Insights and HockeyApp.
    :vartype hockey_app_token: str
    :ivar provisioning_state: Current state of this component: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    :ivar sampling_percentage: Percentage of the data produced by the application being monitored
     that is being sampled for Application Insights telemetry.
    :vartype sampling_percentage: float
    :ivar connection_string: Application Insights component connection string.
    :vartype connection_string: str
    :ivar retention_in_days: Retention period in days.
    :vartype retention_in_days: int
    :ivar disable_ip_masking: Disable IP masking.
    :vartype disable_ip_masking: bool
    :ivar immediate_purge_data_on30_days: Purge data immediately after 30 days.
    :vartype immediate_purge_data_on30_days: bool
    :ivar private_link_scoped_resources: List of linked private link scope resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PrivateLinkScopedResource]
    :ivar public_network_access_for_ingestion: The network access type for accessing Application
     Insights ingestion. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access_for_ingestion: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PublicNetworkAccessType
    :ivar public_network_access_for_query: The network access type for accessing Application
     Insights query. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access_for_query: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PublicNetworkAccessType
    :ivar ingestion_mode: Indicates the flow of the ingestion. Known values are:
     "ApplicationInsights", "ApplicationInsightsWithDiagnosticSettings", and "LogAnalytics".
    :vartype ingestion_mode: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.IngestionMode
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "kind": {"required": True},
        "application_id": {"readonly": True},
        "app_id": {"readonly": True},
        "instrumentation_key": {"readonly": True},
        "creation_date": {"readonly": True},
        "tenant_id": {"readonly": True},
        "hockey_app_token": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "connection_string": {"readonly": True},
        "private_link_scoped_resources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "kind": {"key": "kind", "type": "str"},
        "application_id": {"key": "properties.ApplicationId", "type": "str"},
        "app_id": {"key": "properties.AppId", "type": "str"},
        "application_type": {"key": "properties.Application_Type", "type": "str"},
        "flow_type": {"key": "properties.Flow_Type", "type": "str"},
        "request_source": {"key": "properties.Request_Source", "type": "str"},
        "instrumentation_key": {"key": "properties.InstrumentationKey", "type": "str"},
        "creation_date": {"key": "properties.CreationDate", "type": "iso-8601"},
        "tenant_id": {"key": "properties.TenantId", "type": "str"},
        "hockey_app_id": {"key": "properties.HockeyAppId", "type": "str"},
        "hockey_app_token": {"key": "properties.HockeyAppToken", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sampling_percentage": {"key": "properties.SamplingPercentage", "type": "float"},
        "connection_string": {"key": "properties.ConnectionString", "type": "str"},
        "retention_in_days": {"key": "properties.RetentionInDays", "type": "int"},
        "disable_ip_masking": {"key": "properties.DisableIpMasking", "type": "bool"},
        "immediate_purge_data_on30_days": {"key": "properties.ImmediatePurgeDataOn30Days", "type": "bool"},
        "private_link_scoped_resources": {
            "key": "properties.PrivateLinkScopedResources",
            "type": "[PrivateLinkScopedResource]",
        },
        "public_network_access_for_ingestion": {"key": "properties.publicNetworkAccessForIngestion", "type": "str"},
        "public_network_access_for_query": {"key": "properties.publicNetworkAccessForQuery", "type": "str"},
        "ingestion_mode": {"key": "properties.IngestionMode", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: str,
        tags: Optional[Dict[str, str]] = None,
        application_type: Union[str, "_models.ApplicationType"] = "web",
        flow_type: Union[str, "_models.FlowType"] = "Bluefield",
        request_source: Union[str, "_models.RequestSource"] = "rest",
        hockey_app_id: Optional[str] = None,
        sampling_percentage: Optional[float] = None,
        retention_in_days: int = 90,
        disable_ip_masking: Optional[bool] = None,
        immediate_purge_data_on30_days: Optional[bool] = None,
        public_network_access_for_ingestion: Union[str, "_models.PublicNetworkAccessType"] = "Enabled",
        public_network_access_for_query: Union[str, "_models.PublicNetworkAccessType"] = "Enabled",
        ingestion_mode: Union[str, "_models.IngestionMode"] = "ApplicationInsights",
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: The kind of application that this component refers to, used to customize UI.
         This value is a freeform string, values should typically be one of the following: web, ios,
         other, store, java, phone. Required.
        :paramtype kind: str
        :keyword application_type: Type of application being monitored. Known values are: "web" and
         "other".
        :paramtype application_type: str or
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ApplicationType
        :keyword flow_type: Used by the Application Insights system to determine what kind of flow this
         component was created by. This is to be set to 'Bluefield' when creating/updating a component
         via the REST API. "Bluefield"
        :paramtype flow_type: str or
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.FlowType
        :keyword request_source: Describes what tool created this Application Insights component.
         Customers using this API should set this to the default 'rest'. "rest"
        :paramtype request_source: str or
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.RequestSource
        :keyword hockey_app_id: The unique application ID created when a new application is added to
         HockeyApp, used for communications with HockeyApp.
        :paramtype hockey_app_id: str
        :keyword sampling_percentage: Percentage of the data produced by the application being
         monitored that is being sampled for Application Insights telemetry.
        :paramtype sampling_percentage: float
        :keyword retention_in_days: Retention period in days.
        :paramtype retention_in_days: int
        :keyword disable_ip_masking: Disable IP masking.
        :paramtype disable_ip_masking: bool
        :keyword immediate_purge_data_on30_days: Purge data immediately after 30 days.
        :paramtype immediate_purge_data_on30_days: bool
        :keyword public_network_access_for_ingestion: The network access type for accessing Application
         Insights ingestion. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access_for_ingestion: str or
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PublicNetworkAccessType
        :keyword public_network_access_for_query: The network access type for accessing Application
         Insights query. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access_for_query: str or
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PublicNetworkAccessType
        :keyword ingestion_mode: Indicates the flow of the ingestion. Known values are:
         "ApplicationInsights", "ApplicationInsightsWithDiagnosticSettings", and "LogAnalytics".
        :paramtype ingestion_mode: str or
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.IngestionMode
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.kind = kind
        self.application_id = None
        self.app_id = None
        self.application_type = application_type
        self.flow_type = flow_type
        self.request_source = request_source
        self.instrumentation_key = None
        self.creation_date = None
        self.tenant_id = None
        self.hockey_app_id = hockey_app_id
        self.hockey_app_token = None
        self.provisioning_state = None
        self.sampling_percentage = sampling_percentage
        self.connection_string = None
        self.retention_in_days = retention_in_days
        self.disable_ip_masking = disable_ip_masking
        self.immediate_purge_data_on30_days = immediate_purge_data_on30_days
        self.private_link_scoped_resources = None
        self.public_network_access_for_ingestion = public_network_access_for_ingestion
        self.public_network_access_for_query = public_network_access_for_query
        self.ingestion_mode = ingestion_mode


class ApplicationInsightsComponentListResult(_serialization.Model):
    """Describes the list of Application Insights Resources.

    All required parameters must be populated in order to send to server.

    :ivar value: List of Application Insights component definitions. Required.
    :vartype value:
     list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ApplicationInsightsComponent]
    :ivar next_link: The URI to get the next set of Application Insights component definitions if
     too many components where returned in the result set.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationInsightsComponent]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ApplicationInsightsComponent"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Application Insights component definitions. Required.
        :paramtype value:
         list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ApplicationInsightsComponent]
        :keyword next_link: The URI to get the next set of Application Insights component definitions
         if too many components where returned in the result set.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationInsightsComponentProactiveDetectionConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """A ProactiveDetection configuration definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar name_properties_name: The rule name.
    :vartype name_properties_name: str
    :ivar enabled: A flag that indicates whether this rule is enabled by the user.
    :vartype enabled: bool
    :ivar send_emails_to_subscription_owners: A flag that indicated whether notifications on this
     rule should be sent to subscription owners.
    :vartype send_emails_to_subscription_owners: bool
    :ivar custom_emails: Custom email addresses for this rule notifications.
    :vartype custom_emails: list[str]
    :ivar last_updated_time: The last time this rule was updated.
    :vartype last_updated_time: str
    :ivar rule_definitions: Static definitions of the ProactiveDetection configuration rule (same
     values for all components).
    :vartype rule_definitions:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions  # pylint: disable=line-too-long
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "last_updated_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "send_emails_to_subscription_owners": {"key": "properties.sendEmailsToSubscriptionOwners", "type": "bool"},
        "custom_emails": {"key": "properties.customEmails", "type": "[str]"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "str"},
        "rule_definitions": {
            "key": "properties.ruleDefinitions",
            "type": "ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions",
        },
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        enabled: Optional[bool] = None,
        send_emails_to_subscription_owners: Optional[bool] = None,
        custom_emails: Optional[List[str]] = None,
        rule_definitions: Optional[
            "_models.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Azure resource name.
        :paramtype name: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword enabled: A flag that indicates whether this rule is enabled by the user.
        :paramtype enabled: bool
        :keyword send_emails_to_subscription_owners: A flag that indicated whether notifications on
         this rule should be sent to subscription owners.
        :paramtype send_emails_to_subscription_owners: bool
        :keyword custom_emails: Custom email addresses for this rule notifications.
        :paramtype custom_emails: list[str]
        :keyword rule_definitions: Static definitions of the ProactiveDetection configuration rule
         (same values for all components).
        :paramtype rule_definitions:
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions  # pylint: disable=line-too-long
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = None
        self.location = location
        self.name_properties_name = None
        self.enabled = enabled
        self.send_emails_to_subscription_owners = send_emails_to_subscription_owners
        self.custom_emails = custom_emails
        self.last_updated_time = None
        self.rule_definitions = rule_definitions


class ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Static definitions of the ProactiveDetection configuration rule (same values for all
    components).

    :ivar name: The rule name.
    :vartype name: str
    :ivar display_name: The rule name as it is displayed in UI.
    :vartype display_name: str
    :ivar description: The rule description.
    :vartype description: str
    :ivar help_url: URL which displays additional info about the proactive detection rule.
    :vartype help_url: str
    :ivar is_hidden: A flag indicating whether the rule is hidden (from the UI).
    :vartype is_hidden: bool
    :ivar is_enabled_by_default: A flag indicating whether the rule is enabled by default.
    :vartype is_enabled_by_default: bool
    :ivar is_in_preview: A flag indicating whether the rule is in preview.
    :vartype is_in_preview: bool
    :ivar supports_email_notifications: A flag indicating whether email notifications are supported
     for detections for this rule.
    :vartype supports_email_notifications: bool
    """

    _attribute_map = {
        "name": {"key": "Name", "type": "str"},
        "display_name": {"key": "DisplayName", "type": "str"},
        "description": {"key": "Description", "type": "str"},
        "help_url": {"key": "HelpUrl", "type": "str"},
        "is_hidden": {"key": "IsHidden", "type": "bool"},
        "is_enabled_by_default": {"key": "IsEnabledByDefault", "type": "bool"},
        "is_in_preview": {"key": "IsInPreview", "type": "bool"},
        "supports_email_notifications": {"key": "SupportsEmailNotifications", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        help_url: Optional[str] = None,
        is_hidden: Optional[bool] = None,
        is_enabled_by_default: Optional[bool] = None,
        is_in_preview: Optional[bool] = None,
        supports_email_notifications: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The rule name.
        :paramtype name: str
        :keyword display_name: The rule name as it is displayed in UI.
        :paramtype display_name: str
        :keyword description: The rule description.
        :paramtype description: str
        :keyword help_url: URL which displays additional info about the proactive detection rule.
        :paramtype help_url: str
        :keyword is_hidden: A flag indicating whether the rule is hidden (from the UI).
        :paramtype is_hidden: bool
        :keyword is_enabled_by_default: A flag indicating whether the rule is enabled by default.
        :paramtype is_enabled_by_default: bool
        :keyword is_in_preview: A flag indicating whether the rule is in preview.
        :paramtype is_in_preview: bool
        :keyword supports_email_notifications: A flag indicating whether email notifications are
         supported for detections for this rule.
        :paramtype supports_email_notifications: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.description = description
        self.help_url = help_url
        self.is_hidden = is_hidden
        self.is_enabled_by_default = is_enabled_by_default
        self.is_in_preview = is_in_preview
        self.supports_email_notifications = supports_email_notifications


class ComponentPurgeBody(_serialization.Model):
    """Describes the body of a purge request for an App Insights component.

    All required parameters must be populated in order to send to server.

    :ivar table: Table from which to purge data. Required.
    :vartype table: str
    :ivar filters: The set of columns and filters (queries) to run over them to purge the resulting
     data. Required.
    :vartype filters:
     list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ComponentPurgeBodyFilters]
    """

    _validation = {
        "table": {"required": True},
        "filters": {"required": True},
    }

    _attribute_map = {
        "table": {"key": "table", "type": "str"},
        "filters": {"key": "filters", "type": "[ComponentPurgeBodyFilters]"},
    }

    def __init__(self, *, table: str, filters: List["_models.ComponentPurgeBodyFilters"], **kwargs: Any) -> None:
        """
        :keyword table: Table from which to purge data. Required.
        :paramtype table: str
        :keyword filters: The set of columns and filters (queries) to run over them to purge the
         resulting data. Required.
        :paramtype filters:
         list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ComponentPurgeBodyFilters]
        """
        super().__init__(**kwargs)
        self.table = table
        self.filters = filters


class ComponentPurgeBodyFilters(_serialization.Model):
    """User-defined filters to return data which will be purged from the table.

    :ivar column: The column of the table over which the given query should run.
    :vartype column: str
    :ivar operator: A query operator to evaluate over the provided column and value(s). Supported
     operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as they would
     in a KQL query.
    :vartype operator: str
    :ivar value: the value for the operator to function over. This can be a number (e.g., > 100), a
     string (timestamp >= '2017-09-01') or array of values.
    :vartype value: any
    :ivar key: When filtering over custom dimensions, this key will be used as the name of the
     custom dimension.
    :vartype key: str
    """

    _attribute_map = {
        "column": {"key": "column", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "value": {"key": "value", "type": "object"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(
        self,
        *,
        column: Optional[str] = None,
        operator: Optional[str] = None,
        value: Optional[Any] = None,
        key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword column: The column of the table over which the given query should run.
        :paramtype column: str
        :keyword operator: A query operator to evaluate over the provided column and value(s).
         Supported operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as
         they would in a KQL query.
        :paramtype operator: str
        :keyword value: the value for the operator to function over. This can be a number (e.g., >
         100), a string (timestamp >= '2017-09-01') or array of values.
        :paramtype value: any
        :keyword key: When filtering over custom dimensions, this key will be used as the name of the
         custom dimension.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.column = column
        self.operator = operator
        self.value = value
        self.key = key


class ComponentPurgeResponse(_serialization.Model):
    """Response containing operationId for a specific purge action.

    All required parameters must be populated in order to send to server.

    :ivar operation_id: Id to use when querying for status for a particular purge operation.
     Required.
    :vartype operation_id: str
    """

    _validation = {
        "operation_id": {"required": True},
    }

    _attribute_map = {
        "operation_id": {"key": "operationId", "type": "str"},
    }

    def __init__(self, *, operation_id: str, **kwargs: Any) -> None:
        """
        :keyword operation_id: Id to use when querying for status for a particular purge operation.
         Required.
        :paramtype operation_id: str
        """
        super().__init__(**kwargs)
        self.operation_id = operation_id


class ComponentPurgeStatusResponse(_serialization.Model):
    """Response containing status for a specific purge operation.

    All required parameters must be populated in order to send to server.

    :ivar status: Status of the operation represented by the requested Id. Required. Known values
     are: "pending" and "completed".
    :vartype status: str or ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PurgeState
    """

    _validation = {
        "status": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Union[str, "_models.PurgeState"], **kwargs: Any) -> None:
        """
        :keyword status: Status of the operation represented by the requested Id. Required. Known
         values are: "pending" and "completed".
        :paramtype status: str or ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PurgeState
        """
        super().__init__(**kwargs)
        self.status = status


class HeaderField(_serialization.Model):
    """A header to add to the WebTest.

    :ivar header_field_name: The name of the header.
    :vartype header_field_name: str
    :ivar header_field_value: The value of the header.
    :vartype header_field_value: str
    """

    _attribute_map = {
        "header_field_name": {"key": "key", "type": "str"},
        "header_field_value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, header_field_name: Optional[str] = None, header_field_value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword header_field_name: The name of the header.
        :paramtype header_field_name: str
        :keyword header_field_value: The value of the header.
        :paramtype header_field_value: str
        """
        super().__init__(**kwargs)
        self.header_field_name = header_field_name
        self.header_field_value = header_field_value


class Operation(_serialization.Model):
    """Represents an operation returned by the GetOperations request.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar display: Display name of the operation.
    :vartype display: ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.OperationInfo
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Properties of the operation.
    :vartype properties: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationInfo"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationInfo"] = None,
        origin: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword display: Display name of the operation.
        :paramtype display: ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.OperationInfo
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword properties: Properties of the operation.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationInfo(_serialization.Model):
    """Information about an operation.

    :ivar provider: Name of the provider.
    :vartype provider: str
    :ivar resource: Name of the resource type.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Name of the provider.
        :paramtype provider: str
        :keyword resource: Name of the resource type.
        :paramtype resource: str
        :keyword operation: Name of the operation.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsListResult(_serialization.Model):
    """Result of the List Operations operation.

    :ivar value: A collection of operations.
    :vartype value: list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of operations.
        :paramtype value: list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkScopedResource(_serialization.Model):
    """The private link scope resource reference.

    :ivar resource_id: The full resource Id of the private link scope resource.
    :vartype resource_id: str
    :ivar scope_id: The private link scope unique Identifier.
    :vartype scope_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "ResourceId", "type": "str"},
        "scope_id": {"key": "ScopeId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, scope_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: The full resource Id of the private link scope resource.
        :paramtype resource_id: str
        :keyword scope_id: The private link scope unique Identifier.
        :paramtype scope_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.scope_id = scope_id


class TagsResource(_serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a
    WebTest instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class WebtestsResource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class WebTest(WebtestsResource):
    """An Application Insights WebTest definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: The kind of WebTest that this web test watches. Choices are ping and multistep.
     Known values are: "ping" and "multistep".
    :vartype kind: str or ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestKind
    :ivar synthetic_monitor_id: Unique ID of this WebTest. This is typically the same value as the
     Name field.
    :vartype synthetic_monitor_id: str
    :ivar web_test_name: User defined name if this WebTest.
    :vartype web_test_name: str
    :ivar description: User defined description for this WebTest.
    :vartype description: str
    :ivar enabled: Is the test actively being monitored.
    :vartype enabled: bool
    :ivar frequency: Interval in seconds between test runs for this WebTest. Default value is 300.
    :vartype frequency: int
    :ivar timeout: Seconds until this WebTest will timeout and fail. Default value is 30.
    :vartype timeout: int
    :ivar web_test_kind: The kind of web test this is, valid choices are ping, multistep, basic,
     and standard. Known values are: "ping", "multistep", "basic", and "standard".
    :vartype web_test_kind: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestKindEnum
    :ivar retry_enabled: Allow for retries should this WebTest fail.
    :vartype retry_enabled: bool
    :ivar locations: A list of where to physically run the tests from to give global coverage for
     accessibility of your application.
    :vartype locations:
     list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestGeolocation]
    :ivar configuration: An XML configuration specification for a WebTest.
    :vartype configuration:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesConfiguration
    :ivar provisioning_state: Current state of this component, whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    :ivar request: The collection of request properties.
    :vartype request:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesRequest
    :ivar validation_rules: The collection of validation rule properties.
    :vartype validation_rules:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesValidationRules
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "kind": {"key": "kind", "type": "str"},
        "synthetic_monitor_id": {"key": "properties.SyntheticMonitorId", "type": "str"},
        "web_test_name": {"key": "properties.Name", "type": "str"},
        "description": {"key": "properties.Description", "type": "str"},
        "enabled": {"key": "properties.Enabled", "type": "bool"},
        "frequency": {"key": "properties.Frequency", "type": "int"},
        "timeout": {"key": "properties.Timeout", "type": "int"},
        "web_test_kind": {"key": "properties.Kind", "type": "str"},
        "retry_enabled": {"key": "properties.RetryEnabled", "type": "bool"},
        "locations": {"key": "properties.Locations", "type": "[WebTestGeolocation]"},
        "configuration": {"key": "properties.Configuration", "type": "WebTestPropertiesConfiguration"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "request": {"key": "properties.Request", "type": "WebTestPropertiesRequest"},
        "validation_rules": {"key": "properties.ValidationRules", "type": "WebTestPropertiesValidationRules"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Union[str, "_models.WebTestKind"] = "ping",
        synthetic_monitor_id: Optional[str] = None,
        web_test_name: Optional[str] = None,
        description: Optional[str] = None,
        enabled: Optional[bool] = None,
        frequency: int = 300,
        timeout: int = 30,
        web_test_kind: Union[str, "_models.WebTestKindEnum"] = "ping",
        retry_enabled: Optional[bool] = None,
        locations: Optional[List["_models.WebTestGeolocation"]] = None,
        configuration: Optional["_models.WebTestPropertiesConfiguration"] = None,
        request: Optional["_models.WebTestPropertiesRequest"] = None,
        validation_rules: Optional["_models.WebTestPropertiesValidationRules"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: The kind of WebTest that this web test watches. Choices are ping and multistep.
         Known values are: "ping" and "multistep".
        :paramtype kind: str or ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestKind
        :keyword synthetic_monitor_id: Unique ID of this WebTest. This is typically the same value as
         the Name field.
        :paramtype synthetic_monitor_id: str
        :keyword web_test_name: User defined name if this WebTest.
        :paramtype web_test_name: str
        :keyword description: User defined description for this WebTest.
        :paramtype description: str
        :keyword enabled: Is the test actively being monitored.
        :paramtype enabled: bool
        :keyword frequency: Interval in seconds between test runs for this WebTest. Default value is
         300.
        :paramtype frequency: int
        :keyword timeout: Seconds until this WebTest will timeout and fail. Default value is 30.
        :paramtype timeout: int
        :keyword web_test_kind: The kind of web test this is, valid choices are ping, multistep, basic,
         and standard. Known values are: "ping", "multistep", "basic", and "standard".
        :paramtype web_test_kind: str or
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestKindEnum
        :keyword retry_enabled: Allow for retries should this WebTest fail.
        :paramtype retry_enabled: bool
        :keyword locations: A list of where to physically run the tests from to give global coverage
         for accessibility of your application.
        :paramtype locations:
         list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestGeolocation]
        :keyword configuration: An XML configuration specification for a WebTest.
        :paramtype configuration:
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesConfiguration
        :keyword request: The collection of request properties.
        :paramtype request:
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesRequest
        :keyword validation_rules: The collection of validation rule properties.
        :paramtype validation_rules:
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesValidationRules
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.kind = kind
        self.synthetic_monitor_id = synthetic_monitor_id
        self.web_test_name = web_test_name
        self.description = description
        self.enabled = enabled
        self.frequency = frequency
        self.timeout = timeout
        self.web_test_kind = web_test_kind
        self.retry_enabled = retry_enabled
        self.locations = locations
        self.configuration = configuration
        self.provisioning_state = None
        self.request = request
        self.validation_rules = validation_rules


class WebTestGeolocation(_serialization.Model):
    """Geo-physical location to run a WebTest from. You must specify one or more locations for the
    test to run from.

    :ivar location: Location ID for the WebTest to run from.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "Id", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: Location ID for the WebTest to run from.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location


class WebTestListResult(_serialization.Model):
    """A list of 0 or more Application Insights WebTest definitions.

    All required parameters must be populated in order to send to server.

    :ivar value: Set of Application Insights WebTest definitions. Required.
    :vartype value: list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTest]
    :ivar next_link: The link to get the next part of the returned list of WebTest, should the
     return set be too large for a single request. May be null.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WebTest]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.WebTest"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Set of Application Insights WebTest definitions. Required.
        :paramtype value: list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTest]
        :keyword next_link: The link to get the next part of the returned list of WebTest, should the
         return set be too large for a single request. May be null.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WebTestPropertiesConfiguration(_serialization.Model):
    """An XML configuration specification for a WebTest.

    :ivar web_test: The XML specification of a WebTest to run against an application.
    :vartype web_test: str
    """

    _attribute_map = {
        "web_test": {"key": "WebTest", "type": "str"},
    }

    def __init__(self, *, web_test: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword web_test: The XML specification of a WebTest to run against an application.
        :paramtype web_test: str
        """
        super().__init__(**kwargs)
        self.web_test = web_test


class WebTestPropertiesRequest(_serialization.Model):
    """The collection of request properties.

    :ivar request_url: Url location to test.
    :vartype request_url: str
    :ivar headers: List of headers and their values to add to the WebTest call.
    :vartype headers: list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.HeaderField]
    :ivar http_verb: Http verb to use for this web test.
    :vartype http_verb: str
    :ivar request_body: Base64 encoded string body to send with this web test.
    :vartype request_body: str
    :ivar parse_dependent_requests: Parse Dependent request for this WebTest.
    :vartype parse_dependent_requests: bool
    :ivar follow_redirects: Follow redirects for this web test.
    :vartype follow_redirects: bool
    """

    _attribute_map = {
        "request_url": {"key": "RequestUrl", "type": "str"},
        "headers": {"key": "Headers", "type": "[HeaderField]"},
        "http_verb": {"key": "HttpVerb", "type": "str"},
        "request_body": {"key": "RequestBody", "type": "str"},
        "parse_dependent_requests": {"key": "ParseDependentRequests", "type": "bool"},
        "follow_redirects": {"key": "FollowRedirects", "type": "bool"},
    }

    def __init__(
        self,
        *,
        request_url: Optional[str] = None,
        headers: Optional[List["_models.HeaderField"]] = None,
        http_verb: Optional[str] = None,
        request_body: Optional[str] = None,
        parse_dependent_requests: Optional[bool] = None,
        follow_redirects: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword request_url: Url location to test.
        :paramtype request_url: str
        :keyword headers: List of headers and their values to add to the WebTest call.
        :paramtype headers:
         list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.HeaderField]
        :keyword http_verb: Http verb to use for this web test.
        :paramtype http_verb: str
        :keyword request_body: Base64 encoded string body to send with this web test.
        :paramtype request_body: str
        :keyword parse_dependent_requests: Parse Dependent request for this WebTest.
        :paramtype parse_dependent_requests: bool
        :keyword follow_redirects: Follow redirects for this web test.
        :paramtype follow_redirects: bool
        """
        super().__init__(**kwargs)
        self.request_url = request_url
        self.headers = headers
        self.http_verb = http_verb
        self.request_body = request_body
        self.parse_dependent_requests = parse_dependent_requests
        self.follow_redirects = follow_redirects


class WebTestPropertiesValidationRules(_serialization.Model):
    """The collection of validation rule properties.

    :ivar content_validation: The collection of content validation properties.
    :vartype content_validation:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesValidationRulesContentValidation
    :ivar ssl_check: Checks to see if the SSL cert is still valid.
    :vartype ssl_check: bool
    :ivar ssl_cert_remaining_lifetime_check: A number of days to check still remain before the the
     existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
    :vartype ssl_cert_remaining_lifetime_check: int
    :ivar expected_http_status_code: Validate that the WebTest returns the http status code
     provided.
    :vartype expected_http_status_code: int
    :ivar ignore_https_status_code: When set, validation will ignore the status code.
    :vartype ignore_https_status_code: bool
    """

    _attribute_map = {
        "content_validation": {"key": "ContentValidation", "type": "WebTestPropertiesValidationRulesContentValidation"},
        "ssl_check": {"key": "SSLCheck", "type": "bool"},
        "ssl_cert_remaining_lifetime_check": {"key": "SSLCertRemainingLifetimeCheck", "type": "int"},
        "expected_http_status_code": {"key": "ExpectedHttpStatusCode", "type": "int"},
        "ignore_https_status_code": {"key": "IgnoreHttpsStatusCode", "type": "bool"},
    }

    def __init__(
        self,
        *,
        content_validation: Optional["_models.WebTestPropertiesValidationRulesContentValidation"] = None,
        ssl_check: Optional[bool] = None,
        ssl_cert_remaining_lifetime_check: Optional[int] = None,
        expected_http_status_code: Optional[int] = None,
        ignore_https_status_code: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword content_validation: The collection of content validation properties.
        :paramtype content_validation:
         ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesValidationRulesContentValidation
        :keyword ssl_check: Checks to see if the SSL cert is still valid.
        :paramtype ssl_check: bool
        :keyword ssl_cert_remaining_lifetime_check: A number of days to check still remain before the
         the existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
        :paramtype ssl_cert_remaining_lifetime_check: int
        :keyword expected_http_status_code: Validate that the WebTest returns the http status code
         provided.
        :paramtype expected_http_status_code: int
        :keyword ignore_https_status_code: When set, validation will ignore the status code.
        :paramtype ignore_https_status_code: bool
        """
        super().__init__(**kwargs)
        self.content_validation = content_validation
        self.ssl_check = ssl_check
        self.ssl_cert_remaining_lifetime_check = ssl_cert_remaining_lifetime_check
        self.expected_http_status_code = expected_http_status_code
        self.ignore_https_status_code = ignore_https_status_code


class WebTestPropertiesValidationRulesContentValidation(_serialization.Model):  # pylint: disable=name-too-long
    """The collection of content validation properties.

    :ivar content_match: Content to look for in the return of the WebTest.  Must not be null or
     empty.
    :vartype content_match: str
    :ivar ignore_case: When set, this value makes the ContentMatch validation case insensitive.
    :vartype ignore_case: bool
    :ivar pass_if_text_found: When true, validation will pass if there is a match for the
     ContentMatch string.  If false, validation will fail if there is a match.
    :vartype pass_if_text_found: bool
    """

    _attribute_map = {
        "content_match": {"key": "ContentMatch", "type": "str"},
        "ignore_case": {"key": "IgnoreCase", "type": "bool"},
        "pass_if_text_found": {"key": "PassIfTextFound", "type": "bool"},
    }

    def __init__(
        self,
        *,
        content_match: Optional[str] = None,
        ignore_case: Optional[bool] = None,
        pass_if_text_found: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword content_match: Content to look for in the return of the WebTest.  Must not be null or
         empty.
        :paramtype content_match: str
        :keyword ignore_case: When set, this value makes the ContentMatch validation case insensitive.
        :paramtype ignore_case: bool
        :keyword pass_if_text_found: When true, validation will pass if there is a match for the
         ContentMatch string.  If false, validation will fail if there is a match.
        :paramtype pass_if_text_found: bool
        """
        super().__init__(**kwargs)
        self.content_match = content_match
        self.ignore_case = ignore_case
        self.pass_if_text_found = pass_if_text_found
