/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sf.saxon.om.XMLChar;

public class RegexTranslator {
    private final String regExp;
    private boolean isXPath;
    private int pos = 0;
    private final int length;
    private char curChar;
    private boolean eos = false;
    private final StringBuffer result = new StringBuffer();
    private static final String categories = "LMNPZSC";
    private static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    private static final String subCategories = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn";
    private static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private static final int NONBMP_MIN = 65536;
    private static final int NONBMP_MAX = 0x10FFFF;
    private static final char SURROGATE2_MIN = '\udc00';
    private static final char SURROGATE2_MAX = '\udfff';
    private static final String[] blockNames = new String[]{"BasicLatin", "Latin-1Supplement", "LatinExtended-A", "LatinExtended-B", "IPAExtensions", "SpacingModifierLetters", "CombiningDiacriticalMarks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "HangulJamo", "Ethiopic", "Cherokee", "UnifiedCanadianAboriginalSyllabics", "Ogham", "Runic", "Khmer", "Mongolian", "LatinExtendedAdditional", "GreekExtended", "GeneralPunctuation", "SuperscriptsandSubscripts", "CurrencySymbols", "CombiningMarksforSymbols", "LetterlikeSymbols", "NumberForms", "Arrows", "MathematicalOperators", "MiscellaneousTechnical", "ControlPictures", "OpticalCharacterRecognition", "EnclosedAlphanumerics", "BoxDrawing", "BlockElements", "GeometricShapes", "MiscellaneousSymbols", "Dingbats", "BraillePatterns", "CJKRadicalsSupplement", "KangxiRadicals", "IdeographicDescriptionCharacters", "CJKSymbolsandPunctuation", "Hiragana", "Katakana", "Bopomofo", "HangulCompatibilityJamo", "Kanbun", "BopomofoExtended", "EnclosedCJKLettersandMonths", "CJKCompatibility", "CJKUnifiedIdeographsExtensionA", "CJKUnifiedIdeographs", "YiSyllables", "YiRadicals", "HangulSyllables", "CJKCompatibilityIdeographs", "AlphabeticPresentationForms", "ArabicPresentationForms-A", "CombiningHalfMarks", "CJKCompatibilityForms", "SmallFormVariants", "ArabicPresentationForms-B", "Specials", "HalfwidthandFullwidthForms", "Specials"};
    private static final String[] specialBlockNames = new String[]{"OldItalic", "Gothic", "Deseret", "ByzantineMusicalSymbols", "MusicalSymbols", "MathematicalAlphanumericSymbols", "CJKUnifiedIdeographsExtensionB", "CJKCompatibilityIdeographsSupplement", "Tags", "PrivateUse", "HighSurrogates", "HighPrivateUseSurrogates", "LowSurrogates"};
    static final String CATEGORY_NAMES = "NoLoMnCfLlNlPoLuMcNdSoSmCo";
    static final int[][] CATEGORY_RANGES = new int[][]{{65799, 65843, 66336, 66339}, {65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 66304, 66334, 66352, 66377, 66432, 66461, 66640, 66717, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67647, 131072, 173782, 194560, 195101}, {119143, 119145, 119163, 119170, 119173, 119179, 119210, 119213, 917760, 917999}, {119155, 119162, 917505, 917505, 917536, 917631}, {66600, 66639, 119834, 119859, 119886, 119892, 119894, 119911, 119938, 119963, 119990, 119993, 119995, 119995, 119997, 120003, 120005, 120015, 120042, 120067, 120094, 120119, 120146, 120171, 120198, 120223, 120250, 120275, 120302, 120327, 120354, 120379, 120406, 120431, 120458, 120483, 120514, 120538, 120540, 120545, 120572, 120596, 120598, 120603, 120630, 120654, 120656, 120661, 120688, 120712, 120714, 120719, 120746, 120770, 120772, 120777}, {66378, 66378}, {65792, 65793, 66463, 66463}, {66560, 66599, 119808, 119833, 119860, 119885, 119912, 119937, 119964, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119989, 120016, 120041, 120068, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120120, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120172, 120197, 120224, 120249, 120276, 120301, 120328, 120353, 120380, 120405, 120432, 120457, 120488, 120512, 120546, 120570, 120604, 120628, 120662, 120686, 120720, 120744}, {119141, 119142, 119149, 119154}, {66720, 66729, 120782, 120831}, {65794, 65794, 65847, 65855, 118784, 119029, 119040, 119078, 119082, 119140, 119146, 119148, 119171, 119172, 119180, 119209, 119214, 119261, 119552, 119638}, {120513, 120513, 120539, 120539, 120571, 120571, 120597, 120597, 120629, 120629, 120655, 120655, 120687, 120687, 120713, 120713, 120745, 120745, 120771, 120771}, {983040, 1048573, 0x100000, 1114109}};
    private static final CharClass[] specialBlockCharClasses = new CharClass[]{new CharRange(66304, 66351), new CharRange(66352, 66383), new CharRange(66560, 66639), new CharRange(118784, 119039), new CharRange(119040, 119295), new CharRange(119808, 120831), new CharRange(131072, 173782), new CharRange(194560, 195103), new CharRange(917504, 917631), new Union(new CharClass[]{new CharRange(57344, 63743), new CharRange(983040, 1048573), new CharRange(0x100000, 1114109)}), Empty.getInstance(), Empty.getInstance(), Empty.getInstance()};
    private static final CharClass DOT = new Complement(new Union(new CharClass[]{new SingleChar('\n'), new SingleChar('\r')}));
    private static final CharClass ESC_d = new Property("Nd");
    private static final CharClass ESC_D = new Complement(ESC_d);
    private static final CharClass ESC_W = new Union(new CharClass[]{new Property("P"), new Property("Z"), new Property("C")});
    private static final CharClass ESC_w = new Complement(ESC_W);
    private static final CharClass ESC_s = new Union(new CharClass[]{new SingleChar(' '), new SingleChar('\n'), new SingleChar('\r'), new SingleChar('\t')});
    static final String NMSTRT_INCLUDES = ":_\u02bb\u02bc\u02bd\u02be\u02bf\u02c0\u02c1\u0559\u06e5\u06e6\u212e";
    static final String NMSTRT_EXCLUDE_RANGES = "\u00aa\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02ad\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u048c\u048f\u04ec\u04ed\u0587\u0587\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07a5\u0950\u0950\u0ad0\u0ad0\u0d85\u0dc6\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u1055\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a8\u207f\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc";
    static final String NMSTRT_CATEGORIES = "LlLuLoLtNl";
    static final String NMCHAR_INCLUDES = "-.:_\u00b7\u0387\u212e";
    static final String NMCHAR_EXCLUDE_RANGES = "\u00aa\u00b5\u00ba\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02b8\u02e0\u02ee\u0346\u034e\u0362\u037a\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u0488\u048f\u04ec\u04ed\u0587\u0587\u0653\u0655\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07b0\u0950\u0950\u0ad0\u0ad0\u0d82\u0df3\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u0f6a\u0f96\u0f96\u0fae\u0fb0\u0fb8\u0fb8\u0fba\u1059\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a9\u207f\u207f\u20dd\u20e0\u20e2\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u2183\u3006\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc";
    static final String NMCHAR_CATEGORIES = "LlLuLoLtNlMcMeMnLmNd";
    private static final CharClass ESC_S = new Complement(ESC_s);
    private static final CharClass ESC_i = RegexTranslator.makeCharClass("LlLuLoLtNl", ":_\u02bb\u02bc\u02bd\u02be\u02bf\u02c0\u02c1\u0559\u06e5\u06e6\u212e", "\u00aa\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02ad\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u048c\u048f\u04ec\u04ed\u0587\u0587\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07a5\u0950\u0950\u0ad0\u0ad0\u0d85\u0dc6\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u1055\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a8\u207f\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_I = new Complement(ESC_i);
    private static final CharClass ESC_c = RegexTranslator.makeCharClass("LlLuLoLtNlMcMeMnLmNd", "-.:_\u00b7\u0387\u212e", "\u00aa\u00b5\u00ba\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02b8\u02e0\u02ee\u0346\u034e\u0362\u037a\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u0488\u048f\u04ec\u04ed\u0587\u0587\u0653\u0655\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07b0\u0950\u0950\u0ad0\u0ad0\u0d82\u0df3\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u0f6a\u0f96\u0f96\u0fae\u0fb0\u0fb8\u0fb8\u0fba\u1059\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a9\u207f\u207f\u20dd\u20e0\u20e2\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u2183\u3006\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_C = new Complement(ESC_c);
    private static final char EOS = '\u0000';
    static final int NONE = -1;
    static final int SOME = 0;
    static final int ALL = 1;
    static final String SURROGATES1_CLASS = "[\ud800-\udbff]";
    static final String SURROGATES2_CLASS = "[\udc00-\udfff]";
    static final String NOT_ALLOWED_CLASS = "[\u0000&&[^\u0000]]";
    private static final char UNICODE_3_1_ADD_Lu = '\u03f4';
    private static final char UNICODE_3_1_ADD_Ll = '\u03f5';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MIN = '\u16ee';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MAX = '\u16f0';
    private static final String CATEGORY_Pi = "\u00ab\u2018\u201b\u201c\u201f\u2039";
    private static final String CATEGORY_Pf = "\u00bb\u2019\u201d\u203a";

    private RegexTranslator(String regExp) {
        this.regExp = regExp;
        this.length = regExp.length();
        this.advance();
    }

    public static String translate(String regexp, boolean xpath) throws RegexSyntaxException {
        RegexTranslator tr = new RegexTranslator(regexp);
        tr.isXPath = xpath;
        tr.translateTop();
        return tr.result.toString();
    }

    private void advance() {
        if (this.pos < this.length) {
            this.curChar = this.regExp.charAt(this.pos++);
        } else {
            ++this.pos;
            this.curChar = '\u0000';
            this.eos = true;
        }
    }

    private void translateTop() throws RegexSyntaxException {
        this.translateRegExp();
        if (!this.eos) {
            throw this.makeException("expected end of string");
        }
    }

    private void translateRegExp() throws RegexSyntaxException {
        this.translateBranch();
        while (this.curChar == '|') {
            this.copyCurChar();
            this.translateBranch();
        }
    }

    private void translateBranch() throws RegexSyntaxException {
        while (this.translateAtom()) {
            this.translateQuantifier();
        }
    }

    private void translateQuantifier() throws RegexSyntaxException {
        switch (this.curChar) {
            case '*': 
            case '+': 
            case '?': {
                this.copyCurChar();
                break;
            }
            case '{': {
                this.copyCurChar();
                this.translateQuantity();
                this.expect('}');
                this.copyCurChar();
                break;
            }
            default: {
                return;
            }
        }
        if (this.curChar == '?' && this.isXPath) {
            this.copyCurChar();
        }
    }

    private void translateQuantity() throws RegexSyntaxException {
        block7: {
            String lower = this.parseQuantExact();
            int lowerValue = -1;
            try {
                lowerValue = Integer.parseInt(lower);
                this.result.append(lower);
            }
            catch (NumberFormatException e) {
                this.result.append(Integer.MAX_VALUE);
            }
            if (this.curChar == ',') {
                this.copyCurChar();
                if (this.curChar != '}') {
                    String upper = this.parseQuantExact();
                    try {
                        int upperValue = Integer.parseInt(upper);
                        this.result.append(upper);
                        if (lowerValue < 0 || upperValue < lowerValue) {
                            throw this.makeException("invalid quantity range");
                        }
                    }
                    catch (NumberFormatException e) {
                        this.result.append(Integer.MAX_VALUE);
                        if (lowerValue >= 0 || new BigDecimal(lower).compareTo(new BigDecimal(upper)) <= 0) break block7;
                        throw this.makeException("invalid quantity range");
                    }
                }
            }
        }
    }

    private String parseQuantExact() throws RegexSyntaxException {
        StringBuffer buf = new StringBuffer();
        do {
            if ("0123456789".indexOf(this.curChar) < 0) {
                throw this.makeException("expected digit");
            }
            buf.append(this.curChar);
            this.advance();
        } while (this.curChar != ',' && this.curChar != '}');
        return buf.toString();
    }

    private void copyCurChar() {
        this.result.append(this.curChar);
        this.advance();
    }

    private boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                this.translateRegExp();
                this.expect(')');
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                if (this.isXPath) break;
                DOT.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                if (this.isXPath) {
                    this.copyCurChar();
                    return true;
                }
                this.result.append('\\');
            }
        }
        this.copyCurChar();
        return true;
    }

    private static CharClass makeCharClass(String categories, String includes, String excludeRanges) {
        Vector<SimpleCharClass> includeList = new Vector<SimpleCharClass>();
        int i = 0;
        int len = categories.length();
        while (i < len) {
            includeList.add(new Property(categories.substring(i, i + 2)));
            i += 2;
        }
        int i2 = 0;
        int len2 = includes.length();
        while (i2 < len2) {
            int j = i2 + 1;
            while (j < len2 && includes.charAt(j) - includes.charAt(i2) == j - i2) {
                ++j;
            }
            if (i2 == --j - 1) {
                --j;
            }
            if (i2 == j) {
                includeList.add(new SingleChar(includes.charAt(i2)));
            } else {
                includeList.add(new CharRange(includes.charAt(i2), includes.charAt(j)));
            }
            i2 = j;
            ++i2;
        }
        Vector<SimpleCharClass> excludeList = new Vector<SimpleCharClass>();
        int i3 = 0;
        int len3 = excludeRanges.length();
        while (i3 < len3) {
            char max;
            char min = excludeRanges.charAt(i3);
            if (min == (max = excludeRanges.charAt(i3 + 1))) {
                excludeList.add(new SingleChar(min));
            } else if (min == max - '\u0001') {
                excludeList.add(new SingleChar(min));
                excludeList.add(new SingleChar(max));
            } else {
                excludeList.add(new CharRange(min, max));
            }
            i3 += 2;
        }
        return new Subtraction(new Union(includeList), new Union(excludeList));
    }

    private CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SingleChar('\n');
            }
            case 'r': {
                this.advance();
                return new SingleChar('\r');
            }
            case 't': {
                this.advance();
                return new SingleChar('\t');
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return ESC_i;
            }
            case 'I': {
                this.advance();
                return ESC_I;
            }
            case 'c': {
                this.advance();
                return ESC_c;
            }
            case 'C': {
                this.advance();
                return ESC_C;
            }
            case 'd': {
                this.advance();
                return ESC_d;
            }
            case 'D': {
                this.advance();
                return ESC_D;
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp();
            }
            case 'P': {
                this.advance();
                return new Complement(this.parseProp());
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.isXPath) {
                    char c = this.curChar;
                    this.advance();
                    return new BackReference(c - 48);
                }
                throw this.makeException("digit not allowed after \\");
            }
            case '$': {
                if (this.isXPath) break;
            }
            default: {
                throw this.makeException("bad escape sequence");
            }
        }
        SingleChar tem = new SingleChar(this.curChar);
        this.advance();
        return tem;
    }

    private CharClass parseProp() throws RegexSyntaxException {
        this.expect('{');
        int start = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (RegexTranslator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        String propertyName = this.regExp.substring(start, this.pos - 1);
        this.advance();
        switch (propertyName.length()) {
            case 0: {
                throw this.makeException("empty property name");
            }
            case 2: {
                int sci = subCategories.indexOf(propertyName);
                if (sci < 0 || sci % 2 == 1) {
                    throw this.makeException("bad category");
                }
                return RegexTranslator.getSubCategoryCharClass(sci / 2);
            }
            case 1: {
                int ci = categories.indexOf(propertyName.charAt(0));
                if (ci < 0) {
                    throw this.makeException("bad category", propertyName);
                }
                return RegexTranslator.getCategoryCharClass(ci);
            }
        }
        if (propertyName.startsWith("Is")) {
            String blockName = propertyName.substring(2);
            int i = 0;
            while (i < specialBlockNames.length) {
                if (blockName.equals(specialBlockNames[i])) {
                    return specialBlockCharClasses[i];
                }
                ++i;
            }
            if (!RegexTranslator.isBlock(blockName)) {
                throw this.makeException("bad block name", blockName);
            }
            return new Property("In" + blockName);
        }
        throw this.makeException("bad property name", propertyName);
    }

    private static boolean isBlock(String name) {
        int i = 0;
        while (i < blockNames.length) {
            if (name.equals(blockNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isAsciiAlnum(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    private void expect(char c) throws RegexSyntaxException {
        if (this.curChar != c) {
            throw this.makeException("expected", new String(new char[]{c}));
        }
    }

    private CharClass parseCharClassExpr() throws RegexSyntaxException {
        boolean compl;
        if (this.curChar == '^') {
            this.advance();
            compl = true;
        } else {
            compl = false;
        }
        Vector<CharClass> members = new Vector<CharClass>();
        do {
            CharClass lower = this.parseCharClassEscOrXmlChar();
            members.add(lower);
            if (this.curChar != '-') continue;
            this.advance();
            if (this.curChar == '[') break;
            CharClass upper = this.parseCharClassEscOrXmlChar();
            if (lower.singleChar() < 0 || upper.singleChar() < 0) {
                throw this.makeException("multi_range");
            }
            if (lower.singleChar() > upper.singleChar()) {
                throw this.makeException("invalid_range");
            }
            members.set(members.size() - 1, new CharRange(lower.singleChar(), upper.singleChar()));
            if (this.curChar != '-') continue;
            this.advance();
            this.expect('[');
            break;
        } while (this.curChar != ']');
        CharClass result = members.size() == 1 ? (CharClass)members.get(0) : new Union(members);
        if (compl) {
            result = new Complement(result);
        }
        if (this.curChar == '[') {
            this.advance();
            result = new Subtraction(result, this.parseCharClassExpr());
            this.expect(']');
        }
        this.advance();
        return result;
    }

    private CharClass parseCharClassEscOrXmlChar() throws RegexSyntaxException {
        SimpleCharClass tem;
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '-': 
            case '[': 
            case ']': {
                throw this.makeException("should_quote", new String(new char[]{this.curChar}));
            }
        }
        if (XMLChar.isSurrogate(this.curChar)) {
            if (!XMLChar.isHighSurrogate(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            char c1 = this.curChar;
            this.advance();
            if (!XMLChar.isLowSurrogate(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            tem = new WideSingleChar(XMLChar.supplemental(c1, this.curChar));
        } else {
            tem = new SingleChar(this.curChar);
        }
        this.advance();
        return tem;
    }

    private RegexSyntaxException makeException(String key) {
        return new RegexSyntaxException("Error at character " + (this.pos - 1) + " in regular expression: " + key);
    }

    private RegexSyntaxException makeException(String key, String arg) {
        return new RegexSyntaxException("Error at character " + (this.pos - 1) + " in regular expression: " + key + " (" + arg + ")");
    }

    private static boolean isJavaMetaChar(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static synchronized CharClass getCategoryCharClass(int ci) {
        if (categoryCharClasses[ci] == null) {
            RegexTranslator.categoryCharClasses[ci] = RegexTranslator.computeCategoryCharClass(categories.charAt(ci));
        }
        return categoryCharClasses[ci];
    }

    private static synchronized CharClass getSubCategoryCharClass(int sci) {
        if (subCategoryCharClasses[sci] == null) {
            RegexTranslator.subCategoryCharClasses[sci] = RegexTranslator.computeSubCategoryCharClass(subCategories.substring(sci * 2, (sci + 1) * 2));
        }
        return subCategoryCharClasses[sci];
    }

    private static CharClass computeCategoryCharClass(char code) {
        int i;
        Vector<CharClass> classes = new Vector<CharClass>();
        classes.add(new Property(new String(new char[]{code})));
        int ci = CATEGORY_NAMES.indexOf(code);
        while (ci >= 0) {
            int[] addRanges = CATEGORY_RANGES[ci / 2];
            i = 0;
            while (i < addRanges.length) {
                classes.add(new CharRange(addRanges[i], addRanges[i + 1]));
                i += 2;
            }
            ci = CATEGORY_NAMES.indexOf(code, ci + 1);
        }
        if (code == 'P') {
            classes.add(RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039\u00bb\u2019\u201d\u203a"));
        }
        if (code == 'L') {
            classes.add(new SingleChar('\u03f5'));
            classes.add(new SingleChar('\u03f4'));
        }
        if (code == 'C') {
            classes.add(new Subtraction(new Property("Cn"), new Union(new CharClass[]{new SingleChar('\u03f4'), new SingleChar('\u03f5')})));
            Vector<CharRange> assignedRanges = new Vector<CharRange>();
            i = 0;
            while (i < CATEGORY_RANGES.length) {
                int j = 0;
                while (j < CATEGORY_RANGES[i].length) {
                    assignedRanges.add(new CharRange(CATEGORY_RANGES[i][j], CATEGORY_RANGES[i][j + 1]));
                    j += 2;
                }
                ++i;
            }
            classes.add(new Subtraction(new CharRange(65536, 0x10FFFF), new Union(assignedRanges)));
        }
        if (classes.size() == 1) {
            return (CharClass)classes.get(0);
        }
        return new Union(classes);
    }

    private static CharClass computeSubCategoryCharClass(String name) {
        Property base = new Property(name);
        int sci = CATEGORY_NAMES.indexOf(name);
        if (sci < 0) {
            if (name.equals("Cn")) {
                Vector<SimpleCharClass> assignedRanges = new Vector<SimpleCharClass>();
                assignedRanges.add(new SingleChar('\u03f4'));
                assignedRanges.add(new SingleChar('\u03f5'));
                int i = 0;
                while (i < CATEGORY_RANGES.length) {
                    int j = 0;
                    while (j < CATEGORY_RANGES[i].length) {
                        assignedRanges.add(new CharRange(CATEGORY_RANGES[i][j], CATEGORY_RANGES[i][j + 1]));
                        j += 2;
                    }
                    ++i;
                }
                return new Subtraction(new Union(new CharClass[]{base, new CharRange(65536, 0x10FFFF)}), new Union(assignedRanges));
            }
            if (name.equals("Pi")) {
                return RegexTranslator.makeCharClass(CATEGORY_Pi);
            }
            if (name.equals("Pf")) {
                return RegexTranslator.makeCharClass(CATEGORY_Pf);
            }
            return base;
        }
        Vector<SimpleCharClass> classes = new Vector<SimpleCharClass>();
        classes.add(base);
        int[] addRanges = CATEGORY_RANGES[sci / 2];
        int i = 0;
        while (i < addRanges.length) {
            classes.add(new CharRange(addRanges[i], addRanges[i + 1]));
            i += 2;
        }
        if (name.equals("Lu")) {
            classes.add(new SingleChar('\u03f4'));
        } else if (name.equals("Ll")) {
            classes.add(new SingleChar('\u03f5'));
        } else if (name.equals("Nl")) {
            classes.add(new CharRange(5870, 5872));
        } else if (name.equals("No")) {
            return new Subtraction(new Union(classes), new CharRange(5870, 5872));
        }
        return new Union(classes);
    }

    private static CharClass makeCharClass(String members) {
        Vector<SingleChar> list = new Vector<SingleChar>();
        int i = 0;
        int len = members.length();
        while (i < len) {
            list.add(new SingleChar(members.charAt(i)));
            ++i;
        }
        return new Union(list);
    }

    public static void main(String[] args) throws RegexSyntaxException {
        String s = RegexTranslator.translate(args[0], args[1].equals("xpath"));
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~') {
                System.err.print(c);
            } else {
                System.err.print("\\u");
                int shift = 12;
                while (shift >= 0) {
                    System.err.print("0123456789ABCDEF".charAt(c >> shift & 0xF));
                    shift -= 4;
                }
            }
            ++i;
        }
        System.err.println();
    }

    static class Complement
    extends CharClass {
        private final CharClass cc;

        Complement(CharClass cc) {
            super(-cc.getContainsBmp(), -cc.getContainsNonBmp());
            this.cc = cc;
        }

        void outputBmp(StringBuffer buf) {
            this.cc.outputComplementBmp(buf);
        }

        void outputComplementBmp(StringBuffer buf) {
            this.cc.outputBmp(buf);
        }

        void addNonBmpRanges(List ranges) {
            Vector tem = new Vector();
            this.cc.addNonBmpRanges(tem);
            CharClass.sortRangeList(tem);
            int c = 65536;
            int i = 0;
            int len = tem.size();
            while (i < len) {
                Range r = (Range)tem.get(i);
                if (r.getMin() > c) {
                    ranges.add(new Range(c, r.getMin() - 1));
                }
                c = r.getMax() + 1;
                ++i;
            }
            if (c != 0x110000) {
                ranges.add(new Range(c, 0x10FFFF));
            }
        }
    }

    public static class RegexSyntaxException
    extends Exception {
        private final int position;
        public static final int UNKNOWN_POSITION = -1;

        public RegexSyntaxException(String detail) {
            this(detail, -1);
        }

        public RegexSyntaxException(String detail, int position) {
            super(detail);
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }
    }

    static class BackReference
    extends CharClass {
        private final int i;

        BackReference(int i) {
            super(0, -1);
            this.i = i;
        }

        void outputBmp(StringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        void outputComplementBmp(StringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        void inClassOutputBmp(StringBuffer buf) {
            buf.append('\\');
            buf.append(this.i);
        }
    }

    static class Union
    extends CharClass {
        private final List members;

        Union(CharClass[] v) {
            this(Union.toList(v));
        }

        private static List toList(CharClass[] v) {
            Vector<CharClass> members = new Vector<CharClass>();
            int i = 0;
            while (i < v.length) {
                members.add(v[i]);
                ++i;
            }
            return members;
        }

        Union(List members) {
            super(Union.computeContainsBmp(members), Union.computeContainsNonBmp(members));
            this.members = members;
        }

        void outputBmp(StringBuffer buf) {
            buf.append('[');
            int i = 0;
            int len = this.members.size();
            while (i < len) {
                CharClass cc = (CharClass)this.members.get(i);
                if (cc.getContainsBmp() != -1) {
                    if (cc instanceof SimpleCharClass) {
                        ((SimpleCharClass)cc).inClassOutputBmp(buf);
                    } else {
                        cc.outputBmp(buf);
                    }
                }
                ++i;
            }
            buf.append(']');
        }

        void outputComplementBmp(StringBuffer buf) {
            boolean first = true;
            int len = this.members.size();
            int i = 0;
            while (i < len) {
                CharClass cc = (CharClass)this.members.get(i);
                if (cc.getContainsBmp() != -1 && cc instanceof SimpleCharClass) {
                    if (first) {
                        buf.append("[^");
                        first = false;
                    }
                    ((SimpleCharClass)cc).inClassOutputBmp(buf);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < len) {
                CharClass cc = (CharClass)this.members.get(i2);
                if (cc.getContainsBmp() != -1 && !(cc instanceof SimpleCharClass)) {
                    if (first) {
                        buf.append('[');
                        first = false;
                    } else {
                        buf.append("&&");
                    }
                    cc.outputComplementBmp(buf);
                }
                ++i2;
            }
            if (first) {
                buf.append("[\u0000-\uffff]");
            } else {
                buf.append(']');
            }
        }

        void addNonBmpRanges(List ranges) {
            int i = 0;
            int len = this.members.size();
            while (i < len) {
                ((CharClass)this.members.get(i)).addNonBmpRanges(ranges);
                ++i;
            }
        }

        private static int computeContainsBmp(List members) {
            int ret = -1;
            int i = 0;
            int len = members.size();
            while (i < len) {
                ret = Math.max(ret, ((CharClass)members.get(i)).getContainsBmp());
                ++i;
            }
            return ret;
        }

        private static int computeContainsNonBmp(List members) {
            int ret = -1;
            int i = 0;
            int len = members.size();
            while (i < len) {
                ret = Math.max(ret, ((CharClass)members.get(i)).getContainsNonBmp());
                ++i;
            }
            return ret;
        }
    }

    static class Subtraction
    extends CharClass {
        private final CharClass cc1;
        private final CharClass cc2;

        Subtraction(CharClass cc1, CharClass cc2) {
            super(Math.min(cc1.getContainsBmp(), -cc2.getContainsBmp()), Math.min(cc1.getContainsNonBmp(), -cc2.getContainsNonBmp()));
            this.cc1 = cc1;
            this.cc2 = cc2;
        }

        void outputBmp(StringBuffer buf) {
            buf.append('[');
            this.cc1.outputBmp(buf);
            buf.append("&&");
            this.cc2.outputComplementBmp(buf);
            buf.append(']');
        }

        void outputComplementBmp(StringBuffer buf) {
            buf.append('[');
            this.cc1.outputComplementBmp(buf);
            this.cc2.outputBmp(buf);
            buf.append(']');
        }

        void addNonBmpRanges(List ranges) {
            Vector posList = new Vector();
            this.cc1.addNonBmpRanges(posList);
            Vector negList = new Vector();
            this.cc2.addNonBmpRanges(negList);
            CharClass.sortRangeList(posList);
            CharClass.sortRangeList(negList);
            Iterator negIter = negList.iterator();
            Range negRange = negIter.hasNext() ? (Range)negIter.next() : null;
            int i = 0;
            int len = posList.size();
            while (i < len) {
                Range posRange = (Range)posList.get(i);
                while (negRange != null && negRange.getMax() < posRange.getMin()) {
                    negRange = negIter.hasNext() ? (Range)negIter.next() : null;
                }
                int min = posRange.getMin();
                while (negRange != null && negRange.getMin() <= posRange.getMax()) {
                    if (min < negRange.getMin()) {
                        ranges.add(new Range(min, negRange.getMin() - 1));
                    }
                    if ((min = negRange.getMax() + 1) > posRange.getMax()) break;
                    negRange = negIter.hasNext() ? (Range)negIter.next() : null;
                }
                if (min <= posRange.getMax()) {
                    ranges.add(new Range(min, posRange.getMax()));
                }
                ++i;
            }
        }
    }

    static class Property
    extends SimpleCharClass {
        private final String name;

        Property(String name) {
            super(0, -1);
            this.name = name;
        }

        void outputBmp(StringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        void inClassOutputBmp(StringBuffer buf) {
            buf.append("\\p{");
            buf.append(this.name);
            buf.append('}');
        }

        void outputComplementBmp(StringBuffer buf) {
            buf.append("\\P{");
            buf.append(this.name);
            buf.append('}');
        }
    }

    static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        CharRange(int lower, int upper) {
            super(lower < 65536 ? 0 : -1, upper >= 65536 ? 0 : -1);
            this.lower = lower;
            this.upper = upper;
        }

        void inClassOutputBmp(StringBuffer buf) {
            if (this.lower >= 65536) {
                throw new RuntimeException("BMP output botch");
            }
            if (RegexTranslator.isJavaMetaChar((char)this.lower)) {
                buf.append('\\');
            }
            buf.append((char)this.lower);
            buf.append('-');
            if (this.upper < 65536) {
                if (RegexTranslator.isJavaMetaChar((char)this.upper)) {
                    buf.append('\\');
                }
                buf.append((char)this.upper);
            } else {
                buf.append('\uffff');
            }
        }

        void addNonBmpRanges(List ranges) {
            if (this.upper >= 65536) {
                ranges.add(new Range(this.lower < 65536 ? 65536 : this.lower, this.upper));
            }
        }
    }

    static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
            super(-1, -1);
        }

        static Empty getInstance() {
            return instance;
        }

        void inClassOutputBmp(StringBuffer buf) {
            throw new RuntimeException("BMP output botch");
        }
    }

    static class WideSingleChar
    extends SimpleCharClass {
        private final int c;

        WideSingleChar(int c) {
            super(-1, 0);
            this.c = c;
        }

        void inClassOutputBmp(StringBuffer buf) {
            throw new RuntimeException("BMP output botch");
        }

        int singleChar() {
            return this.c;
        }

        void addNonBmpRanges(List ranges) {
            ranges.add(new Range(this.c, this.c));
        }
    }

    static class SingleChar
    extends SimpleCharClass {
        private final char c;

        SingleChar(char c) {
            super(0, -1);
            this.c = c;
        }

        int singleChar() {
            return this.c;
        }

        void outputBmp(StringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        void inClassOutputBmp(StringBuffer buf) {
            if (RegexTranslator.isJavaMetaChar(this.c)) {
                buf.append('\\');
            }
            buf.append(this.c);
        }
    }

    static abstract class SimpleCharClass
    extends CharClass {
        SimpleCharClass(int containsBmp, int containsNonBmp) {
            super(containsBmp, containsNonBmp);
        }

        void outputBmp(StringBuffer buf) {
            buf.append('[');
            this.inClassOutputBmp(buf);
            buf.append(']');
        }

        void outputComplementBmp(StringBuffer buf) {
            if (this.getContainsBmp() == -1) {
                buf.append("[\u0000-\uffff]");
            } else {
                buf.append("[^");
                this.inClassOutputBmp(buf);
                buf.append(']');
            }
        }

        abstract void inClassOutputBmp(StringBuffer var1);
    }

    static abstract class CharClass {
        private final int containsBmp;
        private final int containsNonBmp;

        protected CharClass(int containsBmp, int containsNonBmp) {
            this.containsBmp = containsBmp;
            this.containsNonBmp = containsNonBmp;
        }

        int getContainsBmp() {
            return this.containsBmp;
        }

        int getContainsNonBmp() {
            return this.containsNonBmp;
        }

        final void output(StringBuffer buf) {
            switch (this.containsNonBmp) {
                case -1: {
                    if (this.containsBmp == -1) {
                        buf.append(RegexTranslator.NOT_ALLOWED_CLASS);
                        break;
                    }
                    this.outputBmp(buf);
                    break;
                }
                case 1: {
                    buf.append("(?:");
                    if (this.containsBmp == -1) {
                        buf.append(RegexTranslator.SURROGATES1_CLASS);
                        buf.append(RegexTranslator.SURROGATES2_CLASS);
                    } else {
                        this.outputBmp(buf);
                        buf.append(RegexTranslator.SURROGATES2_CLASS);
                        buf.append('?');
                    }
                    buf.append(')');
                    break;
                }
                case 0: {
                    buf.append("(?:");
                    boolean needSep = false;
                    if (this.containsBmp != -1) {
                        needSep = true;
                        this.outputBmp(buf);
                    }
                    Vector ranges = new Vector();
                    this.addNonBmpRanges(ranges);
                    CharClass.sortRangeList(ranges);
                    String hi = CharClass.highSurrogateRanges(ranges);
                    if (hi.length() > 0) {
                        if (needSep) {
                            buf.append('|');
                        } else {
                            needSep = true;
                        }
                        buf.append('[');
                        int i = 0;
                        int len = hi.length();
                        while (i < len) {
                            char max;
                            char min = hi.charAt(i);
                            if (min == (max = hi.charAt(i + 1))) {
                                buf.append(min);
                            } else {
                                buf.append(min);
                                buf.append('-');
                                buf.append(max);
                            }
                            i += 2;
                        }
                        buf.append(']');
                        buf.append(RegexTranslator.SURROGATES2_CLASS);
                    }
                    String lo = CharClass.lowSurrogateRanges(ranges);
                    int i = 0;
                    int len = lo.length();
                    while (i < len) {
                        if (needSep) {
                            buf.append('|');
                        } else {
                            needSep = true;
                        }
                        buf.append(lo.charAt(i));
                        char min = lo.charAt(i + 1);
                        char max = lo.charAt(i + 2);
                        if (min == max && (i + 3 >= len || lo.charAt(i + 3) != lo.charAt(i))) {
                            buf.append(min);
                        } else {
                            buf.append('[');
                            while (true) {
                                if (min == max) {
                                    buf.append(min);
                                } else {
                                    buf.append(min);
                                    buf.append('-');
                                    buf.append(max);
                                }
                                if (i + 3 >= len || lo.charAt(i + 3) != lo.charAt(i)) break;
                                min = lo.charAt((i += 3) + 1);
                                max = lo.charAt(i + 2);
                            }
                            buf.append(']');
                        }
                        i += 3;
                    }
                    if (!needSep) {
                        buf.append(RegexTranslator.NOT_ALLOWED_CLASS);
                    }
                    buf.append(')');
                }
            }
        }

        static String highSurrogateRanges(List ranges) {
            StringBuffer highRanges = new StringBuffer();
            int i = 0;
            int len = ranges.size();
            while (i < len) {
                Range r = (Range)ranges.get(i);
                char min1 = XMLChar.highSurrogate(r.getMin());
                char min2 = XMLChar.lowSurrogate(r.getMin());
                char max1 = XMLChar.highSurrogate(r.getMax());
                char max2 = XMLChar.lowSurrogate(r.getMax());
                if (min2 != '\udc00') {
                    min1 = (char)(min1 + '\u0001');
                }
                if (max2 != '\udfff') {
                    max1 = (char)(max1 - '\u0001');
                }
                if (max1 >= min1) {
                    highRanges.append(min1);
                    highRanges.append(max1);
                }
                ++i;
            }
            return highRanges.toString();
        }

        static String lowSurrogateRanges(List ranges) {
            StringBuffer lowRanges = new StringBuffer();
            int i = 0;
            int len = ranges.size();
            while (i < len) {
                Range r = (Range)ranges.get(i);
                char min1 = XMLChar.highSurrogate(r.getMin());
                char min2 = XMLChar.lowSurrogate(r.getMin());
                char max1 = XMLChar.highSurrogate(r.getMax());
                char max2 = XMLChar.lowSurrogate(r.getMax());
                if (min1 == max1) {
                    if (min2 != '\udc00' || max2 != '\udfff') {
                        lowRanges.append(min1);
                        lowRanges.append(min2);
                        lowRanges.append(max2);
                    }
                } else {
                    if (min2 != '\udc00') {
                        lowRanges.append(min1);
                        lowRanges.append(min2);
                        lowRanges.append('\udfff');
                    }
                    if (max2 != '\udfff') {
                        lowRanges.append(max1);
                        lowRanges.append('\udc00');
                        lowRanges.append(max2);
                    }
                }
                ++i;
            }
            return lowRanges.toString();
        }

        abstract void outputBmp(StringBuffer var1);

        abstract void outputComplementBmp(StringBuffer var1);

        int singleChar() {
            return -1;
        }

        void addNonBmpRanges(List ranges) {
        }

        static void sortRangeList(List ranges) {
            Collections.sort(ranges);
            int toIndex = 0;
            int fromIndex = 0;
            int len = ranges.size();
            while (fromIndex < len) {
                Range r = (Range)ranges.get(fromIndex);
                int min = r.getMin();
                int max = r.getMax();
                while (++fromIndex < len) {
                    Range r2 = (Range)ranges.get(fromIndex);
                    if (r2.getMin() > max + 1) break;
                    if (r2.getMax() <= max) continue;
                    max = r2.getMax();
                }
                if (max != r.getMax()) {
                    r = new Range(min, max);
                }
                ranges.set(toIndex++, r);
            }
            while (len > toIndex) {
                ranges.remove(--len);
            }
        }
    }

    static final class Range
    implements Comparable {
        private final int min;
        private final int max;

        Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        int getMin() {
            return this.min;
        }

        int getMax() {
            return this.max;
        }

        public int compareTo(Object o) {
            Range other = (Range)o;
            if (this.min < other.min) {
                return -1;
            }
            if (this.min > other.min) {
                return 1;
            }
            if (this.max > other.max) {
                return -1;
            }
            if (this.max < other.max) {
                return 1;
            }
            return 0;
        }
    }
}

