## TFSA-2022-037: Unitialized variable access in `AssignOp`

### CVE Number
CVE-2022-23573

### Impact
The [implementation of `AssignOp`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/kernels/assign_op.h#L30-L143) can result in copying unitialized data to a new tensor. This later results in undefined behavior.

The implementation has a check that the left hand side of the assignment is initialized (to minimize number of allocations), but does not check that the right hand side is also initialized.

### Patches
We have patched the issue in GitHub commit [ef1d027be116f25e25bb94a60da491c2cf55bd0b](https://github.com/tensorflow/tensorflow/commit/ef1d027be116f25e25bb94a60da491c2cf55bd0b).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
