/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.conditional;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.ADQLFunction;
import java.util.Arrays;
import java.util.Collection;

public class CoalesceFunction
extends ADQLFunction {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adql-conditional", "COALESCE", true, "Return the first of its arguments that is not NULL.");
    protected final String FCT_NAME = "COALESCE";
    protected ADQLOperand[] values;

    public CoalesceFunction(ADQLOperand[] operands) throws Exception {
        this.values = new ADQLOperand[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            this.setParameter(i, operands[i]);
        }
    }

    public CoalesceFunction(Collection<ADQLOperand> operands) throws Exception {
        this.values = new ADQLOperand[operands.size()];
        int i = 0;
        for (ADQLOperand op : operands) {
            this.setParameter(i++, op);
        }
    }

    @Override
    public String getName() {
        return "COALESCE";
    }

    @Override
    public LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new CoalesceFunction(this.values);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    @Override
    public int getNbParameters() {
        return this.values.length;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index > this.values.length) {
            throw new ArrayIndexOutOfBoundsException("No more than " + this.values.length + " parameters to this " + this.getName() + " function!");
        }
        return this.values[index];
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        ADQLOperand replaced = null;
        if (index < 0 || index >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" (" + this.toADQL() + ")!");
        }
        if (replacer == null) {
            int i;
            if (this.values.length == 1) {
                throw new NullPointerException("Impossible to remove the only parameter of \"" + this.getName() + "\" (" + this.toADQL() + ")!");
            }
            ADQLOperand[] newValues = new ADQLOperand[this.values.length - 1];
            for (i = 0; i < index; ++i) {
                newValues[i] = this.values[i];
            }
            replaced = this.values[index];
            for (i = index + 1; i < this.values.length; ++i) {
                newValues[i - 1] = this.values[i];
            }
            this.values = newValues;
        } else {
            replaced = this.values[index];
            this.values[index] = replacer;
        }
        this.setPosition(null);
        return replaced;
    }
}

