# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.monitor import MonitorManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-monitor
# USAGE
    python create_or_update_metric_alert_query_resource_centric.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = MonitorManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7",
    )

    response = client.metric_alerts.create_or_update(
        resource_group_name="gigtest",
        rule_name="chiricutin",
        parameters={
            "identity": {
                "type": "UserAssigned",
                "userAssignedIdentities": {
                    "/subscriptions/2f1a501a-6e1d-4f37-a445-462d7f8a563d/resourceGroups/AdisTest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/msi-test-euap": {}
                },
            },
            "location": "eastus",
            "properties": {
                "actionProperties": {"Email.Sujbect": "my custom email subject"},
                "actions": [
                    {
                        "actionGroupId": "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"
                    }
                ],
                "criteria": {
                    "allOf": [
                        {
                            "criterionType": "StaticThresholdCriterion",
                            "name": "Metric1",
                            "query": 'avg({"system.cpu.utilization"}) > 90',
                        }
                    ],
                    "failingPeriods": {"for": "PT5M"},
                    "odata.type": "Microsoft.Azure.Monitor.PromQLCriteria",
                },
                "customProperties": {"key11": "value11", "key12": "value12"},
                "description": "This is the description of the rule1",
                "enabled": True,
                "evaluationFrequency": "PT1M",
                "resolveConfiguration": {"autoResolved": True, "timeToResolve": "PT10M"},
                "scopes": [
                    "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/microsoft.compute/virtualMachines/myVmName"
                ],
                "severity": 3,
            },
            "tags": {},
        },
    )
    print(response)


# x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/preview/2024-03-01-preview/examples/createOrUpdateMetricAlertQueryResourceCentric.json
if __name__ == "__main__":
    main()
