/**********************************************************************
 * $list_parameters example -- C source code using ACC PLI routines
 *
 * C source to scan through a module and list the typical rise, fall
 * and turn-off delays of all primitives in a module.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $list_prim_delays(<module_instance>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_ListParams_checktf(),
 *              PLIbook_ListParams_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_ListParams_checktf,    /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_ListParams_calltf,     /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$list_parameters",            /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_ListParams_checktf()
{
  acc_initialize();
  if (tf_nump() != 1)
    tf_error("$list_parameters must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$list_parameters arg cannot be null.");
  else if (acc_fetch_type(acc_handle_tfarg(1)) != accModule)
    tf_error("$list_parameters arg must be a module instance.");
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_ListParams_calltf()
{
  handle module_h, param_h;

  acc_initialize();
  acc_configure(accDisplayWarnings, "true");

  module_h = acc_handle_tfarg(1);
  io_printf("\nConstants in module %s:\n",
            acc_fetch_fullname(module_h));
  param_h = null;
  while(param_h = acc_next_parameter(module_h, param_h)) {
    io_printf("  Parameter %s is: ", acc_fetch_fullname(param_h));
    switch(acc_fetch_paramtype(param_h) ) {
      case accRealParam:
       io_printf("%f\n", acc_fetch_paramval(param_h));
       break;
      case accIntegerParam:
       io_printf("%d\n", (int)acc_fetch_paramval(param_h));
       break;
      case accStringParam:
       io_printf("%s\n", (char*)(int)acc_fetch_paramval(param_h));
    }
  }
  acc_close();
  return(0);
}
/*********************************************************************/
