<?php
/**
 * Copyright 1999-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @author   Jan Schneider <jan@horde.org>
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @category Horde
 * @license  http://www.horde.org/licenses/lgpl21 LGPL
 * @package  Data
 */

/**
 * Implement the Horde_Data:: API for vNote data.
 *
 * @author    Jan Schneider <jan@horde.org>
 * @author    Chuck Hagenbuch <chuck@horde.org>
 * @category  Horde
 * @copyright 1999-2017 Horde LLC
 * @license   http://www.horde.org/licenses/lgpl21 LGPL
 * @package   Data
 */
class Horde_Data_Vnote extends Horde_Data_Imc
{
    /**
     * Exports vcalendar data as a string. Unlike vEvent, vNote data
     * is not enclosed in BEGIN|END:vCalendar.
     *
     * @param array $data     An array containing Horde_Icalendar_Vnote
     *                        objects.
     * @param string $method  The iTip method to use.
     *
     * @return string  The iCalendar data.
     */
    public function exportData($data, $method = 'REQUEST')
    {
        $this->_iCal = new Horde_Icalendar();
        $this->_iCal->setAttribute('METHOD', $method);

        $s = '';
        foreach ($data as $event) {
            $s .= $event->exportvCalendar();
        }

        return $s;
    }

}
