/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlUtils {
    public static ImmutableList<Node> childrenOf(Node node) {
        NodeList children = node.getChildNodes();
        ImmutableList.Builder result = ImmutableList.builder();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            result.add((Object)children.item(i));
        }
        return result.build();
    }

    public static ImmutableMap<String, String> attributesOf(Element element) {
        NamedNodeMap map = element.getAttributes();
        ImmutableMap.Builder result = ImmutableMap.builder();
        int size = map.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)map.item(i);
            result.put((Object)attr.getName(), (Object)attr.getValue());
        }
        return result.build();
    }

    private XmlUtils() {
    }
}

