// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/securitycenter/settings/v1beta1/securitycenter_settings_service.proto

package settings

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for GetServiceAccount.
type GetServiceAccountRequest struct {
	// Required. The relative resource name of the service account resource.
	// Format:
	//  * `organizations/{organization}/serviceAccount`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServiceAccountRequest) Reset()         { *m = GetServiceAccountRequest{} }
func (m *GetServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceAccountRequest) ProtoMessage()    {}
func (*GetServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{0}
}

func (m *GetServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceAccountRequest.Unmarshal(m, b)
}
func (m *GetServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceAccountRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceAccountRequest.Merge(m, src)
}
func (m *GetServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceAccountRequest.Size(m)
}
func (m *GetServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceAccountRequest proto.InternalMessageInfo

func (m *GetServiceAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// An organization-level service account to be used by threat detection
// components.
type ServiceAccount struct {
	// The relative resource name of the service account resource.
	// Format:
	//  * `organizations/{organization}/serviceAccount`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Security Center managed service account for the organization
	// example service-org-1234@scc.iam.gserviceaccount.com
	// This service_account will be stored in the ComponentSettings field for the
	// SCC, SHA, and Infra Automation components.
	ServiceAccount       string   `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServiceAccount) Reset()         { *m = ServiceAccount{} }
func (m *ServiceAccount) String() string { return proto.CompactTextString(m) }
func (*ServiceAccount) ProtoMessage()    {}
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{1}
}

func (m *ServiceAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceAccount.Unmarshal(m, b)
}
func (m *ServiceAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceAccount.Marshal(b, m, deterministic)
}
func (m *ServiceAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAccount.Merge(m, src)
}
func (m *ServiceAccount) XXX_Size() int {
	return xxx_messageInfo_ServiceAccount.Size(m)
}
func (m *ServiceAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAccount.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAccount proto.InternalMessageInfo

func (m *ServiceAccount) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServiceAccount) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

// Request message for GetSettings.
type GetSettingsRequest struct {
	// Required. The name of the settings to retrieve.
	// Formats:
	//  * `organizations/{organization}/settings`
	//  * `folders/{folder}/settings`
	//  * `projects/{project}/settings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/settings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/settings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/settings`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSettingsRequest) Reset()         { *m = GetSettingsRequest{} }
func (m *GetSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*GetSettingsRequest) ProtoMessage()    {}
func (*GetSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{2}
}

func (m *GetSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSettingsRequest.Unmarshal(m, b)
}
func (m *GetSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSettingsRequest.Marshal(b, m, deterministic)
}
func (m *GetSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSettingsRequest.Merge(m, src)
}
func (m *GetSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_GetSettingsRequest.Size(m)
}
func (m *GetSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSettingsRequest proto.InternalMessageInfo

func (m *GetSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for UpdateSettings.
type UpdateSettingsRequest struct {
	// Required. The settings to update.
	//
	// The settings' `name` field is used to identify the settings to be updated.
	// Formats:
	//  * `organizations/{organization}/settings`
	//  * `folders/{folder}/settings`
	//  * `projects/{project}/settings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/settings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/settings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/settings`
	Settings *Settings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
	// The list of fields to be updated on the settings.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSettingsRequest) Reset()         { *m = UpdateSettingsRequest{} }
func (m *UpdateSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSettingsRequest) ProtoMessage()    {}
func (*UpdateSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{3}
}

func (m *UpdateSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSettingsRequest.Unmarshal(m, b)
}
func (m *UpdateSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSettingsRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSettingsRequest.Merge(m, src)
}
func (m *UpdateSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSettingsRequest.Size(m)
}
func (m *UpdateSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSettingsRequest proto.InternalMessageInfo

func (m *UpdateSettingsRequest) GetSettings() *Settings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (m *UpdateSettingsRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for ResetSettings.
type ResetSettingsRequest struct {
	// Required. The name of the settings to reset.
	// Formats:
	//  * `organizations/{organization}/settings`
	//  * `folders/{folder}/settings`
	//  * `projects/{project}/settings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/settings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/settings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/settings`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A fingerprint used for optimistic concurrency. If none is provided,
	// then the existing settings will be blindly overwritten.
	Etag                 string   `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResetSettingsRequest) Reset()         { *m = ResetSettingsRequest{} }
func (m *ResetSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*ResetSettingsRequest) ProtoMessage()    {}
func (*ResetSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{4}
}

func (m *ResetSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResetSettingsRequest.Unmarshal(m, b)
}
func (m *ResetSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResetSettingsRequest.Marshal(b, m, deterministic)
}
func (m *ResetSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetSettingsRequest.Merge(m, src)
}
func (m *ResetSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_ResetSettingsRequest.Size(m)
}
func (m *ResetSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResetSettingsRequest proto.InternalMessageInfo

func (m *ResetSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ResetSettingsRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Request message for BatchGetSettings.
type BatchGetSettingsRequest struct {
	// Required. The relative resource name of the organization shared by all of the
	// settings being retrieved.
	// Format:
	//  * `organizations/{organization}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The names of the settings to retrieve.
	// A maximum of 1000 settings can be retrieved in a batch.
	// Formats:
	//  * `organizations/{organization}/settings`
	//  * `folders/{folder}/settings`
	//  * `projects/{project}/settings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/settings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/settings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/settings`
	Names                []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchGetSettingsRequest) Reset()         { *m = BatchGetSettingsRequest{} }
func (m *BatchGetSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchGetSettingsRequest) ProtoMessage()    {}
func (*BatchGetSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{5}
}

func (m *BatchGetSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchGetSettingsRequest.Unmarshal(m, b)
}
func (m *BatchGetSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchGetSettingsRequest.Marshal(b, m, deterministic)
}
func (m *BatchGetSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetSettingsRequest.Merge(m, src)
}
func (m *BatchGetSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchGetSettingsRequest.Size(m)
}
func (m *BatchGetSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetSettingsRequest proto.InternalMessageInfo

func (m *BatchGetSettingsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchGetSettingsRequest) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

// Response message for BatchGetSettings.
type BatchGetSettingsResponse struct {
	// Settings requested.
	Settings             []*Settings `protobuf:"bytes,1,rep,name=settings,proto3" json:"settings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BatchGetSettingsResponse) Reset()         { *m = BatchGetSettingsResponse{} }
func (m *BatchGetSettingsResponse) String() string { return proto.CompactTextString(m) }
func (*BatchGetSettingsResponse) ProtoMessage()    {}
func (*BatchGetSettingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{6}
}

func (m *BatchGetSettingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchGetSettingsResponse.Unmarshal(m, b)
}
func (m *BatchGetSettingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchGetSettingsResponse.Marshal(b, m, deterministic)
}
func (m *BatchGetSettingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetSettingsResponse.Merge(m, src)
}
func (m *BatchGetSettingsResponse) XXX_Size() int {
	return xxx_messageInfo_BatchGetSettingsResponse.Size(m)
}
func (m *BatchGetSettingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetSettingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetSettingsResponse proto.InternalMessageInfo

func (m *BatchGetSettingsResponse) GetSettings() []*Settings {
	if m != nil {
		return m.Settings
	}
	return nil
}

// Request message for CalculateEffectiveSettings.
type CalculateEffectiveSettingsRequest struct {
	// Required. The name of the effective settings to retrieve.
	// Formats:
	//  * `organizations/{organization}/effectiveSettings`
	//  * `folders/{folder}/effectiveSettings`
	//  * `projects/{project}/effectiveSettings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/effectiveSettings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/effectiveSettings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/effectiveSettings`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CalculateEffectiveSettingsRequest) Reset()         { *m = CalculateEffectiveSettingsRequest{} }
func (m *CalculateEffectiveSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*CalculateEffectiveSettingsRequest) ProtoMessage()    {}
func (*CalculateEffectiveSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{7}
}

func (m *CalculateEffectiveSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CalculateEffectiveSettingsRequest.Unmarshal(m, b)
}
func (m *CalculateEffectiveSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CalculateEffectiveSettingsRequest.Marshal(b, m, deterministic)
}
func (m *CalculateEffectiveSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CalculateEffectiveSettingsRequest.Merge(m, src)
}
func (m *CalculateEffectiveSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_CalculateEffectiveSettingsRequest.Size(m)
}
func (m *CalculateEffectiveSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CalculateEffectiveSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CalculateEffectiveSettingsRequest proto.InternalMessageInfo

func (m *CalculateEffectiveSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BatchGetEffectiveSettings.
type BatchCalculateEffectiveSettingsRequest struct {
	// Required. The relative resource name of the organization shared by all of the
	// settings being retrieved.
	// Format:
	//  * `organizations/{organization}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The requests specifying the effective settings to retrieve.
	// A maximum of 1000 effective settings can be retrieved in a batch.
	Requests             []*CalculateEffectiveSettingsRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *BatchCalculateEffectiveSettingsRequest) Reset() {
	*m = BatchCalculateEffectiveSettingsRequest{}
}
func (m *BatchCalculateEffectiveSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchCalculateEffectiveSettingsRequest) ProtoMessage()    {}
func (*BatchCalculateEffectiveSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{8}
}

func (m *BatchCalculateEffectiveSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCalculateEffectiveSettingsRequest.Unmarshal(m, b)
}
func (m *BatchCalculateEffectiveSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCalculateEffectiveSettingsRequest.Marshal(b, m, deterministic)
}
func (m *BatchCalculateEffectiveSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCalculateEffectiveSettingsRequest.Merge(m, src)
}
func (m *BatchCalculateEffectiveSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchCalculateEffectiveSettingsRequest.Size(m)
}
func (m *BatchCalculateEffectiveSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCalculateEffectiveSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCalculateEffectiveSettingsRequest proto.InternalMessageInfo

func (m *BatchCalculateEffectiveSettingsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchCalculateEffectiveSettingsRequest) GetRequests() []*CalculateEffectiveSettingsRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Response message for BatchGetEffectiveSettings.
type BatchCalculateEffectiveSettingsResponse struct {
	// Settings requested.
	Settings             []*Settings `protobuf:"bytes,1,rep,name=settings,proto3" json:"settings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BatchCalculateEffectiveSettingsResponse) Reset() {
	*m = BatchCalculateEffectiveSettingsResponse{}
}
func (m *BatchCalculateEffectiveSettingsResponse) String() string { return proto.CompactTextString(m) }
func (*BatchCalculateEffectiveSettingsResponse) ProtoMessage()    {}
func (*BatchCalculateEffectiveSettingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{9}
}

func (m *BatchCalculateEffectiveSettingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCalculateEffectiveSettingsResponse.Unmarshal(m, b)
}
func (m *BatchCalculateEffectiveSettingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCalculateEffectiveSettingsResponse.Marshal(b, m, deterministic)
}
func (m *BatchCalculateEffectiveSettingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCalculateEffectiveSettingsResponse.Merge(m, src)
}
func (m *BatchCalculateEffectiveSettingsResponse) XXX_Size() int {
	return xxx_messageInfo_BatchCalculateEffectiveSettingsResponse.Size(m)
}
func (m *BatchCalculateEffectiveSettingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCalculateEffectiveSettingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCalculateEffectiveSettingsResponse proto.InternalMessageInfo

func (m *BatchCalculateEffectiveSettingsResponse) GetSettings() []*Settings {
	if m != nil {
		return m.Settings
	}
	return nil
}

// Request message for GetComponentSettings.
type GetComponentSettingsRequest struct {
	// Required. The component settings to retrieve.
	//
	// Formats:
	//  * `organizations/{organization}/components/{component}/settings`
	//  * `folders/{folder}/components/{component}/settings`
	//  * `projects/{project}/components/{component}/settings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/components/{component}/settings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/components/{component}/settings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/components/{component}/settings`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetComponentSettingsRequest) Reset()         { *m = GetComponentSettingsRequest{} }
func (m *GetComponentSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*GetComponentSettingsRequest) ProtoMessage()    {}
func (*GetComponentSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{10}
}

func (m *GetComponentSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetComponentSettingsRequest.Unmarshal(m, b)
}
func (m *GetComponentSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetComponentSettingsRequest.Marshal(b, m, deterministic)
}
func (m *GetComponentSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetComponentSettingsRequest.Merge(m, src)
}
func (m *GetComponentSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_GetComponentSettingsRequest.Size(m)
}
func (m *GetComponentSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetComponentSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetComponentSettingsRequest proto.InternalMessageInfo

func (m *GetComponentSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for UpdateComponentSettings.
type UpdateComponentSettingsRequest struct {
	// Required. The component settings to update.
	//
	// The component settings' `name` field is used to identify the component
	// settings to be updated. Formats:
	//  * `organizations/{organization}/components/{component}/settings`
	//  * `folders/{folder}/components/{component}/settings`
	//  * `projects/{project}/components/{component}/settings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/components/{component}/settings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/components/{component}/settings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/components/{component}/settings`
	ComponentSettings *ComponentSettings `protobuf:"bytes,1,opt,name=component_settings,json=componentSettings,proto3" json:"component_settings,omitempty"`
	// The list of fields to be updated on the component settings resource.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateComponentSettingsRequest) Reset()         { *m = UpdateComponentSettingsRequest{} }
func (m *UpdateComponentSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateComponentSettingsRequest) ProtoMessage()    {}
func (*UpdateComponentSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{11}
}

func (m *UpdateComponentSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateComponentSettingsRequest.Unmarshal(m, b)
}
func (m *UpdateComponentSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateComponentSettingsRequest.Marshal(b, m, deterministic)
}
func (m *UpdateComponentSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateComponentSettingsRequest.Merge(m, src)
}
func (m *UpdateComponentSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateComponentSettingsRequest.Size(m)
}
func (m *UpdateComponentSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateComponentSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateComponentSettingsRequest proto.InternalMessageInfo

func (m *UpdateComponentSettingsRequest) GetComponentSettings() *ComponentSettings {
	if m != nil {
		return m.ComponentSettings
	}
	return nil
}

func (m *UpdateComponentSettingsRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for ResetComponentSettings.
type ResetComponentSettingsRequest struct {
	// Required. The component settings to reset.
	//
	// Formats:
	//  * `organizations/{organization}/components/{component}/settings`
	//  * `folders/{folder}/components/{component}/settings`
	//  * `projects/{project}/components/{component}/settings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/components/{component}/settings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/components/{component}/settings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/components/{component}/settings`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An fingerprint used for optimistic concurrency. If none is provided,
	// then the existing settings will be blindly overwritten.
	Etag                 string   `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResetComponentSettingsRequest) Reset()         { *m = ResetComponentSettingsRequest{} }
func (m *ResetComponentSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*ResetComponentSettingsRequest) ProtoMessage()    {}
func (*ResetComponentSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{12}
}

func (m *ResetComponentSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResetComponentSettingsRequest.Unmarshal(m, b)
}
func (m *ResetComponentSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResetComponentSettingsRequest.Marshal(b, m, deterministic)
}
func (m *ResetComponentSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetComponentSettingsRequest.Merge(m, src)
}
func (m *ResetComponentSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_ResetComponentSettingsRequest.Size(m)
}
func (m *ResetComponentSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetComponentSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResetComponentSettingsRequest proto.InternalMessageInfo

func (m *ResetComponentSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ResetComponentSettingsRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Request message for CalculateEffectiveComponentSettings.
type CalculateEffectiveComponentSettingsRequest struct {
	// Required. The effective component settings to retrieve.
	//
	// Formats:
	//  * `organizations/{organization}/components/{component}/settings`
	//  * `folders/{folder}/components/{component}/settings`
	//  * `projects/{project}/components/{component}/settings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/components/{component}/settings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/components/{component}/settings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/components/{component}/settings`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CalculateEffectiveComponentSettingsRequest) Reset() {
	*m = CalculateEffectiveComponentSettingsRequest{}
}
func (m *CalculateEffectiveComponentSettingsRequest) String() string {
	return proto.CompactTextString(m)
}
func (*CalculateEffectiveComponentSettingsRequest) ProtoMessage() {}
func (*CalculateEffectiveComponentSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{13}
}

func (m *CalculateEffectiveComponentSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CalculateEffectiveComponentSettingsRequest.Unmarshal(m, b)
}
func (m *CalculateEffectiveComponentSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CalculateEffectiveComponentSettingsRequest.Marshal(b, m, deterministic)
}
func (m *CalculateEffectiveComponentSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CalculateEffectiveComponentSettingsRequest.Merge(m, src)
}
func (m *CalculateEffectiveComponentSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_CalculateEffectiveComponentSettingsRequest.Size(m)
}
func (m *CalculateEffectiveComponentSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CalculateEffectiveComponentSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CalculateEffectiveComponentSettingsRequest proto.InternalMessageInfo

func (m *CalculateEffectiveComponentSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListDetectors.
type ListDetectorsRequest struct {
	// Required. The parent, which owns this collection of detectors.
	// Format:
	//  * `organizations/{organization}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Filters to apply on the response. Filters can be applied on:
	//  * components
	//  * labels
	//  * billing tiers
	//
	// Component filters will retrieve only detectors for the components
	// specified. Label filters will retrieve only detectors that match one of the
	// labels specified. Billing tier filters will retrieve only detectors for
	// that billing tier.
	//
	// The filters
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of detectors to return. The service may return fewer
	// than this value. If unspecified, at most 100 detectors will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDetectors` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDetectors` must
	// match the call that provided the page token.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDetectorsRequest) Reset()         { *m = ListDetectorsRequest{} }
func (m *ListDetectorsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDetectorsRequest) ProtoMessage()    {}
func (*ListDetectorsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{14}
}

func (m *ListDetectorsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDetectorsRequest.Unmarshal(m, b)
}
func (m *ListDetectorsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDetectorsRequest.Marshal(b, m, deterministic)
}
func (m *ListDetectorsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDetectorsRequest.Merge(m, src)
}
func (m *ListDetectorsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDetectorsRequest.Size(m)
}
func (m *ListDetectorsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDetectorsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDetectorsRequest proto.InternalMessageInfo

func (m *ListDetectorsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDetectorsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDetectorsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDetectorsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for ListDetectors.
type ListDetectorsResponse struct {
	// The detectors from the specified organization.
	Detectors []*Detector `protobuf:"bytes,1,rep,name=detectors,proto3" json:"detectors,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDetectorsResponse) Reset()         { *m = ListDetectorsResponse{} }
func (m *ListDetectorsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDetectorsResponse) ProtoMessage()    {}
func (*ListDetectorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{15}
}

func (m *ListDetectorsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDetectorsResponse.Unmarshal(m, b)
}
func (m *ListDetectorsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDetectorsResponse.Marshal(b, m, deterministic)
}
func (m *ListDetectorsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDetectorsResponse.Merge(m, src)
}
func (m *ListDetectorsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDetectorsResponse.Size(m)
}
func (m *ListDetectorsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDetectorsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDetectorsResponse proto.InternalMessageInfo

func (m *ListDetectorsResponse) GetDetectors() []*Detector {
	if m != nil {
		return m.Detectors
	}
	return nil
}

func (m *ListDetectorsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for ListComponents.
type ListComponentsRequest struct {
	// Required. The parent, which owns this collection of components.
	// Format:
	//  * `organizations/{organization}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of components to return. The service may return fewer
	// than this value. If unspecified, at most 100 components will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListComponents` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListComponents` must
	// match the call that provided the page token.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListComponentsRequest) Reset()         { *m = ListComponentsRequest{} }
func (m *ListComponentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListComponentsRequest) ProtoMessage()    {}
func (*ListComponentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{16}
}

func (m *ListComponentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListComponentsRequest.Unmarshal(m, b)
}
func (m *ListComponentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListComponentsRequest.Marshal(b, m, deterministic)
}
func (m *ListComponentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListComponentsRequest.Merge(m, src)
}
func (m *ListComponentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListComponentsRequest.Size(m)
}
func (m *ListComponentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListComponentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListComponentsRequest proto.InternalMessageInfo

func (m *ListComponentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListComponentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListComponentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for ListComponents.
type ListComponentsResponse struct {
	// The components from the specified organization.
	Components []string `protobuf:"bytes,1,rep,name=components,proto3" json:"components,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListComponentsResponse) Reset()         { *m = ListComponentsResponse{} }
func (m *ListComponentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListComponentsResponse) ProtoMessage()    {}
func (*ListComponentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3dca974be15dbcc5, []int{17}
}

func (m *ListComponentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListComponentsResponse.Unmarshal(m, b)
}
func (m *ListComponentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListComponentsResponse.Marshal(b, m, deterministic)
}
func (m *ListComponentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListComponentsResponse.Merge(m, src)
}
func (m *ListComponentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListComponentsResponse.Size(m)
}
func (m *ListComponentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListComponentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListComponentsResponse proto.InternalMessageInfo

func (m *ListComponentsResponse) GetComponents() []string {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *ListComponentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetServiceAccountRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.GetServiceAccountRequest")
	proto.RegisterType((*ServiceAccount)(nil), "google.cloud.securitycenter.settings.v1beta1.ServiceAccount")
	proto.RegisterType((*GetSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.GetSettingsRequest")
	proto.RegisterType((*UpdateSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.UpdateSettingsRequest")
	proto.RegisterType((*ResetSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.ResetSettingsRequest")
	proto.RegisterType((*BatchGetSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.BatchGetSettingsRequest")
	proto.RegisterType((*BatchGetSettingsResponse)(nil), "google.cloud.securitycenter.settings.v1beta1.BatchGetSettingsResponse")
	proto.RegisterType((*CalculateEffectiveSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.CalculateEffectiveSettingsRequest")
	proto.RegisterType((*BatchCalculateEffectiveSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.BatchCalculateEffectiveSettingsRequest")
	proto.RegisterType((*BatchCalculateEffectiveSettingsResponse)(nil), "google.cloud.securitycenter.settings.v1beta1.BatchCalculateEffectiveSettingsResponse")
	proto.RegisterType((*GetComponentSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.GetComponentSettingsRequest")
	proto.RegisterType((*UpdateComponentSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.UpdateComponentSettingsRequest")
	proto.RegisterType((*ResetComponentSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.ResetComponentSettingsRequest")
	proto.RegisterType((*CalculateEffectiveComponentSettingsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.CalculateEffectiveComponentSettingsRequest")
	proto.RegisterType((*ListDetectorsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.ListDetectorsRequest")
	proto.RegisterType((*ListDetectorsResponse)(nil), "google.cloud.securitycenter.settings.v1beta1.ListDetectorsResponse")
	proto.RegisterType((*ListComponentsRequest)(nil), "google.cloud.securitycenter.settings.v1beta1.ListComponentsRequest")
	proto.RegisterType((*ListComponentsResponse)(nil), "google.cloud.securitycenter.settings.v1beta1.ListComponentsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/securitycenter/settings/v1beta1/securitycenter_settings_service.proto", fileDescriptor_3dca974be15dbcc5)
}

var fileDescriptor_3dca974be15dbcc5 = []byte{
	// 1836 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5a, 0x4d, 0x6c, 0x13, 0x47,
	0x14, 0xd6, 0xda, 0x49, 0x44, 0x26, 0x22, 0x94, 0xa7, 0x10, 0x52, 0xd3, 0x40, 0xba, 0x95, 0x20,
	0x82, 0x60, 0x93, 0xe5, 0x27, 0xe0, 0x50, 0xc0, 0x76, 0x7e, 0x80, 0x04, 0x08, 0xc6, 0x84, 0x34,
	0x44, 0x75, 0x37, 0x9b, 0x89, 0x63, 0x62, 0xef, 0xba, 0xbb, 0xe3, 0xa4, 0x09, 0x8a, 0x54, 0xaa,
	0x5e, 0x2a, 0xf5, 0x56, 0x55, 0x55, 0x2f, 0x95, 0x7a, 0x68, 0x0f, 0x95, 0x2a, 0x2e, 0x3d, 0xb6,
	0x87, 0x5e, 0x39, 0xc2, 0x2d, 0x97, 0x42, 0x7f, 0x84, 0x84, 0x90, 0xaa, 0xf6, 0xd4, 0xf6, 0x54,
	0x79, 0x76, 0xd7, 0xfb, 0xe3, 0xdd, 0xb5, 0x77, 0xed, 0x70, 0x8b, 0x77, 0xde, 0x7c, 0xef, 0xcd,
	0x7b, 0xdf, 0x7b, 0xf3, 0x66, 0x26, 0x28, 0x9d, 0x93, 0xa4, 0x5c, 0x01, 0xc7, 0x84, 0x82, 0x54,
	0x5e, 0x8a, 0x29, 0x58, 0x28, 0xcb, 0x79, 0xb2, 0x21, 0x60, 0x91, 0x60, 0x39, 0xa6, 0x60, 0x42,
	0xf2, 0x62, 0x4e, 0x89, 0xad, 0x0d, 0x2f, 0x62, 0xc2, 0x0f, 0xdb, 0xc6, 0xb3, 0xfa, 0x78, 0x56,
	0xc1, 0xf2, 0x5a, 0x5e, 0xc0, 0xd1, 0x92, 0x2c, 0x11, 0x09, 0x86, 0x54, 0xcc, 0x28, 0xc5, 0x8c,
	0x5a, 0xe7, 0x44, 0xf5, 0x39, 0x51, 0x0d, 0x33, 0xf2, 0x86, 0x66, 0x01, 0x5f, 0xca, 0xc7, 0x78,
	0x51, 0x94, 0x08, 0x4f, 0xf2, 0x92, 0xa8, 0xa8, 0x58, 0x91, 0xfd, 0xa6, 0x51, 0xa1, 0x90, 0xc7,
	0x22, 0xd1, 0x06, 0x0e, 0x99, 0x06, 0x96, 0xf3, 0xb8, 0xb0, 0x94, 0x5d, 0xc4, 0x2b, 0xfc, 0x5a,
	0x5e, 0x92, 0x35, 0x81, 0xd7, 0x4d, 0x02, 0x32, 0x56, 0xa4, 0xb2, 0xac, 0x1b, 0x18, 0x19, 0xf7,
	0xb5, 0x68, 0x41, 0x2a, 0x96, 0x24, 0x11, 0x8b, 0xa4, 0xba, 0x5e, 0x0d, 0x66, 0xd4, 0x17, 0xcc,
	0x12, 0x26, 0x58, 0x20, 0x55, 0xf3, 0x46, 0x7d, 0x3a, 0xde, 0xa2, 0xf9, 0x80, 0x36, 0x99, 0xfe,
	0x5a, 0x2c, 0x2f, 0xc7, 0x70, 0xb1, 0x44, 0x36, 0xb4, 0xc1, 0x01, 0xfb, 0xa0, 0xea, 0x9e, 0x22,
	0xaf, 0xac, 0xaa, 0x12, 0xec, 0x12, 0xea, 0x9b, 0xc4, 0xe4, 0x96, 0x1a, 0xb4, 0x84, 0x20, 0x48,
	0x65, 0x91, 0xa4, 0xf1, 0xfb, 0x65, 0xac, 0x10, 0xb8, 0x8c, 0xda, 0x44, 0xbe, 0x88, 0xfb, 0x98,
	0x01, 0x66, 0xb0, 0x33, 0x79, 0xea, 0x69, 0x22, 0xf4, 0x5f, 0x22, 0x8a, 0x86, 0x6c, 0x51, 0x54,
	0x55, 0xf0, 0xa5, 0xbc, 0x12, 0x15, 0xa4, 0x62, 0xcc, 0x06, 0x45, 0x11, 0xd8, 0xef, 0x19, 0xd4,
	0x6d, 0x1d, 0x00, 0x30, 0x83, 0xab, 0x62, 0x70, 0x04, 0xed, 0xd1, 0xe8, 0x93, 0xe5, 0x55, 0xb1,
	0xbe, 0x10, 0x1d, 0xee, 0x56, 0x2c, 0x93, 0xe3, 0xef, 0xbe, 0x48, 0xdc, 0xf5, 0x67, 0x08, 0x1c,
	0x93, 0xe4, 0x1c, 0x2f, 0xe6, 0x37, 0x55, 0x4a, 0xc5, 0xee, 0x9b, 0x7f, 0x6e, 0xc5, 0xac, 0xf8,
	0xec, 0x1c, 0x02, 0xea, 0x15, 0xd5, 0xd3, 0xba, 0x3f, 0x92, 0x16, 0x7f, 0x44, 0xa9, 0x3f, 0x06,
	0xd1, 0xe1, 0x7a, 0x66, 0x68, 0x20, 0x55, 0x4f, 0xec, 0xbb, 0x5d, 0x5a, 0xe2, 0x09, 0xb6, 0xa3,
	0xdf, 0x41, 0xbb, 0xf4, 0xd0, 0x52, 0x0d, 0x5d, 0xdc, 0x99, 0xa8, 0x9f, 0xec, 0x89, 0xea, 0x80,
	0xc9, 0xf0, 0xd3, 0x44, 0x28, 0x5d, 0x05, 0x83, 0x51, 0xd4, 0x55, 0xa6, 0x1a, 0x69, 0xdc, 0xa9,
	0x47, 0xbb, 0xb8, 0x88, 0x8e, 0xad, 0x53, 0x23, 0x3a, 0x51, 0xa1, 0xc6, 0x35, 0x5e, 0x59, 0x4d,
	0x23, 0x55, 0xbc, 0xf2, 0x37, 0x2b, 0xa2, 0x9e, 0x34, 0x56, 0x76, 0xc4, 0x17, 0x15, 0x0a, 0x60,
	0xc2, 0xe7, 0xb4, 0x18, 0xd3, 0xbf, 0xd9, 0x07, 0x0c, 0xda, 0x9f, 0xe4, 0x89, 0xb0, 0xe2, 0xe0,
	0xff, 0x19, 0xd4, 0x51, 0xe2, 0x65, 0x2c, 0x12, 0x4d, 0xeb, 0x59, 0xaa, 0x95, 0x43, 0x27, 0xa8,
	0x7f, 0xf4, 0xc4, 0x2e, 0xf2, 0x22, 0x9f, 0xab, 0xd5, 0x7d, 0xc3, 0x14, 0xef, 0xb4, 0x86, 0x03,
	0x3d, 0xa8, 0xbd, 0x62, 0x89, 0xd2, 0x17, 0x1a, 0x08, 0x0f, 0x76, 0xa6, 0xd5, 0x1f, 0xac, 0x88,
	0xfa, 0x6a, 0x4d, 0x50, 0x4a, 0x92, 0xa8, 0x60, 0x48, 0x5b, 0xa2, 0x14, 0x0e, 0x1e, 0x25, 0x23,
	0x40, 0x6c, 0x0e, 0xbd, 0x99, 0xe2, 0x0b, 0x42, 0xb9, 0xc0, 0x13, 0x3c, 0xbe, 0xbc, 0x8c, 0x05,
	0x92, 0x5f, 0xc3, 0x3b, 0x41, 0xbe, 0xe7, 0x0c, 0x3a, 0x4c, 0x57, 0x56, 0x5f, 0x5d, 0xeb, 0x7d,
	0xbd, 0x8a, 0x76, 0xc9, 0x2a, 0xb8, 0xea, 0xee, 0x2e, 0xee, 0x86, 0x3f, 0xcf, 0xd5, 0x35, 0x3a,
	0x5d, 0x55, 0xc0, 0x6e, 0xa1, 0x23, 0x75, 0x17, 0xba, 0x83, 0x11, 0xbd, 0x87, 0x0e, 0x4c, 0x62,
	0x92, 0xd2, 0x77, 0x0b, 0xbb, 0x73, 0xa7, 0x2c, 0xb1, 0x1c, 0xa1, 0xae, 0x1d, 0x46, 0x31, 0xef,
	0x58, 0xd6, 0xa2, 0xa9, 0x41, 0x7d, 0xcc, 0xa0, 0x83, 0x6a, 0x45, 0x71, 0xd5, 0xa7, 0x20, 0xa8,
	0xdd, 0xb9, 0xb4, 0x22, 0x73, 0xd1, 0x67, 0x10, 0xec, 0x3a, 0xd4, 0x6a, 0xb3, 0x57, 0xb0, 0x7f,
	0x6f, 0xae, 0xec, 0x7c, 0xc8, 0xa0, 0x7e, 0x5a, 0x77, 0x5e, 0x89, 0x0f, 0x1d, 0x2b, 0xd1, 0x06,
	0x3a, 0x5a, 0xcb, 0x9e, 0x57, 0x13, 0xd2, 0x1f, 0x19, 0xd4, 0x33, 0x9d, 0x57, 0xc8, 0x98, 0xd6,
	0x27, 0xec, 0x60, 0x56, 0xf6, 0xa2, 0x8e, 0xe5, 0x7c, 0x81, 0x60, 0x59, 0x5b, 0xbb, 0xf6, 0x0b,
	0x0e, 0xa0, 0xce, 0x12, 0x9f, 0xc3, 0x59, 0x25, 0xbf, 0x89, 0xfb, 0xc2, 0x03, 0xcc, 0x60, 0x7b,
	0x7a, 0x57, 0xe5, 0xc3, 0xad, 0xfc, 0x26, 0x86, 0x7e, 0x84, 0xe8, 0x20, 0x91, 0x56, 0xb1, 0xd8,
	0xd7, 0x46, 0x27, 0x52, 0xf1, 0x4c, 0xe5, 0x03, 0xfb, 0x39, 0x83, 0xf6, 0xd9, 0xcc, 0xd7, 0x72,
	0x2d, 0x83, 0x3a, 0xf5, 0xde, 0x27, 0x60, 0xb2, 0xe9, 0x98, 0x69, 0x03, 0x08, 0x0e, 0xa3, 0x3d,
	0x22, 0xfe, 0x80, 0x64, 0x4d, 0x36, 0xa9, 0x8b, 0xd9, 0x5d, 0xf9, 0x3c, 0x53, 0xb5, 0xeb, 0x1b,
	0xcd, 0xae, 0xaa, 0xdb, 0x77, 0xd0, 0xaf, 0x16, 0xff, 0x85, 0x3c, 0xfd, 0x17, 0xb6, 0xfb, 0xef,
	0x3d, 0xd4, 0x6b, 0x37, 0x53, 0xf3, 0xdf, 0x41, 0x84, 0xaa, 0x89, 0xa6, 0x3a, 0xb0, 0x33, 0x6d,
	0xfa, 0xd2, 0xa8, 0x27, 0xb8, 0x8f, 0x4f, 0xa2, 0xfe, 0x5b, 0x9a, 0xa7, 0x53, 0xd4, 0xd3, 0x3a,
	0x03, 0xb5, 0xae, 0x09, 0x9e, 0x31, 0x68, 0x6f, 0x4d, 0x63, 0x08, 0x13, 0xfe, 0x82, 0xe5, 0xd6,
	0x59, 0x46, 0xce, 0xfb, 0xad, 0xb0, 0x96, 0xee, 0x6c, 0x62, 0x3b, 0x41, 0xf3, 0xe4, 0xa3, 0x27,
	0xbf, 0x7f, 0x16, 0x3a, 0x07, 0x23, 0xb5, 0x3d, 0xf2, 0xfd, 0xca, 0xf0, 0xdb, 0xd6, 0x8e, 0xef,
	0xa8, 0xad, 0xc9, 0xdb, 0x82, 0x7f, 0xc3, 0xa8, 0xcb, 0xb4, 0xc7, 0xc3, 0xa5, 0x00, 0xab, 0xb3,
	0x54, 0x81, 0x48, 0xc0, 0x9d, 0x83, 0xfd, 0x33, 0x64, 0x5e, 0xd2, 0xb3, 0x10, 0x0c, 0x37, 0xbe,
	0x26, 0x55, 0x6c, 0x6b, 0xfe, 0x38, 0x1c, 0x73, 0x9b, 0xb4, 0x2c, 0x15, 0x96, 0xb0, 0x6c, 0x15,
	0x8f, 0xc2, 0x90, 0x9b, 0x78, 0x49, 0x96, 0xee, 0x61, 0x81, 0x58, 0xe5, 0xc7, 0x21, 0xd5, 0x80,
	0x7c, 0x41, 0x12, 0xaa, 0xa6, 0x09, 0x85, 0xb2, 0x42, 0xec, 0x6a, 0x53, 0x90, 0x68, 0x00, 0x46,
	0xc6, 0x39, 0x2f, 0x90, 0x04, 0x5c, 0x6c, 0x00, 0x64, 0x53, 0x12, 0xb1, 0x1b, 0x04, 0x3c, 0x68,
	0x47, 0xdd, 0xd6, 0x3e, 0x1c, 0x52, 0xfe, 0x82, 0xe7, 0xd8, 0xc5, 0x07, 0x66, 0xc0, 0x5f, 0xe1,
	0xed, 0x44, 0x8f, 0x3e, 0x3c, 0x64, 0xda, 0x38, 0x29, 0x23, 0x9e, 0x84, 0xb9, 0xb8, 0xc3, 0x8a,
	0xab, 0x70, 0xde, 0xd4, 0x88, 0x57, 0x1b, 0x93, 0xf9, 0x4b, 0xdc, 0xa9, 0xba, 0x38, 0x0e, 0x6c,
	0x31, 0x21, 0x24, 0xb8, 0xd3, 0x75, 0x11, 0x9c, 0x08, 0x64, 0x82, 0x98, 0xe3, 0xa6, 0xfd, 0x40,
	0xd4, 0xe3, 0x94, 0x09, 0x79, 0x96, 0xbb, 0xea, 0x07, 0xd9, 0x9b, 0x66, 0x26, 0xdc, 0x0c, 0x77,
	0xd9, 0x0f, 0xae, 0x17, 0xf3, 0x0c, 0x54, 0xf8, 0xb4, 0x0d, 0xed, 0xb6, 0x1c, 0xae, 0x20, 0xe9,
	0x8f, 0x3d, 0x4e, 0x27, 0xb3, 0x48, 0x6f, 0x4d, 0x8b, 0x35, 0x5e, 0x2c, 0x91, 0x0d, 0xf6, 0xab,
	0x30, 0xa5, 0xd2, 0x17, 0x61, 0x76, 0xc4, 0x77, 0x71, 0x89, 0xcb, 0x15, 0x4d, 0x71, 0xe6, 0xe8,
	0xfc, 0x19, 0x76, 0xd8, 0x47, 0x95, 0x31, 0xe6, 0x8d, 0xb0, 0x9c, 0x9f, 0x72, 0x63, 0x4c, 0xbc,
	0xce, 0x5e, 0x69, 0x41, 0xdd, 0x31, 0xf0, 0xa6, 0xd9, 0xc9, 0xa6, 0x0b, 0x90, 0x81, 0x76, 0x95,
	0x1d, 0x6f, 0xb2, 0x12, 0x55, 0xb1, 0xe0, 0x39, 0x83, 0x5e, 0xb3, 0x9f, 0x3b, 0x61, 0xdc, 0x1f,
	0x23, 0x5c, 0x8e, 0xce, 0x91, 0x89, 0x66, 0x61, 0xd4, 0x06, 0x84, 0x1d, 0xa3, 0x1c, 0xba, 0x00,
	0xe7, 0x1d, 0x56, 0xad, 0x76, 0x3e, 0x76, 0x12, 0x6d, 0x55, 0x25, 0xe3, 0x8b, 0x1a, 0x2a, 0x7c,
	0xd2, 0x8e, 0x22, 0xee, 0x27, 0x33, 0x68, 0xf5, 0xb9, 0x30, 0x70, 0x51, 0x7e, 0x16, 0x36, 0x6f,
	0xcb, 0x4f, 0xc2, 0x30, 0xd6, 0x68, 0xe6, 0x60, 0xbb, 0x29, 0x5b, 0x71, 0x41, 0x37, 0x73, 0xfe,
	0x12, 0x5c, 0xa8, 0x9f, 0x43, 0x9e, 0x08, 0x8d, 0x6d, 0x80, 0x9e, 0x10, 0x73, 0x30, 0x1b, 0x3c,
	0xaf, 0x3c, 0x91, 0x67, 0x21, 0x13, 0x34, 0xc3, 0x3c, 0x71, 0x33, 0x90, 0x0e, 0x96, 0x6b, 0x5e,
	0xa8, 0xf0, 0x6d, 0x08, 0x1d, 0xaa, 0x73, 0x55, 0x00, 0x99, 0x00, 0xd9, 0x53, 0x9f, 0x95, 0xb7,
	0x5b, 0x8c, 0xaa, 0xa5, 0xe8, 0x2c, 0x25, 0xeb, 0x0c, 0x3b, 0xe5, 0x23, 0x45, 0x6b, 0x3c, 0xa4,
	0xe6, 0x6a, 0x55, 0x5b, 0xa5, 0x3c, 0xfd, 0xda, 0x86, 0x7a, 0x9c, 0x2e, 0x35, 0xe0, 0x8a, 0xef,
	0xb6, 0xd9, 0xed, 0x14, 0x1d, 0x69, 0xf6, 0x32, 0x82, 0xfd, 0xc9, 0x92, 0xb1, 0x0f, 0xc3, 0xee,
	0x99, 0x66, 0xcf, 0x58, 0xe3, 0x14, 0x65, 0x69, 0x35, 0xe3, 0x70, 0xb6, 0x7e, 0xae, 0xba, 0xcc,
	0x1d, 0x85, 0x73, 0x0d, 0x10, 0xd6, 0x65, 0x72, 0x1a, 0x66, 0x82, 0xe7, 0xa7, 0x0b, 0xe6, 0x0c,
	0x5c, 0x0f, 0x9a, 0x99, 0x2e, 0x88, 0xd7, 0x61, 0x3a, 0x58, 0x4e, 0x3a, 0xe3, 0xc1, 0xcb, 0x0e,
	0xb4, 0xdf, 0xe5, 0x32, 0x0b, 0xa6, 0x83, 0xf4, 0xe7, 0x3b, 0x47, 0xb5, 0x9f, 0xdb, 0xb7, 0x13,
	0x07, 0x6b, 0xaf, 0xd5, 0x6a, 0x7a, 0xf7, 0x2f, 0xdb, 0xb9, 0x9b, 0x0e, 0x3e, 0x72, 0x78, 0x4a,
	0xf2, 0xc1, 0xcb, 0xb8, 0xc3, 0x85, 0xde, 0x3c, 0xcf, 0x4d, 0xf9, 0x50, 0x54, 0x8f, 0xbe, 0x8e,
	0x2a, 0x16, 0x1d, 0x5b, 0x77, 0x37, 0x15, 0x75, 0x59, 0xee, 0xa8, 0x63, 0x83, 0x13, 0x82, 0xe9,
	0xf0, 0x95, 0x0c, 0x8e, 0xaa, 0xd7, 0x39, 0x3e, 0x98, 0x6a, 0x1f, 0x39, 0xe3, 0xa8, 0xb8, 0xcc,
	0x65, 0x83, 0x29, 0x6e, 0x38, 0xb5, 0x9c, 0xd4, 0xc2, 0xcb, 0x36, 0xd4, 0xeb, 0x7c, 0xcd, 0x0a,
	0x53, 0x01, 0x8e, 0x22, 0xae, 0xc9, 0xe6, 0x76, 0x26, 0x79, 0xa9, 0x9e, 0x49, 0xfe, 0x08, 0xb3,
	0x63, 0xcd, 0xd5, 0x69, 0xa3, 0x23, 0x4f, 0xb1, 0x17, 0x82, 0x16, 0x6c, 0x03, 0x64, 0x8c, 0xbd,
	0x18, 0xb8, 0x72, 0x1b, 0x28, 0x77, 0xd9, 0xd9, 0x56, 0x97, 0x70, 0x03, 0xfc, 0x1d, 0x36, 0xd3,
	0xda, 0x5a, 0x6e, 0x40, 0xdf, 0x61, 0xd3, 0xad, 0x2c, 0xea, 0xc6, 0x09, 0xe7, 0xef, 0x76, 0xf4,
	0x56, 0x03, 0x77, 0xea, 0x30, 0xd7, 0xec, 0x01, 0x60, 0xe7, 0xaa, 0xfe, 0xc3, 0x36, 0x73, 0x83,
	0xf1, 0x75, 0x1b, 0xdc, 0x0c, 0x44, 0x5c, 0xcf, 0x46, 0xf7, 0x1a, 0x4c, 0xf9, 0xa4, 0xb0, 0x27,
	0x5c, 0x63, 0x7b, 0x74, 0xe3, 0x78, 0x18, 0x84, 0x16, 0xd1, 0xda, 0x53, 0x8d, 0x00, 0x7c, 0x4b,
	0x08, 0xee, 0xa9, 0x84, 0x87, 0x6c, 0x0b, 0xa8, 0xee, 0x79, 0xc0, 0xf8, 0x85, 0x41, 0xbb, 0x2d,
	0xaf, 0x21, 0x7e, 0x6f, 0x79, 0x9c, 0x5e, 0x82, 0x22, 0xa9, 0xa6, 0x30, 0xb4, 0xa3, 0xc2, 0xf8,
	0x76, 0x42, 0x7b, 0xaf, 0xa0, 0x6c, 0x3e, 0x03, 0xa7, 0x7c, 0x9c, 0x19, 0x8c, 0xf7, 0x97, 0xdf,
	0x18, 0xd4, 0x6d, 0x7d, 0xb0, 0x80, 0x00, 0xe6, 0xd5, 0xbc, 0xca, 0x44, 0xc6, 0x9a, 0x03, 0xd1,
	0x16, 0x39, 0x61, 0x5d, 0xe4, 0x08, 0x9c, 0xf6, 0xb1, 0x48, 0x23, 0xcc, 0x91, 0x9b, 0x8f, 0x12,
	0xfd, 0x9e, 0xcf, 0x79, 0x8f, 0x13, 0xd1, 0x15, 0x42, 0x4a, 0x4a, 0x3c, 0x16, 0x5b, 0x5f, 0x5f,
	0xb7, 0xbf, 0x12, 0xf1, 0x65, 0xb2, 0xa2, 0xfe, 0x87, 0xcf, 0xf1, 0x52, 0x81, 0x27, 0xcb, 0x92,
	0x5c, 0x4c, 0xfe, 0x10, 0x42, 0x27, 0x04, 0xa9, 0xe8, 0x6b, 0x99, 0xc9, 0x1e, 0xdb, 0x53, 0xcd,
	0x4c, 0x65, 0x4b, 0x9d, 0x61, 0xe6, 0x33, 0x1a, 0x4a, 0x4e, 0x2a, 0xf0, 0x62, 0x2e, 0x2a, 0xc9,
	0xb9, 0x58, 0x0e, 0x8b, 0x74, 0xc3, 0x8d, 0x19, 0xb6, 0x34, 0xf6, 0x4f, 0x46, 0xa3, 0xfa, 0x87,
	0x7f, 0x18, 0xe6, 0xbb, 0xd0, 0xd0, 0xa4, 0x8a, 0x9c, 0xa2, 0xf6, 0x59, 0xdf, 0x8d, 0xaa, 0x97,
	0x25, 0xd1, 0xd9, 0xe1, 0x64, 0x65, 0xea, 0x23, 0x5d, 0x7c, 0x81, 0x8a, 0x2f, 0x58, 0xc5, 0x17,
	0x74, 0xf1, 0x85, 0x59, 0x55, 0xd3, 0x8b, 0xd0, 0x09, 0x55, 0x3c, 0x1e, 0xa7, 0xf2, 0xf1, 0xb8,
	0x75, 0x42, 0xe5, 0xb7, 0x76, 0x24, 0x8d, 0x6b, 0x53, 0x16, 0x3b, 0xe8, 0xa2, 0x4e, 0xfe, 0x1f,
	0x00, 0x00, 0xff, 0xff, 0xf9, 0x20, 0x05, 0x18, 0xb1, 0x26, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SecurityCenterSettingsServiceClient is the client API for SecurityCenterSettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityCenterSettingsServiceClient interface {
	// Retrieves the organizations service account, if it exists, otherwise it
	// creates the organization service account. This API is idempotent and
	// will only create a service account once. On subsequent calls it will
	// return the previously created service account.  SHA, SCC and CTD Infra
	// Automation will use this SA.  This SA will not have any permissions when
	// created.  The UI will provision this via IAM or the user will using
	// their own internal process. This API only creates SAs on the organization.
	// Folders are not supported and projects will use per-project SAs associated
	// with APIs enabled on a project. This API will be called by the UX
	// onboarding workflow.
	GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Gets the Settings.
	GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Updates the Settings.
	UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Reset the organization, folder or project's settings and return
	// the settings of just that resource to the default.
	//
	// Settings are present at the organization, folder, project, and cluster
	// levels. Using Reset on a sub-organization level will remove that resource's
	// override and result in the parent's settings being used (eg: if Reset on a
	// cluster, project settings will be used).
	//
	// Using Reset on organization will remove the override that was set and
	// result in default settings being used.
	ResetSettings(ctx context.Context, in *ResetSettingsRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets a list of settings.
	BatchGetSettings(ctx context.Context, in *BatchGetSettingsRequest, opts ...grpc.CallOption) (*BatchGetSettingsResponse, error)
	// CalculateEffectiveSettings looks up all of the Security Center
	// Settings resources in the GCP resource hierarchy, and calculates the
	// effective settings on that resource by applying the following rules:
	//  * Settings provided closer to the target resource take precedence over
	//    those further away (e.g. folder will override organization level
	//    settings).
	//  * Product defaults can be overridden at org, folder, project, and cluster
	//  levels.
	//  * Detectors will be filtered out if they belong to a billing tier the
	//  customer
	//    has not configured.
	CalculateEffectiveSettings(ctx context.Context, in *CalculateEffectiveSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Gets a list of effective settings.
	BatchCalculateEffectiveSettings(ctx context.Context, in *BatchCalculateEffectiveSettingsRequest, opts ...grpc.CallOption) (*BatchCalculateEffectiveSettingsResponse, error)
	// Gets the Component Settings.
	GetComponentSettings(ctx context.Context, in *GetComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error)
	// Updates the Component Settings.
	UpdateComponentSettings(ctx context.Context, in *UpdateComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error)
	// Reset the organization, folder or project's component settings and return
	// the settings to the default. Settings are present at the
	// organization, folder and project levels. Using Reset for a folder or
	// project will remove the override that was set and result in the
	// organization-level settings being used.
	ResetComponentSettings(ctx context.Context, in *ResetComponentSettingsRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the Effective Component Settings.
	CalculateEffectiveComponentSettings(ctx context.Context, in *CalculateEffectiveComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error)
	// Retrieves an unordered list of available detectors.
	ListDetectors(ctx context.Context, in *ListDetectorsRequest, opts ...grpc.CallOption) (*ListDetectorsResponse, error)
	// Retrieves an unordered list of available SCC components.
	ListComponents(ctx context.Context, in *ListComponentsRequest, opts ...grpc.CallOption) (*ListComponentsResponse, error)
}

type securityCenterSettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSecurityCenterSettingsServiceClient(cc grpc.ClientConnInterface) SecurityCenterSettingsServiceClient {
	return &securityCenterSettingsServiceClient{cc}
}

func (c *securityCenterSettingsServiceClient) GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/GetServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/GetSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/UpdateSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) ResetSettings(ctx context.Context, in *ResetSettingsRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ResetSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) BatchGetSettings(ctx context.Context, in *BatchGetSettingsRequest, opts ...grpc.CallOption) (*BatchGetSettingsResponse, error) {
	out := new(BatchGetSettingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/BatchGetSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) CalculateEffectiveSettings(ctx context.Context, in *CalculateEffectiveSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/CalculateEffectiveSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) BatchCalculateEffectiveSettings(ctx context.Context, in *BatchCalculateEffectiveSettingsRequest, opts ...grpc.CallOption) (*BatchCalculateEffectiveSettingsResponse, error) {
	out := new(BatchCalculateEffectiveSettingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/BatchCalculateEffectiveSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) GetComponentSettings(ctx context.Context, in *GetComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error) {
	out := new(ComponentSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/GetComponentSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) UpdateComponentSettings(ctx context.Context, in *UpdateComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error) {
	out := new(ComponentSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/UpdateComponentSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) ResetComponentSettings(ctx context.Context, in *ResetComponentSettingsRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ResetComponentSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) CalculateEffectiveComponentSettings(ctx context.Context, in *CalculateEffectiveComponentSettingsRequest, opts ...grpc.CallOption) (*ComponentSettings, error) {
	out := new(ComponentSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/CalculateEffectiveComponentSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) ListDetectors(ctx context.Context, in *ListDetectorsRequest, opts ...grpc.CallOption) (*ListDetectorsResponse, error) {
	out := new(ListDetectorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ListDetectors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterSettingsServiceClient) ListComponents(ctx context.Context, in *ListComponentsRequest, opts ...grpc.CallOption) (*ListComponentsResponse, error) {
	out := new(ListComponentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ListComponents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterSettingsServiceServer is the server API for SecurityCenterSettingsService service.
type SecurityCenterSettingsServiceServer interface {
	// Retrieves the organizations service account, if it exists, otherwise it
	// creates the organization service account. This API is idempotent and
	// will only create a service account once. On subsequent calls it will
	// return the previously created service account.  SHA, SCC and CTD Infra
	// Automation will use this SA.  This SA will not have any permissions when
	// created.  The UI will provision this via IAM or the user will using
	// their own internal process. This API only creates SAs on the organization.
	// Folders are not supported and projects will use per-project SAs associated
	// with APIs enabled on a project. This API will be called by the UX
	// onboarding workflow.
	GetServiceAccount(context.Context, *GetServiceAccountRequest) (*ServiceAccount, error)
	// Gets the Settings.
	GetSettings(context.Context, *GetSettingsRequest) (*Settings, error)
	// Updates the Settings.
	UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error)
	// Reset the organization, folder or project's settings and return
	// the settings of just that resource to the default.
	//
	// Settings are present at the organization, folder, project, and cluster
	// levels. Using Reset on a sub-organization level will remove that resource's
	// override and result in the parent's settings being used (eg: if Reset on a
	// cluster, project settings will be used).
	//
	// Using Reset on organization will remove the override that was set and
	// result in default settings being used.
	ResetSettings(context.Context, *ResetSettingsRequest) (*empty.Empty, error)
	// Gets a list of settings.
	BatchGetSettings(context.Context, *BatchGetSettingsRequest) (*BatchGetSettingsResponse, error)
	// CalculateEffectiveSettings looks up all of the Security Center
	// Settings resources in the GCP resource hierarchy, and calculates the
	// effective settings on that resource by applying the following rules:
	//  * Settings provided closer to the target resource take precedence over
	//    those further away (e.g. folder will override organization level
	//    settings).
	//  * Product defaults can be overridden at org, folder, project, and cluster
	//  levels.
	//  * Detectors will be filtered out if they belong to a billing tier the
	//  customer
	//    has not configured.
	CalculateEffectiveSettings(context.Context, *CalculateEffectiveSettingsRequest) (*Settings, error)
	// Gets a list of effective settings.
	BatchCalculateEffectiveSettings(context.Context, *BatchCalculateEffectiveSettingsRequest) (*BatchCalculateEffectiveSettingsResponse, error)
	// Gets the Component Settings.
	GetComponentSettings(context.Context, *GetComponentSettingsRequest) (*ComponentSettings, error)
	// Updates the Component Settings.
	UpdateComponentSettings(context.Context, *UpdateComponentSettingsRequest) (*ComponentSettings, error)
	// Reset the organization, folder or project's component settings and return
	// the settings to the default. Settings are present at the
	// organization, folder and project levels. Using Reset for a folder or
	// project will remove the override that was set and result in the
	// organization-level settings being used.
	ResetComponentSettings(context.Context, *ResetComponentSettingsRequest) (*empty.Empty, error)
	// Gets the Effective Component Settings.
	CalculateEffectiveComponentSettings(context.Context, *CalculateEffectiveComponentSettingsRequest) (*ComponentSettings, error)
	// Retrieves an unordered list of available detectors.
	ListDetectors(context.Context, *ListDetectorsRequest) (*ListDetectorsResponse, error)
	// Retrieves an unordered list of available SCC components.
	ListComponents(context.Context, *ListComponentsRequest) (*ListComponentsResponse, error)
}

// UnimplementedSecurityCenterSettingsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSecurityCenterSettingsServiceServer struct {
}

func (*UnimplementedSecurityCenterSettingsServiceServer) GetServiceAccount(ctx context.Context, req *GetServiceAccountRequest) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceAccount not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) GetSettings(ctx context.Context, req *GetSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) UpdateSettings(ctx context.Context, req *UpdateSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) ResetSettings(ctx context.Context, req *ResetSettingsRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) BatchGetSettings(ctx context.Context, req *BatchGetSettingsRequest) (*BatchGetSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) CalculateEffectiveSettings(ctx context.Context, req *CalculateEffectiveSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateEffectiveSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) BatchCalculateEffectiveSettings(ctx context.Context, req *BatchCalculateEffectiveSettingsRequest) (*BatchCalculateEffectiveSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCalculateEffectiveSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) GetComponentSettings(ctx context.Context, req *GetComponentSettingsRequest) (*ComponentSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetComponentSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) UpdateComponentSettings(ctx context.Context, req *UpdateComponentSettingsRequest) (*ComponentSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateComponentSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) ResetComponentSettings(ctx context.Context, req *ResetComponentSettingsRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetComponentSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) CalculateEffectiveComponentSettings(ctx context.Context, req *CalculateEffectiveComponentSettingsRequest) (*ComponentSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateEffectiveComponentSettings not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) ListDetectors(ctx context.Context, req *ListDetectorsRequest) (*ListDetectorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDetectors not implemented")
}
func (*UnimplementedSecurityCenterSettingsServiceServer) ListComponents(ctx context.Context, req *ListComponentsRequest) (*ListComponentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListComponents not implemented")
}

func RegisterSecurityCenterSettingsServiceServer(s *grpc.Server, srv SecurityCenterSettingsServiceServer) {
	s.RegisterService(&_SecurityCenterSettingsService_serviceDesc, srv)
}

func _SecurityCenterSettingsService_GetServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).GetServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/GetServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).GetServiceAccount(ctx, req.(*GetServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_GetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).GetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/GetSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).GetSettings(ctx, req.(*GetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_UpdateSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).UpdateSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/UpdateSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).UpdateSettings(ctx, req.(*UpdateSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_ResetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).ResetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ResetSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).ResetSettings(ctx, req.(*ResetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_BatchGetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).BatchGetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/BatchGetSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).BatchGetSettings(ctx, req.(*BatchGetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_CalculateEffectiveSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateEffectiveSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).CalculateEffectiveSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/CalculateEffectiveSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).CalculateEffectiveSettings(ctx, req.(*CalculateEffectiveSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_BatchCalculateEffectiveSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCalculateEffectiveSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).BatchCalculateEffectiveSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/BatchCalculateEffectiveSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).BatchCalculateEffectiveSettings(ctx, req.(*BatchCalculateEffectiveSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_GetComponentSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetComponentSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).GetComponentSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/GetComponentSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).GetComponentSettings(ctx, req.(*GetComponentSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_UpdateComponentSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateComponentSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).UpdateComponentSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/UpdateComponentSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).UpdateComponentSettings(ctx, req.(*UpdateComponentSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_ResetComponentSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetComponentSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).ResetComponentSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ResetComponentSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).ResetComponentSettings(ctx, req.(*ResetComponentSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_CalculateEffectiveComponentSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateEffectiveComponentSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).CalculateEffectiveComponentSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/CalculateEffectiveComponentSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).CalculateEffectiveComponentSettings(ctx, req.(*CalculateEffectiveComponentSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_ListDetectors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDetectorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).ListDetectors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ListDetectors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).ListDetectors(ctx, req.(*ListDetectorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterSettingsService_ListComponents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListComponentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterSettingsServiceServer).ListComponents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService/ListComponents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterSettingsServiceServer).ListComponents(ctx, req.(*ListComponentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityCenterSettingsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsService",
	HandlerType: (*SecurityCenterSettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetServiceAccount",
			Handler:    _SecurityCenterSettingsService_GetServiceAccount_Handler,
		},
		{
			MethodName: "GetSettings",
			Handler:    _SecurityCenterSettingsService_GetSettings_Handler,
		},
		{
			MethodName: "UpdateSettings",
			Handler:    _SecurityCenterSettingsService_UpdateSettings_Handler,
		},
		{
			MethodName: "ResetSettings",
			Handler:    _SecurityCenterSettingsService_ResetSettings_Handler,
		},
		{
			MethodName: "BatchGetSettings",
			Handler:    _SecurityCenterSettingsService_BatchGetSettings_Handler,
		},
		{
			MethodName: "CalculateEffectiveSettings",
			Handler:    _SecurityCenterSettingsService_CalculateEffectiveSettings_Handler,
		},
		{
			MethodName: "BatchCalculateEffectiveSettings",
			Handler:    _SecurityCenterSettingsService_BatchCalculateEffectiveSettings_Handler,
		},
		{
			MethodName: "GetComponentSettings",
			Handler:    _SecurityCenterSettingsService_GetComponentSettings_Handler,
		},
		{
			MethodName: "UpdateComponentSettings",
			Handler:    _SecurityCenterSettingsService_UpdateComponentSettings_Handler,
		},
		{
			MethodName: "ResetComponentSettings",
			Handler:    _SecurityCenterSettingsService_ResetComponentSettings_Handler,
		},
		{
			MethodName: "CalculateEffectiveComponentSettings",
			Handler:    _SecurityCenterSettingsService_CalculateEffectiveComponentSettings_Handler,
		},
		{
			MethodName: "ListDetectors",
			Handler:    _SecurityCenterSettingsService_ListDetectors_Handler,
		},
		{
			MethodName: "ListComponents",
			Handler:    _SecurityCenterSettingsService_ListComponents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycenter/settings/v1beta1/securitycenter_settings_service.proto",
}
