// Code generated by smithy-go-codegen DO NOT EDIT.

package kms

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a custom key store
// (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// that is associated with an CloudHSM cluster
// (https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html) that you
// own and manage. This operation is part of the custom key store feature
// (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// feature in KMS, which combines the convenience and extensive integration of KMS
// with the isolation and control of a single-tenant key store. Before you create
// the custom key store, you must assemble the required elements, including an
// CloudHSM cluster that fulfills the requirements for a custom key store. For
// details about the required elements, see Assemble the Prerequisites
// (https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
// in the Key Management Service Developer Guide. When the operation completes
// successfully, it returns the ID of the new custom key store. Before you can use
// your new custom key store, you need to use the ConnectCustomKeyStore operation
// to connect the new key store to its CloudHSM cluster. Even if you are not going
// to use your custom key store immediately, you might want to connect it to verify
// that all settings are correct and then disconnect it until you are ready to use
// it. For help with failures, see Troubleshooting a Custom Key Store
// (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html) in the
// Key Management Service Developer Guide. Cross-account use: No. You cannot
// perform this operation on a custom key store in a different Amazon Web Services
// account. Required permissions: kms:CreateCustomKeyStore
// (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy). Related operations:
//
// * ConnectCustomKeyStore
//
// *
// DeleteCustomKeyStore
//
// * DescribeCustomKeyStores
//
// * DisconnectCustomKeyStore
//
// *
// UpdateCustomKeyStore
func (c *Client) CreateCustomKeyStore(ctx context.Context, params *CreateCustomKeyStoreInput, optFns ...func(*Options)) (*CreateCustomKeyStoreOutput, error) {
	if params == nil {
		params = &CreateCustomKeyStoreInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCustomKeyStore", params, optFns, c.addOperationCreateCustomKeyStoreMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCustomKeyStoreOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateCustomKeyStoreInput struct {

	// Specifies a friendly name for the custom key store. The name must be unique in
	// your Amazon Web Services account.
	//
	// This member is required.
	CustomKeyStoreName *string

	// Identifies the CloudHSM cluster for the custom key store. Enter the cluster ID
	// of any active CloudHSM cluster that is not already associated with a custom key
	// store. To find the cluster ID, use the DescribeClusters
	// (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
	// operation.
	CloudHsmClusterId *string

	// Enter the password of the kmsuser crypto user (CU) account
	// (https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser)
	// in the specified CloudHSM cluster. KMS logs into the cluster as this user to
	// manage key material on your behalf. The password must be a string of 7 to 32
	// characters. Its value is case sensitive. This parameter tells KMS the kmsuser
	// account password; it does not change the password in the CloudHSM cluster.
	KeyStorePassword *string

	// Enter the content of the trust anchor certificate for the cluster. This is the
	// content of the customerCA.crt file that you created when you initialized the
	// cluster
	// (https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html).
	TrustAnchorCertificate *string

	noSmithyDocumentSerde
}

type CreateCustomKeyStoreOutput struct {

	// A unique identifier for the new custom key store.
	CustomKeyStoreId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCustomKeyStoreMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateCustomKeyStore{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateCustomKeyStore{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateCustomKeyStoreValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCustomKeyStore(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateCustomKeyStore(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "kms",
		OperationName: "CreateCustomKeyStore",
	}
}
